/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalindicator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EvalSetGroupHelper {
    private static final Log LOG = LogFactory.getLog(EvalSetGroupHelper.class);

    public static void createOPenDesignData(List<DynamicObject> list, IFormView view) {
        IDataModel model = view.getModel();
        if (list.size() > 0) {
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", list.size());
            int index = 0;
            for (DynamicObject dynamicObject : list) {
                model.setValue("pointertype", dynamicObject.get("indicatortype"), index);
                model.setValue("pointername", dynamicObject.get("indicatorname"), index);
                model.setValue("pointerdes", dynamicObject.get("indicatordescription"), index);
                String codeNumber = EvalSetGroupHelper.getCode(view, dynamicObject);
                model.setValue("combofield", (Object)codeNumber, index);
                ++index;
            }
            view.sendFormAction(view.getParentView());
        }
    }

    public static String getCode(IFormView view, DynamicObject dynamicObject) {
        DynamicObjectCollection groupEntryEntity = view.getParentView().getModel().getEntryEntity("groupentryentity");
        String name = "";
        String codeNumber = "";
        String area = (String)view.getFormShowParameter().getCustomParam("areacode");
        for (DynamicObject groupDot : groupEntryEntity) {
            String code;
            if (!dynamicObject.get("group").equals(groupDot.get("id")) || !groupDot.getString("groupareacode").equals(area)) continue;
            String groupName = groupDot.getString("groupname");
            if (HRStringUtils.isNotEmpty((String)groupName)) {
                name = name.concat(groupName);
            }
            if (!HRStringUtils.isNotEmpty((String)(code = String.valueOf(groupDot.getLong("groupareaseq"))))) continue;
            codeNumber = codeNumber.concat(code);
        }
        return codeNumber;
    }

    public static void createScoreData(List<DynamicObject> list, IFormView view) {
        IDataModel model = view.getModel();
        if (list.size() > 0) {
            model.deleteEntryData("scoreentryentity");
            model.batchCreateNewEntryRow("scoreentryentity", list.size());
            int index = 0;
            for (DynamicObject dynamicObject : list) {
                model.setValue("indicatortype", dynamicObject.get("indicatortype"), index);
                model.setValue("indicatorname", dynamicObject.get("indicatorname"), index);
                model.setValue("indicatordescription", dynamicObject.get("indicatordescription"), index);
                String code = EvalSetGroupHelper.getCode(view, dynamicObject);
                model.setValue("group", (Object)code, index);
                ++index;
            }
            view.sendFormAction(view.getParentView());
        }
    }

    public static void refreshField(IFormView view) {
        DynamicObjectCollection indicator = view.getModel().getEntryEntity("indicatorentryentity");
        DynamicObjectCollection group = view.getModel().getEntryEntity("groupentryentity");
        ArrayList<Long> groupIds = new ArrayList<Long>(group.size());
        for (DynamicObject grDot : group) {
            groupIds.add(grDot.getLong("id"));
        }
        ArrayList<Long> groups = new ArrayList<Long>(indicator.size());
        for (DynamicObject indicatorDot : indicator) {
            long id = indicatorDot.getLong("group");
            if (id == 0L || !groupIds.contains(id)) continue;
            groups.add(id);
            LOG.info("EvalSetGroupHelper.refreshField id:{}", (Object)id);
            LOG.info("EvalSetGroupHelper.refreshField groupIds:{}", groupIds);
        }
        if (CollectionUtils.isNotEmpty(groups)) {
            for (DynamicObject indicatorDot : indicator) {
                long groupId = indicatorDot.getLong("group");
                if (groupId != 0L && groupIds.contains(groupId)) continue;
                for (DynamicObject grDoc : group) {
                    if (!grDoc.getString("groupname").equals(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"EvalTaskSetGroupHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0])) || !grDoc.getString("groupareacode").equals(indicatorDot.getString("areacode"))) continue;
                    Object entryID = grDoc.get("id");
                    indicatorDot.set("group", entryID);
                }
            }
            view.sendFormAction(view.getParentView());
        }
    }
}

