/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalpreview;

import com.kingdee.bos.qing.util.MapUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.evalpreview.EvalViewDomainService;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;
import kd.hrmp.bes.common.constants.eval.EvalViewConstants;
import kd.hrmp.bes.common.dto.LoginParamDTO;
import kd.hrmp.bes.common.dto.ResultObjectDTO;
import kd.hrmp.bes.common.enums.EvaluatorTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class EvalViewDomainServiceImpl
implements EvalViewDomainService,
EvalViewConstants {
    private final EvalTaskDomainServiceImpl EVAL_TASK_DOMAIN_SERVICE = new EvalTaskDomainServiceImpl();
    private static final HRBaseServiceHelper BES_EVALTASK_HELPER = new HRBaseServiceHelper("bes_evaltask");
    private static final HRBaseServiceHelper BES_EVALSUBTASK_HELPER = new HRBaseServiceHelper("bes_evalsubtask");
    private static final Log LOGGER = LogFactory.getLog(EvalViewDomainServiceImpl.class);

    @Override
    public DynamicObject getEvalTaskById(Long evalTaskId, Long evalContentId) {
        QFilter taskIdFilter = new QFilter("id", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("contententryentity.id", "=", (Object)evalContentId);
        DynamicObjectCollection evalTaskList = BES_EVALTASK_HELPER.queryOriginalCollection("id,realorcryptonym,startdate,evaltaskstatus,responsemode,allow,contententryentity.evaledobjtype evaledobjtype,contententryentity.contentname contentname,contententryentity.scoreaccuracy scoreaccuracy", new QFilter[]{taskIdFilter, contentFilter});
        if (evalTaskList.size() > 0) {
            return (DynamicObject)evalTaskList.get(0);
        }
        return null;
    }

    @Override
    public DynamicObject getEvalContentById(Long evalTaskId, Long evalContentId) {
        QFilter taskIdFilter = new QFilter("id", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("contententryentity.id", "=", (Object)evalContentId);
        DynamicObject evalTask = BES_EVALTASK_HELPER.loadDynamicObject(new QFilter[]{taskIdFilter, contentFilter});
        if (evalTask == null) {
            return null;
        }
        List contentList = evalTask.getDynamicObjectCollection("contententryentity").stream().filter(task -> task.get("id").equals(evalContentId)).collect(Collectors.toList());
        if (contentList.size() > 0) {
            return (DynamicObject)contentList.get(0);
        }
        return null;
    }

    @Override
    public Map<Boolean, List<String>> getEvalDiscByContent(DynamicObject evalContent) {
        String evalObjType;
        if (evalContent == null) {
            return null;
        }
        HashMap<Boolean, List<String>> discMap = new HashMap<Boolean, List<String>>(2);
        DynamicObjectCollection discontent = evalContent.getDynamicObjectCollection("discontent");
        List discontentNameList = discontent.stream().map(con -> con.getString("fbasedataid.identifying")).collect(Collectors.toList());
        discMap.put(true, discontentNameList);
        switch (evalObjType = evalContent.getString("evaledobjtype")) {
            case "10": {
                ArrayList<String> personAllContent = new ArrayList<String>(10);
                personAllContent.add("pernumber");
                personAllContent.add("pername");
                personAllContent.add("gender");
                personAllContent.add("birthday");
                personAllContent.add("age");
                personAllContent.add("percompany");
                personAllContent.add("peradminorg");
                personAllContent.add("perposition");
                personAllContent.add("perstdpos");
                personAllContent.add("perjob");
                personAllContent.add("cadrecategory");
                personAllContent.removeAll(discontentNameList);
                discMap.put(false, personAllContent);
                break;
            }
            case "20": {
                ArrayList<String> orgAllContent = new ArrayList<String>(10);
                orgAllContent.add("orgnumber");
                orgAllContent.add("orgname");
                orgAllContent.add("parmanageorg");
                orgAllContent.add("subcompany");
                orgAllContent.removeAll(discontentNameList);
                discMap.put(false, orgAllContent);
            }
        }
        return discMap;
    }

    @Override
    public List<Pair<String, List<DynamicObject>>> getEvalIndGroupByContent(DynamicObject evalContent) {
        if (evalContent == null) {
            return null;
        }
        ArrayList<Pair<String, List<DynamicObject>>> indGroupList = new ArrayList<Pair<String, List<DynamicObject>>>(10);
        List areaSortList = evalContent.getDynamicObjectCollection("areasubentry").stream().sorted(Comparator.comparing(a -> a.getInt("seq"))).collect(Collectors.toList());
        Map<String, List<DynamicObject>> groupSortMap = evalContent.getDynamicObjectCollection("groupsubentry").stream().sorted(Comparator.comparingInt(s -> s.getInt("groupareaseq"))).collect(Collectors.groupingBy(dy -> dy.getString("groupareacode")));
        Map<Long, List<DynamicObject>> indicatorSortMap = evalContent.getDynamicObjectCollection("indicatorsubentry").stream().sorted(Comparator.comparingInt(s -> s.getInt("indicgroupseq"))).collect(Collectors.groupingBy(dy -> dy.getLong("group")));
        for (DynamicObject areaSort : areaSortList) {
            Pair prePair;
            Pair pair;
            List<DynamicObject> noGroupIndicatorList;
            String areaCode = areaSort.getString("acode");
            List<DynamicObject> groupSortList = groupSortMap.get(areaCode);
            if (groupSortList != null && groupSortList.size() > 0) {
                for (DynamicObject groupSort : groupSortList) {
                    Long groupId = groupSort.getLong("id");
                    List<DynamicObject> indicatorSortList = indicatorSortMap.get(groupId);
                    if (indicatorSortList == null || indicatorSortList.size() <= 0) continue;
                    String groupName = groupSort.getString("groupname");
                    Pair pair2 = Pair.of((Object)groupName, indicatorSortList);
                    indGroupList.add((Pair<String, List<DynamicObject>>)pair2);
                }
            }
            if ((noGroupIndicatorList = indicatorSortMap.get(0L)) == null) continue;
            String aCode = "2";
            Map<Boolean, List<DynamicObject>> checkedGroupMap = noGroupIndicatorList.stream().collect(Collectors.partitioningBy(entry -> aCode.equals(entry.getString("areacode"))));
            if (HRStringUtils.equals((String)aCode, (String)areaCode)) {
                List<DynamicObject> genGroup = checkedGroupMap.get(true);
                if (genGroup == null || genGroup.size() <= 0) continue;
                pair = Pair.of((Object)ResManager.loadKDString((String)"\u603b\u4f53\u8bc4\u4ef7", (String)"EvalViewFormService_17", (String)"hrmp-bes-business", (Object[])new Object[0]), genGroup);
                indGroupList.add((Pair<String, List<DynamicObject>>)pair);
                continue;
            }
            List<Object> noGenGroup = checkedGroupMap.get(false);
            if ((noGenGroup = noGenGroup.stream().filter(dy -> dy.getString("areacode").equals(areaCode)).collect(Collectors.toList())).size() <= 0) continue;
            if (indGroupList.size() > 0 && HRStringUtils.equals((String)"", (String)((String)(prePair = (Pair)indGroupList.get(indGroupList.size() - 1)).getKey()))) {
                List preNoGenGroup = (List)prePair.getValue();
                preNoGenGroup.addAll(noGenGroup);
                Pair pair3 = Pair.of((Object)"", (Object)preNoGenGroup);
                indGroupList.remove(prePair);
                indGroupList.add((Pair<String, List<DynamicObject>>)pair3);
                continue;
            }
            pair = Pair.of((Object)"", noGenGroup);
            indGroupList.add((Pair<String, List<DynamicObject>>)pair);
        }
        return indGroupList;
    }

    @Override
    public Map<Long, List<DynamicObject>> getEvalIndOptionByContent(DynamicObject evalContent) {
        if (evalContent == null) {
            return null;
        }
        DynamicObjectCollection optionCollection = evalContent.getDynamicObjectCollection("optsubentry");
        return optionCollection.stream().sorted(Comparator.comparingInt(s -> s.getInt("optsindicaseq"))).collect(Collectors.groupingBy(dy -> dy.getLong("indicator")));
    }

    @Override
    public String getEvalSubTaskFieldByEnum(EvaluatorTypeEnum evaluatorTypeEnum, boolean ... isOutUser) {
        String field = "";
        switch (evaluatorTypeEnum) {
            case REAL_NO_EVALUATOR: {
                field = "evalinternalper";
                break;
            }
            case REAL_USER_MAIN_BODY: 
            case REAL_USER_NO_MAIN_BODY: {
                if (isOutUser == null || isOutUser.length == 0) break;
                if (isOutUser[0]) {
                    field = "evaloutsiderentryid";
                    break;
                }
                field = "evalinternalper";
                break;
            }
            case ANON_NO_EVALUATOR: 
            case ANON_NO_MAIN_BODY: {
                break;
            }
            case ANON_MAIN_BODY: {
                field = "evalbodynameanon";
                break;
            }
            case ANON_ACCOUNT_MAIN_BODY: 
            case ANON_ACCOUNT_NO_MAIN_BODY: {
                field = "evaluatoranonentryid";
                break;
            }
        }
        return field;
    }

    @Override
    public Map<Long, String> getEvalSubStatusWithObjEntry(Long evalTaskId, Long evalContentId, String evalObjType, Object ... statusParam) {
        QFilter taskIdFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)evalContentId);
        String selectFields = "objinfoperentryid";
        if (HRStringUtils.equals((String)evalObjType, (String)"20")) {
            selectFields = "objinfoorgentryid";
        }
        QFilter removeFilter = new QFilter("removemark", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{taskIdFilter, contentFilter, removeFilter};
        if (statusParam != null && statusParam.length == 2) {
            QFilter fieldFilter = new QFilter(statusParam[0].toString(), "=", statusParam[1]);
            filters = new QFilter[]{taskIdFilter, contentFilter, fieldFilter, removeFilter};
        }
        DynamicObjectCollection evalSubTaskList = BES_EVALSUBTASK_HELPER.queryOriginalCollection("taskstatus," + selectFields, filters);
        String fields = selectFields;
        if (evalSubTaskList.size() > 0) {
            return evalSubTaskList.stream().collect(Collectors.toMap(dy -> dy.getLong(fields), dy -> dy.getString("taskstatus"), (key1, key2) -> key1));
        }
        return new HashMap<Long, String>(1);
    }

    @Override
    public Map<Long, ResultObjectDTO> getEvalSubResultEntry(Long evalTaskId, Long evalContentId, String evalObjType, String responseMode, long objectId, Object ... statusParam) {
        HashMap<Long, ResultObjectDTO> listMap;
        block6: {
            DynamicObject[] evalTaskDyn;
            String filed;
            block5: {
                listMap = new HashMap<Long, ResultObjectDTO>(16);
                QFilter qFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
                qFilter.and(new QFilter("taskcontentid", "=", (Object)evalContentId));
                filed = HRStringUtils.equals((String)evalObjType, (String)"10") ? "objinfoperentryid" : "objinfoorgentryid";
                if ("1".equals(responseMode)) {
                    qFilter.and(new QFilter(filed, "=", (Object)objectId));
                }
                if (statusParam != null && statusParam.length == 2) {
                    qFilter.and(new QFilter(statusParam[0].toString(), "=", statusParam[1]));
                }
                qFilter.and(new QFilter("removemark", "=", (Object)Boolean.FALSE));
                evalTaskDyn = BES_EVALSUBTASK_HELPER.loadDynamicObjectArray(qFilter.toArray());
                if (!"1".equals(responseMode)) break block5;
                if (evalTaskDyn.length <= 0) break block6;
                DynamicObjectCollection evalColl = evalTaskDyn[0].getDynamicObjectCollection("entryentity");
                for (DynamicObject eval : evalColl) {
                    ResultObjectDTO resultObjectDTO = this.getResultObjectDTO(eval);
                    listMap.put(eval.getLong("evalindicatorentryid"), resultObjectDTO);
                }
                break block6;
            }
            for (DynamicObject evalTask : evalTaskDyn) {
                DynamicObjectCollection evalColl = evalTask.getDynamicObjectCollection("entryentity");
                for (DynamicObject eval : evalColl) {
                    if (eval.getLong("evalindicatorentryid") != objectId) continue;
                    ResultObjectDTO resultObjectDTO = this.getResultObjectDTO(eval);
                    listMap.put(evalTask.getLong(filed), resultObjectDTO);
                }
            }
        }
        return listMap;
    }

    @Override
    public Map<Long, String> getAllPerTotal(Long evalTaskId, Long evalContentId, String evalObjType, int scoreAccuracy, Object ... statusParam) {
        HashMap<Long, String> listMap = new HashMap<Long, String>(16);
        if (this.judgmentRetType(evalTaskId, evalContentId)) {
            return null;
        }
        QFilter qFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        qFilter.and(new QFilter("taskcontentid", "=", (Object)evalContentId));
        String filed = HRStringUtils.equals((String)evalObjType, (String)"10") ? "objinfoperentryid" : "objinfoorgentryid";
        if (statusParam != null && statusParam.length == 2) {
            qFilter.and(new QFilter(statusParam[0].toString(), "=", statusParam[1]));
        }
        qFilter.and(new QFilter("removemark", "=", (Object)Boolean.FALSE));
        DynamicObject[] evalTaskDyn = BES_EVALSUBTASK_HELPER.loadDynamicObjectArray(qFilter.toArray());
        if (evalTaskDyn.length > 0) {
            for (DynamicObject evalTask : evalTaskDyn) {
                DynamicObjectCollection evalColl = evalTask.getDynamicObjectCollection("entryentity");
                for (DynamicObject eval : evalColl) {
                    if (!"C".equals(eval.getString("indicatortype")) || !"2".equals(eval.getString("indicatorclassify"))) continue;
                    String total = eval.getBigDecimal("numerical") != null ? eval.getBigDecimal("numerical").setScale(scoreAccuracy, RoundingMode.DOWN).toString() : new BigDecimal(0).setScale(scoreAccuracy, RoundingMode.DOWN).toString();
                    listMap.put(evalTask.getLong(filed), total);
                }
            }
        }
        return listMap;
    }

    @Override
    public List<DynamicObject> getEvalObjByEntryId(DynamicObject evalContent, Map<Long, String> evalSubStatusMap) {
        if (evalContent == null) {
            return null;
        }
        String subEntry = "objinfopersubentry";
        if (HRStringUtils.equals((String)evalContent.getString("evaledobjtype"), (String)"20")) {
            subEntry = "objinfoorgsubentry";
        }
        List<Object> evalObjEntry = new ArrayList<DynamicObject>((Collection<DynamicObject>)evalContent.getDynamicObjectCollection(subEntry));
        if (MapUtils.isNotEmpty(evalSubStatusMap)) {
            evalObjEntry = evalContent.getDynamicObjectCollection(subEntry).stream().filter(dy -> evalSubStatusMap.containsKey(dy.getLong("id"))).collect(Collectors.toList());
        }
        if (HRStringUtils.equals((String)evalContent.getString("evaledobjtype"), (String)"10")) {
            evalObjEntry = evalObjEntry.stream().sorted(Comparator.comparing(dyn -> dyn.getLong("seq"))).collect(Collectors.toList());
        }
        return evalObjEntry;
    }

    @Override
    public void updateEvalObjByEntry(Long evalTaskId, Long evalContentId, String evalObjType, Long evnLonObjId, Map<Long, List<ResultObjectDTO>> result, Object ... statusParam) {
        QFilter qFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        qFilter.and(new QFilter("taskcontentid", "=", (Object)evalContentId));
        String filed = HRStringUtils.equals((String)evalObjType, (String)"10") ? "objinfoperentryid" : "objinfoorgentryid";
        qFilter.and(new QFilter(filed, "=", (Object)evnLonObjId));
        if (statusParam != null && statusParam.length == 2) {
            qFilter.and(new QFilter(statusParam[0].toString(), "=", statusParam[1]));
        }
        qFilter.and(new QFilter("removemark", "=", (Object)Boolean.FALSE));
        DynamicObject evalTaskDyn = BES_EVALSUBTASK_HELPER.loadDynamicObject(qFilter);
        if (Objects.nonNull(evalTaskDyn) && result.size() > 0) {
            DynamicObjectCollection evalColl = evalTaskDyn.getDynamicObjectCollection("entryentity");
            List<ResultObjectDTO> resultObjectDTOS = result.get(evnLonObjId);
            for (DynamicObject dynObj : evalColl) {
                for (ResultObjectDTO resultObj : resultObjectDTOS) {
                    if (dynObj.getLong("evalindicatorentryid") != resultObj.getIndicatorId()) continue;
                    dynObj.set("singlechoice", (Object)resultObj.getSingleChoice());
                    dynObj.set("multiplechoice", (Object)resultObj.getMultipleChoice());
                    dynObj.set("numerical", (Object)resultObj.getNumerical());
                    dynObj.set("shortanswer", (Object)resultObj.getEvaluate());
                    dynObj.set("reason", (Object)resultObj.getReason());
                }
            }
            BES_EVALSUBTASK_HELPER.saveOne(evalTaskDyn);
        }
    }

    private boolean judgmentRetType(Long evalTaskId, Long evalContentId) {
        EvaluatorTypeEnum evaluatorEnum = this.EVAL_TASK_DOMAIN_SERVICE.getEvaluatorTypeEnumByTask(evalTaskId, evalContentId);
        switch (evaluatorEnum) {
            case REAL_NO_EVALUATOR: 
            case REAL_USER_MAIN_BODY: 
            case REAL_USER_NO_MAIN_BODY: 
            case ANON_ACCOUNT_MAIN_BODY: 
            case ANON_ACCOUNT_NO_MAIN_BODY: {
                return false;
            }
        }
        return true;
    }

    private ResultObjectDTO getResultObjectDTO(DynamicObject eval) {
        ResultObjectDTO resultObjectDTO = new ResultObjectDTO();
        resultObjectDTO.setIndicatorId(eval.getLong("evalindicatorentryid"));
        resultObjectDTO.setIndicatorType(eval.getString("indicatortype"));
        resultObjectDTO.setIndicatorClassify(eval.getString("indicatorclassify"));
        resultObjectDTO.setSingleChoice(eval.getString("singlechoice"));
        resultObjectDTO.setMultipleChoice(eval.getString("multiplechoice"));
        resultObjectDTO.setNumerical(eval.getBigDecimal("numerical"));
        resultObjectDTO.setEvaluate(eval.getString("shortanswer"));
        resultObjectDTO.setReason(eval.getString("reason"));
        return resultObjectDTO;
    }

    private Map<Long, DynamicObject> createSubTask(Map<Long, List<ResultObjectDTO>> result, String evalObjType, DynamicObject content, Long evalTaskId, String realOranOny, Long contentId, Map<Long, String> statusMap, DynamicObject evalTask) {
        HashMap<Long, DynamicObject> saveSubTaskDyMap = new HashMap<Long, DynamicObject>(16);
        String filed = HRStringUtils.equals((String)evalObjType, (String)"10") ? "objinfoperentryid" : "objinfoorgentryid";
        Date startDate = evalTask.getDate("startdate");
        Set<Map.Entry<Long, List<ResultObjectDTO>>> resultEntries = result.entrySet();
        HRBaseServiceHelper evalSubTask = new HRBaseServiceHelper("bes_evalsubtask");
        for (Map.Entry<Long, List<ResultObjectDTO>> resultEntry : resultEntries) {
            Long evalObjId = resultEntry.getKey();
            DynamicObject evalSubTaskDynamicObject = evalSubTask.generateEmptyDynamicObject();
            String perDataSource = "3";
            if (HRStringUtils.equals((String)evalObjType, (String)"10")) {
                DynamicObjectCollection objInfoPerSubEntry = content.getDynamicObjectCollection("objinfopersubentry");
                for (DynamicObject objInfoPer : objInfoPerSubEntry) {
                    if (!objInfoPer.get("id").equals(evalObjId)) continue;
                    perDataSource = objInfoPer.getString("perdatasource");
                    break;
                }
            }
            if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
                evalSubTaskDynamicObject.set("evaldatasource", (Object)"12");
            } else if (HRStringUtils.equals((String)realOranOny, (String)"2")) {
                evalSubTaskDynamicObject.set("evaldatasource", (Object)"23");
            }
            evalSubTaskDynamicObject.set("perdatasource", (Object)perDataSource);
            evalSubTaskDynamicObject.set(filed, (Object)evalObjId);
            evalSubTaskDynamicObject.set("evaltask", (Object)evalTaskId);
            evalSubTaskDynamicObject.set("taskcontentid", (Object)contentId);
            String status = statusMap.get(evalObjId);
            evalSubTaskDynamicObject.set("taskstatus", (Object)status);
            evalSubTaskDynamicObject.set("starttime", (Object)startDate);
            evalSubTaskDynamicObject.set("endtime", (Object)new Date());
            evalSubTaskDynamicObject.set("evalbodyweight", (Object)100);
            if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
                evalSubTaskDynamicObject.set("evaluatorsource", (Object)"1");
                evalSubTaskDynamicObject.set("user", (Object)RequestContext.get().getCurrUserId());
            } else {
                evalSubTaskDynamicObject.set("usingaccount", (Object)"1");
            }
            DynamicObjectCollection evalColl = evalSubTaskDynamicObject.getDynamicObjectCollection("entryentity");
            List<ResultObjectDTO> resultObjectDTOS = resultEntry.getValue();
            for (ResultObjectDTO resultObj : resultObjectDTOS) {
                evalColl.addNew();
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("evalindicatorentryid", (Object)resultObj.getIndicatorId());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("indicatortype", (Object)resultObj.getIndicatorType());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("indicatorclassify", (Object)resultObj.getIndicatorClassify());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("singlechoice", (Object)resultObj.getSingleChoice());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("multiplechoice", (Object)resultObj.getMultipleChoice());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("numerical", (Object)resultObj.getNumerical());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("shortanswer", (Object)resultObj.getEvaluate());
                ((DynamicObject)evalColl.get(evalColl.size() - 1)).set("reason", (Object)resultObj.getReason());
            }
            saveSubTaskDyMap.put(evalObjId, evalSubTaskDynamicObject);
        }
        return saveSubTaskDyMap;
    }

    private void UpdateSubTask(Map<Long, List<ResultObjectDTO>> result, LoginParamDTO loginParam, QFilter qFilter, String filed, Map<Long, String> statusMap, String evaluatorEnum) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Set<Map.Entry<Long, List<ResultObjectDTO>>> resultEntries = result.entrySet();
        ArrayList<Long> evalObjIdS = new ArrayList<Long>(result.keySet());
        String evalBody = loginParam.getEvalBody();
        if (evaluatorEnum.equals("7")) {
            QFilter evaluatorQFilter = new QFilter("evalbodynameanon", "=", (Object)evalBody);
            qFilter.and(evaluatorQFilter);
        }
        QFilter evalObjIdqFilter = new QFilter(filed, "in", evalObjIdS);
        qFilter.and(new QFilter("taskstatus", "=", (Object)"B"));
        Map<Long, Optional<DynamicObject>> evalTaskDynMap = Arrays.stream(BES_EVALSUBTASK_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter, evalObjIdqFilter})).collect(Collectors.groupingBy(DynamicObject2 -> DynamicObject2.getLong(filed), Collectors.minBy(Comparator.comparingLong(subTask -> subTask.getLong("number")))));
        Date endDate = new Date();
        for (Map.Entry<Long, List<ResultObjectDTO>> resultEntry : resultEntries) {
            Long evalObjId = resultEntry.getKey();
            if (!Objects.nonNull(evalTaskDynMap.get(evalObjId))) continue;
            DynamicObject evalTaskDyn = evalTaskDynMap.get(evalObjId).get();
            String status = statusMap.get(evalObjId);
            evalTaskDyn.set("taskstatus", (Object)status);
            evalTaskDyn.set("endtime", (Object)endDate);
            DynamicObjectCollection evalColl = evalTaskDyn.getDynamicObjectCollection("entryentity");
            List<ResultObjectDTO> resultObjectDTOS = resultEntry.getValue();
            Map resultObjectDTOMap = resultObjectDTOS.stream().collect(Collectors.toMap(ResultObjectDTO::getIndicatorId, Function.identity()));
            for (DynamicObject dynObj : evalColl) {
                long evalIndicatorEntryId = dynObj.getLong("evalindicatorentryid");
                ResultObjectDTO resultObjectDTO = (ResultObjectDTO)resultObjectDTOMap.get(evalIndicatorEntryId);
                if (!Objects.nonNull(resultObjectDTO)) continue;
                dynObj.set("singlechoice", (Object)resultObjectDTO.getSingleChoice());
                dynObj.set("multiplechoice", (Object)resultObjectDTO.getMultipleChoice());
                dynObj.set("numerical", (Object)resultObjectDTO.getNumerical());
                dynObj.set("shortanswer", (Object)resultObjectDTO.getEvaluate());
                dynObj.set("reason", (Object)resultObjectDTO.getReason());
            }
            evalTaskDyn.set("entryentity", (Object)evalColl);
            dynamicObjectCollection.add((Object)evalTaskDyn);
        }
        BES_EVALSUBTASK_HELPER.save(dynamicObjectCollection);
    }

    @Override
    public void mulUpdateSubTaskResultEntry(String evaluatorEnum, String evalObjType, LoginParamDTO loginParam, Map<Long, List<ResultObjectDTO>> result, Map<Long, String> statusMap, DynamicObject evalTask, DynamicObject content) {
        Long evalTaskId = loginParam.getEvalTaskId();
        Long contentId = loginParam.getEvalContentId();
        QFilter qFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        qFilter.and(new QFilter("taskcontentid", "=", (Object)contentId));
        Long evaluatorId = loginParam.getEvaluatorId();
        QFilter evaluatorQFilter = null;
        String filed = HRStringUtils.equals((String)evalObjType, (String)"10") ? "objinfoperentryid" : "objinfoorgentryid";
        String realOranOny = evalTask.getString("realorcryptonym");
        if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
            String evaluatorType = loginParam.getEvaluatorType();
            if (HRStringUtils.equals((String)evaluatorType, (String)"1")) {
                evaluatorQFilter = new QFilter("evalinternalper", "=", (Object)evaluatorId);
            } else if (HRStringUtils.equals((String)evaluatorType, (String)"2")) {
                evaluatorQFilter = new QFilter("evaloutsiderentryid", "=", (Object)evaluatorId);
            }
        } else if (HRStringUtils.equals((String)realOranOny, (String)"2")) {
            evaluatorQFilter = new QFilter("evaluatoranonentryid", "=", (Object)evaluatorId);
        }
        if (HRStringUtils.equals((String)evaluatorEnum, (String)"1") || HRStringUtils.equals((String)evaluatorEnum, (String)"4")) {
            long start = System.currentTimeMillis();
            Map<Long, DynamicObject> saveSubTaskDyMap = this.createSubTask(result, evalObjType, content, evalTaskId, realOranOny, contentId, statusMap, evalTask);
            LOGGER.info("EvalViewDomainServiceImpl.createSubTask end. time is: {} ms.", (Object)(System.currentTimeMillis() - start));
            this.EVAL_TASK_DOMAIN_SERVICE.noEvaluatorGeneratorSubTask(saveSubTaskDyMap, contentId);
            LOGGER.info("EvalViewDomainServiceImpl.noEvaluatorGeneratorSubTask end. time is: {} ms.", (Object)(System.currentTimeMillis() - start));
        } else {
            if (HRStringUtils.equals((String)evaluatorEnum, (String)"5") || HRStringUtils.equals((String)evaluatorEnum, (String)"6") || HRStringUtils.equals((String)evaluatorEnum, (String)"2") || HRStringUtils.equals((String)evaluatorEnum, (String)"3")) {
                qFilter.and(evaluatorQFilter);
            }
            long start = System.currentTimeMillis();
            this.UpdateSubTask(result, loginParam, qFilter, filed, statusMap, evaluatorEnum);
            LOGGER.info("EvalViewDomainServiceImpl.anonMainBodyUpdateSubTask end. time is: {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        this.EVAL_TASK_DOMAIN_SERVICE.refreshEvalResult(Collections.singletonList(evalTaskId));
    }
}

