/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalSubTaskEntityService;
import kd.hrmp.bes.business.domain.evalsubtask.IEvalSubTaskDomainService;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.AbstractEvalSubTaskGenerator;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.GeneratorFactory;
import kd.hrmp.bes.common.enums.EvalSubTaskStatusEnum;
import kd.hrmp.bes.common.utils.DynamicObjectIdUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EvalSubTaskDomainServiceImpl
implements IEvalSubTaskDomainService {
    private static final Log log = LogFactory.getLog(EvalSubTaskDomainServiceImpl.class);
    private final EvalSubTaskEntityService evalSubTaskEntityService = BesServiceFactory.getService(EvalSubTaskEntityService.class);

    @Override
    public void createEvalSubTaskByEvalTaskObj(List<DynamicObject> evalTaskList, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        ArrayList allEvalSubTask = Lists.newArrayList();
        for (DynamicObject evalTaskObj : evalTaskList) {
            ArrayList subTaskList = Lists.newArrayList();
            DynamicObjectCollection contentColl = evalTaskObj.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contentColl) {
                AbstractEvalSubTaskGenerator generator = GeneratorFactory.createGenerator(evalTaskObj, content, evalTaskDependOnDbData);
                List<DynamicObject> evalSubTask = generator.generateSubTask();
                log.info("contentId: {}, evalSubTask Size: {}", content.getPkValue(), (Object)evalSubTask.size());
                subTaskList.addAll(evalSubTask);
            }
            allEvalSubTask.addAll(subTaskList);
        }
        List<Long> contentIdList = evalTaskList.stream().flatMap(evalTask -> evalTask.getDynamicObjectCollection("contententryentity").stream().map(contentEntry -> contentEntry.getLong("id"))).collect(Collectors.toList());
        this.deleteEvalSubTaskByEvalTaskId(contentIdList);
        this.saveSubTask(allEvalSubTask);
    }

    @Override
    public void adjustEvalSubTaskByEvalTaskObj(List<DynamicObject> evalTaskList, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        List ids = DynamicObjectIdUtils.getIds(evalTaskList);
        List<DynamicObject> dbEvalSubList = this.evalSubTaskEntityService.queryListByEvalTaskIdList(ids);
        Map<Long, List<DynamicObject>> evalSubTaskGroupContent = dbEvalSubList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        DynamicObject evalTaskObj = evalTaskList.get(0);
        ArrayList allGenEvalSubTaskList = Lists.newArrayList();
        ArrayList allDelEvalSubTaskIdList = Lists.newArrayList();
        DynamicObjectCollection contentColl = evalTaskObj.getDynamicObjectCollection("contententryentity");
        for (DynamicObject content : contentColl) {
            String specificEvaluator = content.getString("specificevaluator");
            if ("20".equals(specificEvaluator)) continue;
            long contentId = content.getLong("id");
            List<DynamicObject> curContentDbEvalSubTask = evalSubTaskGroupContent.get(contentId);
            AbstractEvalSubTaskGenerator generator = GeneratorFactory.createGenerator(evalTaskObj, content, evalTaskDependOnDbData);
            List<DynamicObject> curContentNewEvalSubTaskList = generator.generateSubTask();
            String evalObjType = content.getString("evaledobjtype");
            if ("10".equals(evalObjType)) {
                this.evalSubTaskAdjust(allGenEvalSubTaskList, allDelEvalSubTaskIdList, curContentDbEvalSubTask, curContentNewEvalSubTaskList, "objinfoperentryid");
                continue;
            }
            this.evalSubTaskAdjust(allGenEvalSubTaskList, allDelEvalSubTaskIdList, curContentDbEvalSubTask, curContentNewEvalSubTaskList, "objinfoorgentryid");
        }
        log.info("EvalSubTaskDomainServiceImpl.adjustEvalSubTaskByEvalTaskObj.allDelEvalSubTaskIdList: {}", (Object)allDelEvalSubTaskIdList);
        if (CollectionUtils.isNotEmpty((Collection)allDelEvalSubTaskIdList)) {
            this.evalSubTaskEntityService.delete(allDelEvalSubTaskIdList.toArray());
        }
        if (CollectionUtils.isNotEmpty((Collection)allGenEvalSubTaskList)) {
            this.saveSubTask(allGenEvalSubTaskList);
        }
    }

    private void evalSubTaskAdjust(List<DynamicObject> allGenEvalSubTaskList, List<Long> allDelEvalSubTaskIdList, List<DynamicObject> curContentDbEvalSubTask, List<DynamicObject> curContentNewEvalSubTaskList, String evalObjEntryKey) {
        Map<Boolean, List<DynamicObject>> dbEvalSubTaskPar = this.evalSubTaskParByDataSource(curContentDbEvalSubTask);
        Map<Boolean, List<DynamicObject>> newGenSubTaskPar = this.evalSubTaskParByDataSource(curContentNewEvalSubTaskList);
        List<DynamicObject> employeeDbEvalSubTaskList = dbEvalSubTaskPar.get(Boolean.TRUE);
        List<Pair<Long, Long>> employeeDbEvalSubTaskPair = this.getMatchKey(employeeDbEvalSubTaskList, evalObjEntryKey, "evalinternalper");
        List<DynamicObject> employeeNewEvalSubTaskList = newGenSubTaskPar.get(Boolean.TRUE);
        List<Pair<Long, Long>> employeeNewEvalSubTaskPair = this.getMatchKey(employeeNewEvalSubTaskList, evalObjEntryKey, "evalinternalper");
        this.findDeleteEvalSubTask(allDelEvalSubTaskIdList, evalObjEntryKey, employeeDbEvalSubTaskList, employeeNewEvalSubTaskPair, "evalinternalper");
        this.findNewEvalSubTask(allGenEvalSubTaskList, employeeNewEvalSubTaskList, evalObjEntryKey, employeeDbEvalSubTaskPair, "evalinternalper.id");
        List<DynamicObject> outDbEvalSubTaskList = dbEvalSubTaskPar.get(Boolean.FALSE);
        List<Pair<Long, Long>> outDbEvalSubTaskPair = this.getMatchKey(outDbEvalSubTaskList, evalObjEntryKey, "evaloutsiderentryid");
        List<DynamicObject> outNewEvalSubTaskList = newGenSubTaskPar.get(Boolean.FALSE);
        List<Pair<Long, Long>> outNewEvalSubTaskPair = this.getMatchKey(outNewEvalSubTaskList, evalObjEntryKey, "evaloutsiderentryid");
        this.findDeleteEvalSubTask(allDelEvalSubTaskIdList, evalObjEntryKey, outDbEvalSubTaskList, outNewEvalSubTaskPair, "evaloutsiderentryid");
        this.findNewEvalSubTask(allGenEvalSubTaskList, outNewEvalSubTaskList, evalObjEntryKey, outDbEvalSubTaskPair, "evaloutsiderentryid");
    }

    private void findNewEvalSubTask(List<DynamicObject> allGenEvalSubTaskList, List<DynamicObject> curContentNewEvalSubTaskList, String evalObjEntryKey, List<Pair<Long, Long>> evaluatorDbEvalSubTaskPair, String evaluatorKey) {
        List newEmployeeSaveEvalSubTaskList = curContentNewEvalSubTaskList.stream().filter(obj -> {
            long evalObjKey = obj.getLong(evalObjEntryKey);
            long outEvaluatorEntryKey = obj.getLong(evaluatorKey);
            return !evaluatorDbEvalSubTaskPair.contains(Pair.of((Object)evalObjKey, (Object)outEvaluatorEntryKey));
        }).collect(Collectors.toList());
        allGenEvalSubTaskList.addAll(newEmployeeSaveEvalSubTaskList);
    }

    private void findDeleteEvalSubTask(List<Long> allDelEvalSubTaskIdList, String evalObjEntryKey, List<DynamicObject> employeeDbEvalSubTaskList, List<Pair<Long, Long>> employeeNewEvalSubTaskPair, String evaluatorKey) {
        for (DynamicObject employeeDbEvalSubTask : employeeDbEvalSubTaskList) {
            long evalObjEntryId = employeeDbEvalSubTask.getLong(evalObjEntryKey);
            long employeeId = DynamicObjectIdUtils.getBaseDataId((DynamicObject)employeeDbEvalSubTask, (String)evaluatorKey);
            Pair matchKey = Pair.of((Object)evalObjEntryId, (Object)employeeId);
            if (employeeNewEvalSubTaskPair.contains(matchKey)) continue;
            long delEvalSubTaskId = employeeDbEvalSubTask.getLong("id");
            allDelEvalSubTaskIdList.add(delEvalSubTaskId);
        }
    }

    private Map<Boolean, List<DynamicObject>> evalSubTaskParByDataSource(List<DynamicObject> curContentDbEvalSubTask) {
        if (CollectionUtils.isEmpty(curContentDbEvalSubTask)) {
            HashMap nullMap = Maps.newHashMapWithExpectedSize((int)2);
            nullMap.put(Boolean.TRUE, Collections.emptyList());
            nullMap.put(Boolean.FALSE, Collections.emptyList());
            return nullMap;
        }
        return curContentDbEvalSubTask.stream().collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("evaluatorsource"))));
    }

    private List<Pair<Long, Long>> getMatchKey(List<DynamicObject> employeeEvalSubTaskList, String leftKey, String rightKey) {
        return employeeEvalSubTaskList.stream().map(obj -> Pair.of((Object)obj.getLong(leftKey), (Object)DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)rightKey))).collect(Collectors.toList());
    }

    public void saveSubTask(List<DynamicObject> subTaskList) {
        this.evalSubTaskEntityService.save(subTaskList.toArray(new DynamicObject[0]));
    }

    @Override
    public void deleteEvalSubTaskByEvalTaskId(List<Long> evalContentIds) {
        QFilter idFilter = new QFilter("taskcontentid", "in", evalContentIds);
        this.evalSubTaskEntityService.deleteByFilter(idFilter.toArray());
    }

    @Override
    public Map<Long, Pair<Integer, Integer>> getEvalTotalProgressByEvalTask(List<Long> evalTaskIdList) {
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        QFilter removeMarkFilter = this.getRemoveMarkFilter();
        List<DynamicObject> evalSubTaskList = this.evalSubTaskEntityService.queryOriginalList("evaltask.id evaltask_id,taskstatus", new QFilter[]{evalTaskFilter, removeMarkFilter});
        return evalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask_id"), Collectors.collectingAndThen(Collectors.toList(), groupEvalTaskList -> {
            long completeNum = groupEvalTaskList.stream().filter(obj -> "D".equals(obj.getString("taskstatus")) || "C".equals(obj.getString("taskstatus"))).count();
            return Pair.of((Object)groupEvalTaskList.size(), (Object)((int)completeNum));
        })));
    }

    @Override
    public void completeEvalSubTask(Map<Boolean, List<DynamicObject>> evalTaskParByProcessMode) {
        List<DynamicObject> removeObjList;
        List<DynamicObject> waiverObjList = evalTaskParByProcessMode.get(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty(waiverObjList)) {
            List waiverEvalSubTaskIdList = DynamicObjectIdUtils.getIds(waiverObjList);
            DynamicObject[] waiverEvalSubTaskArr = this.waiverProcess(waiverEvalSubTaskIdList);
            this.evalSubTaskEntityService.save(waiverEvalSubTaskArr);
        }
        if (CollectionUtils.isNotEmpty(removeObjList = evalTaskParByProcessMode.get(Boolean.FALSE))) {
            List removeEvalSubTaskIdList = DynamicObjectIdUtils.getIds(removeObjList);
            DynamicObject[] removeEvalSubTaskArr = this.removeProcess(removeEvalSubTaskIdList);
            this.evalSubTaskEntityService.save(removeEvalSubTaskArr);
        }
    }

    @Override
    public void noEvaluatorRealSupplementaryValue(Map<Long, DynamicObject> evalObjIdEvalSubTaskMap, DynamicObject evalTaskObj, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        for (DynamicObject evalSubTaskObj : evalObjIdEvalSubTaskMap.values()) {
            Map<Long, Map<String, Object>> employeeInfoMap = evalTaskDependOnDbData.getEmployeeInfoMap();
            evalSubTaskObj.set("taskstatus", (Object)EvalSubTaskStatusEnum.IS_EVALUATE.getCode());
            if (!MapUtils.isNotEmpty(employeeInfoMap)) continue;
            evalSubTaskObj.set("evalinternalper", (Object)employeeInfoMap.keySet().stream().findFirst().orElseGet(() -> 0L));
        }
        this.evalSubTaskEntityService.save(evalObjIdEvalSubTaskMap.values().toArray(new DynamicObject[0]));
    }

    @Override
    public void noEvaluatorAnonSupplementaryValue(Map<Long, DynamicObject> evalObjIdEvalSubTaskMap, DynamicObject evalTaskObj, String evaluatorNumber) {
        for (DynamicObject evalSubTaskObj : evalObjIdEvalSubTaskMap.values()) {
            evalSubTaskObj.set("taskstatus", (Object)EvalSubTaskStatusEnum.IS_EVALUATE.getCode());
            evalSubTaskObj.set("evaluatorNumber", (Object)evaluatorNumber);
        }
        this.evalSubTaskEntityService.save(evalObjIdEvalSubTaskMap.values().toArray(new DynamicObject[0]));
    }

    public DynamicObject[] waiverProcess(List<Long> waiverEvalTaskIdList) {
        DynamicObject[] waiverEvalSubTask;
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", waiverEvalTaskIdList);
        QFilter taskStatusFilter = new QFilter("taskstatus", "=", (Object)EvalSubTaskStatusEnum.UN_EVALUATE.getCode());
        for (DynamicObject evalSubTask : waiverEvalSubTask = this.evalSubTaskEntityService.query("taskstatus,endtime", new QFilter[]{evalTaskFilter, taskStatusFilter})) {
            evalSubTask.set("taskstatus", (Object)EvalSubTaskStatusEnum.ABSTAIN.getCode());
            evalSubTask.set("endtime", (Object)new Date());
        }
        return waiverEvalSubTask;
    }

    public DynamicObject[] removeProcess(List<Long> waiverEvalTaskIdList) {
        DynamicObject[] waiverEvalSubTask;
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", waiverEvalTaskIdList);
        QFilter taskStatusFilter = new QFilter("taskstatus", "=", (Object)EvalSubTaskStatusEnum.UN_EVALUATE.getCode());
        for (DynamicObject evalSubTask : waiverEvalSubTask = this.evalSubTaskEntityService.query("removemark", new QFilter[]{evalTaskFilter, taskStatusFilter})) {
            evalSubTask.set("removemark", (Object)Boolean.TRUE);
        }
        return waiverEvalSubTask;
    }

    public QFilter getRemoveMarkFilter() {
        return new QFilter("removemark", "=", (Object)Boolean.FALSE);
    }
}

