/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EvalTaskSetGroupHelper {
    private static final Log LOG = LogFactory.getLog(EvalTaskSetGroupHelper.class);

    public static void createOPenDesignData(List<DynamicObject> list, IFormView view) {
        IDataModel model = view.getModel();
        if (list.size() > 0) {
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", list.size());
            int index = 0;
            for (DynamicObject dynamicObject : list) {
                model.setValue("pointertype", dynamicObject.get("indicatortype"), index);
                model.setValue("pointername", dynamicObject.get("indicatorname"), index);
                model.setValue("pointerdes", dynamicObject.get("indicatordescription"), index);
                String codeNumber = EvalTaskSetGroupHelper.getCode(view, dynamicObject);
                model.setValue("combofield", (Object)codeNumber, index);
                ++index;
            }
            view.sendFormAction(view.getParentView());
        }
    }

    public static String getCode(IFormView view, DynamicObject dynamicObject) {
        Long contentId = (Long)view.getParentView().getFormShowParameter().getCustomParam("contententryentityid");
        IFormView evalTaskView = view.getParentView().getParentView();
        DynamicObject entryRowEntity = EvalTaskSetGroupHelper.getContentEntryRowEntity(evalTaskView, contentId);
        assert (entryRowEntity != null);
        DynamicObjectCollection groupEntryEntity = entryRowEntity.getDynamicObjectCollection("groupsubentry");
        String codeNumber = "";
        String area = (String)view.getFormShowParameter().getCustomParam("areacode");
        for (DynamicObject groupDot : groupEntryEntity) {
            String code;
            boolean group = dynamicObject.getLong("group") == 0L;
            if (group || !dynamicObject.get("group").equals(groupDot.get("id")) || !groupDot.getString("groupareacode").equals(area) || !HRStringUtils.isNotEmpty((String)(code = String.valueOf(groupDot.getLong("groupareaseq"))))) continue;
            codeNumber = codeNumber.concat(code);
        }
        return codeNumber;
    }

    public static void createScoreData(List<DynamicObject> list, IFormView view) {
        IDataModel model = view.getModel();
        if (list.size() > 0) {
            model.deleteEntryData("scoreentryentity");
            model.batchCreateNewEntryRow("scoreentryentity", list.size());
            int index = 0;
            for (DynamicObject dynamicObject : list) {
                model.setValue("indicatortype", dynamicObject.get("indicatortype"), index);
                model.setValue("indicatorname", dynamicObject.get("indicatorname"), index);
                model.setValue("indicatordescription", dynamicObject.get("indicatordescription"), index);
                String code = EvalTaskSetGroupHelper.getCode(view, dynamicObject);
                model.setValue("group", (Object)code, index);
                ++index;
            }
            view.sendFormAction(view.getParentView());
        }
    }

    private static DynamicObject getContentEntryRowEntity(IFormView evalTaskView, Long contentId) {
        DynamicObjectCollection entryEntity = evalTaskView.getModel().getEntryEntity("contententryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            for (DynamicObject entry : entryEntity) {
                if (contentId.longValue() != entry.getLong("id")) continue;
                return entry;
            }
        }
        return null;
    }

    public static void refreshField(IFormView view) {
        DynamicObjectCollection contententryentity = view.getModel().getDataEntity(true).getDynamicObjectCollection("contententryentity");
        for (DynamicObject cont : contententryentity) {
            Object evaltemp = cont.get("evaltemp");
            if (HRObjectUtils.isEmpty((Object)evaltemp)) continue;
            DynamicObjectCollection indicator = cont.getDynamicObjectCollection("indicatorsubentry");
            DynamicObjectCollection group = cont.getDynamicObjectCollection("groupsubentry");
            ArrayList<Long> groupIds = new ArrayList<Long>(group.size());
            for (DynamicObject grDot : group) {
                groupIds.add(grDot.getLong("id"));
            }
            ArrayList<Long> groups = new ArrayList<Long>(indicator.size());
            for (DynamicObject indicatorDot : indicator) {
                long id = indicatorDot.getLong("group");
                if (id == 0L || !groupIds.contains(id)) continue;
                groups.add(id);
                LOG.info("EvalTaskSetGroupHelper.refreshField id:{}", (Object)id);
                LOG.info("EvalTaskSetGroupHelper.refreshField groupIds:{}", groupIds);
            }
            if (!CollectionUtils.isNotEmpty(groups)) continue;
            for (DynamicObject indicatorDot : indicator) {
                long groupId = indicatorDot.getLong("group");
                if (groupId != 0L && groupIds.contains(groupId)) continue;
                for (DynamicObject grDoc : group) {
                    if (!grDoc.getString("groupname").equals(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"EvalTaskSetGroupHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0])) || !grDoc.getString("groupareacode").equals(indicatorDot.getString("areacode"))) continue;
                    Object entryID = grDoc.get("id");
                    indicatorDot.set("group", entryID);
                }
            }
        }
    }
}

