/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.qing.util.MapUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalSubTaskEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalTaskEntityService;
import kd.hrmp.bes.common.constants.eval.EvalSubTaskConstants;
import kd.hrmp.bes.common.enums.EvalSubTaskStatusEnum;
import kd.hrmp.bes.common.enums.ObjEvaluatorTaskStatusEnum;
import kd.hrmp.bes.common.utils.DynamicObjectIdUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ProgressCalcHelper
implements EvalSubTaskConstants {
    List<Long> evalContentIdList;
    QFilter contentFilter;
    AbstractBaseEntityService entityService;
    Map<Long, DynamicObject> evalContentMap;
    Map<Long, DynamicObject> indicatorIdMap;
    private final EvalTaskEntityService evalTaskEntityService = BesServiceFactory.getService(EvalTaskEntityService.class);
    private final EvalSubTaskEntityService evalSubTaskEntityService = BesServiceFactory.getService(EvalSubTaskEntityService.class);
    private static final Log log = LogFactory.getLog(ProgressCalcHelper.class);

    public void setEvalContentIdList(List<Long> evalContentIdList) {
        this.evalContentIdList = evalContentIdList;
    }

    public void setEntityService(AbstractBaseEntityService entityService) {
        this.entityService = entityService;
    }

    public void calcProgress(Map<Long, DynamicObject> contentMap) {
        this.contentFilter = new QFilter("taskcontentid", "in", this.evalContentIdList);
        DynamicObject[] evalObjPerArr = this.entityService.loadDynamicObjectArray(this.contentFilter.toArray());
        this.calcEvalObjResult(evalObjPerArr, contentMap);
    }

    private void calcEvalObjResult(DynamicObject[] evalObjArr, Map<Long, DynamicObject> contentMap) {
        List<DynamicObject> evalSubTaskArrByContent = this.evalSubTaskEntityService.queryOriginalList("id,taskstatus,taskcontentid,evalbodyweight,entryentity.evalindicatorentryid evalindicatorentryid,entryentity.indicatortype indicatortype,entryentity.singlechoice singlechoice,entryentity.multiplechoice multiplechoice,entryentity.numerical numerical,objinfoorgentryid,objinfoperentryid,evalinternalper,evaloutsiderentryid,accountanon,evaluatornumber,evaluatorsource,evalbodynameanon,evaldatasource", new QFilter[]{this.getRemoveMarkFilter(), this.contentFilter});
        Map<Long, List<DynamicObject>> evalSubTaskGroupByContentId = evalSubTaskArrByContent.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        Map<Long, List<DynamicObject>> evalObjGroupByContentId = Arrays.stream(evalObjArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        for (Map.Entry<Long, List<DynamicObject>> evalObjGroupEntry : evalObjGroupByContentId.entrySet()) {
            Long curContentId = evalObjGroupEntry.getKey();
            List<DynamicObject> curContentEvalList = evalObjGroupEntry.getValue();
            List<DynamicObject> curContentEvalSubTaskList = evalSubTaskGroupByContentId.get(curContentId);
            if (CollectionUtils.isEmpty(curContentEvalSubTaskList)) continue;
            DynamicObject evalContentObj = this.evalContentMap.get(curContentId);
            this.doCalcIndicatorResult(curContentEvalList, evalContentObj, curContentEvalSubTaskList, contentMap);
        }
        this.entityService.save(evalObjArr);
    }

    private void doCalcIndicatorResult(List<DynamicObject> curContentEvalObjList, DynamicObject contentObj, List<DynamicObject> curContentEvalSubTaskList, Map<Long, DynamicObject> contentMap) {
        String evalObjIdKey = this.getEvalObjIdKey(contentObj);
        Map<Long, List<DynamicObject>> evalSubTaskGroupByIndicatorEntryId = curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evalindicatorentryid")));
        Map<Long, List<DynamicObject>> evalSubTaskGroupByEvalObj = curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong(evalObjIdKey)));
        int scoreAccuracy = contentObj.getInt("scoreaccuracy");
        RoundingMode roundingMode = this.getRoundingMode(contentObj);
        String evalObjType = contentObj.getString("evaledobjtype");
        boolean orgEvalObjType = "20".equals(evalObjType);
        log.info("ProgressCalcHelper.doCalcIndicatorResult-begin");
        for (DynamicObject curEvalObj : curContentEvalObjList) {
            boolean completeEvaluate;
            long evalObjId = curEvalObj.getLong(evalObjIdKey);
            List<DynamicObject> curEvalObjAllSubTask = evalSubTaskGroupByEvalObj.get(evalObjId);
            boolean allNoEvaluate = curEvalObjAllSubTask.stream().noneMatch(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus")));
            boolean waitEvaluate = allNoEvaluate && curEvalObj.getInt("completeevalnum") == 0;
            boolean allEvaluate = curEvalObjAllSubTask.stream().noneMatch(obj -> EvalSubTaskStatusEnum.UN_EVALUATE.getCode().equals(obj.getString("taskstatus")));
            boolean bl = completeEvaluate = allEvaluate && ObjEvaluatorTaskStatusEnum.COMPLETED.getCode().equals(curEvalObj.getString("evalstatus"));
            if (waitEvaluate || completeEvaluate) continue;
            this.calcScoreRes(evalSubTaskGroupByIndicatorEntryId, scoreAccuracy, roundingMode, orgEvalObjType, curEvalObj, contentObj, contentMap);
            this.calcTotalScore(scoreAccuracy, roundingMode, curEvalObj, curContentEvalSubTaskList, contentObj, contentMap);
            DynamicObjectCollection noScoreEntry = curEvalObj.getDynamicObjectCollection("noscoreentry");
            for (DynamicObject noScoreObj : noScoreEntry) {
                long indicatorEntryId = noScoreObj.getLong("indicator");
                String optSortCode = noScoreObj.getString("optsindicaseq");
                List<DynamicObject> curIndicatorResList = evalSubTaskGroupByIndicatorEntryId.get(indicatorEntryId);
                List<DynamicObject> curIndicatorResListFilterCurEvalObj = this.getCurIndicatorResListFilterCurEvalObj(orgEvalObjType, curEvalObj, curIndicatorResList);
                if (!CollectionUtils.isNotEmpty(curIndicatorResListFilterCurEvalObj)) continue;
                this.calcNoScoreResult(noScoreObj, optSortCode, curIndicatorResListFilterCurEvalObj, contentObj);
            }
        }
        log.info("ProgressCalcHelper.doCalcIndicatorResult-end");
    }

    private void calcScoreRes(Map<Long, List<DynamicObject>> evalSubTaskGroupByIndicatorEntryId, int scoreAccuracy, RoundingMode roundingMode, boolean orgEvalObjType, DynamicObject evalObj, DynamicObject contentObj, Map<Long, DynamicObject> contentMap) {
        DynamicObjectCollection scoreEntry = evalObj.getDynamicObjectCollection("scoreentry");
        String needMainBody = contentObj.getString("evalmainbody");
        if ("10".equals(needMainBody)) {
            boolean realFlag;
            String evalObjIdKey = this.getEvalObjIdKey(contentObj);
            ArrayList mainBodyGroupList = Lists.newArrayListWithExpectedSize((int)500);
            String realAnon = contentObj.getString("realorcryptonym");
            if ("1".equals(realAnon)) {
                Set<Pair<String, String>> evalObjEvaluatorReal = this.getEvalObjEvaluatorReal(evalSubTaskGroupByIndicatorEntryId.values(), contentObj, evalObjIdKey);
                DynamicObject content = contentMap.get(contentObj.getLong("id"));
                DynamicObjectCollection evalRealEntry = content.getDynamicObjectCollection("evaluatorrealsubentry");
                ProgressCalcHelper.getRealMainBodyGroupList(evalRealEntry, mainBodyGroupList, evalObj.getLong(evalObjIdKey), evalObjEvaluatorReal);
                realFlag = true;
            } else {
                realFlag = false;
            }
            for (DynamicObject scoreObj : scoreEntry) {
                long scoreEvalEntryId = scoreObj.getLong("scoreevalindientryid");
                List<DynamicObject> curIndicatorResList = evalSubTaskGroupByIndicatorEntryId.get(scoreEvalEntryId);
                List<DynamicObject> curIndicatorResListFilterCurEvalObj = this.getCurIndicatorResListFilterCurEvalObj(orgEvalObjType, evalObj, curIndicatorResList);
                if (!realFlag) {
                    for (DynamicObject evalSubTask : curIndicatorResListFilterCurEvalObj) {
                        String evaluatorId = evalSubTask.getString("evaluatornumber");
                        String evalMainBody = evalSubTask.getString("evalbodynameanon");
                        mainBodyGroupList.add(new MainBodyGroup(evalMainBody, evaluatorId));
                    }
                }
                if (!CollectionUtils.isNotEmpty(curIndicatorResListFilterCurEvalObj)) continue;
                this.calcScoreResult(scoreAccuracy, roundingMode, scoreObj, curIndicatorResListFilterCurEvalObj, true, mainBodyGroupList);
            }
        } else {
            for (DynamicObject scoreObj : scoreEntry) {
                long scoreEvalEntryId = scoreObj.getLong("scoreevalindientryid");
                List<DynamicObject> curIndicatorResList = evalSubTaskGroupByIndicatorEntryId.get(scoreEvalEntryId);
                List<DynamicObject> curIndicatorResListFilterCurEvalObj = this.getCurIndicatorResListFilterCurEvalObj(orgEvalObjType, evalObj, curIndicatorResList);
                if (!CollectionUtils.isNotEmpty(curIndicatorResListFilterCurEvalObj)) continue;
                this.calcScoreResult(scoreAccuracy, roundingMode, scoreObj, curIndicatorResListFilterCurEvalObj, false, null);
            }
        }
    }

    private Set<Pair<String, String>> getEvalObjEvaluatorReal(Collection<List<DynamicObject>> evalSubTaskGroupByIndicatorEntryId, DynamicObject contentObj, String evalObjIdKey) {
        return evalSubTaskGroupByIndicatorEntryId.stream().map(value -> value.stream().map(obj -> {
            String evalObjId = obj.getString(evalObjIdKey);
            String evaluatorId = obj.getString(this.getEvaluatorIdKey(contentObj, (DynamicObject)obj));
            return Pair.of((Object)evalObjId, (Object)evaluatorId);
        }).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public void calcEvaluatorProgress() {
        this.contentFilter = new QFilter("taskcontentid", "in", this.evalContentIdList);
        DynamicObject[] evalObjPerArr = this.entityService.loadDynamicObjectArray(this.contentFilter.toArray());
        this.calcEvaluatorResult(evalObjPerArr);
    }

    private void calcEvaluatorResult(DynamicObject[] evaluatorArr) {
        List<DynamicObject> evalSubTaskArrByContent = this.evalSubTaskEntityService.queryOriginalList("id,taskstatus,taskcontentid,evalbodyweight,entryentity.evalindicatorentryid evalindicatorentryid,entryentity.indicatortype indicatortype,entryentity.singlechoice singlechoice,entryentity.multiplechoice multiplechoice,entryentity.numerical numerical,objinfoorgentryid,objinfoperentryid,evalinternalper,evaloutsiderentryid,accountanon,evaluatornumber,evaluatorsource", new QFilter[]{this.getRemoveMarkFilter(), this.contentFilter});
        Map<Long, List<DynamicObject>> evalSubTaskGroupByContentId = evalSubTaskArrByContent.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        Map<Long, List<DynamicObject>> evaluatorGroupByContentId = Arrays.stream(evaluatorArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        log.info("ProgressCalcHelper.calcEvaluatorResult-begin");
        for (Map.Entry<Long, List<DynamicObject>> evaluatorGroupEntry : evaluatorGroupByContentId.entrySet()) {
            Long curContentId = evaluatorGroupEntry.getKey();
            List<DynamicObject> curContentEvaluatorList = evaluatorGroupEntry.getValue();
            List<DynamicObject> curContentEvalSubTaskList = evalSubTaskGroupByContentId.get(curContentId);
            if (CollectionUtils.isEmpty(curContentEvalSubTaskList)) continue;
            DynamicObject evalContentObj = this.evalContentMap.get(curContentId);
            this.doCalcIndicatorEvaluatorResult(curContentEvaluatorList, evalContentObj, curContentEvalSubTaskList);
        }
        log.info("ProgressCalcHelper.calcEvaluatorResult-end");
        this.entityService.save(evaluatorArr);
    }

    private void calcScoreEvaluatorResult(int scoreAccuracy, RoundingMode roundingMode, DynamicObject scoreObj, List<DynamicObject> curIndicatorResList) {
        BigDecimal oneReduce = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(this::getNumerical).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal weightedAvgScore = oneReduce.divide(new BigDecimal(curIndicatorResList.size()), scoreAccuracy, roundingMode);
        scoreObj.set("weightedavgscore", (Object)weightedAvgScore);
        BigDecimal maxVal = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(this::getNumerical).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        scoreObj.set("maxval", (Object)maxVal.setScale(scoreAccuracy, roundingMode));
        BigDecimal minVal = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(this::getNumerical).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        scoreObj.set("minval", (Object)minVal.setScale(scoreAccuracy, roundingMode));
    }

    private void doCalcIndicatorEvaluatorResult(List<DynamicObject> curContentEvaluatorList, DynamicObject contentObj, List<DynamicObject> curContentEvalSubTaskList) {
        Map<Long, List<DynamicObject>> evalSubTaskGroupByIndicatorEntryId = curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evalindicatorentryid")));
        Map<String, List<DynamicObject>> evalSubTaskGroupByEvaluatorKey = curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> {
            String evaluatorIdKey = this.getEvaluatorIdKey(contentObj, (DynamicObject)obj);
            return obj.getString(evaluatorIdKey);
        }));
        int scoreAccuracy = contentObj.getInt("scoreaccuracy");
        RoundingMode roundingMode = this.getRoundingMode(contentObj);
        String evaluatorType = contentObj.getString("realorcryptonym");
        boolean evaluatorRealType = "1".equals(evaluatorType);
        log.info("kd.hrmp.bes.business.domain.evalsubtask.ProgressCalcHelper.doCalcIndicatorEvaluatorResult-begin");
        for (DynamicObject curEvaluatorObj : curContentEvaluatorList) {
            boolean completeEvaluate;
            String evaluatorIdKey;
            List curEvaluatorAllSubTask = evalSubTaskGroupByEvaluatorKey.getOrDefault(curEvaluatorObj.getString(evaluatorIdKey = this.getEvaluatorIdKeyByEvaluator(contentObj, curEvaluatorObj)), Collections.emptyList());
            boolean allNoEvaluate = curEvaluatorAllSubTask.stream().noneMatch(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus")));
            boolean waitEvaluate = allNoEvaluate && curEvaluatorObj.getInt("completeevalnum") == 0;
            boolean allEvaluate = curEvaluatorAllSubTask.stream().noneMatch(obj -> EvalSubTaskStatusEnum.UN_EVALUATE.getCode().equals(obj.getString("taskstatus")));
            boolean bl = completeEvaluate = allEvaluate && ObjEvaluatorTaskStatusEnum.COMPLETED.getCode().equals(curEvaluatorObj.getString("evalstatus"));
            if (waitEvaluate || completeEvaluate) continue;
            DynamicObjectCollection scoreEntry = curEvaluatorObj.getDynamicObjectCollection("scoreentry");
            for (DynamicObject scoreEntryObj : scoreEntry) {
                long scoreEvalEntryId = scoreEntryObj.getLong("scoreevalindientryid");
                List<DynamicObject> curIndicatorResList = evalSubTaskGroupByIndicatorEntryId.get(scoreEvalEntryId);
                List<DynamicObject> curIndicatorResListFilterCurEvaluator = this.getCurIndicatorResListFilterCurEvaluator(evaluatorRealType, curEvaluatorObj, curIndicatorResList);
                if (!CollectionUtils.isNotEmpty(curIndicatorResListFilterCurEvaluator)) continue;
                this.calcScoreEvaluatorResult(scoreAccuracy, roundingMode, scoreEntryObj, curIndicatorResListFilterCurEvaluator);
            }
            this.calcTotalEvaluatorScore(curEvaluatorObj, curContentEvalSubTaskList, contentObj);
            DynamicObjectCollection noScoreEntry = curEvaluatorObj.getDynamicObjectCollection("noscoreentry");
            for (DynamicObject noScoreObj : noScoreEntry) {
                long indicatorEntryId = noScoreObj.getLong("indicator");
                String optSortCode = noScoreObj.getString("optsindicaseq");
                List<DynamicObject> curIndicatorResList = evalSubTaskGroupByIndicatorEntryId.get(indicatorEntryId);
                List<DynamicObject> curIndicatorResListFilterCurEvalObj = this.getCurIndicatorResListFilterCurEvaluator(evaluatorRealType, curEvaluatorObj, curIndicatorResList);
                if (!CollectionUtils.isNotEmpty(curIndicatorResListFilterCurEvalObj)) continue;
                this.calcNoScoreEvaluatorResult(noScoreObj, optSortCode, curIndicatorResListFilterCurEvalObj);
            }
        }
        log.info("kd.hrmp.bes.business.domain.evalsubtask.ProgressCalcHelper.doCalcIndicatorEvaluatorResult-end");
    }

    private void calcTotalEvaluatorScore(DynamicObject curEvaluatorObj, List<DynamicObject> curContentEvalSubTaskList, DynamicObject contentObj) {
        String evalObjType = contentObj.getString("evaledobjtype");
        Map<Long, List<DynamicObject>> evaluatorGroupMap = "10".equals(evalObjType) ? curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("objinfoperentryid"))) : curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("objinfoorgentryid")));
        this.runCalcTotalEvaluatorScore(curEvaluatorObj, contentObj, evaluatorGroupMap);
    }

    private void runCalcTotalEvaluatorScore(DynamicObject curEvaluatorObj, DynamicObject contentObj, Map<Long, List<DynamicObject>> evalSubTaskGroupEvalObj) {
        String indicatorEvalType = contentObj.getString("indicatorevaltype");
        if ("10".equals(indicatorEvalType)) {
            return;
        }
        String calcMethod = contentObj.getString("calcmethod");
        int scoreAccuracy = contentObj.getInt("scoreaccuracy");
        RoundingMode roundingMode = this.getRoundingMode(contentObj);
        HashMap evalObjTotalScoreMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection scoreEntry = curEvaluatorObj.getDynamicObjectCollection("scoreentry");
        Map<Long, DynamicObject> scoreIndicatorList = this.getScoreIndicatorList(scoreEntry);
        long totalScoreObjId = this.getTotalScoreObjId(scoreEntry);
        HashSet distinctSubTaskOriginSet = Sets.newHashSetWithExpectedSize((int)evalSubTaskGroupEvalObj.size());
        for (Map.Entry<Long, List<DynamicObject>> evalSubTaskGroupEvalObjEntry : evalSubTaskGroupEvalObj.entrySet()) {
            Long evalObjId = evalSubTaskGroupEvalObjEntry.getKey();
            BigDecimal curIndicatorScoreSum = BigDecimal.ZERO;
            boolean existEvaluated = false;
            for (DynamicObject evalSubTask : evalSubTaskGroupEvalObjEntry.getValue()) {
                long evalIndicatorEntryId;
                DynamicObject evalTaskIndicatorObj;
                String taskStatus = evalSubTask.getString("taskstatus");
                String evaluatorIdKey = this.getEvaluatorIdKey(contentObj, evalSubTask);
                if (DynamicObjectIdUtils.getBaseDataId((DynamicObject)curEvaluatorObj, (String)evaluatorIdKey) == evalSubTask.getLong(evaluatorIdKey)) {
                    distinctSubTaskOriginSet.add(evalSubTask.getLong("id"));
                }
                if (DynamicObjectIdUtils.getBaseDataId((DynamicObject)curEvaluatorObj, (String)evaluatorIdKey) != evalSubTask.getLong(evaluatorIdKey) || !EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(taskStatus) || (evalTaskIndicatorObj = scoreIndicatorList.get(evalIndicatorEntryId = evalSubTask.getLong("evalindicatorentryid"))) == null) continue;
                existEvaluated = true;
                BigDecimal curIndicatorResult = this.getCurIndicatorScore(calcMethod, evalSubTask, evalTaskIndicatorObj);
                curIndicatorScoreSum = curIndicatorScoreSum.add(curIndicatorResult);
            }
            if (!existEvaluated) continue;
            evalObjTotalScoreMap.put(evalObjId, curIndicatorScoreSum);
        }
        if (MapUtils.isEmpty((Map)evalObjTotalScoreMap)) {
            return;
        }
        BigDecimal maxVal = evalObjTotalScoreMap.values().stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        BigDecimal minVal = evalObjTotalScoreMap.values().stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        BigDecimal totalScoreSum = evalObjTotalScoreMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalScore = totalScoreSum.divide(new BigDecimal(distinctSubTaskOriginSet.size()), scoreAccuracy, roundingMode);
        curEvaluatorObj.set("totalscore", (Object)totalScore);
        scoreEntry.stream().filter(obj -> obj.getLong("id") == totalScoreObjId).findAny().ifPresent(obj -> {
            obj.set("maxval", (Object)maxVal.setScale(scoreAccuracy, roundingMode));
            obj.set("minval", (Object)minVal.setScale(scoreAccuracy, roundingMode));
            obj.set("weightedavgscore", (Object)totalScore);
        });
    }

    private void calcNoScoreEvaluatorResult(DynamicObject noScoreObj, String optSortCode, List<DynamicObject> curIndicatorResList) {
        BigDecimal optRatio;
        BigDecimal optVotesBigDecimal;
        Integer optVotes;
        String indicatorType = noScoreObj.getString("indicatortype");
        if ("A".equals(indicatorType)) {
            Map<String, Integer> optSeqNumMap = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.groupingBy(obj -> obj.getString("singlechoice"), Collectors.collectingAndThen(Collectors.toList(), List::size)));
            optVotes = optSeqNumMap.getOrDefault(optSortCode, 0);
            noScoreObj.set("optvotes", (Object)optVotes);
            optVotesBigDecimal = new BigDecimal(optVotes);
            optRatio = optVotesBigDecimal.divide(new BigDecimal(curIndicatorResList.size()), 4, DEFAULT_ROUND_MODE);
            noScoreObj.set("optratio", (Object)optRatio);
        }
        if ("B".equals(indicatorType)) {
            Map<String, Integer> mulOptSeqNumMap = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).flatMap(obj -> Arrays.stream(obj.getString("multiplechoice").split(",")).filter(StringUtils::isNotBlank)).collect(Collectors.groupingBy(obj -> obj, Collectors.collectingAndThen(Collectors.toList(), List::size)));
            optVotes = mulOptSeqNumMap.getOrDefault(optSortCode, 0);
            noScoreObj.set("optvotes", (Object)optVotes);
            optVotesBigDecimal = new BigDecimal(optVotes);
            optRatio = optVotesBigDecimal.divide(new BigDecimal(curIndicatorResList.size()), 4, DEFAULT_ROUND_MODE);
            noScoreObj.set("optratio", (Object)optRatio);
        }
    }

    private void calcScoreResult(int scoreAccuracy, RoundingMode roundingMode, DynamicObject scoreObj, List<DynamicObject> curIndicatorResList, boolean needMainBody, List<MainBodyGroup> mainBodyGroupList) {
        if (needMainBody) {
            Map<String, Integer> mainBodyEvaluatorNum = mainBodyGroupList.stream().collect(Collectors.groupingBy(MainBodyGroup::getMainBody, Collectors.collectingAndThen(Collectors.toList(), List::size)));
            Map<String, List> mainBodyEvaluatorIdList = mainBodyGroupList.stream().collect(Collectors.groupingBy(MainBodyGroup::getMainBody, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().map(MainBodyGroup::getEvaluatorId).collect(Collectors.toList()))));
            Map evaluatorMainBodyScoreMap = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.toMap(obj -> {
                String evalDataSource = obj.getString("evaldatasource");
                String evaluatorIdKey = "10".equals(evalDataSource) ? "evalinternalper" : ("11".equals(evalDataSource) ? "evaloutsiderentryid" : "evaluatornumber");
                return obj.getString(evaluatorIdKey);
            }, Function.identity(), (k1, k2) -> k1));
            BigDecimal totalScore = BigDecimal.ZERO;
            for (Map.Entry<String, List> mainBodyEvaluatorEntry : mainBodyEvaluatorIdList.entrySet()) {
                String mainBodyId = mainBodyEvaluatorEntry.getKey();
                for (String evaluator : mainBodyEvaluatorEntry.getValue()) {
                    DynamicObject subTaskResult = (DynamicObject)evaluatorMainBodyScoreMap.get(evaluator);
                    if (HRObjectUtils.isEmpty((Object)subTaskResult)) continue;
                    BigDecimal scoreVal = this.getNumerical(subTaskResult);
                    Integer num = mainBodyEvaluatorNum.get(mainBodyId);
                    BigDecimal weight = this.convertWeight(subTaskResult.getInt("evalbodyweight"));
                    BigDecimal oneEvaluatorResult = scoreVal.multiply(weight).divide(new BigDecimal(num), 9, EvalSubTaskConstants.DEFAULT_ROUND_MODE);
                    totalScore = totalScore.add(oneEvaluatorResult);
                }
            }
            scoreObj.set("weightedavgscore", (Object)totalScore.setScale(scoreAccuracy, roundingMode));
        } else {
            BigDecimal oneReduce = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(obj -> {
                BigDecimal weight = this.convertWeight(obj.getInt("evalbodyweight"));
                BigDecimal numResult = this.getNumerical((DynamicObject)obj);
                return weight.multiply(numResult);
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal weightedAvgScore = oneReduce.divide(new BigDecimal(curIndicatorResList.size()), scoreAccuracy, roundingMode);
            scoreObj.set("weightedavgscore", (Object)weightedAvgScore.setScale(scoreAccuracy, roundingMode));
        }
        BigDecimal maxVal = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(this::getNumerical).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        scoreObj.set("maxval", (Object)maxVal.setScale(scoreAccuracy, roundingMode));
        BigDecimal minVal = curIndicatorResList.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).map(this::getNumerical).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        scoreObj.set("minval", (Object)minVal.setScale(scoreAccuracy, roundingMode));
    }

    private void calcTotalScore(int scoreAccuracy, RoundingMode roundingMode, DynamicObject evalObj, List<DynamicObject> curContentEvalSubTaskList, DynamicObject contentObj, Map<Long, DynamicObject> contentMap) {
        String realAnonType = contentObj.getString("realorcryptonym");
        Map<String, List<DynamicObject>> evaluatorGroupMap = "1".equals(realAnonType) ? curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> {
            String evalSource = obj.getString("evaluatorsource");
            if ("1".equals(evalSource)) {
                return obj.getString("evalinternalper");
            }
            return obj.getString("evaloutsiderentryid");
        })) : curContentEvalSubTaskList.stream().collect(Collectors.groupingBy(obj -> obj.getString("evaluatornumber")));
        this.runCalcTotalScore(scoreAccuracy, roundingMode, evalObj, contentObj, evaluatorGroupMap, contentMap);
    }

    private void runCalcTotalScore(int scoreAccuracy, RoundingMode roundingMode, DynamicObject evalObj, DynamicObject contentObj, Map<String, List<DynamicObject>> evaluatorGroupMap, Map<Long, DynamicObject> contentMap) {
        String indicatorEvalType = contentObj.getString("indicatorevaltype");
        if ("10".equals(indicatorEvalType)) {
            return;
        }
        String calcMethod = contentObj.getString("calcmethod");
        String evalObjIdKey = this.getEvalObjIdKey(contentObj);
        HashMap evaluatorTotalScoreMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap evaluatorMainBodyScoreMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection scoreEntry = evalObj.getDynamicObjectCollection("scoreentry");
        Map<Long, DynamicObject> scoreIndicatorList = this.getScoreIndicatorList(scoreEntry);
        long totalScoreObjId = this.getTotalScoreObjId(scoreEntry);
        HashSet distinctSubTaskOriginSet = Sets.newHashSetWithExpectedSize((int)evaluatorGroupMap.size());
        for (Map.Entry<String, List<DynamicObject>> evalSubTaskGroupEvaluatorEntry : evaluatorGroupMap.entrySet()) {
            String evaluatorId = evalSubTaskGroupEvaluatorEntry.getKey();
            BigDecimal curIndicatorScoreSum = BigDecimal.ZERO;
            boolean existEvaluated = false;
            for (DynamicObject dynamicObject : evalSubTaskGroupEvaluatorEntry.getValue()) {
                long evalIndicatorEntryId;
                DynamicObject evalTaskIndicatorObj;
                String taskStatus = dynamicObject.getString("taskstatus");
                if (evalObj.getLong(evalObjIdKey) == dynamicObject.getLong(evalObjIdKey)) {
                    distinctSubTaskOriginSet.add(dynamicObject.getLong("id"));
                }
                if (evalObj.getLong(evalObjIdKey) != dynamicObject.getLong(evalObjIdKey) || !EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(taskStatus) || (evalTaskIndicatorObj = scoreIndicatorList.get(evalIndicatorEntryId = dynamicObject.getLong("evalindicatorentryid"))) == null) continue;
                existEvaluated = true;
                BigDecimal curIndicatorResult = this.getCurIndicatorScore(calcMethod, dynamicObject, evalTaskIndicatorObj);
                curIndicatorScoreSum = curIndicatorScoreSum.add(curIndicatorResult);
            }
            if (!existEvaluated) continue;
            BigDecimal evalBodyWeight = this.convertWeight(evalSubTaskGroupEvaluatorEntry.getValue().get(0).getInt("evalbodyweight"));
            evaluatorTotalScoreMap.put(Pair.of((Object)evaluatorId, (Object)evalBodyWeight), curIndicatorScoreSum);
            evaluatorMainBodyScoreMap.put(evaluatorId, Pair.of((Object)evalBodyWeight, (Object)curIndicatorScoreSum));
        }
        if (MapUtils.isEmpty((Map)evaluatorTotalScoreMap)) {
            return;
        }
        BigDecimal maxVal = evaluatorTotalScoreMap.values().stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        BigDecimal minVal = evaluatorTotalScoreMap.values().stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        String needMainBody = contentObj.getString("evalmainbody");
        if ("10".equals(needMainBody)) {
            ArrayList mainBodyGroupList = Lists.newArrayListWithExpectedSize((int)500);
            String realAnon = contentObj.getString("realorcryptonym");
            if ("1".equals(realAnon)) {
                DynamicObject content = contentMap.get(contentObj.getLong("id"));
                DynamicObjectCollection dynamicObjectCollection = content.getDynamicObjectCollection("evaluatorrealsubentry");
                Set<Pair<String, String>> evalObjEvaluatorReal = this.getEvalObjEvaluatorReal(evaluatorGroupMap.values(), contentObj, evalObjIdKey);
                ProgressCalcHelper.getRealMainBodyGroupList(dynamicObjectCollection, mainBodyGroupList, evalObj.getLong(evalObjIdKey), evalObjEvaluatorReal);
            } else {
                for (Map.Entry entry2 : evaluatorGroupMap.entrySet()) {
                    String evaluatorId = (String)entry2.getKey();
                    String evalMainBody = ((DynamicObject)((List)entry2.getValue()).get(0)).getString("evalbodynameanon");
                    mainBodyGroupList.add(new MainBodyGroup(evalMainBody, evaluatorId));
                }
            }
            ProgressCalcHelper.setMainBodyTotalScore(scoreAccuracy, roundingMode, evalObj, evaluatorMainBodyScoreMap, scoreEntry, totalScoreObjId, maxVal, minVal, mainBodyGroupList);
        } else {
            BigDecimal totalScoreSum = evaluatorTotalScoreMap.entrySet().stream().map(entry -> ((BigDecimal)((Pair)entry.getKey()).getRight()).multiply((BigDecimal)entry.getValue())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalScore = totalScoreSum.divide(new BigDecimal(distinctSubTaskOriginSet.size()), scoreAccuracy, roundingMode);
            evalObj.set("totalscore", (Object)totalScore);
            scoreEntry.stream().filter(obj -> obj.getLong("id") == totalScoreObjId).findAny().ifPresent(obj -> {
                obj.set("maxval", (Object)maxVal.setScale(scoreAccuracy, roundingMode));
                obj.set("minval", (Object)minVal.setScale(scoreAccuracy, roundingMode));
                obj.set("weightedavgscore", (Object)totalScore);
            });
        }
    }

    private static void getRealMainBodyGroupList(DynamicObjectCollection evalRealEntry, List<MainBodyGroup> mainBodyGroupList, long curEvalObjId, Set<Pair<String, String>> evalObjEvaluatorReal) {
        for (DynamicObject evalReal : evalRealEntry) {
            if (evalReal.getLong("evaledobj") != curEvalObjId) continue;
            long evalBodyId = evalReal.getLong("evalbody.id");
            for (DynamicObject employeeMulObj : evalReal.getDynamicObjectCollection("inevaluator")) {
                long employeeId = employeeMulObj.getLong("fbasedataid_id");
                if (!evalObjEvaluatorReal.contains(Pair.of((Object)String.valueOf(curEvalObjId), (Object)String.valueOf(employeeId)))) continue;
                mainBodyGroupList.add(new MainBodyGroup(String.valueOf(evalBodyId), String.valueOf(employeeId)));
            }
            String outEvaluator = evalReal.getString("outevaluator_tag");
            Arrays.stream(outEvaluator.split(",")).filter(StringUtils::isNotBlank).filter(outEvalId -> evalObjEvaluatorReal.contains(Pair.of((Object)String.valueOf(curEvalObjId), (Object)outEvalId))).forEach(outEvalId -> mainBodyGroupList.add(new MainBodyGroup(String.valueOf(evalBodyId), (String)outEvalId)));
        }
    }

    private static void setMainBodyTotalScore(int scoreAccuracy, RoundingMode roundingMode, DynamicObject evalObj, Map<String, Pair<BigDecimal, BigDecimal>> evaluatorMainBodyScoreMap, DynamicObjectCollection scoreEntry, long totalScoreObjId, BigDecimal maxVal, BigDecimal minVal, List<MainBodyGroup> mainBodyGroupList) {
        Map<String, Integer> mainBodyEvaluatorNum = mainBodyGroupList.stream().collect(Collectors.groupingBy(MainBodyGroup::getMainBody, Collectors.collectingAndThen(Collectors.toList(), List::size)));
        Map<String, List> mainBodyEvaluatorIdList = mainBodyGroupList.stream().collect(Collectors.groupingBy(MainBodyGroup::getMainBody, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().map(MainBodyGroup::getEvaluatorId).collect(Collectors.toList()))));
        BigDecimal totalScore = BigDecimal.ZERO;
        for (Map.Entry<String, List> mainBodyEvaluatorEntry : mainBodyEvaluatorIdList.entrySet()) {
            String mainBodyId = mainBodyEvaluatorEntry.getKey();
            for (String evaluator : mainBodyEvaluatorEntry.getValue()) {
                Pair<BigDecimal, BigDecimal> evaluatorScorePair = evaluatorMainBodyScoreMap.get(evaluator);
                if (evaluatorScorePair == null) continue;
                Integer num = mainBodyEvaluatorNum.get(mainBodyId);
                BigDecimal oneEvaluatorResult = ((BigDecimal)evaluatorScorePair.getLeft()).multiply((BigDecimal)evaluatorScorePair.getRight()).divide(new BigDecimal(num), 9, EvalSubTaskConstants.DEFAULT_ROUND_MODE);
                totalScore = totalScore.add(oneEvaluatorResult);
            }
        }
        evalObj.set("totalscore", (Object)totalScore.setScale(scoreAccuracy, roundingMode));
        Optional<DynamicObject> any = scoreEntry.stream().filter(obj -> obj.getLong("id") == totalScoreObjId).findAny();
        if (any.isPresent()) {
            DynamicObject obj2 = any.get();
            obj2.set("maxval", (Object)maxVal.setScale(scoreAccuracy, roundingMode));
            obj2.set("minval", (Object)minVal.setScale(scoreAccuracy, roundingMode));
            obj2.set("weightedavgscore", (Object)totalScore.setScale(scoreAccuracy, roundingMode));
        }
    }

    private BigDecimal getCurIndicatorScore(String calcMethod, DynamicObject evalSubTaskObj, DynamicObject evalTaskIndicatorObj) {
        BigDecimal curIndicatorScore;
        if ("1".equals(calcMethod)) {
            BigDecimal weight = this.convertWeight(evalTaskIndicatorObj.getInt("weight"));
            curIndicatorScore = this.getNumerical(evalSubTaskObj).multiply(weight);
        } else {
            curIndicatorScore = this.getNumerical(evalSubTaskObj);
        }
        return curIndicatorScore;
    }

    private String getEvalObjIdKey(DynamicObject contentObj) {
        String evalObjType = contentObj.getString("evaledobjtype");
        String evalObjIdKey = "10".equals(evalObjType) ? "objinfoperentryid" : "objinfoorgentryid";
        return evalObjIdKey;
    }

    private String getEvaluatorIdKey(DynamicObject contentObj, DynamicObject evalSubTaskObj) {
        String evaluatorSource;
        String evaluatorType = contentObj.getString("realorcryptonym");
        String evalObjIdKey = "1".equals(evaluatorType) ? ("1".equals(evaluatorSource = evalSubTaskObj.getString("evaluatorsource")) ? "evalinternalper" : "evaloutsiderentryid") : "evaluatornumber";
        return evalObjIdKey;
    }

    private String getEvaluatorIdKeyByEvaluator(DynamicObject contentObj, DynamicObject evaluatorObj) {
        String evaluatorSource;
        String evaluatorType = contentObj.getString("realorcryptonym");
        String evalObjIdKey = "1".equals(evaluatorType) ? ("1".equals(evaluatorSource = evaluatorObj.getString("evaluatorsource")) ? "evalinternalper_id" : "evaloutsiderentryid") : "evaluatornumber";
        return evalObjIdKey;
    }

    private long getTotalScoreObjId(DynamicObjectCollection scoreEntry) {
        return scoreEntry.stream().filter(obj -> {
            long scoreEvalEntryId = obj.getLong("scoreevalindientryid");
            DynamicObject evalTaskIndicatorObj = this.indicatorIdMap.get(scoreEvalEntryId);
            if (evalTaskIndicatorObj != null) {
                String areaCode = evalTaskIndicatorObj.getString("areacode");
                String indicatorType = evalTaskIndicatorObj.getString("indicatortype");
                String indicatorClassify = evalTaskIndicatorObj.getString("indicatorclassify");
                return "2".equals(areaCode) && "C".equals(indicatorType) && "2".equals(indicatorClassify);
            }
            return false;
        }).map(obj -> obj.getLong("id")).findAny().orElse(0L);
    }

    private Map<Long, DynamicObject> getScoreIndicatorList(DynamicObjectCollection scoreEntry) {
        return scoreEntry.stream().filter(obj -> {
            long scoreEvalEntryId = obj.getLong("scoreevalindientryid");
            DynamicObject evalTaskIndicatorObj = this.indicatorIdMap.get(scoreEvalEntryId);
            if (evalTaskIndicatorObj != null) {
                String areaCode = evalTaskIndicatorObj.getString("areacode");
                return "0".equals(areaCode);
            }
            return false;
        }).collect(Collectors.toMap(obj -> obj.getLong("scoreevalindientryid"), Function.identity(), (k1, k2) -> k1));
    }

    private BigDecimal convertWeight(int evalBodyWeight) {
        if (evalBodyWeight == 0) {
            return BigDecimal.ONE;
        }
        return new BigDecimal(evalBodyWeight).divide(new BigDecimal(100), 9, RoundingMode.HALF_UP);
    }

    private void calcNoScoreResult(DynamicObject noScoreObj, String optSortCode, List<DynamicObject> curIndicatorResListFilterCurEvalObj, DynamicObject contentObj) {
        String indicatorEvalType = contentObj.getString("indicatorevaltype");
        boolean noScoreFlag = "10".equals(indicatorEvalType);
        String indicatorType = noScoreObj.getString("indicatortype");
        BigDecimal weightTotalVotes = curIndicatorResListFilterCurEvalObj.stream().map(obj -> this.getWeightByEvalType(noScoreFlag, (DynamicObject)obj)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ("A".equals(indicatorType)) {
            Map<String, BigDecimal> optSeqWeightMap = curIndicatorResListFilterCurEvalObj.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).collect(Collectors.groupingBy(obj -> obj.getString("singlechoice"), Collectors.collectingAndThen(Collectors.toList(), optGroup -> optGroup.stream().map(obj -> this.getWeightByEvalType(noScoreFlag, (DynamicObject)obj)).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal optVotes = optSeqWeightMap.getOrDefault(optSortCode, BigDecimal.ZERO);
            noScoreObj.set("optvotes", (Object)optVotes);
            BigDecimal optRatio = optVotes.divide(weightTotalVotes, 4, DEFAULT_ROUND_MODE);
            noScoreObj.set("optratio", (Object)optRatio);
        }
        if ("B".equals(indicatorType)) {
            ArrayList optValWeight = Lists.newArrayListWithExpectedSize((int)(curIndicatorResListFilterCurEvalObj.size() * 4));
            for (DynamicObject curIndicatorRes : curIndicatorResListFilterCurEvalObj) {
                if (!EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(curIndicatorRes.getString("taskstatus"))) continue;
                BigDecimal evalBodyWeight = this.convertWeight(curIndicatorRes.getInt("evalbodyweight"));
                for (String optVal : curIndicatorRes.getString("multiplechoice").split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)optVal)) continue;
                    optValWeight.add(new NoScoreWeight(optVal, evalBodyWeight));
                }
            }
            Map<String, BigDecimal> mulOptSeqNumMap = optValWeight.stream().collect(Collectors.groupingBy(NoScoreWeight::getSortCode, Collectors.collectingAndThen(Collectors.toList(), noScoreWeightGroupList -> noScoreWeightGroupList.stream().map(obj -> {
                if (noScoreFlag) {
                    return obj.getWeight();
                }
                return BigDecimal.ONE;
            }).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal optWeightVotes = mulOptSeqNumMap.getOrDefault(optSortCode, BigDecimal.ZERO);
            noScoreObj.set("optvotes", (Object)optWeightVotes);
            BigDecimal optRatio = optWeightVotes.divide(weightTotalVotes, 4, DEFAULT_ROUND_MODE);
            noScoreObj.set("optratio", (Object)optRatio);
        }
    }

    private BigDecimal getWeightByEvalType(boolean noScoreFlag, DynamicObject obj) {
        if (noScoreFlag) {
            return this.convertWeight(obj.getInt("evalbodyweight"));
        }
        return BigDecimal.ONE;
    }

    private List<DynamicObject> getCurIndicatorResListFilterCurEvalObj(boolean orgEvalObjType, DynamicObject curEvalObj, List<DynamicObject> curIndicatorResList) {
        if (CollectionUtils.isEmpty(curIndicatorResList)) {
            return Collections.emptyList();
        }
        List<Object> curIndicatorResListFilterCurEvalObj = orgEvalObjType ? curIndicatorResList.stream().filter(obj -> obj.getLong("objinfoorgentryid") == curEvalObj.getLong("objinfoorgentryid")).collect(Collectors.toList()) : curIndicatorResList.stream().filter(obj -> obj.getLong("objinfoperentryid") == curEvalObj.getLong("objinfoperentryid")).collect(Collectors.toList());
        return curIndicatorResListFilterCurEvalObj;
    }

    private List<DynamicObject> getCurIndicatorResListFilterCurEvaluator(boolean evaluatorRealType, DynamicObject curEvaluatorObj, List<DynamicObject> curIndicatorResList) {
        List<Object> curIndicatorResListFilterCurEvaluator;
        if (CollectionUtils.isEmpty(curIndicatorResList)) {
            return Collections.emptyList();
        }
        if (evaluatorRealType) {
            String evalSource = curEvaluatorObj.getString("evaluatorsource");
            String matchKey = "1".equals(evalSource) ? "evalinternalper" : "evaloutsiderentryid";
            curIndicatorResListFilterCurEvaluator = curIndicatorResList.stream().filter(obj -> DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey) == DynamicObjectIdUtils.getBaseDataId((DynamicObject)curEvaluatorObj, (String)matchKey)).collect(Collectors.toList());
        } else {
            curIndicatorResListFilterCurEvaluator = curIndicatorResList.stream().filter(obj -> StringUtils.equals((CharSequence)obj.getString("evaluatornumber"), (CharSequence)curEvaluatorObj.getString("evaluatornumber"))).collect(Collectors.toList());
        }
        return curIndicatorResListFilterCurEvaluator;
    }

    private RoundingMode getRoundingMode(DynamicObject evalContentObj) {
        String carryType = evalContentObj.getString("carrytype");
        RoundingMode roundingMode = "10".equals(carryType) ? RoundingMode.HALF_UP : ("20".equals(carryType) ? RoundingMode.CEILING : RoundingMode.FLOOR);
        return roundingMode;
    }

    private BigDecimal getNumerical(DynamicObject obj) {
        BigDecimal numerical = obj.getBigDecimal("numerical");
        if (numerical == null) {
            return BigDecimal.ZERO;
        }
        return numerical;
    }

    public QFilter getRemoveMarkFilter() {
        return new QFilter("removemark", "=", (Object)Boolean.FALSE);
    }

    public void setEvalContentMap(List<Long> evalContentPerIdList) {
        this.evalContentMap = this.evalTaskEntityService.queryContentOriginByContentId(evalContentPerIdList);
        this.indicatorIdMap = this.evalTaskEntityService.queryContentIndicatorOriginByContentId(evalContentPerIdList);
    }

    private static class NoScoreWeight {
        String sortCode;
        BigDecimal weight;

        public NoScoreWeight(String sortCode, BigDecimal weight) {
            this.sortCode = sortCode;
            this.weight = weight;
        }

        public String getSortCode() {
            return this.sortCode;
        }

        public void setSortCode(String sortCode) {
            this.sortCode = sortCode;
        }

        public BigDecimal getWeight() {
            return this.weight;
        }

        public void setWeight(BigDecimal weight) {
            this.weight = weight;
        }
    }

    private static class MainBodyGroup {
        String mainBody;
        String evaluatorId;

        public MainBodyGroup(String mainBody, String evaluatorId) {
            this.mainBody = mainBody;
            this.evaluatorId = evaluatorId;
        }

        public String getMainBody() {
            return this.mainBody;
        }

        public void setMainBody(String mainBody) {
            this.mainBody = mainBody;
        }

        public String getEvaluatorId() {
            return this.evaluatorId;
        }

        public void setEvaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
        }
    }
}

