/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.common.entityservice.AbstractBaseEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalSubTaskEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjOrgEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjPerEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorAnonEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorRealEntityService;
import kd.hrmp.bes.business.domain.evalsubtask.ITrackDomainService;
import kd.hrmp.bes.business.domain.evalsubtask.ProgressCalcHelper;
import kd.hrmp.bes.business.domain.evalsubtask.TrackObjGenerator;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import kd.hrmp.bes.common.enums.EvalSubTaskStatusEnum;
import kd.hrmp.bes.common.enums.ObjEvaluatorTaskStatusEnum;
import kd.hrmp.bes.common.utils.DynamicObjectIdUtils;
import kd.hrmp.bes.common.utils.NumberNameConvertUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class TrackDomainServiceImpl
implements ITrackDomainService {
    private static final Log log = LogFactory.getLog(TrackDomainServiceImpl.class);
    private final TrackEvalObjOrgEntityService evalObjOrgEntityService = BesServiceFactory.getService(TrackEvalObjOrgEntityService.class);
    private final TrackEvalObjPerEntityService evalObjPerEntityService = BesServiceFactory.getService(TrackEvalObjPerEntityService.class);
    private final TrackEvaluatorRealEntityService evaluatorRealEntityService = BesServiceFactory.getService(TrackEvaluatorRealEntityService.class);
    private final TrackEvaluatorAnonEntityService evaluatorAnonEntityService = BesServiceFactory.getService(TrackEvaluatorAnonEntityService.class);
    private final EvalSubTaskEntityService evalSubTaskEntityService = BesServiceFactory.getService(EvalSubTaskEntityService.class);

    @Override
    public void createTrackEvalObj(List<DynamicObject> evalTaskList, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        ArrayList trackEvalObjPerList = Lists.newArrayList();
        ArrayList trackEvalObjOrgList = Lists.newArrayList();
        ArrayList trackTrackEvaluatorReal = Lists.newArrayList();
        ArrayList trackTrackEvaluatorAnon = Lists.newArrayList();
        for (DynamicObject evalTaskObj : evalTaskList) {
            DynamicObjectCollection contentColl = evalTaskObj.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contentColl) {
                TrackObjGenerator trackObjGenerator = new TrackObjGenerator(evalTaskObj, content, evalTaskDependOnDbData);
                List<DynamicObject> curContentTrackEvalObjPerList = trackObjGenerator.genTrackEvalObjPer();
                List<DynamicObject> curContentTrackEvalObjOrgList = trackObjGenerator.genTrackEvalObjOrg();
                List<DynamicObject> curContentTrackTrackEvaluatorReal = trackObjGenerator.genTrackEvaluatorReal();
                List<DynamicObject> curContentTrackTrackEvaluatorAnon = trackObjGenerator.genTrackEvaluatorAnon();
                trackEvalObjPerList.addAll(curContentTrackEvalObjPerList);
                trackEvalObjOrgList.addAll(curContentTrackEvalObjOrgList);
                trackTrackEvaluatorReal.addAll(curContentTrackTrackEvaluatorReal);
                trackTrackEvaluatorAnon.addAll(curContentTrackTrackEvaluatorAnon);
            }
        }
        this.deleteTrackEvalObj(evalTaskList);
        this.evalObjOrgEntityService.save(trackEvalObjPerList.toArray(new DynamicObject[0]));
        this.evalObjPerEntityService.save(trackEvalObjOrgList.toArray(new DynamicObject[0]));
        this.evaluatorRealEntityService.save(trackTrackEvaluatorReal.toArray(new DynamicObject[0]));
        this.evaluatorAnonEntityService.save(trackTrackEvaluatorAnon.toArray(new DynamicObject[0]));
    }

    @Override
    public void adjustTrackEvalObj(List<DynamicObject> evalTaskList, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        List evalTaskIdList = DynamicObjectIdUtils.getIds(evalTaskList);
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", (Object)evalTaskIdList);
        ArrayList evalObjDbPerList = Lists.newArrayList((Object[])this.evalObjPerEntityService.loadDynamicObjectArray(evalTaskFilter.toArray()));
        Map<Long, List<DynamicObject>> evalObjDbPerMap = evalObjDbPerList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        List<DynamicObject> evalObjDbOrgList = this.evalObjOrgEntityService.queryOriginalList("id,objinfoorgentryid,taskcontentid", evalTaskFilter.toArray());
        Map<Long, List<DynamicObject>> evalObjDbOrgMap = evalObjDbOrgList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        ArrayList evaluatorRealDbList = Lists.newArrayList((Object[])this.evaluatorRealEntityService.loadDynamicObjectArray(evalTaskFilter.toArray()));
        Map<Long, List<DynamicObject>> evaluatorRealDbMap = evaluatorRealDbList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        ArrayList trackEvaluatorRealNew = Lists.newArrayList();
        ArrayList trackEvaluatorRealDel = Lists.newArrayList();
        ArrayList trackEvalObjPerNewList = Lists.newArrayList();
        ArrayList trackEvalObjOrgNewList = Lists.newArrayList();
        ArrayList trackEvalObjPerDelList = Lists.newArrayList();
        ArrayList trackEvalObjOrgDelList = Lists.newArrayList();
        DynamicObject evalTaskObj = evalTaskList.get(0);
        DynamicObjectCollection contentColl = evalTaskObj.getDynamicObjectCollection("contententryentity");
        for (DynamicObject content : contentColl) {
            List<DynamicObject> curContentTrackTrackEvaluatorReal;
            List<DynamicObject> dbEvalObj;
            TrackObjGenerator trackObjGenerator = new TrackObjGenerator(evalTaskObj, content, evalTaskDependOnDbData);
            long contentId = content.getLong("id");
            String evalObjType = content.getString("evaledobjtype");
            if ("10".equals(evalObjType)) {
                List<DynamicObject> curContentTrackEvalObjPerList = trackObjGenerator.genTrackEvalObjPer();
                dbEvalObj = evalObjDbPerMap.get(contentId);
                if (CollectionUtils.isNotEmpty(dbEvalObj)) {
                    this.adjustEvalObj(trackEvalObjPerNewList, trackEvalObjPerDelList, curContentTrackEvalObjPerList, dbEvalObj, "objinfoperentryid");
                }
            } else {
                List<DynamicObject> curContentTrackEvalObjOrgList = trackObjGenerator.genTrackEvalObjOrg();
                dbEvalObj = evalObjDbOrgMap.get(contentId);
                if (CollectionUtils.isNotEmpty(dbEvalObj)) {
                    this.adjustEvalObj(trackEvalObjOrgNewList, trackEvalObjOrgDelList, curContentTrackEvalObjOrgList, dbEvalObj, "objinfoorgentryid");
                }
            }
            if (!CollectionUtils.isNotEmpty(curContentTrackTrackEvaluatorReal = trackObjGenerator.genTrackEvaluatorReal())) continue;
            List<DynamicObject> curContentTrackEvaluatorList = evaluatorRealDbMap.get(contentId);
            Map<Boolean, List<DynamicObject>> evaluatorRealDbParSource = curContentTrackEvaluatorList.stream().collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("evaluatorsource"))));
            Map<Boolean, List<DynamicObject>> evaluatorRealParSource = curContentTrackTrackEvaluatorReal.stream().collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("evaluatorsource"))));
            List<DynamicObject> employeeDbEvaluator = evaluatorRealDbParSource.get(Boolean.TRUE);
            List<DynamicObject> employeeEvaluator = evaluatorRealParSource.get(Boolean.TRUE);
            this.matchAndNewSaveAndDelEvaluator(trackEvaluatorRealNew, trackEvaluatorRealDel, employeeDbEvaluator, employeeEvaluator, "evalinternalper");
            List<DynamicObject> outDbEvaluator = evaluatorRealDbParSource.get(Boolean.FALSE);
            List<DynamicObject> outEvaluator = evaluatorRealParSource.get(Boolean.FALSE);
            this.matchAndNewSaveAndDelEvaluator(trackEvaluatorRealNew, trackEvaluatorRealDel, outDbEvaluator, outEvaluator, "evaloutsiderentryid");
        }
        this.evalObjPerEntityService.save(trackEvalObjPerNewList.toArray(new DynamicObject[0]));
        if (CollectionUtils.isNotEmpty((Collection)trackEvalObjPerDelList)) {
            this.evalObjPerEntityService.deleteByFilter(new QFilter("objinfoperentryid", "in", (Object)trackEvalObjPerDelList).toArray());
        }
        this.evalObjOrgEntityService.save(trackEvalObjOrgNewList.toArray(new DynamicObject[0]));
        if (CollectionUtils.isNotEmpty((Collection)trackEvalObjOrgDelList)) {
            this.evalObjOrgEntityService.deleteByFilter(new QFilter("objinfoorgentryid", "in", (Object)trackEvalObjOrgDelList).toArray());
        }
        this.evaluatorRealEntityService.save(trackEvaluatorRealNew.toArray(new DynamicObject[0]));
        if (CollectionUtils.isNotEmpty((Collection)trackEvaluatorRealDel)) {
            this.evaluatorRealEntityService.deleteByFilter(new QFilter("id", "in", (Object)trackEvaluatorRealDel).toArray());
        }
    }

    private void matchAndNewSaveAndDelEvaluator(List<DynamicObject> trackEvaluatorRealNew, List<Long> trackEvaluatorRealDel, List<DynamicObject> evaluatorDbList, List<DynamicObject> evaluatorNewGenList, String matchKey) {
        Set evaluatorDbIdSet = evaluatorDbList.stream().map(obj -> DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey)).collect(Collectors.toSet());
        Set evaluatorNewGenIdSet = evaluatorNewGenList.stream().map(obj -> DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey)).collect(Collectors.toSet());
        List newSave = evaluatorNewGenList.stream().filter(obj -> !evaluatorDbIdSet.contains(DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey))).collect(Collectors.toList());
        List delIds = evaluatorDbList.stream().filter(obj -> !evaluatorNewGenIdSet.contains(DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey))).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        if ("evaloutsiderentryid".equals(matchKey)) {
            Map evaluatorNewGenMap = evaluatorNewGenList.stream().collect(Collectors.toMap(obj -> DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey), Function.identity(), (k1, k2) -> k1));
            List evaluatorDbOut = evaluatorDbList.stream().filter(obj -> evaluatorNewGenMap.containsKey(DynamicObjectIdUtils.getBaseDataId((DynamicObject)obj, (String)matchKey))).collect(Collectors.toList());
            for (DynamicObject evaluatorDb : evaluatorDbOut) {
                DynamicObject newGenEvaluator = (DynamicObject)evaluatorNewGenMap.get(evaluatorDb.getLong(matchKey));
                evaluatorDb.set("evaloroutname", newGenEvaluator.get("evaloroutname"));
                evaluatorDb.set("evalorouttel", newGenEvaluator.get("evalorouttel"));
                evaluatorDb.set("evaloroutemail", newGenEvaluator.get("evaloroutemail"));
                evaluatorDb.set("evaloroutcompany", newGenEvaluator.get("evaloroutcompany"));
                evaluatorDb.set("evaloroutadminorg", newGenEvaluator.get("evaloroutadminorg"));
                evaluatorDb.set("evaloroutpos", newGenEvaluator.get("evaloroutpos"));
                evaluatorDb.set("evaloroutstdpos", newGenEvaluator.get("evaloroutstdpos"));
                evaluatorDb.set("evaloroutjob", newGenEvaluator.get("evaloroutjob"));
            }
            trackEvaluatorRealNew.addAll(evaluatorDbOut);
        }
        trackEvaluatorRealNew.addAll(newSave);
        trackEvaluatorRealDel.addAll(delIds);
    }

    private void adjustEvalObj(List<DynamicObject> trackEvalObjPerNewList, List<Long> trackEvalObjPerDelList, List<DynamicObject> curContentTrackEvalObjPerList, List<DynamicObject> dbEvalObj, String objinfoperentryid) {
        Set newEvalObjPerIdList = curContentTrackEvalObjPerList.stream().map(obj -> obj.getLong(objinfoperentryid)).collect(Collectors.toSet());
        Set dbEvalObjPerIdList = dbEvalObj.stream().map(obj -> obj.getLong(objinfoperentryid)).collect(Collectors.toSet());
        Map curContentTrackEvalObjPerIdMap = curContentTrackEvalObjPerList.stream().collect(Collectors.toMap(obj -> obj.getLong(objinfoperentryid), Function.identity(), (k1, k2) -> k1));
        List waitDelEvlObjIds = dbEvalObjPerIdList.stream().filter(entryId -> !newEvalObjPerIdList.contains(entryId)).collect(Collectors.toList());
        List newSaveObj = curContentTrackEvalObjPerList.stream().filter(obj -> !dbEvalObjPerIdList.contains(obj.getLong(objinfoperentryid))).collect(Collectors.toList());
        List<DynamicObject> propUpdateEvlObjList = dbEvalObj.stream().filter(dbObj -> {
            if (!dbObj.containsProperty("perdatasource")) {
                return false;
            }
            return "2".equals(dbObj.getString("perdatasource")) && curContentTrackEvalObjPerIdMap.containsKey(dbObj.getLong(objinfoperentryid));
        }).collect(Collectors.toList());
        propUpdateEvlObjList.forEach(dbObj -> {
            Long entryId = dbObj.getLong(objinfoperentryid);
            DynamicObject newObj = (DynamicObject)curContentTrackEvalObjPerIdMap.get(entryId);
            dbObj.set("pername", newObj.get("pername"));
            dbObj.set("telephone", newObj.get("telephone"));
            dbObj.set("email", newObj.get("email"));
            dbObj.set("percompany", newObj.get("percompany"));
            dbObj.set("peradminorg", newObj.get("peradminorg"));
            dbObj.set("perposition", newObj.get("perposition"));
            dbObj.set("perstdpos", newObj.get("perstdpos"));
            dbObj.set("perjob", newObj.get("perjob"));
        });
        trackEvalObjPerNewList.addAll(newSaveObj);
        trackEvalObjPerNewList.addAll(propUpdateEvlObjList);
        trackEvalObjPerDelList.addAll(waitDelEvlObjIds);
    }

    @Override
    public void deleteTrackEvalObj(List<DynamicObject> evalTaskList) {
        Long[] evalContentIds = this.getEvalContentIdsByEvalTask(evalTaskList);
        QFilter contentFilter = new QFilter("taskcontentid", "in", (Object)evalContentIds);
        this.deleteTrackObjByFilter(contentFilter);
    }

    private Long[] getEvalContentIdsByEvalTask(List<DynamicObject> evalTaskList) {
        return (Long[])evalTaskList.stream().flatMap(evalTask -> evalTask.getDynamicObjectCollection("contententryentity").stream().map(contentEntry -> contentEntry.getLong("id"))).toArray(Long[]::new);
    }

    private void deleteTrackObjByFilter(QFilter contentFilter) {
        this.evalObjOrgEntityService.deleteByFilter(contentFilter.toArray());
        this.evalObjPerEntityService.deleteByFilter(contentFilter.toArray());
        this.evaluatorRealEntityService.deleteByFilter(contentFilter.toArray());
        this.evaluatorAnonEntityService.deleteByFilter(contentFilter.toArray());
    }

    @Override
    public Map<Long, String> queryEvalProgressPer(List<Long> foperIdList) {
        QFilter entryId = new QFilter("objinfoperentryid", "in", foperIdList);
        Object[] evalObjPer = this.evalObjPerEntityService.query("objinfoperentryid,totalevalnum,completeevalnum", entryId.toArray());
        HashMap<Long, String> map = new HashMap<Long, String>(evalObjPer.length);
        if (!HRArrayUtils.isEmpty((Object[])evalObjPer)) {
            for (Object objPer : evalObjPer) {
                String result = null;
                String totalevalnum = objPer.getString("totalevalnum");
                String completeevalnum = objPer.getString("completeevalnum");
                if (!HRStringUtils.isEmpty((String)totalevalnum)) {
                    result = completeevalnum + "/" + totalevalnum;
                }
                map.put(objPer.getLong("objinfoperentryid"), result == null ? "0" : result);
            }
        }
        return map;
    }

    @Override
    public Map<Long, String> queryEvalProgressOrg(List<Long> foorgIdsList) {
        QFilter entryId = new QFilter("objinfoorgentryid", "in", foorgIdsList);
        Object[] evalObjOrg = this.evalObjOrgEntityService.query("objinfoorgentryid,totalevalnum,completeevalnum", entryId.toArray());
        HashMap<Long, String> map = new HashMap<Long, String>(evalObjOrg.length);
        if (!HRArrayUtils.isEmpty((Object[])evalObjOrg)) {
            for (Object objOrg : evalObjOrg) {
                String result = null;
                String totalevalnum = objOrg.getString("totalevalnum");
                String completeevalnum = objOrg.getString("completeevalnum");
                if (!HRStringUtils.isEmpty((String)totalevalnum)) {
                    result = completeevalnum + "/" + totalevalnum;
                }
                map.put(objOrg.getLong("objinfoorgentryid"), result == null ? "0" : result);
            }
        }
        return map;
    }

    @Override
    public Map<Long, Boolean> checkEvalProgress(List<Long> foperIdsList) {
        QFilter entryId = new QFilter("objinfoperentryid", "in", foperIdsList);
        Object[] evalObjPer = this.evalObjPerEntityService.query("objinfoperentryid,totalevalnum,completeevalnum", entryId.toArray());
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(evalObjPer.length);
        if (!HRArrayUtils.isEmpty((Object[])evalObjPer)) {
            for (Object objPer : evalObjPer) {
                String completeevalnum = objPer.getString("completeevalnum");
                if (HRStringUtils.equals((String)completeevalnum, (String)"0")) {
                    map.put(objPer.getLong("objinfoperentryid"), Boolean.TRUE);
                    continue;
                }
                map.put(objPer.getLong("objinfoperentryid"), Boolean.FALSE);
            }
        }
        return map;
    }

    @Override
    public Map<Long, Integer> getEvalEvaluatorNum(List<Long> evalTaskIdList) {
        QFilter removeMarkFilter = this.getRemoveMarkFilter();
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        List<DynamicObject> evalObjOrgList = this.evalObjOrgEntityService.queryOriginalList("evaltask.id evaltask_id", new QFilter[]{evalTaskFilter, removeMarkFilter});
        List<DynamicObject> evalObjPerList = this.evalObjPerEntityService.queryOriginalList("evaltask.id evaltask_id", new QFilter[]{evalTaskFilter, removeMarkFilter});
        evalObjOrgList.addAll(evalObjPerList);
        return evalObjOrgList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask_id"), Collectors.collectingAndThen(Collectors.toList(), List::size)));
    }

    @Override
    public Map<Long, Integer> getEvalEvalObjNum(List<Long> evalTaskIdList) {
        QFilter removeMarkFilter = this.getRemoveMarkFilter();
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        List<DynamicObject> evalObjOrgList = this.evaluatorRealEntityService.queryOriginalList("evaltask.id evaltask_id", new QFilter[]{evalTaskFilter, removeMarkFilter});
        List<DynamicObject> evalObjPerList = this.evaluatorAnonEntityService.queryOriginalList("evaltask.id evaltask_id", new QFilter[]{evalTaskFilter, removeMarkFilter});
        evalObjOrgList.addAll(evalObjPerList);
        return evalObjOrgList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask_id"), Collectors.collectingAndThen(Collectors.toList(), List::size)));
    }

    public QFilter getRemoveMarkFilter() {
        return new QFilter("removemark", "=", (Object)Boolean.FALSE);
    }

    @Override
    public void updateTrackProgress(List<DynamicObject> evalTaskList) {
        this.updateTrackEvalObjProgress(evalTaskList);
        this.updateTrackEvaluatorProgress(evalTaskList);
    }

    @Override
    public void completeEvalSubTask(Map<Boolean, List<DynamicObject>> evalTaskParByProcessMode) {
        List<DynamicObject> removeObjList = evalTaskParByProcessMode.get(Boolean.FALSE);
        if (CollectionUtils.isNotEmpty(removeObjList)) {
            List removeEvalSubTaskIdList = DynamicObjectIdUtils.getIds(removeObjList);
            QFilter evalStatusFilter = new QFilter("evalstatus", "=", (Object)ObjEvaluatorTaskStatusEnum.IN_PROGRESS.getCode());
            evalStatusFilter.and(new QFilter("evaltask.id", "in", (Object)removeEvalSubTaskIdList));
            this.trackObjCompleteRemoveProgress(evalStatusFilter, this.evaluatorRealEntityService);
            this.trackObjCompleteRemoveProgress(evalStatusFilter, this.evaluatorAnonEntityService);
        }
    }

    @Override
    public void calcEvalObjResult(List<DynamicObject> evalTaskList) {
        List evalContentOrgIdList;
        Map<Boolean, List> evalContentPartition = evalTaskList.stream().flatMap(evalContentEntry -> evalContentEntry.getDynamicObjectCollection("contententryentity").stream()).collect(Collectors.partitioningBy(obj -> "10".equals(obj.getString("evaledobjtype")), Collectors.collectingAndThen(Collectors.toList(), DynamicObjectIdUtils::getIds)));
        Map<Long, DynamicObject> contentMap = evalTaskList.stream().map(evalContentEntry -> evalContentEntry.getDynamicObjectCollection("contententryentity")).flatMap(Collection::stream).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
        List evalContentPerIdList = evalContentPartition.get(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty((Collection)evalContentPerIdList)) {
            ProgressCalcHelper progressCalcHelper = new ProgressCalcHelper();
            progressCalcHelper.setEvalContentIdList(evalContentPerIdList);
            progressCalcHelper.setEntityService(this.evalObjPerEntityService);
            progressCalcHelper.setEvalContentMap(evalContentPerIdList);
            progressCalcHelper.calcProgress(contentMap);
        }
        if (CollectionUtils.isNotEmpty((Collection)(evalContentOrgIdList = evalContentPartition.get(Boolean.FALSE)))) {
            ProgressCalcHelper progressCalcHelper = new ProgressCalcHelper();
            progressCalcHelper.setEvalContentIdList(evalContentOrgIdList);
            progressCalcHelper.setEntityService(this.evalObjOrgEntityService);
            progressCalcHelper.setEvalContentMap(evalContentOrgIdList);
            progressCalcHelper.calcProgress(contentMap);
        }
    }

    @Override
    public void calcEvaluatorResult(List<DynamicObject> evalTaskList) {
        List evaluatorAnonContentIdList;
        Map<Boolean, List> evalContentPartition = evalTaskList.stream().collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("realorcryptonym")), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().flatMap(content -> content.getDynamicObjectCollection("contententryentity").stream()).map(obj -> obj.getLong("id")).collect(Collectors.toList()))));
        List evaluatorRealContentIdList = evalContentPartition.get(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty((Collection)evaluatorRealContentIdList)) {
            ProgressCalcHelper progressCalcHelper = new ProgressCalcHelper();
            progressCalcHelper.setEvalContentIdList(evaluatorRealContentIdList);
            progressCalcHelper.setEntityService(this.evaluatorRealEntityService);
            progressCalcHelper.setEvalContentMap(evaluatorRealContentIdList);
            progressCalcHelper.calcEvaluatorProgress();
        }
        if (CollectionUtils.isNotEmpty((Collection)(evaluatorAnonContentIdList = evalContentPartition.get(Boolean.FALSE)))) {
            ProgressCalcHelper progressCalcHelper = new ProgressCalcHelper();
            progressCalcHelper.setEvalContentIdList(evaluatorAnonContentIdList);
            progressCalcHelper.setEntityService(this.evaluatorAnonEntityService);
            progressCalcHelper.setEvalContentMap(evaluatorAnonContentIdList);
            progressCalcHelper.calcEvaluatorProgress();
        }
    }

    @Override
    public void generatorRealOneEvaluator(Map<Long, DynamicObject> evalObjIdEvalSubTaskMap, DynamicObject evalTaskObj, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        evalObjIdEvalSubTaskMap.entrySet().stream().findAny().ifPresent(evalSubTaskEntry -> {
            QFilter empFilter;
            DynamicObject evalSubTask = (DynamicObject)evalSubTaskEntry.getValue();
            long taskContentId = evalSubTask.getLong("taskcontentid");
            long employeeId = DynamicObjectIdUtils.getBaseDataId((DynamicObject)evalSubTask, (String)"evalinternalper");
            QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)taskContentId);
            boolean existsEvaluator = this.evaluatorRealEntityService.isExists(contentFilter.and(empFilter = new QFilter("evalinternalper.id", "=", (Object)employeeId)));
            if (existsEvaluator) {
                return;
            }
            for (DynamicObject evalContentObj : evalTaskObj.getDynamicObjectCollection("contententryentity")) {
                long contentId = evalContentObj.getLong("id");
                if (contentId != taskContentId) continue;
                TrackObjGenerator trackObjGenerator = new TrackObjGenerator(evalTaskObj, evalContentObj, evalTaskDependOnDbData);
                DynamicObject newRealEvaluator = trackObjGenerator.genTrackEvaluatorRealByEvalSubTask(evalSubTask);
                this.evaluatorRealEntityService.save(newRealEvaluator);
            }
        });
    }

    @Override
    public void generatorAnonOneEvaluator(Map<Long, DynamicObject> evalObjIdEvalSubTaskMap, DynamicObject evalTaskObj, String evaluatorNumber) {
        evalObjIdEvalSubTaskMap.values().stream().findAny().ifPresent(evalSubTask -> {
            long taskContentId = evalSubTask.getLong("taskcontentid");
            DynamicObject newAnonEvaluator = null;
            for (DynamicObject evalContentObj : evalTaskObj.getDynamicObjectCollection("contententryentity")) {
                long contentId = evalContentObj.getLong("id");
                if (contentId != taskContentId) continue;
                TrackObjGenerator trackObjGenerator = new TrackObjGenerator(evalTaskObj, evalContentObj, null);
                newAnonEvaluator = trackObjGenerator.genTrackEvaluatorAnonByEvalSubTask((DynamicObject)evalSubTask);
                newAnonEvaluator.set("evaluatornumber", (Object)evaluatorNumber);
            }
            if (newAnonEvaluator != null) {
                this.evaluatorAnonEntityService.save(newAnonEvaluator);
            }
        });
    }

    @Override
    public Map<Long, List<DynamicObject>> getEvalObjPerByEvalTaskId(List<Long> evalTaskIdList) {
        QFilter qFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        DynamicObject[] evalObjArr = this.evalObjPerEntityService.query("taskcontentid,pername,totalevalnum,completeevalnum,objinfoperentryid,perdatasource", qFilter.toArray());
        return Arrays.stream(evalObjArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
    }

    @Override
    public Map<Long, List<DynamicObject>> getEvaluatorPerByEvalTaskId(List<Long> evalTaskIdList) {
        QFilter qFilter = new QFilter("evaltask.id", "in", evalTaskIdList);
        DynamicObject[] evalObjArr = this.evaluatorRealEntityService.query("taskcontentid,evaloroutname,totalevalnum,completeevalnum,evalinternalper,evaloutsiderentryid,evaluatorsource", qFilter.toArray());
        return Arrays.stream(evalObjArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
    }

    @Override
    public Map<Long, List<String>> getIncompleteEvaluator(List<Long> ids) {
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", ids);
        QFilter evalStatus = new QFilter("evalstatus", "=", (Object)"A");
        QFilter[] filters = new QFilter[]{evalTaskFilter, evalStatus};
        List<DynamicObject> evaluatorObjList = this.evaluatorRealEntityService.queryOriginalList("id,evaltask,evaloroutname,evaloroutnumber,evalorouttel,evaluatorsource", filters);
        Map<Long, List<DynamicObject>> evalObjPerGroup = evaluatorObjList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("evaltask")));
        Map evaluatorNumber = NumberNameConvertUtils.getNumberNameMap((DynamicObject[])evaluatorObjList.toArray(new DynamicObject[0]));
        HashMap result = Maps.newHashMapWithExpectedSize((int)evalObjPerGroup.size());
        evalObjPerGroup.forEach((key, value) -> {
            List perNameList = value.stream().map(obj -> (String)evaluatorNumber.get(obj.getLong("id"))).collect(Collectors.toList());
            result.put(key, perNameList);
        });
        return result;
    }

    private void trackObjCompleteRemoveProgress(QFilter evalTaskFilter, AbstractBaseEntityService entityService) {
        DynamicObject[] trackObjArr = entityService.query("removemark,completeevalnum", evalTaskFilter.toArray());
        Object[] markRemoveTrackEvaluatorArr = (DynamicObject[])Arrays.stream(trackObjArr).filter(obj -> obj.getInt("completeevalnum") == 0).toArray(DynamicObject[]::new);
        if (ArrayUtils.isEmpty((Object[])markRemoveTrackEvaluatorArr)) {
            return;
        }
        for (Object evaluatorObj : markRemoveTrackEvaluatorArr) {
            evaluatorObj.set("removemark", (Object)Boolean.TRUE);
        }
        entityService.save(trackObjArr);
    }

    private void updateTrackEvaluatorProgress(List<DynamicObject> evalTaskList) {
        List anonContentIdList;
        Map<Boolean, List> evalTaskByRealAnonPar = evalTaskList.stream().collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("realorcryptonym")), Collectors.collectingAndThen(Collectors.toList(), DynamicObjectIdUtils::getIds)));
        List realContentIdList = evalTaskByRealAnonPar.get(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty((Collection)realContentIdList)) {
            this.realEvaluator(realContentIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(anonContentIdList = evalTaskByRealAnonPar.get(Boolean.FALSE)))) {
            this.anonEvaluator(anonContentIdList);
        }
    }

    private void realEvaluator(List<Long> realContentIdList) {
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", realContentIdList);
        DynamicObject[] evaluatorRealArr = this.evaluatorRealEntityService.query("taskcontentid,evaluatorsource,completetime,evalinternalper,evaloutsiderentryid,evalstatus,totalevalnum,completeevalnum,reviewednum,waiverevalnum", new QFilter[]{evalTaskFilter, this.getRemoveMarkFilter()});
        Map<Boolean, List<DynamicObject>> evaluatorParByInOut = Arrays.stream(evaluatorRealArr).collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("evaluatorsource"))));
        this.calcRealEvalObjInProgress(evaluatorParByInOut);
        this.calcRealEvalObjOutProgress(evalTaskFilter, evaluatorParByInOut);
        this.evaluatorRealEntityService.save(evaluatorRealArr);
    }

    private void calcRealEvalObjInProgress(Map<Boolean, List<DynamicObject>> evaluatorParByInOut) {
        List<DynamicObject> insideEvaluatorList = evaluatorParByInOut.get(Boolean.TRUE);
        if (CollectionUtils.isEmpty(insideEvaluatorList)) {
            return;
        }
        Map<Long, List<DynamicObject>> insideEvaluatorContentMap = insideEvaluatorList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        List employeeIdList = DynamicObjectIdUtils.getIds(insideEvaluatorList, (String)"evalinternalper_id");
        List taskContentIdList = DynamicObjectIdUtils.getIds(insideEvaluatorList, (String)"taskcontentid");
        QFilter employeeIdFilter = new QFilter("evalinternalper.id", "in", (Object)employeeIdList);
        QFilter taskContentIdFilter = new QFilter("taskcontentid", "in", (Object)taskContentIdList);
        DynamicObject[] insideEvalSubTaskArr = this.evalSubTaskEntityService.query("taskcontentid,evalinternalper.id,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), employeeIdFilter, taskContentIdFilter});
        Map<Long, List<DynamicObject>> insideEvalSubTaskContentMap = Arrays.stream(insideEvalSubTaskArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        for (Map.Entry<Long, List<DynamicObject>> insideEvalSubTask : insideEvalSubTaskContentMap.entrySet()) {
            Long taskContentId = insideEvalSubTask.getKey();
            List<DynamicObject> contentInsideEvaluatorList = insideEvaluatorContentMap.get(taskContentId);
            if (!CollectionUtils.isNotEmpty(contentInsideEvaluatorList)) continue;
            this.calcEvalObjProgress(contentInsideEvaluatorList.toArray(new DynamicObject[0]), insideEvalSubTask.getValue().toArray(new DynamicObject[0]), "evalinternalper_id");
        }
    }

    private void calcRealEvalObjOutProgress(QFilter evalTaskFilter, Map<Boolean, List<DynamicObject>> evaluatorParByInOut) {
        List<DynamicObject> extPersonList = evaluatorParByInOut.get(Boolean.FALSE);
        if (CollectionUtils.isEmpty(extPersonList)) {
            return;
        }
        List extPersonIdList = DynamicObjectIdUtils.getIds(extPersonList, (String)"evaloutsiderentryid");
        QFilter extPersonFilter = new QFilter("evaloutsiderentryid", "in", (Object)extPersonIdList);
        DynamicObject[] extPersonArr = this.evalSubTaskEntityService.query("evaloutsiderentryid,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), extPersonFilter, evalTaskFilter});
        this.calcEvalObjProgress(extPersonList.toArray(new DynamicObject[0]), extPersonArr, "evaloutsiderentryid");
    }

    private void anonEvaluator(List<Long> anonContentIdList) {
        QFilter evalTaskFilter = new QFilter("evaltask.id", "in", anonContentIdList);
        DynamicObject[] evaluatorAnonArr = this.evaluatorAnonEntityService.query("taskcontentid,accountanon,evaluatornumber,usingaccount,evalstatus,totalevalnum,completeevalnum,reviewednum,waiverevalnum,completetime", new QFilter[]{evalTaskFilter, this.getRemoveMarkFilter()});
        Map<Boolean, List<DynamicObject>> evaluatorParByAccount = Arrays.stream(evaluatorAnonArr).collect(Collectors.partitioningBy(obj -> "1".equals(obj.getString("usingaccount"))));
        List<DynamicObject> accountEvaluatorList = evaluatorParByAccount.get(Boolean.TRUE);
        Map<Long, List<DynamicObject>> insideEvaluatorContentMap = accountEvaluatorList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        List accountList = DynamicObjectIdUtils.getStrProp(accountEvaluatorList, (String)"accountanon");
        List taskContentIdList = DynamicObjectIdUtils.getIds(accountEvaluatorList, (String)"taskcontentid");
        QFilter accountFilter = new QFilter("accountanon", "in", (Object)accountList);
        QFilter taskContentIdFilter = new QFilter("taskcontentid", "in", (Object)taskContentIdList);
        DynamicObject[] accountEvalSubTaskArr = this.evalSubTaskEntityService.query("taskcontentid,accountanon,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), accountFilter, taskContentIdFilter});
        Map<Long, List<DynamicObject>> insideEvalSubTaskContentMap = Arrays.stream(accountEvalSubTaskArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        for (Map.Entry<Long, List<DynamicObject>> insideEvalSubTask : insideEvalSubTaskContentMap.entrySet()) {
            Long taskContentId = insideEvalSubTask.getKey();
            List<DynamicObject> contentInsideEvaluatorList = insideEvaluatorContentMap.get(taskContentId);
            if (!CollectionUtils.isNotEmpty(contentInsideEvaluatorList)) continue;
            this.calcAnonEvalObjProgress(contentInsideEvaluatorList.toArray(new DynamicObject[0]), insideEvalSubTask.getValue().toArray(new DynamicObject[0]), "accountanon");
        }
        List<DynamicObject> seqEvaluatorList = evaluatorParByAccount.get(Boolean.FALSE);
        Map<Long, List<DynamicObject>> sqlEvaluatorContentMap = seqEvaluatorList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        List evaluatorNumberList = DynamicObjectIdUtils.getStrProp(seqEvaluatorList, (String)"evaluatornumber");
        List seqTaskContentIdList = DynamicObjectIdUtils.getIds(seqEvaluatorList, (String)"taskcontentid");
        QFilter evaluatorNumberFilter = new QFilter("evaluatornumber", "in", (Object)evaluatorNumberList);
        QFilter sqlTaskContentIdFilter = new QFilter("taskcontentid", "in", (Object)seqTaskContentIdList);
        DynamicObject[] sqlEvalSubTaskArr = this.evalSubTaskEntityService.query("taskcontentid,evaluatornumber,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), evaluatorNumberFilter, sqlTaskContentIdFilter});
        Map<Long, List<DynamicObject>> seqEvalSubTaskContentMap = Arrays.stream(sqlEvalSubTaskArr).collect(Collectors.groupingBy(obj -> obj.getLong("taskcontentid")));
        for (Map.Entry<Long, List<DynamicObject>> seqEvalSubTask : seqEvalSubTaskContentMap.entrySet()) {
            Long taskContentId = seqEvalSubTask.getKey();
            List<DynamicObject> contentInsideEvaluatorList = sqlEvaluatorContentMap.get(taskContentId);
            if (!CollectionUtils.isNotEmpty(contentInsideEvaluatorList)) continue;
            this.calcAnonEvalObjProgress(contentInsideEvaluatorList.toArray(new DynamicObject[0]), seqEvalSubTask.getValue().toArray(new DynamicObject[0]), "evaluatornumber");
        }
        this.evaluatorAnonEntityService.save(evaluatorAnonArr);
    }

    private void calcEvalObjProgress(DynamicObject[] evaluatorObjArr, DynamicObject[] evaluatorObjEvalSubTaskArr, String entryKey) {
        Map<Long, List<DynamicObject>> evalObjPerEvalSubGroup = Arrays.stream(evaluatorObjEvalSubTaskArr).collect(Collectors.groupingBy(obj -> obj.getLong(entryKey)));
        for (DynamicObject evalObjPer : evaluatorObjArr) {
            long evalObjPerEntryId = evalObjPer.getLong(entryKey);
            List<DynamicObject> curEvalSubTask = evalObjPerEvalSubGroup.get(evalObjPerEntryId);
            if (CollectionUtils.isEmpty(curEvalSubTask)) continue;
            TrackDomainServiceImpl.calcProgress(evalObjPer, curEvalSubTask);
        }
    }

    private void calcAnonEvalObjProgress(DynamicObject[] evaluatorObjArr, DynamicObject[] evaluatorObjEvalSubTaskArr, String entryKey) {
        Map<String, List<DynamicObject>> evalObjPerEvalSubGroup = Arrays.stream(evaluatorObjEvalSubTaskArr).collect(Collectors.groupingBy(obj -> obj.getString(entryKey)));
        for (DynamicObject evalObjPer : evaluatorObjArr) {
            String account = evalObjPer.getString(entryKey);
            List<DynamicObject> curEvalSubTask = evalObjPerEvalSubGroup.get(account);
            if (CollectionUtils.isEmpty(curEvalSubTask)) continue;
            TrackDomainServiceImpl.calcProgress(evalObjPer, curEvalSubTask);
        }
    }

    private static void calcProgress(DynamicObject evalObjPer, List<DynamicObject> curEvalSubTask) {
        evalObjPer.set("totalevalnum", (Object)curEvalSubTask.size());
        long completeSize = curEvalSubTask.stream().filter(obj -> {
            String taskStatus = obj.getString("taskstatus");
            return EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(taskStatus) || EvalSubTaskStatusEnum.ABSTAIN.getCode().equals(taskStatus);
        }).count();
        evalObjPer.set("completeevalnum", (Object)completeSize);
        long evaluateSize = curEvalSubTask.stream().filter(obj -> EvalSubTaskStatusEnum.IS_EVALUATE.getCode().equals(obj.getString("taskstatus"))).count();
        evalObjPer.set("reviewednum", (Object)evaluateSize);
        long abstainSize = curEvalSubTask.stream().filter(obj -> EvalSubTaskStatusEnum.ABSTAIN.getCode().equals(obj.getString("taskstatus"))).count();
        evalObjPer.set("waiverevalnum", (Object)abstainSize);
        if (completeSize == (long)curEvalSubTask.size()) {
            evalObjPer.set("evalstatus", (Object)ObjEvaluatorTaskStatusEnum.COMPLETED.getCode());
            evalObjPer.set("completetime", (Object)new Date());
        } else {
            evalObjPer.set("evalstatus", (Object)ObjEvaluatorTaskStatusEnum.IN_PROGRESS.getCode());
            evalObjPer.set("completetime", null);
        }
    }

    private void updateTrackEvalObjProgress(List<DynamicObject> evalTaskList) {
        Map<Boolean, List> evalContentPartition = evalTaskList.stream().flatMap(evalContentEntry -> evalContentEntry.getDynamicObjectCollection("contententryentity").stream()).collect(Collectors.partitioningBy(obj -> "10".equals(obj.getString("evaledobjtype")), Collectors.collectingAndThen(Collectors.toList(), DynamicObjectIdUtils::getIds)));
        DynamicObject[] evalObjPerArr = this.evalObjPerEntityService.query("objinfoperentryid,evalstatus,totalevalnum,completeevalnum,reviewednum,waiverevalnum,completetime", new QFilter("taskcontentid", "in", (Object)evalContentPartition.get(Boolean.TRUE)).toArray());
        List evalObjEntryIdList = DynamicObjectIdUtils.getIds((DynamicObject[])evalObjPerArr, (String)"objinfoperentryid");
        QFilter entryPerIdFilter = new QFilter("objinfoperentryid", "in", (Object)evalObjEntryIdList);
        DynamicObject[] evalObjPerEvalSubTaskArr = this.evalSubTaskEntityService.query("objinfoperentryid,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), entryPerIdFilter});
        this.calcEvalObjProgress(evalObjPerArr, evalObjPerEvalSubTaskArr, "objinfoperentryid");
        this.evalObjPerEntityService.save(evalObjPerArr);
        DynamicObject[] evalObjOrgArr = this.evalObjOrgEntityService.query("objinfoorgentryid,evalstatus,totalevalnum,completeevalnum,reviewednum,waiverevalnum,completetime", new QFilter("taskcontentid", "in", (Object)evalContentPartition.get(Boolean.FALSE)).toArray());
        List evalOrgEntryIdList = DynamicObjectIdUtils.getIds((DynamicObject[])evalObjOrgArr, (String)"objinfoorgentryid");
        QFilter entryOrgIdFilter = new QFilter("objinfoorgentryid", "in", (Object)evalOrgEntryIdList);
        DynamicObject[] evalObjOrgEvalSubTaskArr = this.evalSubTaskEntityService.query("objinfoorgentryid,taskstatus", new QFilter[]{this.getRemoveMarkFilter(), entryOrgIdFilter});
        this.calcEvalObjProgress(evalObjOrgArr, evalObjOrgEvalSubTaskArr, "objinfoorgentryid");
        this.evalObjOrgEntityService.save(evalObjOrgArr);
    }

    public void updateTaskEndStatus(Long taskID) {
        DynamicObject[] evalTaskAnons;
        DynamicObject[] evalTaskReals;
        DynamicObject[] evalTaskObjPers;
        QFilter taskIdQF = new QFilter("evaltask.id", "=", (Object)taskID);
        DynamicObject[] evalTaskObjOrgs = this.evalObjOrgEntityService.query("evalstatus,completetime", taskIdQF.toArray());
        if (CollectionUtils.isNotEmpty(Arrays.asList(evalTaskObjOrgs))) {
            for (DynamicObject evalTaskObjOrg : evalTaskObjOrgs) {
                evalTaskObjOrg.set("evalstatus", (Object)"C");
                evalTaskObjOrg.set("completetime", (Object)new Date());
                this.evalObjOrgEntityService.save(evalTaskObjOrg);
            }
        }
        if (CollectionUtils.isNotEmpty(Arrays.asList(evalTaskObjPers = this.evalObjPerEntityService.query("evalstatus,completetime", taskIdQF.toArray())))) {
            for (DynamicObject evalTaskObjPer : evalTaskObjPers) {
                evalTaskObjPer.set("evalstatus", (Object)"C");
                evalTaskObjPer.set("completetime", (Object)new Date());
            }
            this.evalObjPerEntityService.save(evalTaskObjPers);
        }
        if (CollectionUtils.isNotEmpty(Arrays.asList(evalTaskReals = this.evaluatorRealEntityService.query("evalstatus,completetime", taskIdQF.toArray())))) {
            for (DynamicObject evalTaskReal : evalTaskReals) {
                evalTaskReal.set("evalstatus", (Object)"C");
                evalTaskReal.set("completetime", (Object)new Date());
                this.evaluatorRealEntityService.save(evalTaskReal);
            }
        }
        if (CollectionUtils.isNotEmpty(Arrays.asList(evalTaskAnons = this.evaluatorAnonEntityService.query("evalstatus,completetime", taskIdQF.toArray())))) {
            for (DynamicObject evalTaskAnon : evalTaskAnons) {
                evalTaskAnon.set("evalstatus", (Object)"C");
                evalTaskAnon.set("completetime", (Object)new Date());
                this.evaluatorAnonEntityService.save(evalTaskAnon);
            }
        }
    }
}

