/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjOrgEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjPerEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorAnonEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvaluatorRealEntityService;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import kd.hrmp.bes.common.utils.DynamicObjectIdUtils;
import kd.hrmp.bes.common.utils.NumUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TrackObjGenerator {
    private static final Log log = LogFactory.getLog(TrackObjGenerator.class);
    private final TrackEvalObjPerEntityService evalObjPerEntityService = BesServiceFactory.getService(TrackEvalObjPerEntityService.class);
    private final TrackEvalObjOrgEntityService evalObjOrgEntityService = BesServiceFactory.getService(TrackEvalObjOrgEntityService.class);
    private final TrackEvaluatorRealEntityService evaluatorRealEntityService = BesServiceFactory.getService(TrackEvaluatorRealEntityService.class);
    private final TrackEvaluatorAnonEntityService evaluatorAnonEntityService = BesServiceFactory.getService(TrackEvaluatorAnonEntityService.class);
    private DynamicObject evalTaskObj;
    private DynamicObject evalContentObj;
    private EvalTaskDependOnDbData evalTaskDependOnDbData;

    public TrackObjGenerator(DynamicObject evalTaskObj, DynamicObject content, EvalTaskDependOnDbData evalTaskDependOnDbData) {
        this.evalTaskObj = evalTaskObj;
        this.evalContentObj = content;
        this.evalTaskDependOnDbData = evalTaskDependOnDbData;
    }

    public TrackObjGenerator(DynamicObject evalTaskObj, DynamicObject content) {
        this.evalTaskObj = evalTaskObj;
        this.evalContentObj = content;
    }

    public DynamicObject getEvalTaskObj() {
        return this.evalTaskObj;
    }

    public void setEvalTaskObj(DynamicObject evalTaskObj) {
        this.evalTaskObj = evalTaskObj;
    }

    public DynamicObject getEvalContentObj() {
        return this.evalContentObj;
    }

    public void setEvalContentObj(DynamicObject evalContentObj) {
        this.evalContentObj = evalContentObj;
    }

    public List<DynamicObject> genTrackEvalObjPer() {
        String evalObjType = this.getEvalContentObj().getString("evaledobjtype");
        if ("10".equals(evalObjType)) {
            DynamicObjectCollection objInfoPerSubEntry = this.getEvalContentObj().getDynamicObjectCollection("objinfopersubentry");
            ArrayList trackEvalObjPer = Lists.newArrayListWithExpectedSize((int)objInfoPerSubEntry.size());
            for (DynamicObject objInfoPer : objInfoPerSubEntry) {
                DynamicObject evalObjPerEntity = this.evalObjPerEntityService.generateEmptyDynamicObject();
                this.trackEvalObjPerProp(objInfoPer, evalObjPerEntity);
                this.trackEvalObjCommonProp(evalObjPerEntity);
                this.setResScoreSubEntry(evalObjPerEntity);
                trackEvalObjPer.add(evalObjPerEntity);
            }
            return trackEvalObjPer;
        }
        return Collections.emptyList();
    }

    private void trackEvalObjCommonProp(DynamicObject evalObjEntity) {
        evalObjEntity.set("number", (Object)this.evalContentObj.getString("contentcode"));
        evalObjEntity.set("name", this.evalContentObj.get("contentname"));
        evalObjEntity.set("evaltask", (Object)this.evalTaskObj);
        evalObjEntity.set("taskcontentid", (Object)this.evalContentObj.getLong("id"));
        evalObjEntity.set("evalstatus", (Object)"A");
        evalObjEntity.set("initiator", this.evalTaskObj.get("creator"));
    }

    private void trackEvaluatorObjCommonProp(DynamicObject evalObjEntity) {
        evalObjEntity.set("number", (Object)this.evalContentObj.getString("contentcode"));
        evalObjEntity.set("name", this.evalContentObj.get("contentname"));
        evalObjEntity.set("evaltask", (Object)this.evalTaskObj);
        evalObjEntity.set("taskcontentid", (Object)this.evalContentObj.getLong("id"));
        evalObjEntity.set("evalstatus", (Object)"A");
        evalObjEntity.set("initiator", this.evalTaskObj.get("creator"));
    }

    private void setResScoreSubEntry(DynamicObject evalObjEntity) {
        DynamicObjectCollection indicatorSubEntry = this.evalContentObj.getDynamicObjectCollection("indicatorsubentry");
        DynamicObjectCollection optSubEntry = this.evalContentObj.getDynamicObjectCollection("optsubentry");
        Map<Long, List<DynamicObject>> optIndicatorMap = optSubEntry.stream().collect(Collectors.groupingBy(obj -> obj.getLong("indicator")));
        String indicatorEvalType = this.getEvalContentObj().getString("evaltemp.indicatorevaltype");
        DynamicObjectCollection noScoreEntry = evalObjEntity.getDynamicObjectCollection("noscoreentry");
        DynamicObjectCollection scoreEntry = evalObjEntity.getDynamicObjectCollection("scoreentry");
        for (DynamicObject indicatorObj : indicatorSubEntry) {
            String indicatorType = indicatorObj.getString("indicatortype");
            String areaCode = indicatorObj.getString("areacode");
            if ("B".equals(indicatorType)) {
                this.addResForNoScore(optIndicatorMap, indicatorObj, noScoreEntry, indicatorType);
            }
            if ("C".equals(indicatorType)) {
                this.addResForScore(indicatorObj, scoreEntry);
            }
            if (!"A".equals(indicatorType)) continue;
            if ("10".equals(indicatorEvalType) || !"0".equals(areaCode)) {
                this.addResForNoScore(optIndicatorMap, indicatorObj, noScoreEntry, indicatorType);
                continue;
            }
            this.addResForScore(indicatorObj, scoreEntry);
        }
    }

    private void addResForNoScore(Map<Long, List<DynamicObject>> optIndicatorMap, DynamicObject indicatorObj, DynamicObjectCollection noScoreEntry, String indicatorType) {
        long indicatorId = indicatorObj.getLong("id");
        List<DynamicObject> optObjList = optIndicatorMap.get(indicatorId);
        if (CollectionUtils.isEmpty(optObjList)) {
            return;
        }
        DynamicObjectType noScoreEntryType = noScoreEntry.getDynamicObjectType();
        for (DynamicObject optEntryObj : optObjList) {
            DynamicObject optSubEntryNewObj = new DynamicObject(noScoreEntryType);
            optSubEntryNewObj.set("evalindicatorentryid", optEntryObj.get("id"));
            optSubEntryNewObj.set("indicator", optEntryObj.get("indicator"));
            optSubEntryNewObj.set("optsindicaseq", optEntryObj.get("optsindicaseq"));
            optSubEntryNewObj.set("optname", optEntryObj.get("optname"));
            optSubEntryNewObj.set("indicatortype", (Object)indicatorType);
            noScoreEntry.add((Object)optSubEntryNewObj);
        }
    }

    private void addResForScore(DynamicObject indicatorObj, DynamicObjectCollection scoreEntry) {
        DynamicObjectType noScoreEntryType = scoreEntry.getDynamicObjectType();
        DynamicObject optSubEntryNewObj = new DynamicObject(noScoreEntryType);
        optSubEntryNewObj.set("scoreevalindientryid", indicatorObj.get("id"));
        int weight = indicatorObj.getInt("weight");
        if (weight == 0) {
            weight = 100;
        }
        optSubEntryNewObj.set("weight", (Object)weight);
        scoreEntry.add((Object)optSubEntryNewObj);
    }

    public List<DynamicObject> genTrackEvalObjOrg() {
        String evalObjType = this.getEvalContentObj().getString("evaledobjtype");
        if ("20".equals(evalObjType)) {
            DynamicObjectCollection objInfoPerSubEntry = this.getEvalContentObj().getDynamicObjectCollection("objinfoorgsubentry");
            ArrayList trackEvalObjOrg = Lists.newArrayListWithExpectedSize((int)objInfoPerSubEntry.size());
            for (DynamicObject objInfoPer : objInfoPerSubEntry) {
                DynamicObject evalObjPerEntity = this.evalObjOrgEntityService.generateEmptyDynamicObject();
                this.trackEvalObjOrgProp(objInfoPer, evalObjPerEntity);
                this.trackEvalObjCommonProp(evalObjPerEntity);
                this.setResScoreSubEntry(evalObjPerEntity);
                trackEvalObjOrg.add(evalObjPerEntity);
            }
            return trackEvalObjOrg;
        }
        return Collections.emptyList();
    }

    private void trackEvalObjPerProp(DynamicObject objInfoPer, DynamicObject evalObjPerEntity) {
        evalObjPerEntity.set("objinfoperentryid", objInfoPer.get("id"));
        evalObjPerEntity.set("headsculpture", objInfoPer.get("headsculpture"));
        evalObjPerEntity.set("pernumber", objInfoPer.get("pernumber"));
        evalObjPerEntity.set("pername", objInfoPer.get("pername"));
        evalObjPerEntity.set("telephone", objInfoPer.get("telephone"));
        evalObjPerEntity.set("email", objInfoPer.get("email"));
        evalObjPerEntity.set("percompany", objInfoPer.get("percompany"));
        evalObjPerEntity.set("peradminorg", objInfoPer.get("peradminorg"));
        evalObjPerEntity.set("perposition", objInfoPer.get("perposition"));
        evalObjPerEntity.set("perstdpos", objInfoPer.get("perstdpos"));
        evalObjPerEntity.set("perjob", objInfoPer.get("perjob"));
        evalObjPerEntity.set("perdatasource", objInfoPer.get("perdatasource"));
    }

    private void trackEvalObjOrgProp(DynamicObject objInfoPer, DynamicObject evalObjPerEntity) {
        evalObjPerEntity.set("objinfoorgentryid", objInfoPer.get("id"));
        evalObjPerEntity.set("orgnumber", objInfoPer.get("orgnumber"));
        evalObjPerEntity.set("orgname", objInfoPer.get("orgname"));
        evalObjPerEntity.set("institutionaltype", objInfoPer.get("institutionaltype"));
        evalObjPerEntity.set("parmanageorg", objInfoPer.get("parmanageorg"));
        evalObjPerEntity.set("registerdate", objInfoPer.get("registerdate"));
        evalObjPerEntity.set("subcompany", objInfoPer.get("subcompany"));
    }

    private void trackEvaluatorRealProp(DynamicObject evaluatorRealObj, DynamicObject evalRealEntryObj) {
        evaluatorRealObj.set("evalbody", evalRealEntryObj.get("evalbody"));
        evaluatorRealObj.set("evalbodyweightreal", evalRealEntryObj.get("evalbodyweightreal"));
        evaluatorRealObj.set("evaluatorrealentryid", evalRealEntryObj.get("id"));
    }

    private void trackEvaluatorAnonSeq(DynamicObject evaluatorRealObj, int evalSeq) {
        evaluatorRealObj.set("evaluatornumber", (Object)NumUtil.formatNumber((int)evalSeq));
    }

    private void trackEvaluatorAnonEntry(DynamicObject evaluatorRealObj, DynamicObject anonEvalEntry) {
        evaluatorRealObj.set("evaluatoranonentryid", anonEvalEntry.get("id"));
        evaluatorRealObj.set("evalbodynameanon", anonEvalEntry.get("evalbodynameanon"));
        evaluatorRealObj.set("evalbodyweightanon", anonEvalEntry.get("evalbodyweightanon"));
        evaluatorRealObj.set("accountanon", anonEvalEntry.get("accountanon"));
    }

    private void trackEvaluatorRealEmpProp(DynamicObject evaluatorRealObj, DynamicObject employee) {
        evaluatorRealObj.set("evaluatorsource", (Object)"1");
        evaluatorRealObj.set("evalinternalper", (Object)employee);
        Map<Long, Long> employeeUserIdMap = this.evalTaskDependOnDbData.getEmployeeUserIdMap();
        if (MapUtils.isEmpty(employeeUserIdMap)) {
            log.error("TrackObjGenerator.trackEvaluatorRealEmpProp user null: {}", (Object)employee.getLong("id"));
            return;
        }
        evaluatorRealObj.set("user", (Object)employeeUserIdMap.get(employee.getLong("id")));
        Map<String, Object> employeeInfoMap = this.evalTaskDependOnDbData.getEmployeeInfoMap().get(employee.getLong("id"));
        if (MapUtils.isEmpty(employeeInfoMap)) {
            log.error("TrackObjGenerator.trackEvaluatorRealEmpProp empposorgrel null: {}", (Object)employee.getLong("id"));
            return;
        }
        evaluatorRealObj.set("evalorouttel", employeeInfoMap.get("phone"));
        evaluatorRealObj.set("evaloroutemail", employeeInfoMap.get("email"));
        evaluatorRealObj.set("evaloroutcompany", employeeInfoMap.get("company"));
        evaluatorRealObj.set("evaloroutadminorg", employeeInfoMap.get("adminorg"));
        evaluatorRealObj.set("evaloroutpos", employeeInfoMap.get("position"));
        evaluatorRealObj.set("evaloroutstdpos", employeeInfoMap.get("stdposition"));
        evaluatorRealObj.set("evaloroutjob", employeeInfoMap.get("job"));
        evaluatorRealObj.set("evaloroutname", employeeInfoMap.get("name"));
        evaluatorRealObj.set("evaloroutnumber", employeeInfoMap.get("number"));
    }

    private void trackEvaluatorRealOutProp(DynamicObject evaluatorRealObj, Long outEvaluatorEntryId) {
        evaluatorRealObj.set("evaluatorsource", (Object)"2");
        evaluatorRealObj.set("evaloutsiderentryid", (Object)outEvaluatorEntryId);
        DynamicObjectCollection outEvaluatorEntry = this.evalContentObj.getDynamicObjectCollection("realoutsidersubentry");
        Map outEvaluatorEntryMap = outEvaluatorEntry.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
        DynamicObject outEvaluatorEntryObj = (DynamicObject)outEvaluatorEntryMap.get(outEvaluatorEntryId);
        if (!HRObjectUtils.isEmpty((Object)outEvaluatorEntryObj)) {
            evaluatorRealObj.set("evaloroutname", outEvaluatorEntryObj.get("evaloroutname"));
            evaluatorRealObj.set("evalorouttel", outEvaluatorEntryObj.get("evalorouttel"));
            evaluatorRealObj.set("evaloroutemail", outEvaluatorEntryObj.get("evaloroutemail"));
            evaluatorRealObj.set("evaloroutcompany", outEvaluatorEntryObj.get("evaloroutcompany"));
            evaluatorRealObj.set("evaloroutadminorg", outEvaluatorEntryObj.get("evaloroutadminorg"));
            evaluatorRealObj.set("evaloroutpos", outEvaluatorEntryObj.get("evaloroutpos"));
            evaluatorRealObj.set("evaloroutstdpos", outEvaluatorEntryObj.get("evaloroutstdpos"));
            evaluatorRealObj.set("evaloroutjob", outEvaluatorEntryObj.get("evaloroutjob"));
        }
    }

    public List<DynamicObject> genTrackEvaluatorAnon() {
        String realAnonymous = this.evalTaskObj.getString("realorcryptonym");
        if ("2".equals(realAnonymous)) {
            String specificEvaluator = this.evalContentObj.getString("specificevaluator");
            if ("20".equals(specificEvaluator)) {
                return Collections.emptyList();
            }
            String evalMainBody = this.evalContentObj.getString("evalmainbody");
            String anonMode = this.evalContentObj.getString("anonmode");
            ArrayList res = Lists.newArrayList();
            if ("20".equals(anonMode) && "20".equals(evalMainBody)) {
                int evalNumMax = this.evalContentObj.getInt("evaluatornummax");
                for (int evalSeq = 1; evalSeq <= evalNumMax; ++evalSeq) {
                    DynamicObject evaluatorAnon = this.evaluatorAnonEntityService.generateEmptyDynamicObject();
                    evaluatorAnon.set("usingaccount", (Object)Boolean.FALSE);
                    this.trackEvaluatorObjCommonProp(evaluatorAnon);
                    this.trackEvaluatorAnonSeq(evaluatorAnon, evalSeq);
                    this.setResScoreSubEntry(evaluatorAnon);
                    res.add(evaluatorAnon);
                }
            } else {
                int evalNumMax;
                DynamicObjectCollection evaluatorAnonEntry = this.evalContentObj.getDynamicObjectCollection("evaluatoranonsubentry");
                if ("20".equals(anonMode) && "10".equals(evalMainBody)) {
                    evalNumMax = 1;
                    for (DynamicObject evalAnonEntryObj : evaluatorAnonEntry) {
                        int curMainBodyParticipantNum = evalAnonEntryObj.getInt("participantnumber");
                        for (int i = 0; i < curMainBodyParticipantNum; ++i) {
                            DynamicObject evaluatorAnon = this.evaluatorAnonEntityService.generateEmptyDynamicObject();
                            evaluatorAnon.set("usingaccount", (Object)Boolean.FALSE);
                            this.trackEvaluatorObjCommonProp(evaluatorAnon);
                            this.trackEvaluatorAnonSeq(evaluatorAnon, evalNumMax);
                            this.trackEvaluatorAnonEntry(evaluatorAnon, evalAnonEntryObj);
                            this.setResScoreSubEntry(evaluatorAnon);
                            res.add(evaluatorAnon);
                            ++evalNumMax;
                        }
                    }
                }
                if ("10".equals(anonMode)) {
                    evalNumMax = 1;
                    for (DynamicObject evalAnonEntryObj : evaluatorAnonEntry) {
                        DynamicObject evaluatorAnon = this.evaluatorAnonEntityService.generateEmptyDynamicObject();
                        evaluatorAnon.set("usingaccount", (Object)Boolean.TRUE);
                        this.trackEvaluatorObjCommonProp(evaluatorAnon);
                        this.trackEvaluatorAnonSeq(evaluatorAnon, evalNumMax);
                        this.trackEvaluatorAnonEntry(evaluatorAnon, evalAnonEntryObj);
                        this.setResScoreSubEntry(evaluatorAnon);
                        res.add(evaluatorAnon);
                        ++evalNumMax;
                    }
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    public List<DynamicObject> genTrackEvaluatorReal() {
        String realAnonymous = this.evalTaskObj.getString("realorcryptonym");
        if ("1".equals(realAnonymous)) {
            DynamicObjectCollection evaluatorRealEntry = this.evalContentObj.getDynamicObjectCollection("evaluatorrealsubentry");
            ArrayList trackEvalObjPer = Lists.newArrayListWithExpectedSize((int)(evaluatorRealEntry.size() * 2));
            trackEvalObjPer.addAll(this.evaluatorEmp(evaluatorRealEntry));
            trackEvalObjPer.addAll(this.evaluatorOut(evaluatorRealEntry));
            return trackEvalObjPer;
        }
        return Collections.emptyList();
    }

    private List<DynamicObject> evaluatorEmp(DynamicObjectCollection evaluatorRealEntry) {
        ArrayList evaluatorGroupBeans = Lists.newArrayList();
        for (DynamicObject entryObj : evaluatorRealEntry) {
            for (DynamicObject employeeObj : entryObj.getDynamicObjectCollection("inevaluator")) {
                evaluatorGroupBeans.add(new EvaluatorGroupBean(entryObj, employeeObj.getDynamicObject("fbasedataid")));
            }
        }
        if (CollectionUtils.isEmpty((Collection)evaluatorGroupBeans)) {
            return Collections.emptyList();
        }
        Map<DynamicObject, List<EvaluatorGroupBean>> evalGroupMap = evaluatorGroupBeans.stream().collect(Collectors.groupingBy(EvaluatorGroupBean::getEmployeeObj));
        ArrayList res = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<DynamicObject, List<EvaluatorGroupBean>> evalGroupMapEntry : evalGroupMap.entrySet()) {
            DynamicObject employee = evalGroupMapEntry.getKey();
            DynamicObject evaluatorReal = this.evaluatorRealEntityService.generateEmptyDynamicObject();
            this.trackEvaluatorObjCommonProp(evaluatorReal);
            String taskNumber = this.getEvalTaskObj().getString("number");
            String contentNumber = this.evalContentObj.getString("contentcode");
            evaluatorReal.set("number", (Object)(taskNumber + "_" + contentNumber));
            this.trackEvaluatorRealProp(evaluatorReal, evalGroupMapEntry.getValue().get(0).getEntryObj());
            this.trackEvaluatorRealEmpProp(evaluatorReal, employee);
            this.setResScoreSubEntry(evaluatorReal);
            res.add(evaluatorReal);
        }
        return res;
    }

    private List<DynamicObject> evaluatorOut(DynamicObjectCollection evaluatorRealEntry) {
        ArrayList evaluatorGroupBeans = Lists.newArrayList();
        for (DynamicObject entryObj : evaluatorRealEntry) {
            String outEvaluatorEntryIdStr = entryObj.getString("outevaluator_tag");
            List outEvaluatorEntryIdStrList = Arrays.stream(outEvaluatorEntryIdStr.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            for (String outEvaluatorEntryId : outEvaluatorEntryIdStrList) {
                evaluatorGroupBeans.add(new EvaluatorGroupBean(entryObj, Long.parseLong(outEvaluatorEntryId)));
            }
        }
        if (CollectionUtils.isEmpty((Collection)evaluatorRealEntry)) {
            return Collections.emptyList();
        }
        Map<Long, List<EvaluatorGroupBean>> evalGroupMap = evaluatorGroupBeans.stream().collect(Collectors.groupingBy(EvaluatorGroupBean::getOutEvaluatorEntryId));
        ArrayList res = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<Long, List<EvaluatorGroupBean>> evalGroupMapEntry : evalGroupMap.entrySet()) {
            Long outEvaluatorEntryId = evalGroupMapEntry.getKey();
            DynamicObject evaluatorReal = this.evaluatorRealEntityService.generateEmptyDynamicObject();
            this.trackEvaluatorObjCommonProp(evaluatorReal);
            this.trackEvaluatorRealProp(evaluatorReal, evalGroupMapEntry.getValue().get(0).getEntryObj());
            this.trackEvaluatorRealOutProp(evaluatorReal, outEvaluatorEntryId);
            this.setResScoreSubEntry(evaluatorReal);
            res.add(evaluatorReal);
        }
        return res;
    }

    public DynamicObject genTrackEvaluatorRealByEvalSubTask(DynamicObject evalSubTask) {
        DynamicObject newRealEvaluator = this.evaluatorRealEntityService.generateEmptyDynamicObject();
        this.trackEvaluatorObjCommonProp(newRealEvaluator);
        this.trackEvaluatorRealEmpProp(newRealEvaluator, this.convertIdToObj("hrpi_employee", DynamicObjectIdUtils.getBaseDataId((DynamicObject)evalSubTask, (String)"evalinternalper")));
        this.setResScoreSubEntry(newRealEvaluator);
        return newRealEvaluator;
    }

    private DynamicObject convertIdToObj(String entityType, Long id) {
        HRBaseServiceHelper helper = HRBaseServiceHelper.create((String)entityType);
        DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)id);
        return dynamicObject;
    }

    public DynamicObject genTrackEvaluatorAnonByEvalSubTask(DynamicObject evalSubTask) {
        DynamicObject newAnonEvaluator = this.evaluatorAnonEntityService.generateEmptyDynamicObject();
        this.trackEvaluatorObjCommonProp(newAnonEvaluator);
        this.setResScoreSubEntry(newAnonEvaluator);
        return newAnonEvaluator;
    }

    static class EvaluatorGroupBean {
        private DynamicObject entryObj;
        private DynamicObject employeeObj;
        private Long outEvaluatorEntryId;

        public EvaluatorGroupBean(DynamicObject entryObj, Long outEvalEntryId) {
            this.entryObj = entryObj;
            this.outEvaluatorEntryId = outEvalEntryId;
        }

        public EvaluatorGroupBean(DynamicObject entryObj, DynamicObject employeeObj) {
            this.entryObj = entryObj;
            this.employeeObj = employeeObj;
        }

        public DynamicObject getEntryObj() {
            return this.entryObj;
        }

        public void setEntryObj(DynamicObject entryObj) {
            this.entryObj = entryObj;
        }

        public DynamicObject getEmployeeObj() {
            return this.employeeObj;
        }

        public void setEmployeeObj(DynamicObject employeeObj) {
            this.employeeObj = employeeObj;
        }

        public Long getOutEvaluatorEntryId() {
            return this.outEvaluatorEntryId;
        }

        public void setOutEvaluatorEntryId(Long outEvaluatorEntryId) {
            this.outEvaluatorEntryId = outEvaluatorEntryId;
        }
    }
}

