/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask.strategy;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.AbstractEvalSubTaskGenerator;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import kd.hrmp.bes.common.utils.NumUtil;

public abstract class AbstractAnonSubTaskGenerator
extends AbstractEvalSubTaskGenerator {
    public DynamicObjectCollection evalAnonymousColl;

    public AbstractAnonSubTaskGenerator(DynamicObject evalTaskObj, DynamicObject content, EvalTaskDependOnDbData dbData) {
        super(evalTaskObj, content, dbData);
        this.evalAnonymousColl = content.getDynamicObjectCollection("evaluatoranonsubentry");
    }

    public int getCurEvalObjEvalSubTaskListNameLess(List<DynamicObject> subTaskList, int contentTaskNum) {
        DynamicObject contentObj = this.getContent();
        String specificEvaluator = contentObj.getString("specificevaluator");
        String evalMainBody = contentObj.getString("evalmainbody");
        String anonMode = contentObj.getString("anonmode");
        if ("10".equals(specificEvaluator)) {
            AnonEvalSubTaskGen anonEvalSubTaskGen = new AnonEvalSubTaskGen(subTaskList);
            anonEvalSubTaskGen.initAnonReviewerNum();
            if ("20".equals(anonMode) && "20".equals(evalMainBody)) {
                contentTaskNum = anonEvalSubTaskGen.noLoginNoSubject(contentTaskNum);
            } else {
                for (DynamicObject evalAnonymousObj : this.evalAnonymousColl) {
                    if ("20".equals(anonMode) && "10".equals(evalMainBody)) {
                        contentTaskNum = anonEvalSubTaskGen.noLoginSubject(contentTaskNum, evalAnonymousObj);
                    }
                    if (!"10".equals(anonMode)) continue;
                    DynamicObject oneAnonEvalSubTask = anonEvalSubTaskGen.genOneAnonEvalSubTask(contentTaskNum, evalAnonymousObj);
                    oneAnonEvalSubTask.set("usingaccount", (Object)Boolean.TRUE);
                    ++contentTaskNum;
                }
            }
        }
        return contentTaskNum;
    }

    private String getEvalDataSource() {
        String specificEvaluator = this.getContent().getString("specificevaluator");
        String anonMode = this.getContent().getString("anonmode");
        String evalMainBody = this.getContent().getString("evalmainbody");
        String type = "10".equals(specificEvaluator) ? ("10".equals(anonMode) ? "21" : ("10".equals(evalMainBody) ? "22" : "23")) : "24";
        return type;
    }

    class AnonEvalSubTaskGen {
        List<DynamicObject> subTaskList;
        int anonReviewerNum;

        public void initAnonReviewerNum() {
            this.anonReviewerNum = 1;
        }

        public void incrAnonReviewerNum() {
            ++this.anonReviewerNum;
        }

        public int getAnonReviewerNum() {
            return this.anonReviewerNum;
        }

        public AnonEvalSubTaskGen(List<DynamicObject> subTaskList) {
            this.subTaskList = subTaskList;
        }

        private int noLoginNoSubject(int contentTaskNum) {
            int evalNumMax = AbstractAnonSubTaskGenerator.this.getContent().getInt("evaluatornummax");
            for (int subTaskNum = 0; subTaskNum < evalNumMax; ++subTaskNum) {
                DynamicObject oneAnonEvalSubTask = this.genOneAnonEvalSubTask(contentTaskNum, null);
                oneAnonEvalSubTask.set("usingaccount", (Object)Boolean.FALSE);
                ++contentTaskNum;
            }
            return contentTaskNum;
        }

        private int noLoginSubject(int contentTaskNum, DynamicObject evalAnonymousObj) {
            int participantNum = evalAnonymousObj.getInt("participantnumber");
            for (int subTaskNum = 0; subTaskNum < participantNum; ++subTaskNum) {
                DynamicObject oneAnonEvalSubTask = this.genOneAnonEvalSubTask(contentTaskNum, evalAnonymousObj);
                oneAnonEvalSubTask.set("usingaccount", (Object)Boolean.FALSE);
                ++contentTaskNum;
            }
            return contentTaskNum;
        }

        private DynamicObject genOneAnonEvalSubTask(int contentTaskNum, DynamicObject evalAnonymousObj) {
            String subTaskName = AbstractAnonSubTaskGenerator.this.getEvalObjName() + " -> " + contentTaskNum;
            DynamicObject oneEvalSubTask = AbstractAnonSubTaskGenerator.this.evalSubTaskEntityService.generateEmptyDynamicObject();
            AbstractAnonSubTaskGenerator.this.subTaskEntryByIndicator(AbstractAnonSubTaskGenerator.this.indicatorColl, oneEvalSubTask);
            AbstractAnonSubTaskGenerator.this.setEvalSubTaskCommonProp(contentTaskNum, subTaskName, oneEvalSubTask);
            String type = AbstractAnonSubTaskGenerator.this.getEvalDataSource();
            oneEvalSubTask.set("evaldatasource", (Object)type);
            long evalAnonymousEntryId = evalAnonymousObj != null ? evalAnonymousObj.getLong("id") : 0L;
            oneEvalSubTask.set("evaluatoranonentryid", (Object)evalAnonymousEntryId);
            oneEvalSubTask.set("evaluatornumber", (Object)NumUtil.formatNumber((int)this.getAnonReviewerNum()));
            this.incrAnonReviewerNum();
            this.setAnonEntryProperty(evalAnonymousObj, oneEvalSubTask);
            this.subTaskList.add(oneEvalSubTask);
            return oneEvalSubTask;
        }

        private void setAnonEntryProperty(DynamicObject evalAnonymousObj, DynamicObject oneEvalSubTask) {
            if (!Objects.isNull(evalAnonymousObj)) {
                oneEvalSubTask.set("evalbodynameanon", evalAnonymousObj.get("evalbodynameanon"));
                int weight = evalAnonymousObj.getInt("evalbodyweightanon");
                if (weight == 0) {
                    weight = 100;
                }
                oneEvalSubTask.set("evalbodyweight", (Object)weight);
                oneEvalSubTask.set("accountanon", evalAnonymousObj.get("accountanon"));
            }
        }
    }
}

