/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evalsubtask.strategy;

import com.kingdee.bos.qing.util.MapUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.AbstractEvalSubTaskGenerator;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRealEvalSubTaskGenerator
extends AbstractEvalSubTaskGenerator {
    private final DynamicObjectCollection evalRealColl;
    private final Map<Long, DynamicObject> realOutsiderMap;

    public AbstractRealEvalSubTaskGenerator(DynamicObject evalTaskObj, DynamicObject content, EvalTaskDependOnDbData dbData) {
        super(evalTaskObj, content, dbData);
        this.evalRealColl = content.getDynamicObjectCollection("evaluatorrealsubentry");
        this.realOutsiderMap = content.getDynamicObjectCollection("realoutsidersubentry").stream().collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
    }

    public int getCurEvalObjEvalSubTaskList(List<DynamicObject> subTaskList, int contentTaskNum) {
        for (DynamicObject evalRealEntryObj : this.evalRealColl) {
            long evalObjIdCur = evalRealEntryObj.getLong("evaledobj");
            long evalRealEntryId = evalRealEntryObj.getLong("id");
            int evalBodyWeightReal = this.getBodyWeightReal(evalRealEntryObj);
            if (this.getEvalObjEntryId() != evalObjIdCur) continue;
            DynamicObjectCollection inEvaluatorColl = evalRealEntryObj.getDynamicObjectCollection("inevaluator");
            for (DynamicObject inEvaluator : inEvaluatorColl) {
                String subTaskName = this.getEvalObjName() + " -> " + inEvaluator.getDynamicObject("fbasedataid.person").get("name");
                DynamicObject oneEvalSubTask = this.evalSubTaskEntityService.generateEmptyDynamicObject();
                oneEvalSubTask.set("evalbodyweight", (Object)evalBodyWeightReal);
                this.subTaskEntryByIndicator(this.indicatorColl, oneEvalSubTask);
                this.setEvalSubTaskCommonProp(contentTaskNum, subTaskName, oneEvalSubTask);
                String specificEvaluator = this.getContent().getString("specificevaluator");
                String type = "10".equals(specificEvaluator) ? "10" : "12";
                oneEvalSubTask.set("evaldatasource", (Object)type);
                oneEvalSubTask.set("evaluatorsource", (Object)"1");
                oneEvalSubTask.set("evaluatorrealentryid", (Object)evalRealEntryId);
                oneEvalSubTask.set("evalinternalper", (Object)inEvaluator.getDynamicObject("fbasedataid"));
                Map<Long, Long> employeeUserIdMap = this.getDbData().getEmployeeUserIdMap();
                if (MapUtils.isNotEmpty(employeeUserIdMap)) {
                    Long userId = employeeUserIdMap.get(inEvaluator.getLong("fbasedataid_id"));
                    oneEvalSubTask.set("user", (Object)userId);
                }
                subTaskList.add(oneEvalSubTask);
                ++contentTaskNum;
            }
            String outEvaluator = evalRealEntryObj.getString("outevaluator_tag");
            List outEvaluatorList = Arrays.stream(outEvaluator.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            for (String outEvaluatorEntryId : outEvaluatorList) {
                long outsiderId = Long.parseLong(outEvaluatorEntryId);
                DynamicObject outsiderObj = this.realOutsiderMap.get(outsiderId);
                if (HRObjectUtils.isEmpty((Object)outsiderObj)) continue;
                String subTaskName = this.getEvalObjName() + " -> " + outsiderObj.getString("evaloroutname");
                DynamicObject oneEvalSubTask = this.evalSubTaskEntityService.generateEmptyDynamicObject();
                oneEvalSubTask.set("evalbodyweight", (Object)evalBodyWeightReal);
                oneEvalSubTask.set("evalorouttel", outsiderObj.get("evalorouttel"));
                this.subTaskEntryByIndicator(this.indicatorColl, oneEvalSubTask);
                this.setEvalSubTaskCommonProp(contentTaskNum, subTaskName, oneEvalSubTask);
                String type = this.getEvalSourceType();
                oneEvalSubTask.set("evaldatasource", (Object)type);
                oneEvalSubTask.set("evaluatorsource", (Object)"2");
                oneEvalSubTask.set("evaluatorrealentryid", (Object)evalRealEntryId);
                oneEvalSubTask.set("evaloutsiderentryid", (Object)outEvaluatorEntryId);
                subTaskList.add(oneEvalSubTask);
                ++contentTaskNum;
            }
        }
        return contentTaskNum;
    }

    private int getBodyWeightReal(DynamicObject evalRealEntryObj) {
        int weight = evalRealEntryObj.getInt("evalbodyweightreal");
        if (weight == 0) {
            return 100;
        }
        return weight;
    }

    private String getEvalSourceType() {
        String specificEvaluator = this.getContent().getString("specificevaluator");
        String type = "10".equals(specificEvaluator) ? "11" : "12";
        return type;
    }
}

