/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evaltask;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.evalpreview.EvalViewDomainServiceImpl;
import kd.hrmp.bes.business.domain.evaltask.EvalOnlineValidService;
import kd.hrmp.bes.common.constants.eval.EvalViewConstants;
import kd.hrmp.bes.common.dto.LoginParamDTO;
import kd.hrmp.bes.common.dto.ResultObjectDTO;
import org.apache.commons.lang3.tuple.Pair;

public class EvalOnlineValidServiceImpl
implements EvalOnlineValidService {
    private final EvalViewDomainServiceImpl evalViewDomainService = new EvalViewDomainServiceImpl();
    private static final HRBaseServiceHelper BES_EVALSUBTASK = new HRBaseServiceHelper("bes_evalsubtask");

    @Override
    public List<String> onePerIndicatorMustFillValid(Long evalObjId, Map<Long, List<ResultObjectDTO>> evalObjResultObjListMap, DynamicObject content) {
        List<ResultObjectDTO> resultObjectDTOList = evalObjResultObjListMap.get(evalObjId);
        return this.tipIndicatorMust(resultObjectDTOList, content);
    }

    @Override
    public List<String> tipIndicatorMust(List<ResultObjectDTO> resultObjectDTOList, DynamicObject content) {
        List<Long> mustIndicatorIdList = this.mustFillIndicatorId(content);
        Map<Long, List<String>> reasonIndOptListMap = this.mustFillIndicatorIdOptName(content);
        ArrayList<String> tipIndicatorNameList = new ArrayList<String>(10);
        List indicatorIdList = resultObjectDTOList.stream().map(ResultObjectDTO::getIndicatorId).collect(Collectors.toList());
        for (Long indicator : mustIndicatorIdList) {
            if (indicatorIdList.contains(indicator)) continue;
            String indicatorName = this.getIndicatorNameByContent(indicator, content);
            tipIndicatorNameList.add("\u201c" + indicatorName + "\u201d");
        }
        block13: for (ResultObjectDTO resultObjectDTO : resultObjectDTOList) {
            String indicatorResult;
            String indicatorType;
            Long indicatorId = resultObjectDTO.getIndicatorId();
            switch (indicatorType = resultObjectDTO.getIndicatorType()) {
                case "A": {
                    indicatorResult = resultObjectDTO.getSingleChoice();
                    break;
                }
                case "B": {
                    indicatorResult = resultObjectDTO.getMultipleChoice();
                    break;
                }
                case "C": {
                    if (Objects.nonNull(resultObjectDTO.getNumerical())) {
                        indicatorResult = resultObjectDTO.getNumerical().toString();
                        break;
                    }
                    indicatorResult = "";
                    break;
                }
                case "D": {
                    indicatorResult = resultObjectDTO.getEvaluate();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + indicatorType);
                }
            }
            String indicatorName = this.getIndicatorNameByContent(indicatorId, content);
            if (mustIndicatorIdList.contains(indicatorId) && (HRStringUtils.equals((String)"", (String)indicatorResult) || mustIndicatorIdList.contains(indicatorId) && Objects.isNull(indicatorResult))) {
                tipIndicatorNameList.add("\u201c" + indicatorName + "\u201d");
                continue;
            }
            List<String> optNameList = reasonIndOptListMap.get(indicatorId);
            if (!Objects.nonNull(optNameList) || optNameList.size() == 0) continue;
            if (HRStringUtils.equals((String)"C", (String)indicatorType)) {
                if (HRStringUtils.equals((String)resultObjectDTO.getIndicatorClassify(), (String)"2") || HRStringUtils.equals((String)indicatorResult, (String)"")) continue;
                BigDecimal indResBigDecimal = new BigDecimal(indicatorResult);
                String below = optNameList.get(0);
                BigDecimal belowBigDecimal = new BigDecimal(below);
                String high = optNameList.get(1);
                BigDecimal highBigDecimal = new BigDecimal(high);
                if (indResBigDecimal.compareTo(belowBigDecimal) >= 0 && indResBigDecimal.compareTo(highBigDecimal) <= 0 || !Objects.isNull(resultObjectDTO.getReason()) && !HRStringUtils.equals((String)"", (String)resultObjectDTO.getReason())) continue;
                tipIndicatorNameList.add("\u201c" + indicatorName + "\u201d");
                continue;
            }
            if (HRStringUtils.equals((String)"B", (String)indicatorType)) {
                String[] optStrS;
                for (String optStr : optStrS = indicatorResult.split(",")) {
                    if (!optNameList.contains(optStr) || !HRStringUtils.equals((String)"", (String)resultObjectDTO.getReason())) continue;
                    tipIndicatorNameList.add("\u201c" + indicatorName + "\u201d");
                    continue block13;
                }
                continue;
            }
            if (!optNameList.contains(indicatorResult) || !HRStringUtils.equals((String)"", (String)resultObjectDTO.getReason())) continue;
            tipIndicatorNameList.add("\u201c" + indicatorName + "\u201d");
        }
        return tipIndicatorNameList;
    }

    @Override
    public Map<String, List<String>> mulPerIndicatorMustFillValid(IFormView view, Map<Long, List<ResultObjectDTO>> evalObjResultObjListMap, DynamicObject content) {
        HashMap<String, List<String>> evalObjIndNameMap = new HashMap<String, List<String>>(16);
        for (Map.Entry<Long, List<ResultObjectDTO>> evalObjResObjEntryMap : evalObjResultObjListMap.entrySet()) {
            Long evalObjId = evalObjResObjEntryMap.getKey();
            Map evalObjFieldMap = (Map)SerializationUtils.deSerializeFromBase64((String)view.getPageCache().get("cache_evalobj"));
            List fieldList = (List)evalObjFieldMap.get(evalObjId);
            String evalObjName = (String)fieldList.get(0);
            List<ResultObjectDTO> resultObjectDTOList = evalObjResObjEntryMap.getValue();
            List<String> tipIndicatorNameList = this.tipIndicatorMust(resultObjectDTOList, content);
            if (tipIndicatorNameList.size() == 0) continue;
            evalObjIndNameMap.put(evalObjName, tipIndicatorNameList);
        }
        return evalObjIndNameMap;
    }

    @Override
    public List<Long> mustFillIndicatorId(DynamicObject content) {
        ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
        List<DynamicObject> indicatorEntryList = this.getIndicatorIdListByContent(content);
        for (DynamicObject indicatorEntry : indicatorEntryList) {
            Long indicatorId = indicatorEntry.getLong("id");
            boolean isRequired = indicatorEntry.getBoolean("isrequired");
            if (!isRequired) continue;
            indicatorIdList.add(indicatorId);
        }
        return indicatorIdList;
    }

    public List<Long> calScoreMustFillIndIds(DynamicObject content) {
        ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
        List<DynamicObject> indicatorEntryList = this.getIndicatorIdListByContent(content);
        for (DynamicObject indicatorEntry : indicatorEntryList) {
            Long indicatorId = indicatorEntry.getLong("id");
            long areaId = indicatorEntry.getLong("area");
            String areaName = content.getDynamicObjectCollection("areasubentry").stream().filter(area -> area.getLong("id") == areaId).findFirst().get().getString("areaname");
            boolean isRequired = indicatorEntry.getBoolean("isrequired");
            if (!isRequired || !HRStringUtils.equals((String)ResManager.loadKDString((String)"\u8bb0\u5206\u533a", (String)"EvalOnlineValidService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), (String)areaName)) continue;
            indicatorIdList.add(indicatorId);
        }
        return indicatorIdList;
    }

    @Override
    public String getIndicatorNameByContent(Long indicatorId, DynamicObject content) {
        List<DynamicObject> indicatorEntryList = this.getIndicatorIdListByContent(content);
        for (DynamicObject indicatorEntry : indicatorEntryList) {
            if (indicatorId.longValue() != indicatorEntry.getLong("id")) continue;
            return indicatorEntry.getString("indicatorname");
        }
        return "";
    }

    @Override
    public Map<Long, List<String>> mustFillIndicatorIdOptName(DynamicObject content) {
        HashMap<Long, List<String>> indicatorIdOptNameMap = new HashMap<Long, List<String>>(16);
        List<DynamicObject> indicatorEntryList = this.getIndicatorIdListByContent(content);
        for (DynamicObject indicatorEntry : indicatorEntryList) {
            String indicatorType = indicatorEntry.getString("indicatortype");
            Long indicatorId = indicatorEntry.getLong("id");
            boolean isResRequired = indicatorEntry.getBoolean("isresrequired");
            if (HRStringUtils.equals((String)"C", (String)indicatorType)) {
                if (!isResRequired) continue;
                ArrayList<String> scoreRange = new ArrayList<String>(2);
                BigDecimal needResScoreBelow = indicatorEntry.getBigDecimal("needresscorebelow");
                BigDecimal needResScoreHigh = indicatorEntry.getBigDecimal("needresscorehigh");
                BigDecimal miniMum = indicatorEntry.getBigDecimal("minimum");
                BigDecimal maxiMum = indicatorEntry.getBigDecimal("maximum");
                if (Objects.nonNull(needResScoreBelow)) {
                    scoreRange.add(needResScoreBelow.toString());
                } else if (Objects.nonNull(miniMum)) {
                    scoreRange.add(miniMum.toString());
                }
                if (Objects.nonNull(needResScoreHigh)) {
                    scoreRange.add(needResScoreHigh.toString());
                } else if (Objects.nonNull(maxiMum)) {
                    scoreRange.add(maxiMum.toString());
                }
                indicatorIdOptNameMap.put(indicatorId, scoreRange);
                continue;
            }
            if (!isResRequired) continue;
            ArrayList<String> isNeedOptName = new ArrayList<String>(10);
            Map<Long, List<DynamicObject>> evalIndOptionByContent = this.evalViewDomainService.getEvalIndOptionByContent(content);
            if (!Objects.nonNull(evalIndOptionByContent)) continue;
            List<DynamicObject> optEntryList = evalIndOptionByContent.get(indicatorId);
            for (DynamicObject optEntry : optEntryList) {
                boolean isNeedResOpt = optEntry.getBoolean("isneedresopt");
                if (!isNeedResOpt) continue;
                String optName = optEntry.getString("optsindicaseq");
                isNeedOptName.add(optName);
            }
            if (isNeedOptName.size() == 0) continue;
            indicatorIdOptNameMap.put(indicatorId, isNeedOptName);
        }
        return indicatorIdOptNameMap;
    }

    @Override
    public List<DynamicObject> getIndicatorIdListByContent(DynamicObject content) {
        List<Pair<String, List<DynamicObject>>> evalIndGroupByContent = this.evalViewDomainService.getEvalIndGroupByContent(content);
        ArrayList<DynamicObject> indicatorEntryList = new ArrayList<DynamicObject>(10);
        for (Pair<String, List<DynamicObject>> evalIndGroup : evalIndGroupByContent) {
            List evalIndList = (List)evalIndGroup.getValue();
            indicatorEntryList.addAll(evalIndList);
        }
        return indicatorEntryList;
    }

    @Override
    public List<Long> validEvalObjDel(LoginParamDTO loginParam, DynamicObject evalTask, DynamicObject content, String evaluatorEnum) {
        long evalTaskId = loginParam.getEvalTaskId();
        long contentId = loginParam.getEvalContentId();
        String evalObjString = "objinfoperentryid";
        String evalEdObjType = content.getString("evaledobjtype");
        if (HRStringUtils.equals((String)"20", (String)evalEdObjType)) {
            evalObjString = "objinfoorgentryid";
        }
        Long evaluatorId = loginParam.getEvaluatorId();
        QFilter evaluatorQFilter = null;
        String realOranOny = evalTask.getString("realorcryptonym");
        if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
            String evaluatorType = loginParam.getEvaluatorType();
            if (HRStringUtils.equals((String)evaluatorType, (String)"1")) {
                evaluatorQFilter = new QFilter("evalinternalper", "=", (Object)evaluatorId);
            } else if (HRStringUtils.equals((String)evaluatorType, (String)"2")) {
                evaluatorQFilter = new QFilter("evaloutsiderentryid", "=", (Object)evaluatorId);
            }
        } else if (HRStringUtils.equals((String)realOranOny, (String)"2")) {
            evaluatorQFilter = new QFilter("evaluatoranonentryid", "=", (Object)evaluatorId);
        }
        QFilter evalTaskQFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        QFilter contentIdQFilter = new QFilter("taskcontentid", "=", (Object)contentId);
        List<Object> subTaskEvalObjIdList = new ArrayList(10);
        if (!EvalViewConstants.GNETASKANONTYPE.contains(evaluatorEnum)) {
            DynamicObject[] evalSubTasks = BES_EVALSUBTASK.loadDynamicObjectArray(new QFilter[]{evalTaskQFilter, evaluatorQFilter, contentIdQFilter});
            String finalEvalObjString = evalObjString;
            if (evalSubTasks.length != 0) {
                subTaskEvalObjIdList = Arrays.stream(evalSubTasks).map(evalSubTask -> evalSubTask.getLong(finalEvalObjString)).collect(Collectors.toList());
            }
        } else {
            String taskObjEntryString = "objinfopersubentry";
            if (HRStringUtils.equals((String)"20", (String)evalEdObjType)) {
                taskObjEntryString = "objinfoorgsubentry";
            }
            subTaskEvalObjIdList = content.getDynamicObjectCollection(taskObjEntryString).stream().map(objDy -> objDy.getLong("id")).collect(Collectors.toList());
        }
        return subTaskEvalObjIdList;
    }

    @Override
    public String validEvaluatorDel(Long evalTaskId, Long contentId, LoginParamDTO loginParam, DynamicObject evalTask, String evaluatorEnum) {
        Long evaluatorId = loginParam.getEvaluatorId();
        QFilter evaluatorQFilter = null;
        String realOranOny = evalTask.getString("realorcryptonym");
        if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
            String evaluatorType = loginParam.getEvaluatorType();
            if (HRStringUtils.equals((String)evaluatorType, (String)"1")) {
                evaluatorQFilter = new QFilter("evalinternalper", "=", (Object)evaluatorId);
            } else if (HRStringUtils.equals((String)evaluatorType, (String)"2")) {
                evaluatorQFilter = new QFilter("evaloutsiderentryid", "=", (Object)evaluatorId);
            }
        } else if (HRStringUtils.equals((String)realOranOny, (String)"2")) {
            evaluatorQFilter = new QFilter("evaluatoranonentryid", "=", (Object)evaluatorId);
        }
        QFilter evalTaskQFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        QFilter contentIdQFilter = new QFilter("taskcontentid", "=", (Object)contentId);
        DynamicObject evalSubTask = BES_EVALSUBTASK.loadDynamicObject(new QFilter[]{evalTaskQFilter, evaluatorQFilter, contentIdQFilter});
        if (Objects.isNull(evalSubTask) && !EvalViewConstants.GNETASKANONTYPE.contains(evaluatorEnum)) {
            return ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u7684\u8bc4\u4ef7\u4efb\u52a1\u5df2\u5931\u6548\u3002", (String)"EvalOnlineValidServiceImpl_0", (String)"hrmp-bes-business", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public String overEvaluatorMaxLimit(IFormView view, LoginParamDTO loginParam, Long evalObjEntryId, DynamicObject evalTask, DynamicObject content, String evaluatorEnum) {
        long evalTaskId = loginParam.getEvalTaskId();
        long contentId = loginParam.getEvalContentId();
        QFilter evalTaskFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)contentId);
        QFilter taskStatusFilter = new QFilter("taskstatus", "=", (Object)"C").or(new QFilter("taskstatus", "=", (Object)"D"));
        QFilter evalObjFilter = null;
        String evalEdObjType = content.getString("evaledobjtype");
        if ("10".equals(evalEdObjType)) {
            evalObjFilter = new QFilter("objinfoperentryid", "=", (Object)evalObjEntryId);
        } else if ("20".equals(evalEdObjType)) {
            evalObjFilter = new QFilter("objinfoorgentryid", "=", (Object)evalObjEntryId);
        }
        if (EvalViewConstants.GNETASKANONTYPE.contains(evaluatorEnum)) {
            int evaluatorNumMax = 0;
            if (HRStringUtils.equals((String)evaluatorEnum, (String)"7")) {
                String evalBody = loginParam.getEvalBody();
                assert (evalObjFilter != null);
                evalObjFilter.and(new QFilter("evalbodynameanon", "=", (Object)evalBody));
                DynamicObjectCollection evaluatorAnonSubEntry = content.getDynamicObjectCollection("evaluatoranonsubentry");
                for (DynamicObject evaluatorAnon : evaluatorAnonSubEntry) {
                    String evalBodyNameAnon = evaluatorAnon.getString("evalbodynameanon");
                    if (!HRStringUtils.equals((String)evalBodyNameAnon, (String)evalBody)) continue;
                    evaluatorNumMax = evaluatorAnon.getInt("participantnumber");
                }
            } else {
                evaluatorNumMax = content.getInt("evaluatornummax");
            }
            String responseMode = evalTask.getString("responsemode");
            int count = BES_EVALSUBTASK.count("bes_evalsubtask", new QFilter[]{evalTaskFilter, contentFilter, taskStatusFilter, evalObjFilter});
            Map evalObjFieldMap = (Map)SerializationUtils.deSerializeFromBase64((String)view.getPageCache().get("cache_evalobj"));
            List fieldList = (List)evalObjFieldMap.get(evalObjEntryId);
            String evalObjName = "\"" + (String)fieldList.get(0) + "\"";
            if (evaluatorNumMax == 0) {
                return "";
            }
            if (evaluatorNumMax == count) {
                if (HRStringUtils.equals((String)"1", (String)responseMode) && !EvalViewConstants.GNETASKANONTYPE.contains(evaluatorEnum)) {
                    return String.format(ResManager.loadKDString((String)"\u62b1\u6b49\uff0c%s\u7684\u8bc4\u4ef7\u8005\u4eba\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"EvalOnlineValidServiceImpl_4", (String)"hrmp-bes-business", (Object[])new Object[0]), evalObjName);
                }
                return ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u8bc4\u4ef7\u8005\u4eba\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u4e0d\u53ef\u518d\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"EvalOnlineValidServiceImpl_3", (String)"hrmp-bes-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    public String mutuallyRepeat(LoginParamDTO loginParam, List<Long> evalObjList, DynamicObject evalTask, DynamicObject content, String evaluatorEnum) {
        String subTaskFinishTipString = "";
        long evalTaskId = loginParam.getEvalTaskId();
        long contentId = loginParam.getEvalContentId();
        QFilter evalTaskFilter = new QFilter("evaltask", "=", (Object)evalTaskId);
        QFilter contentFilter = new QFilter("taskcontentid", "=", (Object)contentId);
        QFilter evalObjFilter = null;
        Long evaluatorId = loginParam.getEvaluatorId();
        QFilter evaluatorQFilter = null;
        String realOranOny = evalTask.getString("realorcryptonym");
        if (EvalViewConstants.GNETASKANONTYPE.contains(evaluatorEnum)) {
            return "";
        }
        String responseMode = evalTask.getString("responsemode");
        if (HRStringUtils.equals((String)"2", (String)responseMode)) {
            subTaskFinishTipString = ResManager.loadKDString((String)"\u5f53\u524d\u8bc4\u4ef7\u5df2\u88ab\u5b8c\u6210\uff0c\u5173\u95ed\u5f39\u7a97\u6216\u5237\u65b0\u754c\u9762\u53ef\u67e5\u770b\u5df2\u6709\u7ed3\u679c\u3002", (String)"EvalOnlineValidServiceImpl_2", (String)"hrmp-bes-business", (Object[])new Object[0]);
        }
        if (HRStringUtils.equals((String)realOranOny, (String)"1")) {
            String evaluatorType = loginParam.getEvaluatorType();
            if (HRStringUtils.equals((String)evaluatorType, (String)"1")) {
                evaluatorQFilter = new QFilter("evalinternalper", "=", (Object)evaluatorId);
            } else if (HRStringUtils.equals((String)evaluatorType, (String)"2")) {
                evaluatorQFilter = new QFilter("evaloutsiderentryid", "=", (Object)evaluatorId);
            }
        } else if (HRStringUtils.equals((String)realOranOny, (String)"2")) {
            evaluatorQFilter = new QFilter("evaluatoranonentryid", "=", (Object)evaluatorId);
            if (HRStringUtils.equals((String)evaluatorEnum, (String)"2")) {
                evaluatorQFilter = new QFilter("evalbodynameanon", "=", (Object)loginParam.getEvalBody());
            }
        }
        String evalEdObjType = content.getString("evaledobjtype");
        if ("10".equals(evalEdObjType)) {
            evalObjFilter = new QFilter("objinfoperentryid", "in", evalObjList);
        } else if ("20".equals(evalEdObjType)) {
            evalObjFilter = new QFilter("objinfoorgentryid", "in", evalObjList);
        }
        if (HRStringUtils.equals((String)"1", (String)responseMode)) {
            QFilter taskStatusFilter = new QFilter("taskstatus", "in", (Object)new String[]{"C", "D"});
            boolean exists = BES_EVALSUBTASK.isExists(new QFilter[]{evalTaskFilter, contentFilter, evaluatorQFilter, evalObjFilter, taskStatusFilter});
            if (exists) {
                subTaskFinishTipString = ResManager.loadKDString((String)"\u5f53\u524d\u88ab\u6d4b\u8bc4\u5bf9\u8c61\u7684\u8bc4\u4ef7\u5df2\u88ab\u5b8c\u6210\uff0c\u5173\u95ed\u5f39\u7a97\u6216\u5237\u65b0\u754c\u9762\u53ef\u67e5\u770b\u5df2\u6709\u7ed3\u679c\u3002", (String)"EvalOnlineValidServiceImpl_1", (String)"hrmp-bes-business", (Object[])new Object[0]);
            }
        } else {
            QFilter taskStatusFilter = new QFilter("taskstatus", "not in", (Object)new String[]{"C", "D"});
            boolean exists = BES_EVALSUBTASK.isExists(new QFilter[]{evalTaskFilter, contentFilter, evaluatorQFilter, evalObjFilter, taskStatusFilter});
            if (exists) {
                subTaskFinishTipString = "";
            }
        }
        return subTaskFinishTipString;
    }
}

