/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evaltask;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.evalsubtask.EvalTaskSetObHelper;
import kd.hrmp.bes.business.domain.evaltask.ParamTransferException;
import kd.hrmp.bes.common.dto.evalrel.AdjustEvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.DeleteEvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.EvalBodyInfo;
import kd.hrmp.bes.common.dto.evalrel.EvalObjectDto;
import kd.hrmp.bes.common.dto.evalrel.EvalObjectInfo;
import kd.hrmp.bes.common.dto.evalrel.EvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.EvaluatorDto;
import kd.hrmp.bes.common.dto.evalrel.EvaluatorInfo;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EvalRelationConvert {
    private static final Log LOG = LogFactory.getLog(EvalRelationConvert.class);

    public static List<AdjustEvalRelationDto> convertAdjustMapToDto(Map<String, Object> param) {
        if (CollectionUtils.isEmpty(param)) {
            return Collections.emptyList();
        }
        return EvalRelationConvert.convertAdjustMapToDto(Collections.singletonList(param));
    }

    public static List<AdjustEvalRelationDto> convertAdjustMapToDto(List<Map<String, Object>> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        ArrayList<AdjustEvalRelationDto> adjustEvalRelationDtoList = new ArrayList<AdjustEvalRelationDto>(paramList.size());
        try {
            for (Map<String, Object> param : paramList) {
                AdjustEvalRelationDto adjustEvalRelationDto = new AdjustEvalRelationDto();
                adjustEvalRelationDtoList.add(adjustEvalRelationDto);
                adjustEvalRelationDto.setEvalTaskId(EvalRelationConvert.getLong(param, "evalTaskId"));
                adjustEvalRelationDto.setEvalContentId(EvalRelationConvert.getLong(param, "evalContentId"));
                adjustEvalRelationDto.setNeedEvalBody(EvalRelationConvert.getBoolean(param, "needEvalBody"));
                Boolean needSendMsg = EvalRelationConvert.getBoolean(param, "needSendMsg");
                adjustEvalRelationDto.setNeedSendMsg(needSendMsg);
                if (needSendMsg != null && needSendMsg.booleanValue()) {
                    adjustEvalRelationDto.setSendMsgAppNumber(EvalRelationConvert.getString(param, "sendMsgAppNumber"));
                    adjustEvalRelationDto.setMsgFieldConfig((Map)param.get("msgFieldConfig"));
                }
                List paramBodyInfoList = (List)param.get("evalBodyInfoList");
                List<EvalBodyInfo> evalBodyInfoList = EvalRelationConvert.convertBodyInfoMapToDto(paramBodyInfoList);
                adjustEvalRelationDto.setEvalBodyInfoList(evalBodyInfoList);
                List paramEvalObjectList = (List)param.get("evalObjectList");
                Objects.requireNonNull(paramEvalObjectList);
                List<EvalObjectDto> evalObjectDtoList = EvalRelationConvert.convertEvalObjMapToDto(paramEvalObjectList);
                adjustEvalRelationDto.setEvalObjectDtoList(evalObjectDtoList);
                List evaluatorList = (List)param.get("evaluatorList");
                Objects.requireNonNull(evaluatorList);
                List<EvaluatorDto> evaluatorDtoList = EvalRelationConvert.convertEvaluatorMapToDto(evaluatorList);
                adjustEvalRelationDto.setEvaluatorDtoList(evaluatorDtoList);
                List evalRelationList = (List)param.get("evalRelationList");
                Objects.requireNonNull(evalRelationList);
                ArrayList<EvalRelationDto> evalRelationDtoList = new ArrayList<EvalRelationDto>(10);
                adjustEvalRelationDto.setEvalRelationDtoList(evalRelationDtoList);
                for (EvalObjectDto evalObjectDto : evalObjectDtoList) {
                    if (CollectionUtils.isEmpty(evalBodyInfoList)) {
                        EvalRelationDto evalRelationDto = EvalRelationConvert.initEvalRelationDto(evalObjectDto, null);
                        evalRelationDtoList.add(evalRelationDto);
                        EvalRelationConvert.makeUpEvaluators(evalRelationDto, evaluatorDtoList, evalRelationList);
                        continue;
                    }
                    for (EvalBodyInfo evalBodyInfo : evalBodyInfoList) {
                        EvalRelationDto evalRelationDto = EvalRelationConvert.initEvalRelationDto(evalObjectDto, evalBodyInfo);
                        evalRelationDtoList.add(evalRelationDto);
                        EvalRelationConvert.makeUpEvaluators(evalRelationDto, evaluatorDtoList, evalRelationList);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOG.error("EvalRelationConvert.convertAdjustMapToDto error: ", (Throwable)exception);
            throw new ParamTransferException(exception.getMessage(), exception);
        }
        return adjustEvalRelationDtoList;
    }

    public static Pair<Boolean, String> checkAdjustEvalRelationDtoParam(AdjustEvalRelationDto adjustEvalRelationDto) {
        ArrayList<String> failParamList = new ArrayList<String>(10);
        ErrorParamRecord errorParamRecord = new ErrorParamRecord(failParamList);
        return EvalRelationConvert.checkAdjustEvalRelationDtoParam(adjustEvalRelationDto, errorParamRecord);
    }

    private static Pair<Boolean, String> checkAdjustEvalRelationDtoParam(AdjustEvalRelationDto dto, ErrorParamRecord errorRecord) {
        errorRecord.doVerify("evalTaskId", () -> Objects.isNull(dto.getEvalTaskId()) || dto.getEvalTaskId() == 0L);
        errorRecord.doVerify("evalContentId", () -> Objects.isNull(dto.getEvalContentId()) || dto.getEvalContentId() == 0L);
        errorRecord.doVerify("needSendMsg", () -> Objects.isNull(dto.getNeedSendMsg()));
        errorRecord.doVerifyWithPreVerify(Objects.nonNull(dto.getNeedSendMsg()) && dto.getNeedSendMsg() != false, "sendMsgAppNumber", () -> HRStringUtils.isEmpty((String)dto.getSendMsgAppNumber()));
        errorRecord.doVerifyWithPreVerify(Objects.nonNull(dto.getNeedSendMsg()) && dto.getNeedSendMsg() != false, "msgFieldConfig", () -> Objects.isNull(dto.getNeedSendMsg()) && !CollectionUtils.isEmpty((Map)dto.getMsgFieldConfig()));
        errorRecord.doVerify("needEvalBody", () -> Objects.isNull(dto.getNeedEvalBody()));
        errorRecord.doVerifyWithPreVerify(Objects.nonNull(dto.getNeedEvalBody()), "evalBodyInfoList", () -> Objects.nonNull(dto.getNeedEvalBody()) && !CollectionUtils.isEmpty((Collection)dto.getEvalBodyInfoList()));
        if (dto.getNeedEvalBody() != null && dto.getNeedEvalBody().booleanValue()) {
            List evalBodyInfoList = dto.getEvalBodyInfoList();
            for (EvalBodyInfo evalBodyInfo : evalBodyInfoList) {
                errorRecord.doVerify("evalBodyId", () -> Objects.isNull(evalBodyInfo.getEvalBodyId()) || evalBodyInfo.getEvalBodyId() == 0L);
                errorRecord.doVerify("weight", () -> Objects.isNull(evalBodyInfo.getWeight()) || evalBodyInfo.getWeight() == 0);
            }
        }
        EvalRelationConvert.doCheckEvalObjDtoParam(errorRecord, dto.getEvalObjectDtoList());
        EvalRelationConvert.doCheckEvaluatorDtoParam(errorRecord, dto.getEvaluatorDtoList());
        errorRecord.doVerify("evalRelationDtoList", () -> CollectionUtils.isEmpty((Collection)dto.getEvalRelationDtoList()));
        return Pair.of((Object)errorRecord.success, (Object)Joiner.on((char)',').skipNulls().join(errorRecord.paramList));
    }

    public static Map<Long, Pair<Boolean, String>> checkAdjustEvalRelationDtoParam(List<AdjustEvalRelationDto> adjustEvalRelationDtos) {
        ArrayList<String> failParamList = new ArrayList<String>(10);
        HashMap result = Maps.newHashMapWithExpectedSize((int)adjustEvalRelationDtos.size());
        ErrorParamRecord errorRecord = new ErrorParamRecord(failParamList);
        for (AdjustEvalRelationDto dto : adjustEvalRelationDtos) {
            Pair<Boolean, String> pair = EvalRelationConvert.checkAdjustEvalRelationDtoParam(dto, errorRecord);
            if (((Boolean)pair.getLeft()).booleanValue()) continue;
            result.put(dto.getEvalContentId(), pair);
            failParamList.clear();
        }
        LOG.info("EvalRelationConvert.checkParam result:{}", (Object)result);
        return result;
    }

    private static void doCheckEvaluatorDtoParam(ErrorParamRecord errorRecord, List<EvaluatorDto> evaluatorDtoList) {
        if (!CollectionUtils.isEmpty(evaluatorDtoList)) {
            errorRecord.doVerify("evaluatorDtoList", () -> CollectionUtils.isEmpty((Collection)evaluatorDtoList));
            for (EvaluatorDto evaluatorDto : evaluatorDtoList) {
                errorRecord.doVerify("evaluatorType", () -> !HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"1") && !HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2"));
                errorRecord.doVerify("evaluatorId", () -> Objects.isNull(evaluatorDto.getEvaluatorId()) || evaluatorDto.getEvaluatorId() == 0L);
                EvaluatorInfo evaluatorInfo = evaluatorDto.getEvaluatorInfo();
                errorRecord.doVerifyWithPreVerify(HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2"), "evaluatorDtoList.name", () -> EvalRelationConvert.isNullLocaleString(evaluatorInfo.getName()));
                errorRecord.doVerifyWithPreVerify(HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2"), "evaluatorDtoList.phone", () -> HRStringUtils.isEmpty((String)evaluatorInfo.getPhone()));
                errorRecord.doVerifyWithPreVerify(HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2"), "evaluatorDtoList.company", () -> EvalRelationConvert.isNullLocaleString(evaluatorInfo.getCompany()));
            }
            AtomicBoolean result = new AtomicBoolean(true);
            evaluatorDtoList.stream().collect(Collectors.groupingBy(EvaluatorDto::getEvaluatorId)).forEach((evalObjId, dtoList) -> {
                if (dtoList.size() > 1) {
                    result.set(false);
                }
            });
            if (!result.get()) {
                errorRecord.doVerify("evaluatorDtoList", () -> true, " evalObjId repeat");
            }
        }
    }

    public static Pair<Boolean, String> checkEvalObjectDtoParam(List<EvalObjectDto> evalObjectDtoList) {
        ArrayList<String> failParamList = new ArrayList<String>(10);
        ErrorParamRecord errorParamRecord = new ErrorParamRecord(failParamList);
        EvalRelationConvert.doCheckEvalObjDtoParam(errorParamRecord, evalObjectDtoList);
        if (CollectionUtils.isEmpty(failParamList)) {
            return Pair.of((Object)Boolean.TRUE, (Object)"");
        }
        return Pair.of((Object)Boolean.FALSE, (Object)Joiner.on((char)',').skipNulls().join(failParamList));
    }

    private static void doCheckEvalObjDtoParam(ErrorParamRecord record, List<EvalObjectDto> evalObjectDtoList) {
        record.doVerify("evalObjectList", () -> CollectionUtils.isEmpty((Collection)evalObjectDtoList));
        if (!CollectionUtils.isEmpty(evalObjectDtoList)) {
            for (EvalObjectDto dto : evalObjectDtoList) {
                record.doVerify("evalObjType", () -> !HRStringUtils.equals((String)dto.getEvalObjType(), (String)"1") && !HRStringUtils.equals((String)dto.getEvalObjType(), (String)"2"));
                record.doVerify("evalObjId", () -> Objects.isNull(dto.getEvalObjId()) || dto.getEvalObjId() == 0L);
                record.doVerifyWithPreVerify(HRStringUtils.equals((String)dto.getEvalObjType(), (String)"1"), "depEmpFid", () -> Objects.isNull(dto.getDepEmpFid()) || dto.getDepEmpFid() == 0L);
                EvalObjectInfo evalObjInfo = dto.getEvalObjectInfo();
                record.doVerify("evalObjectList.name", () -> EvalRelationConvert.isNullLocaleString(evalObjInfo.getName()));
                record.doVerify("evalObjectList.phone", () -> HRStringUtils.isEmpty((String)evalObjInfo.getPhone()));
                record.doVerify("evalObjectList.company", () -> EvalRelationConvert.isNullLocaleString(evalObjInfo.getCompany()));
            }
            AtomicBoolean result = new AtomicBoolean(true);
            evalObjectDtoList.stream().collect(Collectors.groupingBy(EvalObjectDto::getEvalObjId)).forEach((evalObjId, dtoList) -> {
                if (dtoList.size() > 1) {
                    result.set(false);
                }
            });
            if (!result.get()) {
                record.doVerify("evalObjectList", () -> true, " evalObjId repeat");
            }
        }
    }

    private static boolean isNullLocaleString(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            return CollectionUtils.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof String) {
            return HRStringUtils.isEmpty((String)String.valueOf(obj));
        }
        return false;
    }

    private static List<EvaluatorDto> convertEvaluatorMapToDto(List<Map<String, Object>> evaluatorList) {
        ArrayList<EvaluatorDto> evaluatorDtoList = new ArrayList<EvaluatorDto>(evaluatorList.size());
        evaluatorList.stream().filter(paramEvaluator -> HRStringUtils.equals((String)EvalRelationConvert.getString(paramEvaluator, "evaluatorType"), (String)"1")).forEach(paramEvaluator -> {
            Long employeeId = EvalRelationConvert.getLong(paramEvaluator, "employeeId");
            EvaluatorDto evaluatorDto = new EvaluatorDto();
            evaluatorDtoList.add(evaluatorDto);
            evaluatorDto.setEvaluatorId(employeeId);
            evaluatorDto.setEvaluatorType("1");
            evaluatorDto.setEvaluatorOpType(EvalRelationConvert.getString(paramEvaluator, "evaluatorOpType"));
        });
        evaluatorList.stream().filter(paramEvaluator -> HRStringUtils.equals((String)EvalRelationConvert.getString(paramEvaluator, "evaluatorType"), (String)"2")).forEach(paramEvaluator -> {
            EvaluatorDto evaluatorDto = new EvaluatorDto();
            evaluatorDtoList.add(evaluatorDto);
            evaluatorDto.setEvaluatorType("2");
            evaluatorDto.setEvaluatorId(EvalRelationConvert.getLong(paramEvaluator, "outEvaluatorId"));
            EvaluatorInfo evaluatorInfo = new EvaluatorInfo();
            evaluatorDto.setEvaluatorInfo(evaluatorInfo);
            evaluatorInfo.setId(EvalRelationConvert.getLong(paramEvaluator, "outEvaluatorId"));
            evaluatorInfo.setName(paramEvaluator.get("name"));
            evaluatorInfo.setPhone(EvalRelationConvert.getString(paramEvaluator, "phone"));
            evaluatorInfo.setEmail(EvalRelationConvert.getString(paramEvaluator, "email"));
            evaluatorInfo.setCompany(paramEvaluator.get("company"));
            evaluatorInfo.setDepartment(paramEvaluator.get("department"));
            evaluatorInfo.setPosition(paramEvaluator.get("position"));
            evaluatorInfo.setStdPosition(paramEvaluator.get("stdPosition"));
            evaluatorInfo.setJob(paramEvaluator.get("job"));
            evaluatorDto.setEvaluatorOpType(EvalRelationConvert.getString(paramEvaluator, "evaluatorOpType"));
        });
        return evaluatorDtoList;
    }

    public static List<EvalBodyInfo> convertBodyInfoMapToDto(List<Map<String, Object>> paramBodyInfoList) {
        ArrayList<EvalBodyInfo> evalBodyInfoList = null;
        if (!CollectionUtils.isEmpty(paramBodyInfoList)) {
            evalBodyInfoList = new ArrayList<EvalBodyInfo>(paramBodyInfoList.size());
            for (Map<String, Object> paramBodyInfo : paramBodyInfoList) {
                EvalBodyInfo evalBodyInfo = new EvalBodyInfo();
                evalBodyInfoList.add(evalBodyInfo);
                evalBodyInfo.setEvalBodyId(EvalRelationConvert.getLong(paramBodyInfo, "evalBodyId"));
                evalBodyInfo.setWeight(EvalRelationConvert.getInteger(paramBodyInfo, "weight"));
                evalBodyInfo.setDescription(paramBodyInfo.get("description"));
            }
        }
        return evalBodyInfoList;
    }

    public static List<EvalObjectDto> convertEvalObjMapToDto(List<Map<String, Object>> paramEvalObjectList) {
        ArrayList<EvalObjectDto> evalObjectDtoList = new ArrayList<EvalObjectDto>(paramEvalObjectList.size());
        List<Long> depEmpIdList = paramEvalObjectList.stream().filter(paramEvalObj -> HRStringUtils.equals((String)EvalRelationConvert.getString(paramEvalObj, "evalObjType"), (String)"1")).map(paramEvalObj -> EvalRelationConvert.getLong(paramEvalObj, "depempId")).collect(Collectors.toList());
        List<InEvalObjData> inEvalObjDataList = InEvalObjData.genInEvalObjData(depEmpIdList);
        int seq = 0;
        long[] entryRowIdArr = ID.genLongIds((int)paramEvalObjectList.size());
        for (Map<String, Object> paramEvalObj2 : paramEvalObjectList) {
            long evalObjEntryRowId = entryRowIdArr[seq];
            String evalObjType = EvalRelationConvert.getString(paramEvalObj2, "evalObjType");
            if (HRStringUtils.equals((String)evalObjType, (String)"1")) {
                Long depEmpId = EvalRelationConvert.getLong(paramEvalObj2, "depempId");
                int finalSeq = seq;
                inEvalObjDataList.stream().filter(data -> Objects.equals(data.depEmpId, depEmpId)).findFirst().ifPresent(inEvalObjData -> {
                    DynamicObject perContactDO;
                    Map<String, Object> personMap;
                    EvalObjectDto evalObjectDto = new EvalObjectDto();
                    evalObjectDtoList.add(evalObjectDto);
                    evalObjectDto.setDepEmpFid(Long.valueOf(Long.parseLong(String.valueOf(inEvalObjData.depEmpVid))));
                    evalObjectDto.setEvalObjEntryRowId(Long.valueOf(evalObjEntryRowId));
                    evalObjectDto.setEvalObjId(depEmpId);
                    evalObjectDto.setEvalObjType("1");
                    evalObjectDto.setSeq(finalSeq);
                    EvalObjectInfo evalObjectInfo = new EvalObjectInfo();
                    evalObjectDto.setEvalObjectInfo(evalObjectInfo);
                    evalObjectInfo.setId(depEmpId);
                    if (inEvalObjData.empPosOrgDO != null) {
                        evalObjectInfo.setCompany(inEvalObjData.empPosOrgDO.get("company.name"));
                        evalObjectInfo.setDepartment(inEvalObjData.empPosOrgDO.get("adminorg.name"));
                        evalObjectInfo.setPosition(inEvalObjData.empPosOrgDO.get("position.name"));
                        evalObjectInfo.setStdPosition(inEvalObjData.empPosOrgDO.get("stdposition.name"));
                        evalObjectInfo.setJob(inEvalObjData.empPosOrgDO.get("job.name"));
                    }
                    if (!CollectionUtils.isEmpty(personMap = inEvalObjData.personInfo)) {
                        evalObjectInfo.setName(personMap.get("name"));
                        evalObjectInfo.setHeadPicture(EvalRelationConvert.getString(personMap, "headsculpture"));
                        evalObjectInfo.setNumber(EvalRelationConvert.getString(personMap, "number"));
                        evalObjectInfo.setGender(EvalRelationConvert.getString(personMap, "gender"));
                        evalObjectInfo.setAge(EvalRelationConvert.getString(personMap, "age"));
                        try {
                            String birthdayStr = EvalRelationConvert.getString(personMap, "birthday");
                            if (HRStringUtils.isNotEmpty((String)birthdayStr)) {
                                evalObjectInfo.setBirthday(HRDateTimeUtils.parseDate((String)birthdayStr));
                            }
                        }
                        catch (ParseException exception) {
                            LOG.warn("EvalRelationConvert.convertEvalObjMapToDto setBirthday error:", (Throwable)exception);
                        }
                    }
                    if ((perContactDO = inEvalObjData.contactInfo) != null) {
                        evalObjectInfo.setPhone(perContactDO.getString("phone"));
                        evalObjectInfo.setEmail(perContactDO.getString("busemail"));
                    }
                    evalObjectInfo.setCadreCategory(inEvalObjData.appRemRelInfo);
                });
            }
            if (HRStringUtils.equals((String)evalObjType, (String)"2")) {
                EvalObjectDto evalObjectDto = new EvalObjectDto();
                evalObjectDtoList.add(evalObjectDto);
                Long outEvalObjId = EvalRelationConvert.getLong(paramEvalObj2, "outEvalObjId");
                evalObjectDto.setEvalObjId(outEvalObjId);
                evalObjectDto.setEvalObjType("2");
                evalObjectDto.setEvalObjEntryRowId(Long.valueOf(evalObjEntryRowId));
                evalObjectDto.setSeq(seq);
                EvalObjectInfo evalObjectInfo = new EvalObjectInfo();
                evalObjectDto.setEvalObjectInfo(evalObjectInfo);
                evalObjectInfo.setId(outEvalObjId);
                evalObjectInfo.setName(paramEvalObj2.get("name"));
                evalObjectInfo.setPhone(EvalRelationConvert.getString(paramEvalObj2, "phone"));
                evalObjectInfo.setEmail(EvalRelationConvert.getString(paramEvalObj2, "email"));
                evalObjectInfo.setCompany(paramEvalObj2.get("company"));
                evalObjectInfo.setDepartment(paramEvalObj2.get("department"));
                evalObjectInfo.setStdPosition(paramEvalObj2.get("stdPosition"));
                evalObjectInfo.setPosition(paramEvalObj2.get("position"));
                evalObjectInfo.setJob(paramEvalObj2.get("job"));
            }
            ++seq;
        }
        return evalObjectDtoList;
    }

    private static EvalRelationDto initEvalRelationDto(EvalObjectDto evalObjectDto, EvalBodyInfo evalBodyInfo) {
        EvalRelationDto evalRelationDto = new EvalRelationDto();
        evalRelationDto.setEvalObjectDto(evalObjectDto);
        if (evalBodyInfo != null) {
            evalRelationDto.setEvalBodyId(evalBodyInfo.getEvalBodyId());
        }
        return evalRelationDto;
    }

    private static void makeUpEvaluators(EvalRelationDto evalRelationDto, List<EvaluatorDto> evaluatorDtoList, List<Map<String, Object>> evalRelationList) {
        Long evalBodyId = evalRelationDto.getEvalBodyId();
        if (evalBodyId == null) {
            evalBodyId = Long.valueOf("0");
        }
        Long evalObjId = evalRelationDto.getEvalObjectDto().getEvalObjId();
        String evalObjType = evalRelationDto.getEvalObjectDto().getEvalObjType();
        Long finalEvalBodyId = evalBodyId;
        evalRelationList.stream().filter(param -> Objects.equals(finalEvalBodyId, EvalRelationConvert.getLong(param, "evalBodyId")) && Objects.equals(evalObjId, EvalRelationConvert.getLong(param, "evalObjectId")) && HRStringUtils.equals((String)evalObjType, (String)EvalRelationConvert.getString(param, "evalObjectType"))).findFirst().ifPresent(param -> {
            Object evaluatorListObj = param.get("evaluatorList");
            if (evaluatorListObj != null) {
                List evaluatorList = (List)evaluatorListObj;
                evalRelationDto.setEvaluatorDtoList(evaluatorDtoList.stream().filter(dto -> {
                    for (Map evaluatorMap : evaluatorList) {
                        Long evaluatorId = EvalRelationConvert.getLong(evaluatorMap, "evaluatorId");
                        String evaluatorType = EvalRelationConvert.getString(evaluatorMap, "evaluatorType");
                        if (!Objects.equals(evaluatorId, dto.getEvaluatorId()) || !HRStringUtils.equals((String)evaluatorType, (String)dto.getEvaluatorType())) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList()));
            }
        });
    }

    public static String getString(Map<String, Object> param, String key) {
        return String.valueOf(param.getOrDefault(key, ""));
    }

    public static Long getLong(Map<String, Object> param, String key) {
        return Long.parseLong(String.valueOf(param.getOrDefault(key, 0)));
    }

    private static Boolean getBoolean(Map<String, Object> param, String key) {
        if (param.get(key) == null) {
            return null;
        }
        return Boolean.parseBoolean(String.valueOf(param.get(key)));
    }

    private static Integer getInteger(Map<String, Object> param, String key) {
        return Integer.valueOf(String.valueOf(param.getOrDefault(key, 0)));
    }

    private static Map<Long, DynamicObject> getPerContact(List<Long> personIds) {
        return EvalTaskSetObHelper.getPerContact(personIds);
    }

    private static Map<Long, Map<String, Object>> getPersonInfos(List<Long> personIds) {
        return EvalTaskSetObHelper.getPersonInfos(personIds);
    }

    private static List<DynamicObject> getEmpposorgrelsByDepId(List<Long> depempIds) {
        return EvalTaskSetObHelper.getEmpposorgrelsByDepId(depempIds);
    }

    private static Map<Long, Object> getAppointRemoveRelDyn(List<Long> empposrelIds) {
        return EvalTaskSetObHelper.getAppointRemoveRelDyn(empposrelIds);
    }

    public static List<DeleteEvalRelationDto> convertDeleteMapToDto(List<Map<String, Object>> paramList) {
        List<DeleteEvalRelationDto> deleteEvalRelationDtoList;
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        LOG.info("EvalRelationConvert.convertDeleteMapToDto param:{}", paramList);
        try {
            deleteEvalRelationDtoList = paramList.stream().map(param -> {
                List outerEvaluatorInfoList;
                DeleteEvalRelationDto deleteEvalRelationDto = new DeleteEvalRelationDto();
                deleteEvalRelationDto.setDeleteType(String.valueOf(param.get("deleteType")));
                deleteEvalRelationDto.setEvalContentId(EvalRelationConvert.getLong(param, "evalContentId"));
                deleteEvalRelationDto.setEvalTaskId(EvalRelationConvert.getLong(param, "evalTaskId"));
                deleteEvalRelationDto.setBusinessId(EvalRelationConvert.getLong(param, "businessId"));
                deleteEvalRelationDto.setBusinessType(EvalRelationConvert.getString(param, "businessType"));
                deleteEvalRelationDto.setBusinessName(String.valueOf(param.get("businessName")));
                List innerEvaluatorInfoList = (List)param.get("innerEvaluatorInfoList");
                if (!CollectionUtils.isEmpty((Collection)innerEvaluatorInfoList)) {
                    innerEvaluatorInfoList = innerEvaluatorInfoList.stream().filter(info -> HRStringUtils.isNotEmpty((String)EvalRelationConvert.getString(info, "id"))).collect(Collectors.toList());
                    deleteEvalRelationDto.setInnerEvaluatorInfoList(innerEvaluatorInfoList);
                }
                if (!CollectionUtils.isEmpty((Collection)(outerEvaluatorInfoList = (List)param.get("outerEvaluatorInfoList")))) {
                    outerEvaluatorInfoList = outerEvaluatorInfoList.stream().filter(info -> HRStringUtils.isNotEmpty((String)EvalRelationConvert.getString(info, "id"))).collect(Collectors.toList());
                    deleteEvalRelationDto.setOuterEvaluatorInfoList(outerEvaluatorInfoList);
                }
                return deleteEvalRelationDto;
            }).collect(Collectors.toList());
        }
        catch (Exception exception) {
            LOG.error("EvalRelationConvert.convertDeleteMapToDto error: ", (Throwable)exception);
            throw new ParamTransferException(exception.getMessage(), exception);
        }
        LOG.info("EvalRelationConvert.convertDeleteMapToDto result:{}", deleteEvalRelationDtoList);
        return deleteEvalRelationDtoList;
    }

    public static Map<String, Object> convertDeleteDtoToMap(DeleteEvalRelationDto dto, boolean success, String errorMsg) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)9);
        result.put("success", success);
        result.put("message", errorMsg);
        result.put("evalTaskId", dto.getEvalTaskId());
        result.put("evalContentId", dto.getEvalContentId());
        result.put("deleteType", dto.getDeleteType());
        result.put("businessId", dto.getBusinessId());
        result.put("businessName", dto.getBusinessName());
        result.put("businessType", dto.getBusinessType());
        result.put("errorCode", dto.getErrorCode());
        return result;
    }

    public static Map<Long, Pair<Boolean, String>> checkDeleteDtoParam(List<DeleteEvalRelationDto> deleteEvalRelationDtoList) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)deleteEvalRelationDtoList.size());
        ArrayList<String> errorParamList = new ArrayList<String>(deleteEvalRelationDtoList.size());
        ErrorParamRecord record = new ErrorParamRecord(errorParamList);
        for (DeleteEvalRelationDto dto : deleteEvalRelationDtoList) {
            Long evalContentId = dto.getEvalContentId();
            record.doVerify("deleteType", () -> !HRStringUtils.equals((String)"1", (String)dto.getDeleteType()) && !HRStringUtils.equals((String)"2", (String)dto.getDeleteType()), " value error");
            record.doVerify("businessId", () -> Objects.isNull(dto.getBusinessId()) || dto.getBusinessId() == 0L);
            record.doVerify("businessType", () -> !HRStringUtils.equals((String)"1", (String)dto.getBusinessType()) && !HRStringUtils.equals((String)"2", (String)dto.getBusinessType()), " value error");
            record.doVerify("businessName", () -> HRStringUtils.isEmpty((String)dto.getBusinessName()));
            record.doVerify("evalTaskId", () -> Objects.isNull(dto.getEvalTaskId()) || dto.getEvalTaskId() == 0L);
            record.doVerify("evalContentId", () -> Objects.isNull(dto.getEvalContentId()) || dto.getEvalContentId() == 0L);
            if (!CollectionUtils.isEmpty(errorParamList)) {
                map.put(evalContentId, Pair.of((Object)Boolean.FALSE, (Object)Joiner.on((char)',').skipNulls().join(errorParamList)));
            }
            errorParamList.clear();
        }
        return map;
    }

    private static class ErrorParamRecord {
        List<String> paramList;
        boolean success = true;
        private static final String DEFAULT_ERROR = " not null";

        public ErrorParamRecord(List<String> paramList) {
            this.paramList = paramList;
        }

        public void doVerify(String field, Supplier<Boolean> supplier) {
            this.doVerify(field, supplier, DEFAULT_ERROR);
        }

        public void doVerify(String field, Supplier<Boolean> supplier, String errorMsg) {
            field = field + errorMsg;
            Boolean result = supplier.get();
            if (result.booleanValue()) {
                this.success = false;
                this.paramList.add(field);
            }
        }

        public void doVerifyWithPreVerify(boolean preVerifyResult, String field, Supplier<Boolean> supplier) {
            if (preVerifyResult) {
                this.doVerify(field, supplier);
            }
        }
    }

    private static class InEvalObjData {
        Long depEmpId;
        DynamicObject empPosOrgDO;
        Map<String, Object> personInfo;
        DynamicObject contactInfo;
        Object appRemRelInfo;
        Object depEmpVid;

        private InEvalObjData() {
        }

        public static List<InEvalObjData> genInEvalObjData(List<Long> depEmpIdList) {
            if (depEmpIdList == null) {
                depEmpIdList = Collections.emptyList();
            }
            List empPosOrgDOList = EvalRelationConvert.getEmpposorgrelsByDepId(depEmpIdList);
            List personIdList = empPosOrgDOList.stream().map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
            List empPosOrgIdList = empPosOrgDOList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Map personInfo = EvalRelationConvert.getPersonInfos(personIdList);
            Map contactInfo = EvalRelationConvert.getPerContact(personIdList);
            Map appRemRelInfo = EvalRelationConvert.getAppointRemoveRelDyn(empPosOrgIdList);
            Map<Long, Object> depEmpSourceVidMap = EvalTaskSetObHelper.getSourcevids(depEmpIdList);
            ArrayList<InEvalObjData> dataList = new ArrayList<InEvalObjData>(depEmpIdList.size());
            for (Long depEmpIdVal : depEmpIdList) {
                InEvalObjData inEvalObjData = new InEvalObjData();
                dataList.add(inEvalObjData);
                inEvalObjData.depEmpId = depEmpIdVal;
                inEvalObjData.empPosOrgDO = empPosOrgDOList.stream().filter(dy -> dy.getLong("depemp.id") == depEmpIdVal.longValue()).findFirst().orElseThrow(() -> new ParamTransferException("not find empPosOrg, depEmpId: " + depEmpIdVal));
                long personId = inEvalObjData.empPosOrgDO.getLong("person.id");
                long empPosOrgId = inEvalObjData.empPosOrgDO.getLong("id");
                inEvalObjData.personInfo = (Map)personInfo.get(personId);
                inEvalObjData.appRemRelInfo = appRemRelInfo.get(empPosOrgId);
                inEvalObjData.contactInfo = (DynamicObject)contactInfo.get(personId);
                inEvalObjData.depEmpVid = depEmpSourceVidMap.get(depEmpIdVal);
            }
            return dataList;
        }
    }
}

