/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evaltask;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.application.external.BesHRPIPersonService;
import kd.hrmp.bes.business.util.MsgPublisherUtil;

public class EvalRoleHelper {
    private static final Log LOG = LogFactory.getLog(EvalRoleHelper.class);
    private static String MSG_PUBLISH_NUMBER = "MP20240719001004";
    private static Long ACTION_ID = 1997805584434371584L;
    private static SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    public static void addEvaluatorToRole(DynamicObject taskDy) {
        if (taskDy == null) {
            LOG.info("addEvaluatorToRole taskDy is null");
            return;
        }
        try {
            LOG.info("addEvaluatorToRole taskId: {}", (Object)taskDy.getLong("id"));
            String realOrAnon = taskDy.getString("realorcryptonym");
            if (!HRStringUtils.equals((String)"1", (String)realOrAnon)) {
                return;
            }
            DynamicObjectCollection contentEntry = taskDy.getDynamicObjectCollection("contententryentity");
            if (contentEntry != null && contentEntry.size() > 0) {
                HashSet<Long> evaluatorSet = new HashSet<Long>(16);
                for (DynamicObject entry : contentEntry) {
                    DynamicObjectCollection realSuEntry = entry.getDynamicObjectCollection("evaluatorrealsubentry");
                    if (realSuEntry == null || realSuEntry.size() == 0) continue;
                    for (DynamicObject subEntry : realSuEntry) {
                        DynamicObjectCollection inEvaluator = subEntry.getDynamicObjectCollection("inevaluator");
                        if (inEvaluator == null || inEvaluator.size() == 0) continue;
                        Set userIds = inEvaluator.stream().map(in -> in.getLong("fbasedataid.id")).collect(Collectors.toSet());
                        evaluatorSet.addAll(userIds);
                    }
                }
                EvalRoleHelper.addEvaluatorToRole(evaluatorSet);
            }
        }
        catch (Exception exception) {
            LOG.error("addEvaluatorToRole error: ", (Throwable)exception);
        }
    }

    public static void addEvaluatorToRole(Set<Long> evaluatorSet) {
        try {
            if (evaluatorSet == null || evaluatorSet.size() == 0) {
                LOG.info("addEvaluatorToRole evaluatorSet is null");
                return;
            }
            LOG.info("addEvaluatorToRole evaluatorSet number: {}", (Object)evaluatorSet.size());
            for (Long evaluator : evaluatorSet) {
                EvalRoleHelper.publishEvaluatorAction(evaluator);
            }
        }
        catch (Exception exception) {
            LOG.error("addEvaluatorToRole error: ", (Throwable)exception);
        }
    }

    public static void publishEvaluatorAction(Long evaluator) {
        if (evaluator == 0L) {
            return;
        }
        String date = FORMAT.format(new Date());
        String title = ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005\u6388\u6743", (String)"EvalRoleHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]);
        MsgPublisherUtil.publishAction(MSG_PUBLISH_NUMBER, date + evaluator, title, ACTION_ID, evaluator);
    }

    public static Map<String, Object> getEvaluatorInfo(Long evaluatorId) {
        LOG.info("getEvaluatorInfo begin");
        HashMap<String, Object> evaluatorMap = new HashMap<String, Object>(3);
        try {
            if (evaluatorId == 0L) {
                evaluatorMap.put("success", false);
                evaluatorMap.put("errorMsg", "evaluatorId is 0");
                evaluatorMap.put("data", null);
                return evaluatorMap;
            }
            BesHRPIPersonService besHRPIPersonService = BesServiceFactory.getService(BesHRPIPersonService.class);
            Map<String, Object> userInfo = besHRPIPersonService.getUserIdByEmployeeIds(Collections.singletonList(evaluatorId));
            Boolean success = (Boolean)userInfo.get("success");
            if (success.booleanValue()) {
                Map data = (Map)userInfo.get("data");
                Map userInfoMap = (Map)data.get(evaluatorId);
                Long personId = (Long)userInfoMap.get("person");
                List personList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{personId});
                Optional<Map> optional = personList.stream().filter(obj -> Boolean.TRUE.equals(obj.get("isprimary"))).findAny();
                Map personMap = optional.orElseGet(() -> personList.stream().max(Comparator.comparing(empposorgrel -> {
                    Object startDate = empposorgrel.get("startdate");
                    if (startDate == null) {
                        return new Date(0L);
                    }
                    return (Date)startDate;
                })).orElseGet(HashMap::new));
                if (personMap.size() > 0) {
                    HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
                    returnMap.put("chgCategoryId", 0L);
                    returnMap.put("chgActionId", 0L);
                    returnMap.put("chgRuleId", 0L);
                    returnMap.put("effectTime", 0L);
                    returnMap.put("datastatus", " ");
                    returnMap.put("billId", 0L);
                    returnMap.put("billNo", " ");
                    returnMap.put("billSource", " ");
                    returnMap.put("eventEntity", " ");
                    returnMap.put("eventId", 0L);
                    HashMap<String, Long> employeeMap = new HashMap<String, Long>(2);
                    employeeMap.put("vid", Long.parseLong(personMap.getOrDefault("employee_id", "0").toString()));
                    employeeMap.put("boid", Long.parseLong(personMap.getOrDefault("employee_id", "0").toString()));
                    HashMap<String, Long> cmpempMap = new HashMap<String, Long>(2);
                    cmpempMap.put("vid", personMap.getOrDefault("cmpemp_id", 0L));
                    cmpempMap.put("boid", personMap.getOrDefault("cmpemp_id", 0L));
                    HashMap<String, Long> depempMap = new HashMap<String, Long>(2);
                    depempMap.put("vid", personMap.getOrDefault("depemp_id", 0L));
                    depempMap.put("boid", personMap.getOrDefault("depemp_id", 0L));
                    HashMap<String, Long> perMap = new HashMap<String, Long>(2);
                    perMap.put("vid", Long.parseLong(personMap.getOrDefault("person_id", "0").toString()));
                    perMap.put("boid", Long.parseLong(personMap.getOrDefault("person_id", "0").toString()));
                    HashMap<String, HashMap<String, Long>> dataMap = new HashMap<String, HashMap<String, Long>>(4);
                    dataMap.put("hrpi_employee", employeeMap);
                    dataMap.put("hrpi_cmpemp", cmpempMap);
                    dataMap.put("hrpi_depemp", depempMap);
                    dataMap.put("hrpi_person", perMap);
                    ArrayList<HashMap<String, HashMap<String, Long>>> userList = new ArrayList<HashMap<String, HashMap<String, Long>>>(1);
                    userList.add(dataMap);
                    returnMap.put("data", userList);
                    evaluatorMap.put("success", true);
                    evaluatorMap.put("errorMsg", null);
                    evaluatorMap.put("data", returnMap);
                    LOG.info("getEvaluatorInfo evaluatorMap: {}", evaluatorMap);
                    return evaluatorMap;
                }
            }
            evaluatorMap.put("success", false);
            evaluatorMap.put("errorMsg", "null");
            evaluatorMap.put("data", null);
        }
        catch (Exception exception) {
            LOG.error("getEvaluatorInfo error: ", (Throwable)exception);
            evaluatorMap.put("success", false);
            evaluatorMap.put("errorMsg", "error");
            evaluatorMap.put("data", null);
        }
        LOG.info("getEvaluatorInfo evaluatorMap: {}", evaluatorMap);
        return evaluatorMap;
    }
}

