/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.evaltask;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.application.external.BesHRPIPersonService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.EvalTaskEntityService;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.EvalContentSeqEntityService;
import kd.hrmp.bes.business.domain.evalsubtask.EvalSubTaskDomainServiceImpl;
import kd.hrmp.bes.business.domain.evalsubtask.IEvalSubTaskDomainService;
import kd.hrmp.bes.business.domain.evalsubtask.ITrackDomainService;
import kd.hrmp.bes.business.domain.evalsubtask.TrackDomainServiceImpl;
import kd.hrmp.bes.business.domain.evalsubtask.strategy.EvalTaskDependOnDbData;
import kd.hrmp.bes.business.domain.evaltask.EvalRelationConvert;
import kd.hrmp.bes.business.domain.evaltask.EvalRoleHelper;
import kd.hrmp.bes.business.domain.evaltask.IEvalTaskDomainService;
import kd.hrmp.bes.business.domain.evaltpl.EvalTplDomainServiceImpl;
import kd.hrmp.bes.business.domain.evaltpl.IEvalTplDomainService;
import kd.hrmp.bes.business.domain.msg.BesEvalMsgSendDomainService;
import kd.hrmp.bes.common.dto.evalrel.AdjustEvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.DeleteEvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.EvalBodyInfo;
import kd.hrmp.bes.common.dto.evalrel.EvalObjectDto;
import kd.hrmp.bes.common.dto.evalrel.EvalObjectInfo;
import kd.hrmp.bes.common.dto.evalrel.EvalRelationDto;
import kd.hrmp.bes.common.dto.evalrel.EvaluatorAnonymousDto;
import kd.hrmp.bes.common.dto.evalrel.EvaluatorDto;
import kd.hrmp.bes.common.dto.evalrel.EvaluatorInfo;
import kd.hrmp.bes.common.enums.EvalMsgOpEnum;
import kd.hrmp.bes.common.enums.EvalTaskStatusEnum;
import kd.hrmp.bes.common.enums.EvaluatorTypeEnum;
import kd.hrmp.bes.common.enums.ProcessModeEnum;
import kd.hrmp.bes.common.utils.DynamicObjectIdUtils;
import kd.hrmp.bes.common.utils.NumUtil;
import kd.hrmp.bes.common.utils.OuterEvalFieldUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.Pair;

public class EvalTaskDomainServiceImpl
implements IEvalTaskDomainService {
    private static final Log log = LogFactory.getLog(EvalTaskDomainServiceImpl.class);
    private static final IEvalTplDomainService TPL_DOMAIN_SERVICE = new EvalTplDomainServiceImpl();
    public static final HRBaseServiceHelper HR_BASE_SERVICE_HELPER = new HRBaseServiceHelper("bes_evaltask");
    private static final BesEvalMsgSendDomainService besEvalMsgSendDomainService = new BesEvalMsgSendDomainService();
    private final EvalTaskEntityService evalTaskEntityService = BesServiceFactory.getService(EvalTaskEntityService.class);
    private final IEvalSubTaskDomainService evalSubTaskDomainService = BesServiceFactory.getService(EvalSubTaskDomainServiceImpl.class);
    private final ITrackDomainService trackDomainService = BesServiceFactory.getService(TrackDomainServiceImpl.class);
    private final BesHRPIPersonService besHRPIPersonService = BesServiceFactory.getService(BesHRPIPersonService.class);
    private final EvalContentSeqEntityService evalContentSeqEntityService = BesServiceFactory.getService(EvalContentSeqEntityService.class);
    private static final HRBaseServiceHelper REPOSITORY_SUB_TASK = HRBaseServiceHelper.create((String)"bes_evalsubtask");
    private static final HRBaseServiceHelper REPOSITORY_TASK = HRBaseServiceHelper.create((String)"bes_evaltask");
    private static final HRBaseServiceHelper BES_EVALCONT = new HRBaseServiceHelper("bes_evaledobjdiscont");
    private static ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"BES_EVALTASKDOMAINSERVICEIMPL_POOL", (int)1);

    @Override
    public Map<String, Object> createEvalTaskPerAnonymous(Map<String, Object> evalParam) {
        log.info("EvalTaskDomainServiceImpl createEvalTaskPerAnonymous start evalParam is :", (Object)evalParam.toString());
        Map<String, Object> result = EvalTaskDomainServiceImpl.checkEvalTaskParam(evalParam, 2);
        Boolean checkResult = Boolean.valueOf(result.get("success").toString());
        if (!checkResult.booleanValue()) {
            log.info("EvalTaskDomainServiceImpl createEvalTaskPerAnonymous check false :", result);
            return result;
        }
        try {
            DynamicObject evalTaskDO = HR_BASE_SERVICE_HELPER.generateEmptyDynamicObject();
            this.evalBaseInfoSetValue(evalTaskDO, evalParam);
            evalTaskDO.set("realorcryptonym", (Object)2);
            Long evalTempId = Long.parseLong(evalParam.get("evaltemp").toString());
            DynamicObject evalTempDO = TPL_DOMAIN_SERVICE.queryTplDynamicObjId(evalTempId);
            this.evalTaskTplInfoSetValue(evalTempDO, evalTaskDO);
            DynamicObject contentDO = (DynamicObject)evalTaskDO.getDynamicObjectCollection("contententryentity").get(0);
            this.evalContenInfoSetValue(evalTaskDO, evalParam);
            this.evalContenAnonymousSettingSetValue(contentDO, evalParam);
            contentDO.set("evalmainbody", evalParam.get("evalmainbody"));
            List<EvaluatorAnonymousDto> evaluatorAnonymous = this.convertEvaluatorAnonymous(evalParam);
            List evalObjectList = (List)evalParam.get("evalObjectList");
            List<EvalObjectDto> EvalObjectDtos = EvalRelationConvert.convertEvalObjMapToDto(evalObjectList);
            for (EvalObjectDto evalRelationDto : EvalObjectDtos) {
                this.updateEvalObjEntryData(contentDO, evalRelationDto);
            }
            this.doAdjustEvalAnonymous(contentDO, evaluatorAnonymous, evalParam);
            HR_BASE_SERVICE_HELPER.saveOne(evalTaskDO);
            result.put("success", true);
            result.put("message", evalTaskDO);
            log.info("EvalTaskDomainServiceImpl createEvalTaskPerAnonymous end, result is success");
        }
        catch (Exception exception) {
            result.put("success", false);
            result.put("message", exception);
            log.error("EvalTaskDomainServiceImpl createEvalTaskPerAnonymous error: ", (Throwable)exception);
        }
        return result;
    }

    @Override
    public Map<String, Object> createEvalTaskPerRealName(Map<String, Object> evalParam) {
        log.info("EvalTaskDomainServiceImpl createEvalTaskPerRealName start evalParam is :", (Object)evalParam.toString());
        Map<String, Object> result = EvalTaskDomainServiceImpl.checkEvalTaskParam(evalParam, 1);
        Boolean checkResult = Boolean.valueOf(result.get("success").toString());
        if (!checkResult.booleanValue()) {
            log.info("EvalTaskDomainServiceImpl createEvalTaskPerRealName check false :", result);
            return result;
        }
        try {
            DynamicObject evalTaskDO = HR_BASE_SERVICE_HELPER.generateEmptyDynamicObject();
            this.evalBaseInfoSetValue(evalTaskDO, evalParam);
            evalTaskDO.set("realorcryptonym", (Object)1);
            Long evalTempId = Long.parseLong(evalParam.get("evaltemp").toString());
            DynamicObject evalTempDO = TPL_DOMAIN_SERVICE.queryTplDynamicObjId(evalTempId);
            this.evalTaskTplInfoSetValue(evalTempDO, evalTaskDO);
            DynamicObject contentDO = (DynamicObject)evalTaskDO.getDynamicObjectCollection("contententryentity").get(0);
            this.evalContenInfoSetValue(evalTaskDO, evalParam);
            this.evalTaskMsgInfoSetValue(contentDO, evalParam);
            List<AdjustEvalRelationDto> adjustEvalRelationDtos = EvalRelationConvert.convertAdjustMapToDto(evalParam);
            this.doAdjustEvalRelation(contentDO, adjustEvalRelationDtos.get(0));
            if (adjustEvalRelationDtos.get(0).getNeedEvalBody().booleanValue()) {
                contentDO.set("evalmainbody", (Object)"10");
            } else {
                contentDO.set("evalmainbody", (Object)"20");
            }
            HR_BASE_SERVICE_HELPER.saveOne(evalTaskDO);
            result.put("success", true);
            result.put("message", evalTaskDO);
            log.info("EvalTaskDomainServiceImpl createEvalTaskPerRealName end, result is success");
        }
        catch (Exception exception) {
            result.put("success", false);
            result.put("message", exception);
            log.error("EvalTaskDomainServiceImpl createEvalTaskPerRealName error: ", (Throwable)exception);
        }
        return result;
    }

    private List<EvaluatorAnonymousDto> convertEvaluatorAnonymous(Map<String, Object> evalParam) {
        ArrayList<EvaluatorAnonymousDto> evaluatorAnonymousDtos = new ArrayList<EvaluatorAnonymousDto>(evalParam.size());
        if (evalParam.get("evalaccountanon") != null) {
            List evalaccountanons = (List)evalParam.get("evalaccountanon");
            for (Map evalaccountanon : evalaccountanons) {
                EvaluatorAnonymousDto evalaccountanonDto = new EvaluatorAnonymousDto();
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("accountanon"))) {
                    evalaccountanonDto.setAccountanon(evalaccountanon.get("accountanon").toString());
                }
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("passwordanon"))) {
                    evalaccountanonDto.setPasswordanon(evalaccountanon.get("passwordanon").toString());
                }
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("evalSubDescribe"))) {
                    evalaccountanonDto.setEvalSubDescribe(evalaccountanon.get("evalSubDescribe").toString());
                }
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("evaluatorNum"))) {
                    evalaccountanonDto.setEvaluatorNum(Integer.valueOf(Integer.parseInt(evalaccountanon.get("evaluatorNum").toString())));
                }
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("evaluatorNum"))) {
                    evalaccountanonDto.setEvalSubWeight(Integer.valueOf(Integer.parseInt(evalaccountanon.get("evalSubWeight").toString())));
                }
                if (!HRObjectUtils.isEmpty(evalaccountanon.get("evalSubName"))) {
                    evalaccountanonDto.setEvalSubName(evalaccountanon.get("evalSubName").toString());
                }
                evaluatorAnonymousDtos.add(evalaccountanonDto);
            }
        }
        return evaluatorAnonymousDtos;
    }

    private void doAdjustEvalAnonymous(DynamicObject evalContentDO, List<EvaluatorAnonymousDto> evaluatorAnonymous, Map<String, Object> evalParam) {
        try {
            DynamicObjectCollection evalUatorAnonsubEntry = evalContentDO.getDynamicObjectCollection("evaluatoranonsubentry");
            for (EvaluatorAnonymousDto evaluatorAnonymousInfo : evaluatorAnonymous) {
                DynamicObject objInfoDO = evalUatorAnonsubEntry.addNew();
                if (!HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getEvalSubName())) {
                    objInfoDO.set("evalbodynameanon", (Object)evaluatorAnonymousInfo.getEvalSubName());
                }
                if (!HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getEvalSubWeight())) {
                    objInfoDO.set("evalbodyweightanon", (Object)evaluatorAnonymousInfo.getEvalSubWeight());
                }
                if (!HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getEvaluatorNum())) {
                    objInfoDO.set("participantnumber", (Object)evaluatorAnonymousInfo.getEvaluatorNum());
                }
                if (!HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getEvalSubDescribe())) {
                    objInfoDO.set("descriptionanon", (Object)evaluatorAnonymousInfo.getEvalSubDescribe());
                }
                if (!HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getAccountanon())) {
                    objInfoDO.set("accountanon", (Object)evaluatorAnonymousInfo.getAccountanon());
                }
                if (HRObjectUtils.isEmpty((Object)evaluatorAnonymousInfo.getPasswordanon())) continue;
                objInfoDO.set("passwordanon", (Object)evaluatorAnonymousInfo.getPasswordanon());
            }
            if (!HRObjectUtils.isEmpty((Object)evalParam.get("evaluatorscope"))) {
                List employeeIds = (List)evalParam.get("evaluatorscope");
                DynamicObjectCollection evaluatorscopeDOC = evalContentDO.getDynamicObjectCollection("evaluatorscope");
                DynamicObjectType discontentType = evaluatorscopeDOC.getDynamicObjectType();
                for (Long employeeId : employeeIds) {
                    DynamicObject evaluatorscopeDot = new DynamicObject(discontentType);
                    evaluatorscopeDot.set("fbasedataid_id", (Object)employeeId);
                    evaluatorscopeDOC.add((Object)evaluatorscopeDot);
                }
            }
            boolean isSetouterevaluator = false;
            if (!HRObjectUtils.isEmpty((Object)evalParam.get("evaluatorout"))) {
                DynamicObjectCollection anonoutsidersubEntry = evalContentDO.getDynamicObjectCollection("anonoutsidersubentry");
                List evalObjectList = (List)evalParam.get("evaluatorout");
                for (Map evalUatorOutInfo : evalObjectList) {
                    DynamicObject anonoutsidersubDO = anonoutsidersubEntry.addNew();
                    anonoutsidersubDO.set("evaloroutnameanon", evalUatorOutInfo.get("name"));
                    anonoutsidersubDO.set("evalorouttelanon", evalUatorOutInfo.get("phone"));
                    anonoutsidersubDO.set("evaloroutemailanon", evalUatorOutInfo.get("email"));
                    anonoutsidersubDO.set("evaloroutcompanyanon", evalUatorOutInfo.get("company"));
                    anonoutsidersubDO.set("evaloroutadminorganon", evalUatorOutInfo.get("department"));
                    anonoutsidersubDO.set("evaloroutposanon", evalUatorOutInfo.get("position"));
                    anonoutsidersubDO.set("evaloroutstdposanon", evalUatorOutInfo.get("stdPosition"));
                    anonoutsidersubDO.set("evaloroutjobanon", evalUatorOutInfo.get("job"));
                }
                if (evalObjectList.size() > 0) {
                    isSetouterevaluator = true;
                }
            }
            if (isSetouterevaluator) {
                evalContentDO.set("setouterevaluator", (Object)"10");
            } else {
                evalContentDO.set("setouterevaluator", (Object)"20");
            }
        }
        catch (Exception exception) {
            log.error("EvalTaskDomainServiceImpl doAdjustEvalAnonymous error: ", (Throwable)exception);
            throw exception;
        }
    }

    private void evalContenAnonymousSettingSetValue(DynamicObject evalContentDO, Map<String, Object> evalParam) {
        evalContentDO.set("anonmode", evalParam.get("anonmode"));
        evalContentDO.set("accountletter", evalParam.get("accountletter"));
        evalContentDO.set("accountnumdigit", evalParam.get("accountnumdigit"));
        evalContentDO.set("pwdletter", evalParam.get("pwdletter"));
        evalContentDO.set("pwdspecialsymbol", evalParam.get("pwdspecialsymbol"));
        evalContentDO.set("pwdnumdigit", evalParam.get("pwdnumdigit"));
    }

    public DynamicObject evalContenInfoSetValue(DynamicObject evalTaskDO, Map<String, Object> evalParam) {
        DynamicObject contentDO = (DynamicObject)evalTaskDO.getDynamicObjectCollection("contententryentity").get(0);
        contentDO.set("contentcode", (Object)"CPNR01");
        contentDO.set("evaledobjtype", (Object)10);
        DynamicObjectCollection discontent = contentDO.getDynamicObjectCollection("discontent");
        try {
            DynamicObject[] ids;
            List<String> discontentInfos;
            if (HRObjectUtils.isEmpty((Object)evalParam.get("discontent"))) {
                discontentInfos = new ArrayList(16);
                String name = ResManager.loadKDString((String)"\u59d3\u540d", (String)"EvalObjectSetPlugin_0", (String)"hrmp-bes-business", (Object[])new Object[0]);
                discontentInfos.add(name);
                String company = ResManager.loadKDString((String)"\u516c\u53f8", (String)"EvalObjectSetPlugin_3", (String)"hrmp-bes-business", (Object[])new Object[0]);
                discontentInfos.add(company);
                String adminorg = ResManager.loadKDString((String)"\u90e8\u95e8", (String)"EvalObjectSetPlugin_4", (String)"hrmp-bes-business", (Object[])new Object[0]);
                discontentInfos.add(adminorg);
            } else {
                discontentInfos = (List)evalParam.get("discontent");
            }
            QFilter qFilter = new QFilter("name", "in", discontentInfos);
            for (DynamicObject idDot : ids = BES_EVALCONT.query("id,name", qFilter.toArray())) {
                DynamicObjectType discontentType = discontent.getDynamicObjectType();
                DynamicObject paDot = new DynamicObject(discontentType);
                paDot.set("fbasedataid_id", (Object)idDot.getLong("id"));
                discontent.add((Object)paDot);
            }
            contentDO.set("specificevaluator", evalParam.get("specificevaluator"));
            contentDO.set("evaluatornummax", evalParam.get("evaluatornummax"));
            contentDO.set("anonmode", evalParam.get("anonmode"));
        }
        catch (Exception exception) {
            log.error("EvalTaskDomainServiceImpl evalContenInfoSetValue error: ", (Throwable)exception);
            throw exception;
        }
        return evalTaskDO;
    }

    public DynamicObject evalBaseInfoSetValue(DynamicObject evalTaskDO, Map<String, Object> evalParam) {
        evalTaskDO.set("number", (Object)evalParam.get("number").toString());
        evalTaskDO.set("org", (Object)evalParam.get("org").toString());
        evalTaskDO.set("adminorg", evalParam.get("adminorg"));
        evalTaskDO.set("name", evalParam.get("name"));
        evalTaskDO.set("evalscen", evalParam.get("evalscen"));
        if (((Boolean)evalParam.get("autostart")).booleanValue()) {
            evalTaskDO.set("autostart", (Object)"1");
        } else {
            evalTaskDO.set("autostart", (Object)"0");
        }
        evalTaskDO.set("startdate", evalParam.get("startdate"));
        if (((Boolean)evalParam.get("autoend")).booleanValue()) {
            evalTaskDO.set("autoend", (Object)"1");
        } else {
            evalTaskDO.set("autoend", (Object)"0");
        }
        evalTaskDO.set("planenddate", evalParam.get("planenddate"));
        evalTaskDO.set("responsemode", evalParam.get("responsemode"));
        evalTaskDO.set("allow", evalParam.get("allow"));
        evalTaskDO.set("processmode", evalParam.get("processmode"));
        evalTaskDO.set("description", evalParam.get("description"));
        evalTaskDO.set("tasksource", (Object)"2");
        evalTaskDO.set("evalcat", (Object)1010L);
        evalTaskDO.set("status", (Object)"A");
        evalTaskDO.set("enable", (Object)"1");
        evalTaskDO.set("evaltaskstatus", (Object)"A");
        evalTaskDO.set("creator", evalParam.get("evaltaskcreator"));
        return evalTaskDO;
    }

    private static Map<String, Object> checkEvalTaskParam(Map<String, Object> evalParam, int checkType) {
        HashMap<String, Object> checkResult = new HashMap<String, Object>();
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "org", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "adminorg", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "name", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evalscen", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "autostart", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "autoend", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "planenddate", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "responsemode", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "allow", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "processmode", checkResult);
        EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evaltemp", checkResult);
        if (checkType == 1) {
            EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evalnoticemsg", checkResult);
        }
        if (checkType == 2) {
            EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "specificevaluator", checkResult);
            if (HRStringUtils.equals((String)String.valueOf(evalParam.get("anonmode")), (String)"10")) {
                EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evalaccountanon", checkResult);
            }
            if (evalParam.get("specificevaluator").toString().equals("10")) {
                EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evalmainbody", checkResult);
                EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "anonmode", checkResult);
                if (HRObjectUtils.isEmpty((Object)evalParam.get("evalmainbody")) && evalParam.get("evalmainbody").toString().equals("10")) {
                    EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "evaluatornummax", checkResult);
                }
            }
        }
        if (((Boolean)evalParam.get("autostart")).booleanValue()) {
            EvalTaskDomainServiceImpl.checkEvalTaskParamBaseEmpty(evalParam, "startdate", checkResult);
        }
        checkResult.put("success", true);
        checkResult.put("message", "check param over");
        return checkResult;
    }

    private static Map<String, Object> checkEvalTaskParamBaseEmpty(Map<String, Object> evalParam, String checkKey, Map<String, Object> checkResult) {
        if (HRObjectUtils.isEmpty((Object)evalParam.get(checkKey))) {
            StringBuilder checkStrBul = new StringBuilder();
            checkStrBul.append(checkResult.get("message") == null ? "" : String.valueOf(checkResult.get("message")));
            checkStrBul.append(checkKey);
            checkStrBul.append("is null;");
            checkResult.put("success", false);
            checkResult.put("message", checkStrBul.toString());
        }
        return checkResult;
    }

    public DynamicObject evalTaskMsgInfoSetValue(DynamicObject contentDO, Map<String, Object> evalParam) {
        contentDO.set("evalnoticemsg", evalParam.get("evalnoticemsg"));
        List sendchannels = (List)evalParam.get("sendchannel");
        contentDO.set("sendchannel", (Object)String.join((CharSequence)",", sendchannels));
        contentDO.set("emailtheme", evalParam.get("emailtheme"));
        contentDO.set("emailrichtext_tag", evalParam.get("emailrichtext"));
        contentDO.set("smstemplate", evalParam.get("smstemplate"));
        contentDO.set("systemplate", evalParam.get("systemplate"));
        return contentDO;
    }

    private void refIndicatorAreaInfo(DynamicObject tplDO, Long areaeNewId, Long areaeOldId) {
        for (DynamicObject indicator : tplDO.getDynamicObjectCollection("indicatorentryentity")) {
            if (indicator.getLong("area") != areaeOldId.longValue()) continue;
            indicator.set("area", (Object)areaeNewId);
        }
    }

    private void refIndicatorGroupInfo(DynamicObject tplDO, Long groupNewId, Long groupOldId) {
        for (DynamicObject indicator : tplDO.getDynamicObjectCollection("indicatorentryentity")) {
            if (indicator.getLong("group") != groupOldId.longValue()) continue;
            indicator.set("group", (Object)groupNewId);
        }
    }

    private void refOptentryInfo(DynamicObject tplDO, Long indicatorNewId, Long indicatorOldId) {
        for (DynamicObject optentry : tplDO.getDynamicObjectCollection("optentryentity")) {
            if (optentry.getLong("indicator") != indicatorOldId.longValue()) continue;
            optentry.set("indicator", (Object)indicatorNewId);
        }
    }

    public DynamicObject evalTaskTplInfoSetValue(DynamicObject tplDO, DynamicObject evalTaskDO) {
        String name;
        for (DynamicObject areaentryentityDO : tplDO.getDynamicObjectCollection("areaentryentity")) {
            Long areaeNewId = ID.genLongId();
            Long areaeOldId = areaentryentityDO.getLong("id");
            areaentryentityDO.set("id", (Object)areaeNewId);
            this.refIndicatorAreaInfo(tplDO, areaeNewId, areaeOldId);
        }
        for (DynamicObject groupsubentryDO : tplDO.getDynamicObjectCollection("groupentryentity")) {
            Long groupNewId = ID.genLongId();
            Long groupOldId = groupsubentryDO.getLong("id");
            groupsubentryDO.set("id", (Object)groupNewId);
            this.refIndicatorGroupInfo(tplDO, groupNewId, groupOldId);
        }
        for (DynamicObject indicator : tplDO.getDynamicObjectCollection("indicatorentryentity")) {
            Long indicatorNewId = ID.genLongId();
            Long indicatorOldId = indicator.getLong("id");
            indicator.set("id", (Object)indicatorNewId);
            this.refOptentryInfo(tplDO, indicatorNewId, indicatorOldId);
        }
        for (DynamicObject optentry : tplDO.getDynamicObjectCollection("optentryentity")) {
            Long optentryNewId = ID.genLongId();
            Long optentryOldId = optentry.getLong("id");
            optentry.set("id", (Object)optentryNewId);
        }
        DynamicObjectCollection contentColl = evalTaskDO.getDynamicObjectCollection("contententryentity");
        DynamicObject contentDO = evalTaskDO.getDynamicObjectCollection("contententryentity").addNew();
        contentDO.set("contentname", (Object)evalTaskDO.getString("name"));
        contentDO.set("evaltemp", (Object)tplDO.getLong("id"));
        contentDO.set("indicatorevaltype", (Object)tplDO.getLong("indicatorevaltype"));
        contentDO.set("score", (Object)tplDO.getLong("score"));
        contentDO.set("scoreaccuracy", (Object)tplDO.getLong("scoreaccuracy"));
        contentDO.set("carrytype", (Object)tplDO.getLong("carrytype"));
        for (DynamicObject areaentryentityDO : tplDO.getDynamicObjectCollection("areaentryentity")) {
            DynamicObject areasubentryDO = contentDO.getDynamicObjectCollection("areasubentry").addNew();
            for (IDataEntityProperty property : areaentryentityDO.getDynamicObjectType().getProperties()) {
                name = property.getName();
                if (HRStringUtils.equals((String)name, (String)"multilanguagetext")) continue;
                areasubentryDO.set(name, areaentryentityDO.get(name));
            }
        }
        for (DynamicObject groupentryentityDO : tplDO.getDynamicObjectCollection("groupentryentity")) {
            DynamicObject groupentryDO = contentDO.getDynamicObjectCollection("groupsubentry").addNew();
            for (IDataEntityProperty property : groupentryentityDO.getDynamicObjectType().getProperties()) {
                name = property.getName();
                if (HRStringUtils.equals((String)name, (String)"multilanguagetext")) continue;
                groupentryDO.set(name, groupentryentityDO.get(name));
            }
        }
        for (DynamicObject indicatorentryentityDO : tplDO.getDynamicObjectCollection("indicatorentryentity")) {
            DynamicObject indicatorsubentryDO = contentDO.getDynamicObjectCollection("indicatorsubentry").addNew();
            for (IDataEntityProperty property : indicatorentryentityDO.getDynamicObjectType().getProperties()) {
                name = property.getName();
                if (HRStringUtils.equals((String)name, (String)"multilanguagetext")) continue;
                indicatorsubentryDO.set(name, indicatorentryentityDO.get(name));
            }
        }
        for (DynamicObject optentryentityDO : tplDO.getDynamicObjectCollection("optentryentity")) {
            DynamicObject optsubentryDO = contentDO.getDynamicObjectCollection("optsubentry").addNew();
            for (IDataEntityProperty property : optentryentityDO.getDynamicObjectType().getProperties()) {
                name = property.getName();
                if (HRStringUtils.equals((String)name, (String)"multilanguagetext")) continue;
                optsubentryDO.set(name, optentryentityDO.get(name));
            }
        }
        return evalTaskDO;
    }

    @Override
    public DynamicObject createEvalTaskByTpl(Long evalTplId) {
        this.deleteTplEvalTaskByTplId(evalTplId);
        DynamicObject tplDO = TPL_DOMAIN_SERVICE.queryTplDynamicObjId(evalTplId);
        DynamicObject evalTaskDO = HR_BASE_SERVICE_HELPER.generateEmptyDynamicObject();
        evalTaskDO = this.evalTaskTplInfoSetValue(tplDO, evalTaskDO);
        evalTaskDO.set("name", (Object)"sysTplTask");
        evalTaskDO.set("evaltaskstatus", (Object)Character.valueOf('S'));
        HR_BASE_SERVICE_HELPER.saveOne(evalTaskDO);
        return evalTaskDO;
    }

    @Override
    public void deleteTplEvalTaskByTplId(Long evalTplId) {
        DynamicObject[] taskDOs;
        QFilter qFilter = new QFilter("evaltaskstatus", "=", (Object)Character.valueOf('S'));
        for (DynamicObject evalTaskDo : taskDOs = HR_BASE_SERVICE_HELPER.query("status,contententryentity,contententryentity.evaltemp", new QFilter[]{qFilter})) {
            DynamicObjectCollection contentColl = evalTaskDo.getDynamicObjectCollection("contententryentity");
            for (DynamicObject contentDO : contentColl) {
                if (contentDO.getLong("evaltemp.id") != evalTplId.longValue()) continue;
                HR_BASE_SERVICE_HELPER.deleteOne((Object)evalTaskDo);
            }
        }
    }

    @Override
    public Map<Long, String> queryByIds(List<Long> taskIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bes_evaltask");
        QFilter filter = new QFilter("id", "in", taskIds);
        DynamicObject[] taskDys = hrBaseServiceHelper.query("id,evaltaskstatus", filter.toArray());
        HashMap<Long, String> idAndStatus = new HashMap<Long, String>(taskDys.length);
        for (DynamicObject taskDy : taskDys) {
            idAndStatus.put(taskDy.getLong("id"), taskDy.getString("evaltaskstatus"));
        }
        return idAndStatus;
    }

    @Override
    public DynamicObject queryById(Long taskId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bes_evaltask");
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskObj = hrBaseServiceHelper.queryOne("contententryentity.id,contententryentity.indicatorevaltype,contententryentity.evaledobjtype,indicatorsubentry.areacode,indicatorsubentry.indicatortype,indicatorsubentry.indicatorclassify", filter.toArray());
        return taskObj;
    }

    @Override
    public void startUpEvalTask(List<Long> ids) {
        DynamicObject[] evalTaskArr = this.getDynamicArrByIds(ids);
        this.pageStartUpEvalTaskBatch(evalTaskArr);
    }

    @Override
    public void suspendEvalTask(List<Long> ids) {
        DynamicObject[] evalTaskArr = this.getDynamicArrByIds(ids);
        this.pageSuspendEvalTask(evalTaskArr);
    }

    @Override
    public void completedEvalTask(List<Long> ids) {
        DynamicObject[] evalTaskArr = this.getDynamicArrByIds(ids);
        this.pageCompletedEvalTask(evalTaskArr, false);
    }

    @Override
    public void deleteEvalTaskById(List<Long> ids) {
        this.evalTaskEntityService.delete(ids.toArray());
    }

    @Override
    public OperationResult terminateEvalTask(Map<Long, Object> param) {
        DynamicObject[] taskArr;
        Set<Long> taskIds = param.keySet();
        QFilter taskFilter = new QFilter("id", "in", taskIds);
        for (DynamicObject taskObj : taskArr = this.evalTaskEntityService.query("terminatersn,enddate,evaltaskstatus,modifier,modifytime", taskFilter.toArray())) {
            taskObj.set("terminatersn", param.get(taskObj.getLong("id")));
        }
        return OperationServiceHelper.executeOperate((String)"endevaltask", (String)"bes_evaltask", (DynamicObject[])taskArr, (OperateOption)this.getOption());
    }

    private OperateOption getOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skip_task_source_validate", "1");
        return operateOption;
    }

    @Override
    public OperationResult completedEvalTaskByOp(List<Long> ids) {
        return OperationServiceHelper.executeOperate((String)"complete", (String)"bes_evaltask", (Object[])ids.toArray(), (OperateOption)this.getOption());
    }

    @Override
    public OperationResult adjustTaskEndDate(Map<Long, Date> param) {
        Set<Long> taskIds = param.keySet();
        String jsonObject = SerializationUtils.toJsonString(param);
        OperateOption option = this.getOption();
        option.setVariableValue("SetIdAndDateInfo", jsonObject);
        return OperationServiceHelper.executeOperate((String)"dochangedeadline", (String)"bes_evaltask", (Object[])taskIds.toArray(), (OperateOption)option);
    }

    @Override
    public void pageStartUpEvalTask(DynamicObject evalTaskObj) {
        this.pageStartUpEvalTaskBatch(new DynamicObject[]{evalTaskObj});
    }

    @Override
    public void pageStartUpEvalTaskBatch(DynamicObject[] evalTaskArr) {
        try {
            this.startUpUpdateEvalTaskStatus(evalTaskArr);
            THREAD_POOL.execute(() -> this.addEvaluatorToRole(evalTaskArr));
            this.generateEvalSubTaskAndTrackObj(evalTaskArr);
            this.updateEvalProgress(Lists.newArrayList((Object[])evalTaskArr));
        }
        catch (Exception e) {
            log.error("EvalTaskDomainServiceImpl.pageStartUpEvalTaskBatch", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u8bc4\u4efb\u52a1\u542f\u52a8\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EvalTaskDomainServiceImpl_4", (String)"hrmp-bes-business", (Object[])new Object[0]));
        }
    }

    @Override
    public void generateEvalSubTaskAndTrackObj(DynamicObject[] evalTaskArr) {
        ArrayList evalTaskList = Lists.newArrayList((Object[])evalTaskArr);
        EvalTaskDependOnDbData evalTaskDependOnDbData = this.queryDbDataByEvalTask(evalTaskList);
        this.evalSubTaskDomainService.createEvalSubTaskByEvalTaskObj(evalTaskList, evalTaskDependOnDbData);
        this.trackDomainService.createTrackEvalObj(evalTaskList, evalTaskDependOnDbData);
    }

    private void calcEvalTaskResult(List<DynamicObject> evalTaskList) {
        log.info("EvalTaskDomainServiceImpl.calcEvalTaskResult calcEvalObjResult begin");
        this.trackDomainService.calcEvalObjResult(evalTaskList);
        log.info("EvalTaskDomainServiceImpl.calcEvalTaskResult calcEvalObjResult end");
        log.info("EvalTaskDomainServiceImpl.calcEvalTaskResult calcEvaluatorResult begin");
        this.trackDomainService.calcEvaluatorResult(evalTaskList);
        log.info("EvalTaskDomainServiceImpl.calcEvalTaskResult calcEvaluatorResult end");
    }

    public void updateEvalProgress(List<DynamicObject> evalTaskList) {
        List evalTaskIdList = DynamicObjectIdUtils.getIds(evalTaskList);
        Map<Long, Pair<Integer, Integer>> evalTotalProgress = this.evalSubTaskDomainService.getEvalTotalProgressByEvalTask(evalTaskIdList);
        for (DynamicObject dynamicObject : evalTaskList) {
            long evalTaskId = dynamicObject.getLong("id");
            Pair<Integer, Integer> oneEvalTotalProgress = evalTotalProgress.get(evalTaskId);
            if (oneEvalTotalProgress == null) continue;
            dynamicObject.set("totalsubtask", oneEvalTotalProgress.getLeft());
            dynamicObject.set("completedsubtask", oneEvalTotalProgress.getRight());
        }
        Map<Long, Integer> evalEvaluatorNum = this.trackDomainService.getEvalEvaluatorNum(evalTaskIdList);
        for (DynamicObject evalTaskObj : evalTaskList) {
            long evalTaskId = evalTaskObj.getLong("id");
            evalTaskObj.set("evalobjnum", (Object)evalEvaluatorNum.get(evalTaskId));
        }
        Map<Long, Integer> map = this.trackDomainService.getEvalEvalObjNum(evalTaskIdList);
        for (DynamicObject evalTaskObj : evalTaskList) {
            long evalTaskId = evalTaskObj.getLong("id");
            evalTaskObj.set("evalnum", (Object)map.get(evalTaskId));
        }
        this.trackDomainService.updateTrackProgress(evalTaskList);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.update((DynamicObject[])evalTaskList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
    }

    private EvalTaskDependOnDbData queryDbDataByEvalTask(List<DynamicObject> evalTaskList) {
        List<Long> employeeIds = evalTaskList.stream().flatMap(contentEntry -> contentEntry.getDynamicObjectCollection("contententryentity").stream().flatMap(evalEntry -> evalEntry.getDynamicObjectCollection("evaluatorrealsubentry").stream().flatMap(inEvaluatorMulBase -> inEvaluatorMulBase.getDynamicObjectCollection("inevaluator").stream().map(obj -> obj.getLong("fbasedataid_id"))))).collect(Collectors.toList());
        return this.getEvalTaskDependOnDbData(employeeIds);
    }

    private EvalTaskDependOnDbData queryDbDataByUser() {
        Map<String, Object> personModelId = this.besHRPIPersonService.getPersonModelId();
        Boolean success = (Boolean)personModelId.get("success");
        if (Boolean.TRUE.equals(success)) {
            Map data = (Map)personModelId.get("data");
            Long employeeIds = (Long)data.get("employee");
            return this.getEvalTaskDependOnDbData(Lists.newArrayList((Object[])new Long[]{employeeIds}));
        }
        return new EvalTaskDependOnDbData();
    }

    private EvalTaskDependOnDbData getEvalTaskDependOnDbData(List<Long> employeeIds) {
        Map<String, Object> userInfos;
        Boolean success;
        EvalTaskDependOnDbData dbData = new EvalTaskDependOnDbData();
        HashMap employeeIdUserMap = Maps.newHashMap();
        HashMap employeeInfoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(employeeIds) && Boolean.TRUE.equals(success = (Boolean)(userInfos = this.besHRPIPersonService.getUserIdByEmployeeIds(employeeIds)).get("success"))) {
            Map data = (Map)userInfos.get("data");
            for (Map.Entry dataEntry : data.entrySet()) {
                employeeIdUserMap.put(dataEntry.getKey(), (Long)((Map)dataEntry.getValue()).get("user"));
            }
            List<Long> personIds = data.values().stream().map(obj -> (Long)obj.get("person")).collect(Collectors.toList());
            Map<Long, Map<String, Object>> empEmpposorgrelsMap = this.besHRPIPersonService.listPrimaryEmpposorgrels(personIds);
            DynamicObject[] perContact = this.besHRPIPersonService.listFieldsFilterInfo(personIds);
            Map personContactMap = Arrays.stream(perContact).collect(Collectors.toMap(obj -> obj.getLong("person_id"), Function.identity(), (k1, k2) -> k1));
            for (Map.Entry dataEntry : data.entrySet()) {
                Map<String, Object> primaryEmpposorgrels;
                Long employeeId = (Long)dataEntry.getKey();
                Long personId = (Long)((Map)dataEntry.getValue()).get("person");
                DynamicObject perContactObj = (DynamicObject)personContactMap.get(personId);
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)empEmpposorgrelsMap.size());
                if (!HRObjectUtils.isEmpty((Object)perContactObj)) {
                    dataMap.put("email", perContactObj.get("busemail"));
                    dataMap.put("phone", perContactObj.get("phone"));
                }
                if (MapUtils.isNotEmpty(primaryEmpposorgrels = empEmpposorgrelsMap.get(employeeId))) {
                    dataMap.put("company", primaryEmpposorgrels.get("company"));
                    dataMap.put("adminorg", primaryEmpposorgrels.get("adminorg"));
                    dataMap.put("position", primaryEmpposorgrels.get("position"));
                    dataMap.put("stdposition", primaryEmpposorgrels.get("stdposition"));
                    dataMap.put("job", primaryEmpposorgrels.get("job"));
                    dataMap.put("name", primaryEmpposorgrels.get("name"));
                    dataMap.put("number", primaryEmpposorgrels.get("number"));
                    dataMap.put("employee_id", primaryEmpposorgrels.get("employee_id"));
                    dataMap.put("depemp_id", primaryEmpposorgrels.get("depemp_id"));
                    dataMap.put("person_id", primaryEmpposorgrels.get("person_id"));
                }
                employeeInfoMap.put(employeeId, dataMap);
            }
        }
        dbData.setEmployeeUserIdMap(employeeIdUserMap);
        dbData.setEmployeeInfoMap(employeeInfoMap);
        return dbData;
    }

    private void startUpUpdateEvalTaskStatus(DynamicObject[] evalTaskArr) {
        for (DynamicObject evalTaskObj : evalTaskArr) {
            evalTaskObj.set("evaltaskstatus", (Object)EvalTaskStatusEnum.IN_PROGRESS.getCode());
            evalTaskObj.set("status", (Object)"C");
            String autoStart = evalTaskObj.getString("autostart");
            if (!"0".equals(autoStart)) continue;
            evalTaskObj.set("startdate", (Object)HRDateTimeUtils.getNowDate());
        }
        this.evalTaskEntityService.save(evalTaskArr);
    }

    @Override
    public void pageSuspendEvalTask(DynamicObject[] evalTaskArr) {
        this.updateStatus(evalTaskArr, EvalTaskStatusEnum.PAUSED.getCode());
        this.evalTaskEntityService.save(evalTaskArr);
    }

    private void updateStatus(DynamicObject[] evalTaskArr, String evalTaskStatus) {
        for (DynamicObject evalTask : evalTaskArr) {
            evalTask.set("evaltaskstatus", (Object)evalTaskStatus);
        }
    }

    private DynamicObject[] getDynamicArrByIds(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return this.evalTaskEntityService.loadDynamicObjectArray(qFilter.toArray());
    }

    @Override
    public void pageCompletedEvalTask(DynamicObject[] evalTaskArr, boolean scheduleComplete) {
        Map<Boolean, List<DynamicObject>> evalTaskParByProcessMode = Arrays.stream(evalTaskArr).collect(Collectors.groupingBy(obj -> ProcessModeEnum.WAIVER.getCode().equals(obj.getString("processmode"))));
        this.evalSubTaskDomainService.completeEvalSubTask(evalTaskParByProcessMode);
        this.trackDomainService.completeEvalSubTask(evalTaskParByProcessMode);
        this.updateCompleteStatusAndDate(evalTaskArr, scheduleComplete);
        List evalTaskIdList = DynamicObjectIdUtils.getIds((DynamicObject[])evalTaskArr);
        this.refreshEvalResult(this.getDynamicArrByIds(evalTaskIdList));
    }

    private void updateCompleteStatusAndDate(DynamicObject[] evalTaskArr, boolean scheduleComplete) {
        for (DynamicObject evalTaskObj : evalTaskArr) {
            String autoEnd = evalTaskObj.getString("autoend");
            boolean autoEndFlag = "1".equals(autoEnd);
            if (!scheduleComplete && autoEndFlag) {
                EvalTaskDomainServiceImpl.autoEndNo(evalTaskObj);
            }
            evalTaskObj.set("enddate", (Object)HRDateTimeUtils.getNowDate());
            evalTaskObj.set("evaltaskstatus", (Object)EvalTaskStatusEnum.COMPLETED.getCode());
        }
        this.evalTaskEntityService.save(evalTaskArr);
    }

    private static void autoEndNo(DynamicObject dataEntity) {
        dataEntity.set("autoend", (Object)"0");
    }

    @Override
    public DynamicObject[] queryTaskDynamicObjByBodyIds(List<Long> evalBodyIdList) {
        QFilter qFilter = new QFilter("contententryentity.evaluatorrealsubentry.evalbody", "in", evalBodyIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(enableFilter);
        return HR_BASE_SERVICE_HELPER.queryOriginalArray("id,name,contententryentity.evaluatorrealsubentry.evalbody", qFilter.toArray());
    }

    @Override
    public DynamicObject[] queryTaskDynamicObjByBodyId(Long evalBodyId) {
        QFilter qFilter = new QFilter("contententryentity.evaluatorrealsubentry.evalbody", "=", (Object)evalBodyId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(enableFilter);
        return HR_BASE_SERVICE_HELPER.query("id,name,contententryentity.evaluatorrealsubentry.evalbody", qFilter.toArray());
    }

    @Override
    public EvaluatorTypeEnum getEvaluatorTypeEnumByTask(Long evalContentId) {
        return this.getEvaluatorTypeEnumByTask(null, evalContentId);
    }

    @Override
    public EvaluatorTypeEnum getEvaluatorTypeEnumByTask(Long evalTaskId, Long evalContentId) {
        List<DynamicObject> evalTaskArr = this.evalTaskEntityService.queryOriginEvalTaskTypeByContentId(evalTaskId, evalContentId);
        if (CollectionUtils.isEmpty(evalTaskArr)) {
            return null;
        }
        DynamicObject evalTask = evalTaskArr.get(0);
        return this.getEvaluatorTypeEnumByContentObj(evalTask);
    }

    private EvaluatorTypeEnum getEvaluatorTypeEnumByContentObj(DynamicObject evalTask) {
        EvaluatorTypeEnum evaluatorTypeEnum = null;
        String realAnonymous = evalTask.getString("realorcryptonym");
        String evalMainBody = evalTask.getString("evalmainbody");
        String specificEvaluator = evalTask.getString("specificevaluator");
        if ("1".equals(realAnonymous)) {
            if ("10".equals(specificEvaluator)) {
                if ("10".equals(evalMainBody)) {
                    evaluatorTypeEnum = EvaluatorTypeEnum.REAL_USER_MAIN_BODY;
                }
                if ("20".equals(evalMainBody)) {
                    evaluatorTypeEnum = EvaluatorTypeEnum.REAL_USER_NO_MAIN_BODY;
                }
            }
            if ("20".equals(specificEvaluator)) {
                evaluatorTypeEnum = EvaluatorTypeEnum.REAL_NO_EVALUATOR;
            }
        } else if ("2".equals(realAnonymous)) {
            if ("10".equals(specificEvaluator)) {
                String anonMode = evalTask.getString("anonmode");
                if ("10".equals(anonMode)) {
                    if ("10".equals(evalMainBody)) {
                        evaluatorTypeEnum = EvaluatorTypeEnum.ANON_ACCOUNT_MAIN_BODY;
                    }
                    if ("20".equals(evalMainBody)) {
                        evaluatorTypeEnum = EvaluatorTypeEnum.ANON_ACCOUNT_NO_MAIN_BODY;
                    }
                }
                if ("20".equals(anonMode)) {
                    if ("10".equals(evalMainBody)) {
                        evaluatorTypeEnum = EvaluatorTypeEnum.ANON_MAIN_BODY;
                    }
                    if ("20".equals(evalMainBody)) {
                        evaluatorTypeEnum = EvaluatorTypeEnum.ANON_NO_MAIN_BODY;
                    }
                }
            }
            if ("20".equals(specificEvaluator)) {
                evaluatorTypeEnum = EvaluatorTypeEnum.ANON_NO_EVALUATOR;
            }
        }
        return evaluatorTypeEnum;
    }

    @Override
    public void refreshEvalResult(List<Long> evalTaskIds) {
        log.info("EvalTaskDomainServiceImpl.refreshEvalResult param: {}", evalTaskIds);
        this.refreshEvalResult(this.getDynamicArrByIds(evalTaskIds));
    }

    @Override
    public void noEvaluatorGeneratorSubTask(Map<Long, DynamicObject> evalObjIdEvalSubTaskMap, Long contentId) {
        log.info("EvalTaskDomainServiceImpl noEvaluatorGeneratorSubTask contentId: {}, param: {}", (Object)contentId, evalObjIdEvalSubTaskMap);
        if (MapUtils.isEmpty(evalObjIdEvalSubTaskMap)) {
            log.info("EvalTaskDomainServiceImpl noEvaluatorGeneratorSubTask param empty");
            return;
        }
        EvaluatorTypeEnum evaluatorTypeEnum = this.getEvaluatorTypeEnumByTask(contentId);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try (TXHandle cadreFileHandle = TX.required((String)"noEvaluatorGeneratorSubTask");){
            try {
                DynamicObject[] evalTaskArr = this.evalTaskEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("contententryentity.id", "=", (Object)contentId)});
                DynamicObject evalTaskObj = evalTaskArr[0];
                if (EvaluatorTypeEnum.REAL_NO_EVALUATOR == evaluatorTypeEnum) {
                    log.info("TrackDomainServiceImpl.generatorOneEvaluator REAL_NO_EVALUATOR");
                    EvalTaskDependOnDbData evalTaskDependOnDbData = this.queryDbDataByUser();
                    this.evalSubTaskDomainService.noEvaluatorRealSupplementaryValue(evalObjIdEvalSubTaskMap, evalTaskObj, evalTaskDependOnDbData);
                    this.trackDomainService.generatorRealOneEvaluator(evalObjIdEvalSubTaskMap, evalTaskObj, evalTaskDependOnDbData);
                }
                stopWatch.split();
                log.info("EvalTaskDomainServiceImpl.noEvaluatorGeneratorSubTask REAL_NO_EVALUATOR time: {}", (Object)stopWatch.formatSplitTime());
                if (EvaluatorTypeEnum.ANON_NO_EVALUATOR == evaluatorTypeEnum) {
                    log.info("TrackDomainServiceImpl.generatorOneEvaluator ANON_NO_EVALUATOR");
                    int count = this.getSerialNumByContentId(contentId);
                    stopWatch.split();
                    log.info("EvalTaskDomainServiceImpl.noEvaluatorGeneratorSubTask getSerialNumByContentId time: {}", (Object)stopWatch.formatSplitTime());
                    String evaluatorNumber = NumUtil.formatNumber((int)count);
                    this.evalSubTaskDomainService.noEvaluatorAnonSupplementaryValue(evalObjIdEvalSubTaskMap, evalTaskObj, evaluatorNumber);
                    stopWatch.split();
                    log.info("EvalTaskDomainServiceImpl.noEvaluatorGeneratorSubTask noEvaluatorAnonSupplementaryValue time: {}", (Object)stopWatch.formatSplitTime());
                    this.trackDomainService.generatorAnonOneEvaluator(evalObjIdEvalSubTaskMap, evalTaskObj, evaluatorNumber);
                    stopWatch.split();
                    log.info("EvalTaskDomainServiceImpl.noEvaluatorGeneratorSubTask generatorAnonOneEvaluator time: {}", (Object)stopWatch.formatSplitTime());
                }
                stopWatch.stop();
                log.info("EvalTaskDomainServiceImpl.noEvaluatorGeneratorSubTask noEvaluatorGeneratorSubTask time: {}", (Object)stopWatch.formatTime());
            }
            catch (Exception exception) {
                cadreFileHandle.markRollback();
                log.error("EvalTaskDomainServiceImpl noEvaluatorGeneratorSubTask error: ", (Throwable)exception);
                throw exception;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int getSerialNumByContentId(Long contentId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void adjustingEvaluationRelationships(long evalTaskId) {
        long adjustBeginTime = System.currentTimeMillis();
        log.info("EvalTaskDomainServiceImpl.adjustingEvaluationRelationships taskId: {}", (Object)evalTaskId);
        try (TXHandle cadreFileHandle = TX.required((String)"EvalTaskDomainServiceImpl.adjustEvaluator");){
            try {
                DynamicObject evalTaskObj = this.evalTaskEntityService.loadSingle(evalTaskId);
                ArrayList evalTaskList = Lists.newArrayList((Object[])new DynamicObject[]{evalTaskObj});
                EvalTaskDependOnDbData evalTaskDependOnDbData = this.queryDbDataByEvalTask(evalTaskList);
                this.evalSubTaskDomainService.adjustEvalSubTaskByEvalTaskObj(evalTaskList, evalTaskDependOnDbData);
                this.trackDomainService.adjustTrackEvalObj(evalTaskList, evalTaskDependOnDbData);
                this.refreshEvalResult(new DynamicObject[]{evalTaskObj});
            }
            catch (Exception exception) {
                cadreFileHandle.markRollback();
                log.error("EvalTaskDomainServiceImpl.adjustEvaluator error: ", (Throwable)exception);
                throw exception;
            }
        }
        long adjustEndTime = System.currentTimeMillis();
        log.info("EvalTaskDomainServiceImpl.refreshEvalResult cost time: {}", (Object)(adjustEndTime - adjustBeginTime));
    }

    @Override
    public List<Long> scheduleStartUp() {
        DynamicObject[] startUpData = this.evalTaskEntityService.queryNeedStartUpData();
        this.pageStartUpEvalTaskBatch(startUpData);
        return DynamicObjectIdUtils.getIds((DynamicObject[])startUpData);
    }

    private void addEvaluatorToRole(DynamicObject[] startUpData) {
        if (startUpData == null || startUpData.length == 0) {
            return;
        }
        Arrays.stream(startUpData).forEach(EvalRoleHelper::addEvaluatorToRole);
    }

    @Override
    public void scheduleComplete() {
        DynamicObject[] completeData = this.evalTaskEntityService.queryNeedCompleteData();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("schedule_complete", "1");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"complete", (String)"bes_evaltask", (DynamicObject[])completeData, (OperateOption)operateOption);
        log.info("EvalTaskDomainServiceImpl.scheduleComplete: {}", (Object)operationResult);
    }

    public void refreshEvalResult(DynamicObject[] evalTaskArr) {
        log.info("EvalTaskDomainServiceImpl.refreshEvalResult begin");
        long refreshBeginTime = System.currentTimeMillis();
        ArrayList evalTaskList = Lists.newArrayList((Object[])evalTaskArr);
        try (TXHandle cadreFileHandle = TX.required((String)"EvalTaskDomainServiceImpl_refreshEvalResult");){
            try {
                this.calcEvalTaskResult(evalTaskList);
                log.info("EvalTaskDomainServiceImpl.updateEvalProgress begin");
                this.updateEvalProgress(evalTaskList);
                log.info("EvalTaskDomainServiceImpl.updateEvalProgress end");
            }
            catch (Exception exception) {
                cadreFileHandle.markRollback();
                log.error("EvalTaskDomainServiceImpl_refreshEvalResult error: ", (Throwable)exception);
                throw exception;
            }
        }
        long refreshEndTime = System.currentTimeMillis();
        log.info("EvalTaskDomainServiceImpl.refreshEvalResult cost time: {}", (Object)(refreshEndTime - refreshBeginTime));
    }

    @Override
    public Map<Long, Map<String, Object>> adjustEvalRelation(List<AdjustEvalRelationDto> adjustEvalRelationDtos) {
        DynamicObject[] evalTaskDOArr = HR_BASE_SERVICE_HELPER.loadDynamicObjectArray(adjustEvalRelationDtos.stream().map(AdjustEvalRelationDto::getEvalTaskId).toArray());
        Map<Long, Map<String, Object>> result = this.verifyAdjustEvalRelation(adjustEvalRelationDtos);
        adjustEvalRelationDtos = this.getVerifySuccessEvalRelaDto(adjustEvalRelationDtos, result);
        ArrayList<DynamicObject> successDOList = new ArrayList<DynamicObject>(adjustEvalRelationDtos.size());
        ArrayList<AdjustEvalRelationDto> successDtoList = new ArrayList<AdjustEvalRelationDto>(adjustEvalRelationDtos.size());
        for (AdjustEvalRelationDto dto : adjustEvalRelationDtos) {
            Arrays.stream(evalTaskDOArr).filter(evalTaskDO -> com.google.common.base.Objects.equal((Object)dto.getEvalTaskId(), (Object)evalTaskDO.getLong("id"))).findFirst().ifPresent(evalTaskDO -> {
                Long evalContentId = dto.getEvalContentId();
                Optional<DynamicObject> evalContentOp = evalTaskDO.getDynamicObjectCollection("contententryentity").stream().filter(dy -> com.google.common.base.Objects.equal((Object)evalContentId, (Object)dy.getLong("id"))).findFirst();
                if (!evalContentOp.isPresent()) {
                    log.warn("EvalTaskDomainServiceImpl.adjustEvalRelation find evalcontent error dto:{},evalTaskId:{}", (Object)dto, (Object)evalTaskDO.getLong("id"));
                    return;
                }
                Pair<Boolean, String> pair = this.doAdjustEvalRelation(evalContentOp.get(), dto);
                result.put(dto.getEvalContentId(), (Map<String, Object>)ImmutableMap.of((Object)"success", (Object)pair.getLeft(), (Object)"message", (Object)pair.getRight()));
                if (((Boolean)pair.getLeft()).booleanValue()) {
                    successDOList.add((DynamicObject)evalTaskDO);
                    successDtoList.add(dto);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(successDOList)) {
            try (TXHandle txHandle = TX.required((String)"adjustEvalRelation");){
                try {
                    HR_BASE_SERVICE_HELPER.save(successDOList.toArray(new DynamicObject[0]));
                    for (DynamicObject dynamicObject : successDOList) {
                        this.adjustingEvaluationRelationships(dynamicObject.getLong("id"));
                    }
                }
                catch (Exception exception) {
                    log.error("EvalTaskDomainServiceImpl.adjustRelation save error: ", (Throwable)exception);
                    txHandle.markRollback();
                    throw exception;
                }
            }
            this.sendMsg(successDOList, successDtoList);
            Set<Long> collect = successDtoList.stream().map(AdjustEvalRelationDto::getEvaluatorDtoList).flatMap(Collection::stream).filter(dy -> HRStringUtils.equals((String)dy.getEvaluatorType(), (String)"1")).map(EvaluatorDto::getEvaluatorId).collect(Collectors.toSet());
            EvalRoleHelper.addEvaluatorToRole(collect);
        }
        return result;
    }

    private void sendMsg(List<DynamicObject> successDOList, List<AdjustEvalRelationDto> successDtoList) {
        List needSendMsgDtoList = successDtoList.stream().filter(dto -> dto.getNeedSendMsg() != null && dto.getNeedSendMsg() != false).collect(Collectors.toList());
        Set<Long> outEvaluatorIdList = needSendMsgDtoList.stream().map(AdjustEvalRelationDto::getEvaluatorDtoList).flatMap(Collection::stream).filter(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorOpType(), (String)"1") && HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2")).map(EvaluatorDto::getEvaluatorId).collect(Collectors.toSet());
        Set<Long> inEvaluatorIdList = needSendMsgDtoList.stream().map(AdjustEvalRelationDto::getEvaluatorDtoList).flatMap(Collection::stream).filter(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorOpType(), (String)"1") && HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"1")).map(EvaluatorDto::getEvaluatorId).collect(Collectors.toSet());
        AdjustEvalRelationDto adjustEvalRelationDto = successDtoList.get(0);
        besEvalMsgSendDomainService.send(successDOList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()), EvalMsgOpEnum.BEGIN, outEvaluatorIdList, inEvaluatorIdList, (Map<String, Map<String, String>>)adjustEvalRelationDto.getMsgFieldConfig(), adjustEvalRelationDto.getSendMsgAppNumber(), successDtoList.stream().map(AdjustEvalRelationDto::getEvalContentId).collect(Collectors.toSet()));
    }

    private List<AdjustEvalRelationDto> getVerifySuccessEvalRelaDto(List<AdjustEvalRelationDto> adjustEvalRelationDtos, Map<Long, Map<String, Object>> result) {
        adjustEvalRelationDtos = adjustEvalRelationDtos.stream().filter(dto -> {
            Map verifyInfo = (Map)result.get(dto.getEvalContentId());
            if (MapUtils.isEmpty((Map)verifyInfo)) {
                return true;
            }
            return (Boolean)verifyInfo.get("success");
        }).collect(Collectors.toList());
        return adjustEvalRelationDtos;
    }

    private Pair<Boolean, String> doAdjustEvalRelation(DynamicObject evalContentDO, AdjustEvalRelationDto adjustEvalRelationDto) {
        try {
            List evalRelationDtoList = adjustEvalRelationDto.getEvalRelationDtoList();
            DynamicObjectCollection evalObjEntryOldDataList = evalContentDO.getDynamicObjectCollection("objinfopersubentry");
            evalContentDO.set("objinfopersubentry", null);
            evalContentDO.set("realoutsidersubentry", null);
            evalContentDO.set("evaluatorrealsubentry", null);
            for (EvalRelationDto evalRelationDto : evalRelationDtoList) {
                EvalObjectDto evalObjectDto = evalRelationDto.getEvalObjectDto();
                DynamicObject oldEvalObjDO = evalObjEntryOldDataList.stream().filter(dy -> com.google.common.base.Objects.equal((Object)evalObjectDto.getEvalObjId(), (Object)dy.getLong("evalobjid"))).findFirst().orElse(null);
                this.updateEvalObjEntryData(evalContentDO, oldEvalObjDO, evalObjectDto);
                List evaluatorDtoList = evalRelationDto.getEvaluatorDtoList();
                DynamicObjectCollection evaluatorRealEntry = evalContentDO.getDynamicObjectCollection("evaluatorrealsubentry");
                DynamicObject evalRelationEntryRow = evaluatorRealEntry.addNew();
                evalRelationEntryRow.set("evaledobj", (Object)evalObjectDto.getEvalObjEntryRowId());
                evalRelationEntryRow.set("evaledobjtypereal", (Object)"10");
                evalRelationEntryRow.set("evalrelaevalobjid", (Object)evalObjectDto.getEvalObjId());
                EvalBodyInfo evalBodyInfo = this.getEvalBodyInfo(evalRelationDto.getEvalBodyId(), adjustEvalRelationDto);
                if (evalBodyInfo != null) {
                    evalRelationEntryRow.set("evalbody", (Object)evalBodyInfo.getEvalBodyId());
                    evalRelationEntryRow.set("evalbodyweightreal", (Object)evalBodyInfo.getWeight());
                    evalRelationEntryRow.set("evalbodydesreal", evalBodyInfo.getDescription());
                }
                this.updateInEvaluator(evaluatorDtoList, evalRelationEntryRow);
                this.updateOutEvaluator(evaluatorDtoList, evalRelationEntryRow);
            }
            DynamicObjectCollection realOutsidersEntry = evalContentDO.getDynamicObjectCollection("realoutsidersubentry");
            List evaluatorDtoList = adjustEvalRelationDto.getEvaluatorDtoList();
            evaluatorDtoList.stream().filter(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2")).forEach(evaluatorDto -> {
                EvaluatorInfo evaluatorInfo = evaluatorDto.getEvaluatorInfo();
                DynamicObject dynamicObject = realOutsidersEntry.addNew();
                dynamicObject.set("id", (Object)evaluatorInfo.getId());
                dynamicObject.set("evaloroutname", evaluatorInfo.getName());
                dynamicObject.set("evalorouttel", (Object)evaluatorInfo.getPhone());
                dynamicObject.set("evaloroutemail", (Object)evaluatorInfo.getEmail());
                dynamicObject.set("evaloroutcompany", evaluatorInfo.getCompany());
                dynamicObject.set("evaloroutadminorg", evaluatorInfo.getDepartment());
                dynamicObject.set("evaloroutpos", evaluatorInfo.getPosition());
                dynamicObject.set("evaloroutstdpos", evaluatorInfo.getStdPosition());
                dynamicObject.set("evaloroutjob", evaluatorInfo.getJob());
            });
            boolean haveOuterEvaluator = adjustEvalRelationDto.getEvaluatorDtoList().stream().anyMatch(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2"));
            evalContentDO.set("setouterevaluator", (Object)(haveOuterEvaluator ? "10" : "20"));
        }
        catch (Exception exception) {
            log.error("EvalTaskDomainServiceImpl.doAdjustEvalRelation error: ", (Throwable)exception);
            return Pair.of((Object)Boolean.FALSE, (Object)"system error");
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    private void updateEvalObjEntryData(DynamicObject evalContentDO, EvalObjectDto evalObjectDto) {
        this.updateEvalObjEntryData(evalContentDO, null, evalObjectDto);
    }

    private void updateEvalObjEntryData(DynamicObject evalContentDO, DynamicObject oldEvalObjDO, EvalObjectDto evalObjectDto) {
        if (oldEvalObjDO != null) {
            evalObjectDto.setEvalObjEntryRowId(Long.valueOf(oldEvalObjDO.getLong("id")));
            evalObjectDto.setEvalObjId(Long.valueOf(oldEvalObjDO.getLong("evalobjid")));
            evalObjectDto.setEvalObjType(oldEvalObjDO.getString("perdatasource"));
            evalObjectDto.setDepEmpFid(Long.valueOf(oldEvalObjDO.getLong("depempfid")));
            if (HRStringUtils.equals((String)evalObjectDto.getEvalObjType(), (String)"1")) {
                EvalObjectInfo evalObjInfo = evalObjectDto.getEvalObjectInfo();
                evalObjInfo.setId(Long.valueOf(oldEvalObjDO.getLong("evalobjid")));
                evalObjInfo.setName(oldEvalObjDO.get("pername"));
                evalObjInfo.setNumber(oldEvalObjDO.getString("pernumber"));
                evalObjInfo.setHeadPicture(oldEvalObjDO.getString("headsculpture"));
                evalObjInfo.setPhone(oldEvalObjDO.getString("telephone"));
                evalObjInfo.setEmail(oldEvalObjDO.getString("email"));
                evalObjInfo.setGender(oldEvalObjDO.getString("gender"));
                evalObjInfo.setBirthday(oldEvalObjDO.getDate("birthday"));
                evalObjInfo.setAge(oldEvalObjDO.getString("age"));
                evalObjInfo.setCompany(oldEvalObjDO.get("percompany"));
                evalObjInfo.setDepartment(oldEvalObjDO.get("peradminorg"));
                evalObjInfo.setPosition(oldEvalObjDO.get("perposition"));
                evalObjInfo.setStdPosition(oldEvalObjDO.get("perstdpos"));
                evalObjInfo.setJob(oldEvalObjDO.get("perjob"));
                evalObjInfo.setCadreCategory(oldEvalObjDO.get("cadrecategory"));
            }
        }
        DynamicObjectCollection objInfoEntry = evalContentDO.getDynamicObjectCollection("objinfopersubentry");
        DynamicObject objInfoDO = objInfoEntry.addNew();
        EvalObjectInfo evalObjectInfo = evalObjectDto.getEvalObjectInfo();
        objInfoDO.set("headsculpture", (Object)evalObjectInfo.getHeadPicture());
        objInfoDO.set("pernumber", (Object)evalObjectInfo.getNumber());
        objInfoDO.set("pername", evalObjectInfo.getName());
        objInfoDO.set("telephone", (Object)evalObjectInfo.getPhone());
        objInfoDO.set("email", (Object)evalObjectInfo.getEmail());
        objInfoDO.set("gender", (Object)evalObjectInfo.getGender());
        objInfoDO.set("birthday", (Object)evalObjectInfo.getBirthday());
        objInfoDO.set("age", (Object)evalObjectInfo.getAge());
        objInfoDO.set("percompany", evalObjectInfo.getCompany());
        objInfoDO.set("peradminorg", evalObjectInfo.getDepartment());
        objInfoDO.set("perposition", evalObjectInfo.getPosition());
        objInfoDO.set("perstdpos", evalObjectInfo.getStdPosition());
        objInfoDO.set("perjob", evalObjectInfo.getStdPosition());
        objInfoDO.set("perdatasource", (Object)evalObjectDto.getEvalObjType());
        objInfoDO.set("cadrecategory", evalObjectInfo.getCadreCategory());
        objInfoDO.set("depempid", (Object)evalObjectDto.getEvalObjId());
        objInfoDO.set("depempfid", (Object)evalObjectDto.getDepEmpFid());
        objInfoDO.set("id", (Object)evalObjectDto.getEvalObjEntryRowId());
        objInfoDO.set("evalobjid", (Object)evalObjectDto.getEvalObjId());
        objInfoDO.set("seq", (Object)evalObjectDto.getSeq());
    }

    private EvalBodyInfo getEvalBodyInfo(Long evalBodyId, AdjustEvalRelationDto adjustEvalRelationDto) {
        if (!adjustEvalRelationDto.getNeedEvalBody().booleanValue()) {
            return null;
        }
        return adjustEvalRelationDto.getEvalBodyInfoList().stream().filter(evalBodyInfo -> com.google.common.base.Objects.equal((Object)evalBodyInfo.getEvalBodyId(), (Object)evalBodyId)).findFirst().orElse(null);
    }

    private Map<Long, Map<String, Object>> verifyAdjustEvalRelation(List<AdjustEvalRelationDto> adjustEvalRelationDtoList) {
        Map<Long, Map<String, Object>> result;
        try {
            result = this.adjustEvalRelationDelValidate(adjustEvalRelationDtoList);
            adjustEvalRelationDtoList = this.getVerifySuccessEvalRelaDto(adjustEvalRelationDtoList, result);
            for (AdjustEvalRelationDto adjustEvalRelationDto : adjustEvalRelationDtoList) {
                List evalRelationDtoList = adjustEvalRelationDto.getEvalRelationDtoList();
                List noEvaluatorObjNameList = evalRelationDtoList.stream().filter(evalRelation -> CollectionUtils.isEmpty((Collection)evalRelation.getEvaluatorDtoList())).map(evalRelationDto -> {
                    Object name = evalRelationDto.getEvalObjectDto().getEvalObjectInfo().getName();
                    if (name instanceof String) {
                        return String.valueOf(name);
                    }
                    if (name instanceof Map) {
                        Map nameMap = (Map)name;
                        return (String)nameMap.get(RequestContext.get().getLang().name());
                    }
                    return String.valueOf(name);
                }).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(noEvaluatorObjNameList)) {
                    result.put(adjustEvalRelationDto.getEvalContentId(), (Map<String, Object>)ImmutableMap.of((Object)"success", (Object)Boolean.FALSE, (Object)"message", (Object)String.format(ResManager.loadKDString((String)"\u8bf7\u4e3a%s\u8bbe\u7f6e\u8bc4\u4ef7\u8005\u6570\u636e\u3002", (String)"EvalTaskDomainServiceImpl_2", (String)"hrmp-bes-business", (Object[])new Object[0]), Joiner.on((char)'\u3001').skipNulls().join(noEvaluatorObjNameList))));
                    continue;
                }
                List evaluatorDtoList = adjustEvalRelationDto.getEvaluatorDtoList();
                if (evaluatorDtoList.size() <= 500) continue;
                result.put(adjustEvalRelationDto.getEvalContentId(), (Map<String, Object>)ImmutableMap.of((Object)"success", (Object)Boolean.FALSE, (Object)"message", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u6d4b\u8bc4\u5185\u5bb9\u4e0b\u8bc4\u4ef7\u8005\u6570\u91cf\u5df2\u8d85500\u4e0a\u9650\uff0c\u8d85\u51fa\u90e8\u5206\u4e0d\u4f1a\u6dfb\u52a0\u3002", (String)"EvalTaskDomainServiceImpl_3", (String)"hrmp-bes-business", (Object[])new Object[0])));
            }
        }
        catch (Exception exception) {
            log.error("EvalTaskDomainServiceImpl.verifyAdjustEvalRelation error:", (Throwable)exception);
            throw exception;
        }
        return result;
    }

    private void updateOutEvaluator(List<EvaluatorDto> evaluatorDtoList, DynamicObject entryRow) {
        entryRow.set("outevaluator_tag", (Object)OuterEvalFieldUtil.handleOuterIdString(evaluatorDtoList.stream().filter(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"2")).map(EvaluatorDto::getEvaluatorId).collect(Collectors.toList())));
    }

    private void updateInEvaluator(List<EvaluatorDto> evaluatorDtoList, DynamicObject entryRow) {
        DynamicObjectCollection inevaluatorCol = entryRow.getDynamicObjectCollection("inevaluator");
        inevaluatorCol.clear();
        evaluatorDtoList.stream().filter(evaluatorDto -> HRStringUtils.equals((String)evaluatorDto.getEvaluatorType(), (String)"1")).map(EvaluatorDto::getEvaluatorId).forEach(evaluatorId -> {
            DynamicObject dynamicObject = inevaluatorCol.addNew();
            dynamicObject.set("fbasedataid_id", evaluatorId);
        });
    }

    @Override
    public Map<DeleteEvalRelationDto, String> deleteEvalRelVerify(List<DeleteEvalRelationDto> deleteEvalRelationDtoList) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)deleteEvalRelationDtoList.size());
        deleteEvalRelationDtoList.stream().collect(Collectors.groupingBy(DeleteEvalRelationDto::getDeleteType)).forEach((deleteType, list) -> {
            if (HRStringUtils.equals((String)deleteType, (String)"1")) {
                list.stream().collect(Collectors.groupingBy(DeleteEvalRelationDto::getBusinessType)).forEach((businessType, dtoList) -> {
                    if (HRStringUtils.equals((String)businessType, (String)"1")) {
                        this.doDeleteEvaluatorVerify(result, (List<DeleteEvalRelationDto>)dtoList, true);
                    }
                    if (HRStringUtils.equals((String)businessType, (String)"2")) {
                        this.doDeleteEvaluatorVerify(result, (List<DeleteEvalRelationDto>)dtoList, false);
                    }
                });
            }
            if (HRStringUtils.equals((String)deleteType, (String)"2")) {
                list.stream().collect(Collectors.groupingBy(DeleteEvalRelationDto::getBusinessType)).forEach((businessType, dtoList) -> {
                    if (HRStringUtils.equals((String)businessType, (String)"1")) {
                        this.doDeleteEvalObjVerify(result, (List<DeleteEvalRelationDto>)dtoList, true);
                    }
                    if (HRStringUtils.equals((String)businessType, (String)"2")) {
                        this.doDeleteEvalObjVerify(result, (List<DeleteEvalRelationDto>)dtoList, false);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public Map<Long, List<String>> getIncompleteEvaluator(List<Long> ids) {
        return this.trackDomainService.getIncompleteEvaluator(ids);
    }

    private void doDeleteEvaluatorVerify(Map<DeleteEvalRelationDto, String> result, List<DeleteEvalRelationDto> dtoList, boolean isSystemUser) {
        Set evaluatorIdSet = dtoList.stream().map(DeleteEvalRelationDto::getBusinessId).collect(Collectors.toSet());
        DynamicObject[] subTaskDOArr = REPOSITORY_SUB_TASK.query("evaloutsiderentryid,evalinternalper", new QFilter[]{new QFilter("taskcontentid", "in", dtoList.stream().map(DeleteEvalRelationDto::getEvalContentId).collect(Collectors.toSet())), isSystemUser ? new QFilter("evalinternalper", "in", evaluatorIdSet) : new QFilter("evaloutsiderentryid", "in", evaluatorIdSet), new QFilter("taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"C", "D"}))});
        for (DeleteEvalRelationDto deleteEvalRelationDto : dtoList) {
            String errorMsg = "";
            if (Arrays.stream(subTaskDOArr).anyMatch(dy -> {
                if (isSystemUser) {
                    return com.google.common.base.Objects.equal((Object)deleteEvalRelationDto.getBusinessId(), (Object)dy.getLong("evalinternalper.id"));
                }
                return com.google.common.base.Objects.equal((Object)deleteEvalRelationDto.getBusinessId(), (Object)dy.getLong("evaloutsiderentryid"));
            })) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005%s\u5df2\u7ecf\u8fdb\u884c\u4e86\u8bc4\u4ef7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EvalTaskDomainServiceImpl_0", (String)"hrmp-bes-business", (Object[])new Object[0]), deleteEvalRelationDto.getBusinessName());
            }
            result.put(deleteEvalRelationDto, errorMsg);
        }
    }

    private void doDeleteEvalObjVerify(Map<DeleteEvalRelationDto, String> result, List<DeleteEvalRelationDto> dtoList, boolean isSystemUser) {
        List evalContentIdList = dtoList.stream().map(DeleteEvalRelationDto::getEvalContentId).collect(Collectors.toList());
        DynamicObject[] evalTaskDOArr = REPOSITORY_TASK.query("objinfopersubentry.id,objinfopersubentry.evalobjid,objinfopersubentry.perdatasource", new QFilter[]{new QFilter("contententryentity.id", "in", evalContentIdList)});
        Function<DynamicObject, Boolean> evalObjectTypeFilter = isSystemUser ? evalObjEntryRow -> HRStringUtils.equals((String)evalObjEntryRow.getString("perdatasource"), (String)"1") : evalObjEntryRow -> HRStringUtils.equals((String)evalObjEntryRow.getString("perdatasource"), (String)"2");
        List evalObjEntryRowList = Arrays.stream(evalTaskDOArr).map(dy -> dy.getDynamicObjectCollection("contententryentity")).flatMap(Collection::stream).map(dy -> dy.getDynamicObjectCollection("objinfopersubentry")).flatMap(Collection::stream).filter(evalObjectTypeFilter::apply).collect(Collectors.toList());
        Map<Long, Long> evalObjId2EntryRowId = evalObjEntryRowList.stream().collect(Collectors.toMap(row -> row.getLong("evalobjid"), row -> row.getLong("id"), (v1, v2) -> v1));
        Map<Long, Boolean> map = this.trackDomainService.checkEvalProgress(new ArrayList<Long>(evalObjId2EntryRowId.values()));
        for (DeleteEvalRelationDto deleteEvalRelationDto : dtoList) {
            Long evalObjId = deleteEvalRelationDto.getBusinessId();
            Long entryRowId = evalObjId2EntryRowId.get(evalObjId);
            Boolean flag = map.get(entryRowId);
            String errorMsg = "";
            if (flag != null && !flag.booleanValue()) {
                errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u8bc4\u4ef7\u8fdb\u5ea6\u4e3a0\u7684\u88ab\u6d4b\u8bc4\u5bf9\u8c61\u5141\u8bb8\u5220\u9664\u3002", (String)"EvalTaskDomainServiceImpl_1", (String)"hrmp-bes-business", (Object[])new Object[0]);
                deleteEvalRelationDto.setErrorCode("101");
            }
            result.put(deleteEvalRelationDto, errorMsg);
        }
        List verifyEvaluatorDtoList = dtoList.stream().filter(dto -> HRStringUtils.isEmpty((String)((String)result.get(dto)))).collect(Collectors.toList());
        for (DeleteEvalRelationDto deleteEvalRelationDto : verifyEvaluatorDtoList) {
            List innerEvaluatorInfoList = deleteEvalRelationDto.getInnerEvaluatorInfoList();
            List outerEvaluatorInfoList = deleteEvalRelationDto.getOuterEvaluatorInfoList();
            Map<Long, Boolean> innerResult = this.checkEvaluatorAlreadyEval(deleteEvalRelationDto.getEvalContentId(), innerEvaluatorInfoList.stream().map(info -> EvalRelationConvert.getLong(info, "id")).collect(Collectors.toList()), true);
            Map<Long, Boolean> outerResult = this.checkEvaluatorAlreadyEval(deleteEvalRelationDto.getEvalContentId(), outerEvaluatorInfoList.stream().map(info -> EvalRelationConvert.getLong(info, "id")).collect(Collectors.toList()), false);
            ArrayList failNameList = new ArrayList(10);
            innerResult.forEach((id, fail) -> {
                if (fail.booleanValue()) {
                    failNameList.add(innerEvaluatorInfoList.stream().filter(info -> com.google.common.base.Objects.equal((Object)EvalRelationConvert.getLong(info, "id"), (Object)id)).map(info -> "\u201c" + EvalRelationConvert.getString(info, "name") + "\u201c").findFirst().orElse(""));
                }
            });
            outerResult.forEach((id, fail) -> {
                if (fail.booleanValue()) {
                    failNameList.add(outerEvaluatorInfoList.stream().filter(info -> com.google.common.base.Objects.equal((Object)EvalRelationConvert.getLong(info, "id"), (Object)id)).map(info -> "\u201c" + EvalRelationConvert.getString(info, "name") + "\u201c").findFirst().orElse(""));
                }
            });
            if (!CollectionUtils.isNotEmpty(failNameList)) continue;
            String errorMsg = ResManager.loadKDString((String)"%1$s\uff1a\u8bc4\u4ef7\u8005%2$s\u5df2\u6709\u8bc4\u4ef7\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"EvalTaskDomainServiceImpl_5", (String)"hrmp-bes-business", (Object[])new Object[0]);
            errorMsg = String.format(errorMsg, deleteEvalRelationDto.getBusinessName(), Joiner.on((char)'\u3001').skipNulls().join(failNameList));
            deleteEvalRelationDto.setErrorCode("102");
            result.put(deleteEvalRelationDto, errorMsg);
        }
    }

    private Map<Long, Boolean> checkEvaluatorAlreadyEval(Long contentId, List<Long> evaluatorIdList, boolean isSystemUser) {
        if (CollectionUtils.isEmpty(evaluatorIdList)) {
            return Collections.emptyMap();
        }
        DynamicObject[] subTaskDOArr = REPOSITORY_SUB_TASK.query("evaloutsiderentryid,evalinternalper", new QFilter[]{new QFilter("taskcontentid", "=", (Object)contentId), isSystemUser ? new QFilter("evalinternalper.id", "in", evaluatorIdList) : new QFilter("evaloutsiderentryid", "in", evaluatorIdList), new QFilter("taskstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"C", "D"}))});
        HashMap result = Maps.newHashMapWithExpectedSize((int)evaluatorIdList.size());
        for (Long id : evaluatorIdList) {
            boolean match = Arrays.stream(subTaskDOArr).anyMatch(dy -> {
                if (isSystemUser) {
                    return dy.getLong("evalinternalper.id") == id.longValue();
                }
                return dy.getLong("evaloutsiderentryid") == id.longValue();
            });
            result.put(id, match);
        }
        return result;
    }

    public Map<Long, Map<String, Object>> adjustEvalRelationDelValidate(List<AdjustEvalRelationDto> adjustEvalRelationDtoList) {
        HashMap validateResult = Maps.newHashMapWithExpectedSize((int)adjustEvalRelationDtoList.size());
        Map<Long, List<AdjustEvalRelationDto>> adjustContentMap = adjustEvalRelationDtoList.stream().collect(Collectors.groupingBy(AdjustEvalRelationDto::getEvalContentId));
        List<Long> evalTaskIdList = adjustEvalRelationDtoList.stream().map(AdjustEvalRelationDto::getEvalTaskId).collect(Collectors.toList());
        Map<Long, Map<Long, Long>> depEmpId2EntryRowId = this.getEvalObjDepEmpId2EntryRowId(evalTaskIdList);
        Map<Long, List<DynamicObject>> evalObjPerMap = this.trackDomainService.getEvalObjPerByEvalTaskId(evalTaskIdList);
        Map<Long, List<DynamicObject>> evaluatorRealMap = this.trackDomainService.getEvaluatorPerByEvalTaskId(evalTaskIdList);
        for (Map.Entry<Long, List<AdjustEvalRelationDto>> adjustRelationContentEntry : adjustContentMap.entrySet()) {
            Map<Boolean, List<EvalObjectDto>> curContentAdjustEvalRelationPar;
            List<Long> allAdjustEvalObjIdList;
            boolean evalObjValidateSuccess;
            Long contentId = adjustRelationContentEntry.getKey();
            List<DynamicObject> dbEvalObjPer = evalObjPerMap.get(contentId);
            List<AdjustEvalRelationDto> curContentAdjustEvalRelationList = adjustRelationContentEntry.getValue();
            if (CollectionUtils.isEmpty(dbEvalObjPer) || !(evalObjValidateSuccess = this.validCurContentEvalObj(validateResult, contentId, dbEvalObjPer, allAdjustEvalObjIdList = this.getAllAdjustEvalObjIdList(depEmpId2EntryRowId, contentId, dbEvalObjPer, curContentAdjustEvalRelationPar = curContentAdjustEvalRelationList.stream().map(AdjustEvalRelationDto::getEvalRelationDtoList).flatMap(Collection::stream).map(EvalRelationDto::getEvalObjectDto).collect(Collectors.partitioningBy(obj -> "1".equals(obj.getEvalObjType()))))))) continue;
            List<DynamicObject> dbEvaluatorRealList = evaluatorRealMap.get(contentId);
            Map<Boolean, List<EvaluatorDto>> curContentAdjustEvaluatorRelaPar = curContentAdjustEvalRelationList.stream().map(AdjustEvalRelationDto::getEvalRelationDtoList).flatMap(Collection::stream).map(EvalRelationDto::getEvaluatorDtoList).flatMap(Collection::stream).collect(Collectors.partitioningBy(obj -> "1".equals(obj.getEvaluatorType())));
            this.validCurContentEvaluator(validateResult, contentId, dbEvaluatorRealList, curContentAdjustEvaluatorRelaPar);
        }
        return validateResult;
    }

    private void validCurContentEvaluator(Map<Long, Map<String, Object>> validateResult, Long contentId, List<DynamicObject> dbEvaluatorRealList, Map<Boolean, List<EvaluatorDto>> curContentAdjustEvaluatorRelaPar) {
        List evaluatorEmpDtoList = curContentAdjustEvaluatorRelaPar.getOrDefault(Boolean.TRUE, Collections.emptyList());
        List evaluatorOutDtoList = curContentAdjustEvaluatorRelaPar.getOrDefault(Boolean.FALSE, Collections.emptyList());
        if (CollectionUtils.isNotEmpty(dbEvaluatorRealList)) {
            List<DynamicObject> empEvaluatorObjList = dbEvaluatorRealList.stream().filter(obj -> "1".equals(obj.getString("evaluatorsource"))).collect(Collectors.toList());
            Map<Long, Integer> adjustEmployeeCountMap = evaluatorEmpDtoList.stream().collect(Collectors.groupingBy(EvaluatorDto::getEvaluatorId, Collectors.collectingAndThen(Collectors.toList(), List::size)));
            HashMap curContentResult = Maps.newHashMapWithExpectedSize((int)2);
            validateResult.put(contentId, curContentResult);
            this.evaluatorDelValidate(empEvaluatorObjList, adjustEmployeeCountMap, curContentResult, "evalinternalper.id");
            List<DynamicObject> outEvaluatorObjList = dbEvaluatorRealList.stream().filter(obj -> "2".equals(obj.getString("evaluatorsource"))).collect(Collectors.toList());
            Map<Long, Integer> adjustOutCountMap = evaluatorOutDtoList.stream().collect(Collectors.groupingBy(EvaluatorDto::getEvaluatorId, Collectors.collectingAndThen(Collectors.toList(), List::size)));
            this.evaluatorDelValidate(outEvaluatorObjList, adjustOutCountMap, curContentResult, "evaloutsiderentryid");
        }
    }

    private void evaluatorDelValidate(List<DynamicObject> realEvaluatorList, Map<Long, Integer> adjustCountMap, Map<String, Object> curContentResult, String evaluatorKey) {
        for (DynamicObject realEvaluator : realEvaluatorList) {
            int completeEvalNum;
            long evaluatorId = realEvaluator.getLong(evaluatorKey);
            int totalEvalNum = realEvaluator.getInt("totalevalnum");
            Integer adjustEvaluatorNum = adjustCountMap.get(evaluatorId);
            if (adjustEvaluatorNum != null && adjustEvaluatorNum >= totalEvalNum || (completeEvalNum = realEvaluator.getInt("completeevalnum")) == 0) continue;
            String evaluatorTip = String.format(ResManager.loadKDString((String)"\u8bc4\u4ef7\u8005%s\u5df2\u7ecf\u8fdb\u884c\u4e86\u8bc4\u4ef7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EvalTaskDomainServiceImpl_0", (String)"hrmp-bes-business", (Object[])new Object[0]), realEvaluator.getString("evaloroutname"));
            this.markError(curContentResult, evaluatorTip, "101");
            break;
        }
    }

    private boolean validCurContentEvalObj(Map<Long, Map<String, Object>> validateResult, Long contentId, List<DynamicObject> dbEvalObjPer, List<Long> allAdjustEvalObjIdList) {
        boolean evalObjValidateSuccess = true;
        HashMap curContentResult = Maps.newHashMapWithExpectedSize((int)2);
        validateResult.put(contentId, curContentResult);
        for (DynamicObject dbEvalObj : dbEvalObjPer) {
            int completeEvalNum;
            long evalObjPerId = dbEvalObj.getLong("objinfoperentryid");
            if (allAdjustEvalObjIdList.contains(evalObjPerId) || (completeEvalNum = dbEvalObj.getInt("completeevalnum")) == 0) continue;
            String evalObjTip = ResManager.loadKDString((String)"\u53ea\u6709\u8bc4\u4ef7\u8fdb\u5ea6\u4e3a0\u7684\u88ab\u6d4b\u8bc4\u5bf9\u8c61\u5141\u8bb8\u5220\u9664\u3002", (String)"EvalTaskDomainServiceImpl_1", (String)"hrmp-bes-business", (Object[])new Object[0]);
            this.markError(curContentResult, evalObjTip, "102");
            evalObjValidateSuccess = false;
            break;
        }
        this.markSuccess(curContentResult);
        return evalObjValidateSuccess;
    }

    private void markError(Map<String, Object> curContentResult, String evalObjTip, String errCode) {
        curContentResult.put("success", Boolean.FALSE);
        curContentResult.put("message", evalObjTip);
        curContentResult.put("errorCode", errCode);
    }

    private void markSuccess(Map<String, Object> curContentResult) {
        if (MapUtils.isEmpty(curContentResult)) {
            curContentResult.put("success", Boolean.TRUE);
            curContentResult.put("message", "");
        }
    }

    private List<Long> getAllAdjustEvalObjIdList(Map<Long, Map<Long, Long>> depEmpId2EntryRowId, Long contentId, List<DynamicObject> dbEvalObjPer, Map<Boolean, List<EvalObjectDto>> curContentAdjustEvalRelationPar) {
        List<EvalObjectDto> outEvalObjDtoList;
        ArrayList allAdjustEvalObjIdList = Lists.newArrayListWithExpectedSize((int)dbEvalObjPer.size());
        List<EvalObjectDto> depEmpEvalObjDtoList = curContentAdjustEvalRelationPar.get(Boolean.TRUE);
        Map<Long, Long> depEmpEvalObjEntryIdMap = depEmpId2EntryRowId.get(contentId);
        if (CollectionUtils.isNotEmpty(depEmpEvalObjDtoList) && MapUtils.isNotEmpty(depEmpEvalObjEntryIdMap)) {
            List depEmpEvalObjEntryIds = depEmpEvalObjDtoList.stream().map(obj -> {
                Long depEmpFid = obj.getEvalObjId();
                return (Long)depEmpEvalObjEntryIdMap.get(depEmpFid);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            allAdjustEvalObjIdList.addAll(depEmpEvalObjEntryIds);
        }
        if (CollectionUtils.isNotEmpty(outEvalObjDtoList = curContentAdjustEvalRelationPar.get(Boolean.FALSE))) {
            List outEvalObjEntryIds = outEvalObjDtoList.stream().map(EvalObjectDto::getEvalObjId).collect(Collectors.toList());
            allAdjustEvalObjIdList.addAll(outEvalObjEntryIds);
        }
        return allAdjustEvalObjIdList;
    }

    private Map<Long, Map<Long, Long>> getEvalObjDepEmpId2EntryRowId(List<Long> evalTaskIdList) {
        DynamicObject[] evalTaskDOArr = REPOSITORY_TASK.query("objinfopersubentry.id,objinfopersubentry.depempid,objinfopersubentry.perdatasource", new QFilter[]{new QFilter("id", "in", evalTaskIdList)});
        HashMap<Long, Map<Long, Long>> contentEvalObjMap = new HashMap<Long, Map<Long, Long>>(16);
        for (DynamicObject evalTaskObj : evalTaskDOArr) {
            DynamicObjectCollection contentEntry = evalTaskObj.getDynamicObjectCollection("contententryentity");
            for (DynamicObject contentObj : contentEntry) {
                List contentEvalObjEntryRowList = contentObj.getDynamicObjectCollection("objinfopersubentry").stream().filter(dy -> HRStringUtils.equals((String)dy.getString("perdatasource"), (String)"1")).collect(Collectors.toList());
                Map<Long, Long> curContentDepEmpEntryIdMap = contentEvalObjEntryRowList.stream().collect(Collectors.toMap(row -> row.getLong("depempid"), row -> row.getLong("id"), (v1, v2) -> v1));
                contentEvalObjMap.put(contentObj.getLong("id"), curContentDepEmpEntryIdMap);
            }
        }
        return contentEvalObjMap;
    }
}

