/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.login;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.hr.web.vo.HrUserContext;
import kd.bos.ext.hr.web.vo.HrUserVO;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskComValidatorService;
import kd.hrmp.bes.business.domain.login.LoginBizParamDomainService;

public class LoginEvalInfoServiceHelper {
    public static final HRBaseServiceHelper EVAL_TASK_REPOSITORY = new HRBaseServiceHelper("bes_evaltask");
    private static final EvalTaskComValidatorService EVAL_TASK_COM_VALIDATOR_SERVICE = new EvalTaskComValidatorService();
    private static final Log LOG = LogFactory.getLog(LoginEvalInfoServiceHelper.class);

    private static Map<String, Object> getPersonModelId() {
        return (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
    }

    public static void handleCustomParam(PreOpenFormEventArgs preOpenFormEventArgs) {
        DynamicObject loginBizParamDO;
        Object bizCustomParamId;
        boolean result = LoginEvalInfoServiceHelper.verifyLinkParameter(preOpenFormEventArgs);
        if (!result) {
            return;
        }
        FormShowParameter showParameter = preOpenFormEventArgs.getFormShowParameter();
        Object ispoxyrecord = showParameter.getCustomParam("ispoxyrecord");
        if (ispoxyrecord != null && HRStringUtils.equals((String)((String)showParameter.getCustomParam("ispoxyrecord")), (String)"1")) {
            return;
        }
        Object urlTypeObj = showParameter.getCustomParam("urlType");
        if (urlTypeObj != null && HRStringUtils.equals((String)urlTypeObj.toString(), (String)"1")) {
            Object taskId = showParameter.getCustomParam("taskId");
            Object contentId = showParameter.getCustomParam("contentId");
            if (taskId == null || contentId == null) {
                LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObject evalTaskDO = EVAL_TASK_REPOSITORY.queryOne(taskId);
            Optional<DynamicObject> contentOp = evalTaskDO.getDynamicObjectCollection("contententryentity").stream().filter(content -> content.getLong("id") == Long.parseLong(contentId.toString())).findFirst();
            if (!contentOp.isPresent()) {
                return;
            }
            DynamicObject contentDO = contentOp.get();
            if (HRStringUtils.equals((String)evalTaskDO.getString("realorcryptonym"), (String)"1") && HRStringUtils.equals((String)contentDO.getString("specificevaluator"), (String)"10")) {
                HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"bes_trackevaluatorreal");
                DynamicObject dynamicObject = serviceHelper.queryOriginalOne("evalinternalper,evalbody", new QFilter[]{new QFilter("evaltask", "=", (Object)Long.parseLong(taskId.toString())), new QFilter("taskcontentid", "=", (Object)Long.parseLong(contentId.toString())), new QFilter("user", "=", (Object)currUserId)});
                if (dynamicObject != null) {
                    showParameter.setCustomParam("employeeId", (Object)dynamicObject.getLong("evalinternalper"));
                    showParameter.setCustomParam("evalbodyId", (Object)dynamicObject.getLong("evalbody"));
                }
            } else {
                long userEmployeeId = LoginEvalInfoServiceHelper.getUserEmployeeId();
                if (HRStringUtils.equals((String)contentDO.getString("specificevaluator"), (String)"10")) {
                    showParameter.setCustomParam("employeeId", (Object)userEmployeeId);
                } else if (userEmployeeId != 0L) {
                    showParameter.setCustomParam("employeeId", (Object)userEmployeeId);
                }
            }
        }
        if ((bizCustomParamId = showParameter.getCustomParam("bizCustomParam")) != null && (loginBizParamDO = LoginBizParamDomainService.getInstance().queryOne(bizCustomParamId)) != null) {
            String evaluatorType = loginBizParamDO.getString("evaluatortype");
            if (HRStringUtils.equals((String)evaluatorType, (String)"2")) {
                HrUserVO hrUserVO = HrUserContext.get();
                showParameter.setCustomParam("evaluatorid", (Object)hrUserVO.getRealBizUserId());
            }
            if (HRStringUtils.equals((String)evaluatorType, (String)"1")) {
                long userEmployeeId = LoginEvalInfoServiceHelper.getUserEmployeeId();
                showParameter.setCustomParam("evaluatorid", (Object)userEmployeeId);
            }
        }
    }

    public static boolean verifyLinkParameter(PreOpenFormEventArgs preOpenFormEventArgs) {
        boolean result;
        FormShowParameter showParameter = preOpenFormEventArgs.getFormShowParameter();
        Object ispoxyrecord = showParameter.getCustomParam("ispoxyrecord");
        if (ispoxyrecord != null && HRStringUtils.equals((String)((String)showParameter.getCustomParam("ispoxyrecord")), (String)"1")) {
            return true;
        }
        Object imitate = showParameter.getCustomParam("imitate");
        if (imitate != null && HRStringUtils.equals((String)((String)showParameter.getCustomParam("imitate")), (String)"1")) {
            return true;
        }
        if (LoginEvalInfoServiceHelper.checkIsFormEvalTaskReal(showParameter)) {
            return true;
        }
        Object urlTypeObj = showParameter.getCustomParam("urlType");
        Object bizCustomParamObj = showParameter.getCustomParam("bizCustomParam");
        if (Objects.nonNull(urlTypeObj)) {
            String urlType = String.valueOf(urlTypeObj);
            if (!HRStringUtils.equals((String)urlType, (String)"1")) {
                result = false;
                LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
            } else {
                try {
                    long evalTaskId = Long.parseLong((String)showParameter.getCustomParam("taskId"));
                    long contentId = Long.parseLong((String)showParameter.getCustomParam("contentId"));
                    DynamicObject evalTaskDO = EVAL_TASK_REPOSITORY.queryOne("contententryentity", (Object)evalTaskId);
                    if (evalTaskDO != null && !evalTaskDO.getDynamicObjectCollection("contententryentity").stream().noneMatch(dy -> dy.getLong("id") == contentId)) {
                        return true;
                    }
                    result = false;
                    LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                }
                catch (NumberFormatException exception) {
                    result = false;
                    LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                }
                catch (Exception exception) {
                    LOG.warn("LoginEvalInfoServiceHelper.verifyLinkParameter_1 error: ", (Throwable)exception);
                    result = false;
                    LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                }
            }
        } else if (Objects.nonNull(bizCustomParamObj)) {
            try {
                long bizParam = Long.parseLong(String.valueOf(bizCustomParamObj));
                boolean exists = LoginBizParamDomainService.REPOSITORY.isExists((Object)bizParam);
                if (exists) {
                    return true;
                }
                LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                result = false;
            }
            catch (NumberFormatException exception) {
                LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
                result = false;
            }
            catch (Exception exception) {
                LOG.warn("LoginEvalInfoServiceHelper.verifyLinkParameter_2 error: ", (Throwable)exception);
                result = false;
                LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
            }
        } else {
            LoginEvalInfoServiceHelper.validateFail(preOpenFormEventArgs);
            result = false;
        }
        return result;
    }

    private static boolean checkIsFormEvalTaskReal(FormShowParameter showParameter) {
        Object formevaltaskreal = showParameter.getCustomParam("formevaltaskreal");
        return formevaltaskreal != null && HRStringUtils.equals((String)((String)showParameter.getCustomParam("formevaltaskreal")), (String)"true");
    }

    private static void validateFail(PreOpenFormEventArgs preOpenFormEventArgs) {
        preOpenFormEventArgs.setCancel(true);
        preOpenFormEventArgs.setCancelMessage("Illegal link parameter");
    }

    public static boolean isOneUrlManyPersonMode(FormShowParameter showParameter) {
        Object urlTypeObj = showParameter.getCustomParam("urlType");
        if (urlTypeObj == null) {
            return false;
        }
        return HRStringUtils.equals((String)urlTypeObj.toString(), (String)"1");
    }

    public static boolean handleTaskStatusValidate(IFormView formView, BiConsumer<IFormView, String> consumer) {
        String errorMsg;
        Object bizCustomParamId = formView.getFormShowParameter().getCustomParam("bizCustomParam");
        DynamicObject dynamicObject = LoginBizParamDomainService.getInstance().queryOne(bizCustomParamId);
        Object evalTaskId = dynamicObject != null ? Long.valueOf(dynamicObject.getLong("evaltaskid")) : formView.getFormShowParameter().getCustomParam("taskId");
        if (evalTaskId == null || Long.parseLong(evalTaskId.toString()) == 0L) {
            return false;
        }
        DynamicObject evalTaskDO = EVAL_TASK_REPOSITORY.queryOne(evalTaskId);
        if (evalTaskDO == null) {
            return false;
        }
        String realorcryptonym = evalTaskDO.getString("realorcryptonym");
        String evaltaskstatus = evalTaskDO.getString("evaltaskstatus");
        if (!(HRStringUtils.equals((String)realorcryptonym, (String)"1") && HRStringUtils.equals((String)evaltaskstatus, (String)"E") || !HRStringUtils.isNotEmpty((String)(errorMsg = EVAL_TASK_COM_VALIDATOR_SERVICE.validatorTaskStatus(Long.parseLong(evalTaskId.toString())))))) {
            consumer.accept(formView, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean handleEvaluatorValidate(IFormView formView, BiConsumer<IFormView, String> consumer) {
        FormShowParameter showParameter = formView.getFormShowParameter();
        boolean isOneUrlManyPersonMode = LoginEvalInfoServiceHelper.isOneUrlManyPersonMode(showParameter);
        Object ispoxyrecord = showParameter.getCustomParam("ispoxyrecord");
        if (ispoxyrecord != null && HRStringUtils.equals((String)((String)showParameter.getCustomParam("ispoxyrecord")), (String)"1")) {
            return true;
        }
        boolean result = true;
        if (isOneUrlManyPersonMode) {
            Object employeeId = showParameter.getCustomParam("employeeId");
            if (employeeId == null) {
                result = false;
            }
        } else {
            Object bizCustomParam = showParameter.getCustomParam("bizCustomParam");
            DynamicObject bizCustomParamDO = LoginBizParamDomainService.getInstance().queryOne(bizCustomParam);
            if (bizCustomParamDO != null) {
                String realOrAnony = bizCustomParamDO.getString("realoranony");
                String evaluatorType = bizCustomParamDO.getString("evaluatortype");
                if (HRStringUtils.equals((String)realOrAnony, (String)"1")) {
                    Object evaluatorId;
                    long employeeId;
                    if (HRStringUtils.equals((String)evaluatorType, (String)"1") && (employeeId = LoginEvalInfoServiceHelper.getUserEmployeeId()) != bizCustomParamDO.getLong("evaluatorid")) {
                        LOG.info("LoginEvalInfoServiceHelper.verifyEvaluator false loginEmployee:{} originEmployee:{}", (Object)employeeId, (Object)bizCustomParamDO.getLong("evaluatorid"));
                        result = false;
                    }
                    if (HRStringUtils.equals((String)evaluatorType, (String)"2") && (evaluatorId = showParameter.getCustomParam("evaluatorid")) == null) {
                        LOG.info("LoginEvalInfoServiceHelper.verifyEvaluator outEvaluator not find");
                        result = false;
                    }
                } else {
                    Object evaluatorId;
                    long evalContentId = bizCustomParamDO.getLong("evalcontentid");
                    DynamicObject evalTaskDO = EVAL_TASK_REPOSITORY.queryOne("anonmode", new QFilter("contententryentity.id", "=", (Object)evalContentId).toArray());
                    DynamicObject evalContentDO = evalTaskDO.getDynamicObjectCollection("contententryentity").stream().filter(content -> evalContentId == content.getLong("id")).findFirst().orElse(null);
                    if (evalContentDO != null && HRStringUtils.equals((String)evalContentDO.getString("anonmode"), (String)"10") && (evaluatorId = showParameter.getCustomParam("evaluatorid")) == null) {
                        LOG.info("LoginEvalInfoServiceHelper.verifyEvaluator anonymousNeedLogin not evaluator");
                        result = false;
                    }
                }
            }
        }
        if (!result) {
            consumer.accept(formView, ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u6ca1\u6709\u627e\u5230\u60a8\u7684\u8bc4\u4ef7\u4efb\u52a1\u3002", (String)"LoginEvalInfoServiceHelper_0", (String)"hrmp-bes-business", (Object[])new Object[0]));
        }
        return result;
    }

    private static long getUserEmployeeId() {
        Map<String, Object> personModelId = LoginEvalInfoServiceHelper.getPersonModelId();
        if (CollectionUtils.isEmpty(personModelId)) {
            return 0L;
        }
        Object data = personModelId.get("data");
        if (data == null) {
            return 0L;
        }
        Map dataMap = (Map)data;
        Object employee = dataMap.get("employee");
        if (employee == null) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(employee));
    }
}

