/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.login;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class LoginServiceHelper {
    private static final List<String> BROWSER_LIST = new ArrayList<String>(46);

    public static void resetOpenForm(PreOpenFormEventArgs preOpenFormEventArgs, FormShowParameter showParameter) {
        LoginServiceHelper.resetOpenForm(preOpenFormEventArgs, showParameter, RequestContext.get());
    }

    public static void resetOpenForm(PreOpenFormEventArgs preOpenFormEventArgs, FormShowParameter showParameter, RequestContext requestContext) {
        boolean loginIsByPhone;
        Objects.requireNonNull(preOpenFormEventArgs);
        Objects.requireNonNull(showParameter);
        if (requestContext == null) {
            requestContext = RequestContext.get();
        }
        if (loginIsByPhone = LoginServiceHelper.getLoginIsByPhone(requestContext)) {
            if (LoginServiceHelper.isMobileForm(showParameter)) {
                FormShowParameter formShowParameter = preOpenFormEventArgs.getFormShowParameter();
                formShowParameter.setFormId(showParameter.getFormId());
            }
        } else if (!LoginServiceHelper.isMobileForm(showParameter)) {
            FormShowParameter formShowParameter = preOpenFormEventArgs.getFormShowParameter();
            formShowParameter.setFormId(showParameter.getFormId());
        }
    }

    private static boolean isMobileForm(FormShowParameter showParameter) {
        return showParameter instanceof MobileFormShowParameter || showParameter instanceof MobileBillShowParameter;
    }

    private static boolean getLoginIsByPhone(RequestContext requestContext) {
        String userAgent = requestContext.getUserAgent();
        if (userAgent == null) {
            return false;
        }
        userAgent = userAgent.replaceAll("(^|;|\\s*)deviceName\\s*:[^;]*(;|$)", ";");
        return (userAgent = userAgent.toLowerCase(Locale.ENGLISH)).contains("iphone") || userAgent.contains("android") || LoginServiceHelper.isMobile(requestContext);
    }

    private static boolean isMobile(RequestContext requestContext) {
        String userAgent = requestContext.getUserAgent();
        if (HRStringUtils.isEmpty((String)userAgent)) {
            return false;
        }
        if (LoginServiceHelper.isMobile(userAgent, BROWSER_LIST)) {
            return true;
        }
        String tenantId = requestContext.getTenantId();
        String customAgent = SystemPropertyUtils.getProptyByTenant((String)"custom_mobile_browser_agent", (String)tenantId);
        if (StringUtils.isNotEmpty((String)customAgent)) {
            String[] customArray = customAgent.trim().split(",");
            return LoginServiceHelper.isMobile(userAgent, Arrays.asList(customArray));
        }
        return false;
    }

    private static boolean isMobile(String userAgent, List<String> bList) {
        boolean isMobile = false;
        if (userAgent != null && bList != null && bList.size() > 0) {
            for (String s : bList) {
                if (!userAgent.contains(s)) continue;
                isMobile = true;
                break;
            }
        }
        return isMobile;
    }

    static {
        BROWSER_LIST.add("android");
        BROWSER_LIST.add("iphone");
        BROWSER_LIST.add("ipad");
        BROWSER_LIST.add("ipod");
        BROWSER_LIST.add("nokia");
        BROWSER_LIST.add("samsung");
        BROWSER_LIST.add("midp-2");
        BROWSER_LIST.add("cldc1.1");
        BROWSER_LIST.add("symbianos");
        BROWSER_LIST.add("maui");
        BROWSER_LIST.add("untrusted/1.0");
        BROWSER_LIST.add("windows ce");
        BROWSER_LIST.add("blackberry");
        BROWSER_LIST.add("ucweb");
        BROWSER_LIST.add("brew");
        BROWSER_LIST.add("j2me");
        BROWSER_LIST.add("yulong");
        BROWSER_LIST.add("coolpad");
        BROWSER_LIST.add("tianyu");
        BROWSER_LIST.add("ty-");
        BROWSER_LIST.add("k-touch");
        BROWSER_LIST.add("haier");
        BROWSER_LIST.add("dopod");
        BROWSER_LIST.add("lenovo");
        BROWSER_LIST.add("mobile");
        BROWSER_LIST.add("huaqin");
        BROWSER_LIST.add("aigo-");
        BROWSER_LIST.add("ctc/1.0");
        BROWSER_LIST.add("ctc/2.0");
        BROWSER_LIST.add("cmcc");
        BROWSER_LIST.add("daxian");
        BROWSER_LIST.add("mot-");
        BROWSER_LIST.add("sonyericsson");
        BROWSER_LIST.add("gionee");
        BROWSER_LIST.add("htc");
        BROWSER_LIST.add("zte");
        BROWSER_LIST.add("huawei");
        BROWSER_LIST.add("webos");
        BROWSER_LIST.add("gobrowser");
        BROWSER_LIST.add("iemobile");
        BROWSER_LIST.add("wap2.0");
        BROWSER_LIST.add("ucbrowser");
        BROWSER_LIST.add("mi 6 build");
        BROWSER_LIST.add("vivo");
        BROWSER_LIST.add("symbianos");
        BROWSER_LIST.add("nokia5700");
    }
}

