/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.login.link;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.login.LoginBizParamDomainService;
import kd.hrmp.bes.business.domain.login.link.bo.AnonyEvalLinkParam;
import kd.hrmp.bes.business.domain.login.link.bo.GenEvalLinkParam;
import kd.hrmp.bes.business.domain.login.link.bo.RealEvalLinkParam;
import kd.hrmp.bes.common.enums.EvaluatorType;

public class EvalLinkService {
    private static final String DEFAULT_LINK = "";
    private static final Log LOG = LogFactory.getLog(EvalLinkService.class);
    private static final EvalLinkService INSTANCE = new EvalLinkService();

    public static EvalLinkService getInstance() {
        return INSTANCE;
    }

    private String getLinkSystemPrefix() {
        String domainContextUrl = UrlService.getDomainContextUrl();
        if (HRStringUtils.isNotEmpty((String)domainContextUrl) && domainContextUrl.endsWith("/")) {
            return domainContextUrl.substring(0, domainContextUrl.length() - 1);
        }
        return domainContextUrl;
    }

    public String genEvalLink(GenEvalLinkParam genEvalLinkParam) {
        String result = DEFAULT_LINK;
        LOG.info("EvalLinkService.genEvalLink param:{}", (Object)genEvalLinkParam);
        try {
            if (genEvalLinkParam instanceof RealEvalLinkParam) {
                result = this.genRealEvalLink((RealEvalLinkParam)genEvalLinkParam);
            }
            if (genEvalLinkParam instanceof AnonyEvalLinkParam) {
                result = this.genAnonyEvalLink((AnonyEvalLinkParam)genEvalLinkParam);
            }
            LOG.info("EvalLinkService.genEvalLink result:{}", (Object)result);
        }
        catch (Exception exception) {
            LOG.error("EvalLinkService.genEvalLink error: ", (Throwable)exception);
        }
        return result;
    }

    private String genRealEvalLink(RealEvalLinkParam realEvalLinkParam) {
        String url;
        String result = DEFAULT_LINK;
        EvaluatorType evaluatorType = realEvalLinkParam.getEvaluatorType();
        Boolean hasEvaluator = realEvalLinkParam.getHasEvaluator();
        String urlType = realEvalLinkParam.getUrlSource();
        if (hasEvaluator == null || !hasEvaluator.booleanValue() || evaluatorType == EvaluatorType.SYSTEM_IN) {
            if (HRStringUtils.equals((String)urlType, (String)"1")) {
                String url2 = this.isMobile(realEvalLinkParam) ? "{0}/mobile.html?form={1}&taskId={2}&contentId={3}&urlType={4}" : "{0}/index.html?formId={1}&taskId={2}&contentId={3}&urlType={4}";
                result = MessageFormat.format(url2, this.getLinkSystemPrefix(), this.getFormId(realEvalLinkParam), realEvalLinkParam.getEvalTaskId(), realEvalLinkParam.getEvalContentId(), urlType);
                return result;
            }
            url = this.isMobile(realEvalLinkParam) ? "{0}/mobile.html?form={1}&bizCustomParam={2}" : "{0}/index.html?formId={1}&bizCustomParam={2}";
            result = MessageFormat.format(url, this.getLinkSystemPrefix(), this.getFormId(realEvalLinkParam), this.getBizCustomParam(realEvalLinkParam));
        }
        if (evaluatorType == EvaluatorType.SYSTEM_OUT) {
            if (HRStringUtils.equals((String)urlType, (String)"1")) {
                url = "{0}/mobile.html?accountId={1}&loginConfigNumber={2}&bizUserId={3}&bizCustomParam={4}";
                String bizCustomParam = this.getBizCustomParam(realEvalLinkParam);
                String realUrl = MessageFormat.format(url, this.getLinkSystemPrefix(), RequestContext.get().getAccountId(), realEvalLinkParam.getLoginConfigNumber(), realEvalLinkParam.getEvalContentId(), bizCustomParam);
                SafeUrlDTO safeUrlDTO = this.getShortUrlByArgReal(String.valueOf(realEvalLinkParam.getEvalTaskId()), realUrl);
                result = safeUrlDTO == null ? DEFAULT_LINK : safeUrlDTO.getSafeUrl();
            } else {
                url = "{0}/mobile.html?accountId={1}&loginConfigNumber={2}&bizUserId={3}&bizCustomParam={4}";
                String bizCustomParam = this.getBizCustomParam(realEvalLinkParam);
                String realUrl = MessageFormat.format(url, this.getLinkSystemPrefix(), RequestContext.get().getAccountId(), realEvalLinkParam.getLoginConfigNumber(), realEvalLinkParam.getEvaluatorId(), bizCustomParam);
                SafeUrlDTO safeUrlDTO = this.getShortUrl(String.valueOf(realEvalLinkParam.getEvalTaskId()), realUrl);
                result = safeUrlDTO == null ? DEFAULT_LINK : safeUrlDTO.getSafeUrl();
            }
        }
        return result;
    }

    private boolean isMobile(GenEvalLinkParam genEvalLinkParam) {
        if (genEvalLinkParam == null || genEvalLinkParam.getOpenFormType() == null) {
            return false;
        }
        return HRStringUtils.equals((String)genEvalLinkParam.getOpenFormType(), (String)"2");
    }

    private String getFormId(GenEvalLinkParam genEvalLinkParam) {
        String formId = this.isMobile(genEvalLinkParam) ? genEvalLinkParam.getMobilePage() : genEvalLinkParam.getPcPage();
        return formId;
    }

    private String getBizCustomParam(GenEvalLinkParam genEvalLinkParam) {
        return LoginBizParamDomainService.getInstance().saveBizParam(genEvalLinkParam);
    }

    private SafeUrlDTO getShortUrl(String evalTaskId, String realUrl) {
        Object urlDetail = DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{realUrl});
        if (urlDetail instanceof SafeUrlDTO && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getSafeUrl()) && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getOriginUrl())) {
            return (SafeUrlDTO)urlDetail;
        }
        return (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShort", (Object[])new Object[]{realUrl, HRDateTimeUtils.getSysMaxDate(), evalTaskId});
    }

    private SafeUrlDTO getShortUrlByArgReal(String evalTaskId, String realUrl) {
        Object urlDetail = DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{realUrl});
        if (urlDetail instanceof SafeUrlDTO && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getSafeUrl()) && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getOriginUrl())) {
            return (SafeUrlDTO)urlDetail;
        }
        ImmutableMap param = ImmutableMap.of((Object)"loginType", (Object)"1", (Object)"batch", (Object)true, (Object)"language", (Object)(RequestContext.get().getLang() == null ? "zh_CN" : RequestContext.get().getLang().toString()));
        return (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByArg", (Object[])new Object[]{realUrl, HRDateTimeUtils.getSysMaxDate(), evalTaskId, param});
    }

    private String genAnonyEvalLink(AnonyEvalLinkParam anonyEvalLinkParam) {
        String result;
        Boolean hasEvaluator = anonyEvalLinkParam.getHasEvaluator();
        Objects.requireNonNull(hasEvaluator);
        if (!hasEvaluator.booleanValue()) {
            String url = "{0}/mobile.html?userId=Guest&form={1}&bizCustomParam={2}&accountId={3}";
            result = MessageFormat.format(url, this.getLinkSystemPrefix(), anonyEvalLinkParam.getMobilePage(), this.getBizCustomParam(anonyEvalLinkParam), RequestContext.get().getAccountId());
        } else {
            Boolean needLogin = anonyEvalLinkParam.getNeedLogin();
            Objects.requireNonNull(needLogin);
            if (!needLogin.booleanValue()) {
                String url = "{0}/mobile.html?userId=Guest&form={1}&bizCustomParam={2}&accountId={3}";
                result = MessageFormat.format(url, this.getLinkSystemPrefix(), anonyEvalLinkParam.getMobilePage(), this.getBizCustomParam(anonyEvalLinkParam), RequestContext.get().getAccountId());
            } else {
                String url = "{0}/mobile.html?accountId={1}&loginConfigNumber={2}&bizUserId={3}&bizCustomParam={4}";
                String bizCustomParam = this.getBizCustomParam(anonyEvalLinkParam);
                String realUrl = MessageFormat.format(url, this.getLinkSystemPrefix(), RequestContext.get().getAccountId(), anonyEvalLinkParam.getLoginConfigNumber(), bizCustomParam, bizCustomParam);
                SafeUrlDTO safeUrlDTO = this.getShortUrlByArgAnonymous(String.valueOf(anonyEvalLinkParam.getEvalTaskId()), realUrl);
                result = safeUrlDTO == null ? DEFAULT_LINK : safeUrlDTO.getSafeUrl();
            }
        }
        return result;
    }

    private SafeUrlDTO getShortUrlByArgAnonymous(String evalTaskId, String url) {
        Object urlDetail = DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"getLongUrlDetail", (Object[])new Object[]{url});
        if (urlDetail instanceof SafeUrlDTO && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getSafeUrl()) && HRStringUtils.isNotEmpty((String)((SafeUrlDTO)urlDetail).getOriginUrl())) {
            return (SafeUrlDTO)urlDetail;
        }
        ImmutableMap param = ImmutableMap.of((Object)"loginType", (Object)"3", (Object)"batch", (Object)true, (Object)"language", (Object)(RequestContext.get().getLang() == null ? "zh_CN" : RequestContext.get().getLang().toString()));
        return (SafeUrlDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSSafeUrlService", (String)"longToShortByArg", (Object[])new Object[]{url, HRDateTimeUtils.getSysMaxDate(), evalTaskId, param});
    }
}

