/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.msg;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.BesServiceFactory;
import kd.hrmp.bes.business.domain.login.link.EvalLinkService;
import kd.hrmp.bes.business.domain.login.link.bo.RealEvalLinkParam;
import kd.hrmp.bes.business.domain.msg.EmailMessageImpl;
import kd.hrmp.bes.business.domain.msg.EvalMsgContDO;
import kd.hrmp.bes.business.domain.msg.EvalMsgTempDO;
import kd.hrmp.bes.business.domain.msg.IBesEvalMsgSendDomainService;
import kd.hrmp.bes.business.domain.msg.OtherMessageImpl;
import kd.hrmp.bes.common.enums.EvalMsgOpEnum;
import kd.hrmp.bes.common.enums.EvaluatorType;
import kd.hrmp.bes.common.fun.QRCodeImageHelper;

public class BesEvalMsgSendDomainService
implements IBesEvalMsgSendDomainService {
    private static final Log log = LogFactory.getLog(BesEvalMsgSendDomainService.class);
    private static final String EMAILSENDCHANNEL = "0";
    private static final String SMSSENDCHANNEL = "1";
    private static final String SYSSENDCHANNEL = "2";
    private static final String SPECIFICEVALUATOR_YES = "10";
    private static final String OPENFORMTYPE_PC = "1";
    private static final String OPENFORMTYPE_MOBILE = "2";
    private static final HRBaseServiceHelper taskService = new HRBaseServiceHelper("bes_evaltask");
    private static final EvalLinkService evalLinkService = EvalLinkService.getInstance();

    public boolean isNeedSendMsg(List<Long> taskIds, EvalMsgOpEnum evalMsgOpEnum) {
        DynamicObject[] tasks = this.queryTask(taskIds);
        if (Objects.nonNull(tasks) && tasks.length > 0) {
            for (DynamicObject task : tasks) {
                if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
                DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
                for (DynamicObject content : contents) {
                    if (!HRStringUtils.equals((String)SPECIFICEVALUATOR_YES, (String)content.getString("specificevaluator"))) continue;
                    if (EvalMsgOpEnum.BEGIN == evalMsgOpEnum) {
                        String sendChannel = content.getString("sendchannel");
                        if (!HRStringUtils.equals((String)content.getString("evalnoticemsg"), (String)"1") || !HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, Object> send(DynamicObject[] tasks, EvalMsgOpEnum evalMsgOpEnum, Map<String, Map<String, String>> scene2SceneFieldMap, String source) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgs(evalMsgOpEnum, tasks, messageInfos, scene2SceneFieldMap, source);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send1 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public Map<String, Object> send(DynamicObject[] tasks, EvalMsgTempDO msgTemp, EvalMsgOpEnum evalMsgOpEnum, Map<String, String> sceneFieldMap, String source) {
        if (Objects.isNull(msgTemp)) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgsByMsgTemp(evalMsgOpEnum, tasks, messageInfos, msgTemp, sceneFieldMap, source);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send2 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public Map<String, Object> send(DynamicObject[] tasks, EvalMsgOpEnum evalMsgOpEnum, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, Map<String, String>> scene2SceneFieldMap, String source, Set<Long> contIds) {
        if (CollectionUtils.isEmpty(realOutsiderIds) && CollectionUtils.isEmpty(realInnerIds)) {
            return null;
        }
        log.info("EvalMsgSendDomainService send3 realOutsiderIds:{}", realOutsiderIds);
        log.info("EvalMsgSendDomainService send3 realInnerIds:{}", realInnerIds);
        if (CollectionUtils.isEmpty(contIds)) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgsByEvaluator(evalMsgOpEnum, tasks, messageInfos, realOutsiderIds, realInnerIds, scene2SceneFieldMap, source, contIds);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send3 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public Map<String, Object> send(DynamicObject[] tasks, EvalMsgTempDO msgTemp, EvalMsgOpEnum evalMsgOpEnum, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, String> sceneFieldMap, String source, Set<Long> contIds) {
        if (CollectionUtils.isEmpty(realOutsiderIds) && CollectionUtils.isEmpty(realInnerIds)) {
            return null;
        }
        log.info("EvalMsgSendDomainService send4 realOutsiderIds:{}", realOutsiderIds);
        log.info("EvalMsgSendDomainService send4 realInnerIds:{}", realInnerIds);
        if (CollectionUtils.isEmpty(contIds)) {
            return null;
        }
        if (Objects.isNull(msgTemp)) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgsByMsgTempEvaluator(evalMsgOpEnum, tasks, messageInfos, msgTemp, realOutsiderIds, realInnerIds, sceneFieldMap, source, contIds);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send4 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public Map<String, Object> send(List<Long> taskIds, EvalMsgOpEnum evalMsgOpEnum, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, Map<String, String>> scene2SceneFieldMap, String source, Set<Long> contIds) {
        if (CollectionUtils.isEmpty(realOutsiderIds) && CollectionUtils.isEmpty(realInnerIds)) {
            return null;
        }
        log.info("EvalMsgSendDomainService send5 realOutsiderIds:{}", realOutsiderIds);
        log.info("EvalMsgSendDomainService send5 realInnerIds:{}", realInnerIds);
        if (CollectionUtils.isEmpty(contIds)) {
            return null;
        }
        DynamicObject[] tasks = this.queryTask(taskIds);
        if (Objects.isNull(tasks) || tasks.length == 0) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgsByEvaluatorScene(evalMsgOpEnum, tasks, messageInfos, realOutsiderIds, realInnerIds, scene2SceneFieldMap, source, contIds);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send5 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public Map<String, Object> send(List<Long> taskIds, EvalMsgOpEnum evalMsgOpEnum, Map<String, Map<String, String>> scene2SceneFieldMap, String source) {
        DynamicObject[] tasks = this.queryTask(taskIds);
        if (Objects.isNull(tasks) || tasks.length == 0) {
            return null;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
        this.buildUpMsgsScene(evalMsgOpEnum, tasks, messageInfos, scene2SceneFieldMap, source);
        if (CollectionUtils.isEmpty(messageInfos)) {
            return null;
        }
        Map returnMap = MessageCenterServiceHelper.batchSendMessages(messageInfos);
        log.info("EvalMsgSendDomainService send6 returnMap:{}", (Object)returnMap);
        return returnMap;
    }

    public DynamicObject[] queryTask(List<Long> taskIds) {
        DynamicObject[] tasks = taskService.query("name,startdate,planenddate,realorcryptonym,contententryentity,contententryentity.contentname,contententryentity.specificevaluator,contententryentity.evalnoticemsg,contententryentity.sendchannel,contententryentity.emailtheme,contententryentity.emailrichtext_tag,contententryentity.smstemplate,contententryentity.systemplate,contententryentity.realoutsidersubentry,realoutsidersubentry.evaloroutemail,realoutsidersubentry.evalorouttel,realoutsidersubentry.evaloroutname,contententryentity.evaluatorrealsubentry,evaluatorrealsubentry.outevaluator_tag,evaluatorrealsubentry.evalbody,evaluatorrealsubentry.inevaluator", new QFilter("id", "in", taskIds).toArray());
        return tasks;
    }

    private void buildUpMsgs(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, Map<String, Map<String, String>> scene2SceneFieldMap, String source) {
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                String sendChannel = content.getString("sendchannel");
                if (!HRStringUtils.equals((String)content.getString("evalnoticemsg"), (String)"1") || !HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, content.getString("emailtheme"));
                    Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                    String msgContent = messageParser.parseMessage(content.getString("systemplate"), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void buildUpMsgsByMsgTemp(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, EvalMsgTempDO msgTemp, Map<String, String> sceneFieldMap, String source) {
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                String sendChannel = msgTemp.getSendChannel();
                if (!HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getEmailRichText_tag(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(msgTemp.getEmailTheme()), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getEmailRichText_tag(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(msgTemp.getEmailTheme()), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getSmsTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getSmsTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, msgTemp.getEmailTheme());
                    String msgContent = messageParser.parseMessage(msgTemp.getSysTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void buildUpMsgsByEvaluator(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, Map<String, String>> scene2SceneFieldMap, String source, Set<Long> contIds) {
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                if (!contIds.contains(content.getLong("id"))) continue;
                String sendChannel = content.getString("sendchannel");
                if (!HRStringUtils.equals((String)content.getString("evalnoticemsg"), (String)"1") || !HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        if (!realInnerIds.contains(inEvaluator.getLong("fbasedataid.id"))) continue;
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, content.getString("emailtheme"));
                    Map sceneFieldMap = (Map)scene2SceneFieldMap.get(content.getString("msgtemplate.usescene.id"));
                    String msgContent = messageParser.parseMessage(content.getString("systemplate"), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void buildUpMsgsByMsgTempEvaluator(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, EvalMsgTempDO msgTemp, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, String> sceneFieldMap, String source, Set<Long> contIds) {
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                String sendChannel;
                if (!contIds.contains(content.getLong("id")) || !HRStringUtils.isNotEmpty((String)(sendChannel = msgTemp.getSendChannel()))) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        if (!realInnerIds.contains(inEvaluator.getLong("fbasedataid.id"))) continue;
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getEmailRichText_tag(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(msgTemp.getEmailTheme()), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getEmailRichText_tag(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(msgTemp.getEmailTheme()), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getSmsTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, msgTemp.getEmailTheme());
                        String msgContent = messageParser.parseMessage(msgTemp.getSmsTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, msgTemp.getEmailTheme());
                    String msgContent = messageParser.parseMessage(msgTemp.getSysTemplate(), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void buildUpMsgsByEvaluatorScene(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, Set<Long> realOutsiderIds, Set<Long> realInnerIds, Map<String, Map<String, String>> scene2SceneFieldMap, String source, Set<Long> contIds) {
        if (scene2SceneFieldMap == null || scene2SceneFieldMap.size() != 1) {
            return;
        }
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                if (!contIds.contains(content.getLong("id"))) continue;
                String sendChannel = content.getString("sendchannel");
                if (!HRStringUtils.equals((String)content.getString("evalnoticemsg"), (String)"1") || !HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        if (!realInnerIds.contains(inEvaluator.getLong("fbasedataid.id"))) continue;
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (!realOutsiderIds.contains(realOutsider.getLong("id"))) {
                            return;
                        }
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, content.getString("emailtheme"));
                    HashMap<String, String> sceneFieldMap = new HashMap(16);
                    for (Map value : scene2SceneFieldMap.values()) {
                        sceneFieldMap = value;
                    }
                    String msgContent = messageParser.parseMessage(content.getString("systemplate"), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void buildUpMsgsScene(EvalMsgOpEnum evalMsgOpEnum, DynamicObject[] tasks, List<MessageInfo> messageInfos, Map<String, Map<String, String>> scene2SceneFieldMap, String source) {
        for (DynamicObject task : tasks) {
            if (!HRStringUtils.equals((String)"1", (String)task.getString("realorcryptonym"))) continue;
            DynamicObjectCollection contents = task.getDynamicObjectCollection("contententryentity");
            for (DynamicObject content : contents) {
                String sendChannel = content.getString("sendchannel");
                if (!HRStringUtils.equals((String)content.getString("evalnoticemsg"), (String)"1") || !HRStringUtils.isNotEmpty((String)sendChannel)) continue;
                DynamicObjectCollection realOutsiders = content.getDynamicObjectCollection("realoutsidersubentry");
                DynamicObjectCollection evaluatorReals = content.getDynamicObjectCollection("evaluatorrealsubentry");
                HashSet personIdStrs = new HashSet(16);
                HashSet<Long> personIdLongs = new HashSet<Long>(16);
                HashMap personId2MsgDO = new HashMap(16);
                HashMap realOutsider2EvalBody = new HashMap(16);
                evaluatorReals.forEach(evaluatorReal -> {
                    DynamicObjectCollection inEvaluators = evaluatorReal.getDynamicObjectCollection("inevaluator");
                    for (DynamicObject inEvaluator : inEvaluators) {
                        String personIdStr = inEvaluator.getString("fbasedataid.person.id");
                        Long personIdLong = inEvaluator.getLong("fbasedataid.person.id");
                        personIdStrs.add(personIdStr);
                        personIdLongs.add(personIdLong);
                        EvalMsgContDO msgContDO = new EvalMsgContDO();
                        msgContDO.setPerName(inEvaluator.getString("fbasedataid.person.name"));
                        msgContDO.setEvaluatorId(inEvaluator.getString("fbasedataid.id"));
                        msgContDO.setEvalBodyId(evaluatorReal.getString("evalbody.id"));
                        personId2MsgDO.put(personIdStr, msgContDO);
                    }
                    this.setRealOutsider2EvalBody(realOutsider2EvalBody, (DynamicObject)evaluatorReal);
                });
                Map<Long, List<Map<String, Object>>> perContactMap = this.getPerContactInfoMap(new ArrayList<String>(personIdStrs));
                Map<Long, Long> perSysIdMap = this.getPerSysIdMap(personIdLongs);
                if (sendChannel.contains(EMAILSENDCHANNEL)) {
                    HashMap<String, EvalMsgContDO> outerEmail2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerEmails2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evaloroutemail"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerEmail2MsgDO.put(realOutsider.getString("evaloroutemail"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object email = perContact.get("busemail");
                            if (Objects.nonNull(email) && HRStringUtils.isNotEmpty((String)email.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerEmails2MsgDO.put(email.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerEmail2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)url, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerEmails2MsgDO.forEach((email, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        EmailMessageImpl messageParser = BesServiceFactory.getService(EmailMessageImpl.class);
                        String pcUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "1");
                        String mobileUrl = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        String cperCode = QRCodeImageHelper.generateQRCodeImage((String)mobileUrl, (int)200, (int)200);
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), cperCode, pcUrl, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("emailrichtext_tag"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)new LocaleString(content.getString("emailtheme")), (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("email", Lists.newArrayList((Object[])new String[]{email}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (sendChannel.contains("1")) {
                    HashMap<String, EvalMsgContDO> outerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    HashMap<String, EvalMsgContDO> innerTel2MsgDO = new HashMap<String, EvalMsgContDO>(16);
                    realOutsiders.forEach(realOutsider -> {
                        if (HRStringUtils.isNotEmpty((String)realOutsider.getString("evalorouttel"))) {
                            EvalMsgContDO evalMsgContDO = new EvalMsgContDO();
                            evalMsgContDO.setPerName(realOutsider.getString("evaloroutname"));
                            String realOutsiderId = realOutsider.getString("id");
                            evalMsgContDO.setEvaluatorId(realOutsiderId);
                            evalMsgContDO.setEvalBodyId((String)realOutsider2EvalBody.get(realOutsiderId));
                            outerTel2MsgDO.put(realOutsider.getString("evalorouttel"), evalMsgContDO);
                        }
                    });
                    perContactMap.forEach((per, perContacts) -> {
                        if (CollectionUtils.isEmpty((Collection)perContacts)) {
                            return;
                        }
                        perContacts.forEach(perContact -> {
                            Object phone = perContact.get("phone");
                            if (Objects.nonNull(phone) && HRStringUtils.isNotEmpty((String)phone.toString())) {
                                EvalMsgContDO evalMsgContDO = (EvalMsgContDO)personId2MsgDO.get(per.toString());
                                innerTel2MsgDO.put(phone.toString(), evalMsgContDO);
                                return;
                            }
                        });
                    });
                    outerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_OUT, "");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                    innerTel2MsgDO.forEach((tel, msgDO) -> {
                        MessageInfo messageInfo = new MessageInfo();
                        LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"%1$s_\u6d4b\u8bc4%2$s\u901a\u77e5", (String)"MsgSendDomainService_1", (String)"hrmp-bes-business", (Object[])new Object[0]), content.getString("contentname"), evalMsgOpEnum.getName()));
                        OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                        String url = this.getUrl(task, content, (EvalMsgContDO)msgDO, EvaluatorType.SYSTEM_IN, "2");
                        Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, msgDO.getPerName(), "", url, content.getString("emailtheme"));
                        HashMap<String, String> sceneFieldMap = new HashMap(16);
                        for (Map value : scene2SceneFieldMap.values()) {
                            sceneFieldMap = value;
                        }
                        String msgContent = messageParser.parseMessage(content.getString("smstemplate"), sceneFieldMapValue, sceneFieldMap, null);
                        this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                        LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                        messageInfo.setMessageTag((ILocaleString)tag);
                        messageInfo.setNotifyType(MessageChannels.SMS.getNumber());
                        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>(16);
                        map.put("phone", Lists.newArrayList((Object[])new String[]{tel}));
                        messageInfo.setParams(map);
                        messageInfos.add(messageInfo);
                    });
                }
                if (!sendChannel.contains("2")) continue;
                perSysIdMap.forEach((perId, sysId) -> {
                    MessageInfo messageInfo = new MessageInfo();
                    LocaleString title = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    OtherMessageImpl messageParser = BesServiceFactory.getService(OtherMessageImpl.class);
                    EvalMsgContDO msgDO = (EvalMsgContDO)personId2MsgDO.get(perId.toString());
                    String url = this.getUrl(task, content, msgDO, EvaluatorType.SYSTEM_IN, "1");
                    Map<String, Object> sceneFieldMapValue = this.constructSceneFieldValueMap(task, content, ((EvalMsgContDO)personId2MsgDO.get(perId.toString())).getPerName(), "", url, content.getString("emailtheme"));
                    HashMap<String, String> sceneFieldMap = new HashMap(16);
                    for (Map value : scene2SceneFieldMap.values()) {
                        sceneFieldMap = value;
                    }
                    String msgContent = messageParser.parseMessage(content.getString("systemplate"), sceneFieldMapValue, sceneFieldMap, null);
                    this.constructMsgInfoGeneralField(messageInfo, (ILocaleString)title, (ILocaleString)new LocaleString(msgContent), source);
                    LocaleString tag = new LocaleString(String.format(ResManager.loadKDString((String)"\u6d4b\u8bc4%s\u901a\u77e5", (String)"MsgSendDomainService_0", (String)"hrmp-bes-business", (Object[])new Object[0]), evalMsgOpEnum.getName()));
                    messageInfo.setMessageTag((ILocaleString)tag);
                    messageInfo.setNotifyType(MessageChannels.MC.getNumber());
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add((Long)sysId);
                    messageInfo.setUserIds(userIds);
                    if (evalMsgOpEnum != EvalMsgOpEnum.SUSPEND) {
                        messageInfo.setContentUrl(url);
                    }
                    messageInfos.add(messageInfo);
                });
            }
        }
    }

    private void setRealOutsider2EvalBody(HashMap<String, String> realOutsider2EvalBody, DynamicObject evaluatorReal) {
        String evaluatorOuter = evaluatorReal.getString("outevaluator_tag");
        if (HRStringUtils.isNotEmpty((String)evaluatorOuter)) {
            String[] evaluatorOuters;
            ArrayList evaluatorOuterList = Lists.newArrayListWithExpectedSize((int)10);
            for (String evaluatorOuterId : evaluatorOuters = evaluatorOuter.split(",")) {
                if (!HRStringUtils.isNotEmpty((String)evaluatorOuterId)) continue;
                evaluatorOuterList.add(evaluatorOuterId.trim());
            }
            evaluatorOuterList.forEach(evaltorOuterId -> realOutsider2EvalBody.put((String)evaltorOuterId, evaluatorReal.getString("evalbody.id")));
        }
    }

    private String getUrl(DynamicObject task, DynamicObject content, EvalMsgContDO msgDO, EvaluatorType evaluatorType, String openFormType) {
        RealEvalLinkParam realEvalLinkParam = new RealEvalLinkParam();
        realEvalLinkParam.setHasEvaluator(Boolean.TRUE);
        realEvalLinkParam.setEvaluatorType(evaluatorType);
        if (EvaluatorType.SYSTEM_OUT == evaluatorType) {
            realEvalLinkParam.setLoginConfigNumber("soeem_eval");
        }
        realEvalLinkParam.setOpenFormType(openFormType);
        if ("1".equals(openFormType)) {
            realEvalLinkParam.setPcPage("soeem_evalonlinepc");
        } else if ("2".equals(openFormType)) {
            realEvalLinkParam.setMobilePage("soeem_evalonlinepc_mobile");
        }
        realEvalLinkParam.setEvalTaskId(task.getString("id"));
        realEvalLinkParam.setEvalContentId(content.getString("id"));
        realEvalLinkParam.setEvaluatorId(msgDO.getEvaluatorId());
        if (HRStringUtils.isNotEmpty((String)msgDO.getEvalBodyId())) {
            realEvalLinkParam.setEvalBodyId(msgDO.getEvalBodyId());
        }
        String url = evalLinkService.genEvalLink(realEvalLinkParam);
        log.info("EvalMsgSendDomainService getUrl realEvalLinkParam:{} url:{}", (Object)realEvalLinkParam, (Object)url);
        return url;
    }
}

