/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.msg;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.msg.ITempManageParser;
import kd.hrmp.bes.business.domain.msg.MsgHtmlConstants;
import org.apache.commons.lang3.ObjectUtils;

public class EmailMessageImpl
implements ITempManageParser {
    private static Log LOG = LogFactory.getLog(EmailMessageImpl.class);

    @Override
    public String parseMessage(String messageContent, Map<String, Object> bizParam, Map<String, String> labelVariableMap, DynamicObjectCollection dynObjColl) {
        bizParam.put("emailtheme", this.EmailThemeHtmlFilter((String)bizParam.get("emailtheme")));
        String parseRichTextContent = messageContent;
        if (HRStringUtils.isEmpty((String)parseRichTextContent)) {
            return null;
        }
        StringBuilder emailContent = new StringBuilder();
        if (bizParam.get("replaceVar") != null) {
            for (Map.Entry<String, String> entry : labelVariableMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                Object paramValue = bizParam.get(key);
                if (HRStringUtils.equals((String)"cpercode", (String)key)) {
                    paramValue = "<br><img src=\"data:image/png;base64," + paramValue + "\">";
                }
                if (HRStringUtils.equals((String)"cpurl", (String)key)) {
                    String link = ResManager.loadKDString((String)"\u6d4b\u8bc4\u94fe\u63a5", (String)"EmailMessageImpl_0", (String)"hrmp-bes-business", (Object[])new Object[0]);
                    paramValue = "<a href=\"" + paramValue + "\">" + link + "</a>";
                }
                parseRichTextContent = parseRichTextContent.replaceAll("\\{" + value + "}", paramValue == null ? "" : Matcher.quoteReplacement(paramValue.toString()));
            }
        }
        parseRichTextContent = parseRichTextContent.replaceAll("<table", "<p><table");
        parseRichTextContent = parseRichTextContent.replaceAll("</table>", "</table></p>");
        List<String> rowString = this.parseRichTextToRowData(parseRichTextContent);
        emailContent.append(MsgHtmlConstants.HTML_HEAD_START.getHtml());
        emailContent.append(MessageFormat.format(MsgHtmlConstants.HTML_HEAD_BODY_BEGIN.getHtml(), bizParam.get("emailtheme").toString()));
        emailContent.append("<div style=\"padding:17px 24px\">");
        for (String row : rowString) {
            emailContent.append(MessageFormat.format(MsgHtmlConstants.HTML_HEAD_BODY_LINE.getHtml(), UUID.randomUUID().toString(), row));
        }
        emailContent.append("</div>");
        emailContent.append(MsgHtmlConstants.HTML_END.getHtml());
        return emailContent.toString();
    }

    private List<String> parseRichTextToRowData(String richTextContent) {
        ArrayList<String> rowString = new ArrayList<String>(10);
        String regex = "<p>(.+?)</p>";
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(richTextContent);
        while (matcher.find()) {
            rowString.add(matcher.group(1));
        }
        if (rowString.size() <= 1) {
            if (ObjectUtils.isNotEmpty(rowString)) {
                rowString.remove(0);
            }
            String regex1 = "<p>[\\s\\S]*</p>";
            Pattern pattern1 = Pattern.compile(regex1);
            Matcher matcher1 = pattern1.matcher(richTextContent);
            while (matcher1.find()) {
                rowString.add(matcher1.group());
            }
        }
        return rowString;
    }

    private String EmailThemeHtmlFilter(String message) {
        if (message == null) {
            return null;
        }
        message = Matcher.quoteReplacement(message);
        return "<xmp style = 'display:contents'>" + message + "</xmp>";
    }
}

