/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.msg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public interface IBesEvalMsgSendDomainService {
    public static final Log log = LogFactory.getLog(IBesEvalMsgSendDomainService.class);

    default public MessageInfo constructMsgInfoGeneralField(MessageInfo messageInfo, ILocaleString title, ILocaleString content, String source) {
        messageInfo.setMessageTitle(title);
        messageInfo.setMessageContent(content);
        messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        messageInfo.setType("message");
        messageInfo.setTplScene("success");
        messageInfo.setSource(source);
        return messageInfo;
    }

    default public Map<Long, List<Map<String, Object>>> getTargetResult(Map<String, Map<String, Object>> result, String targetName) {
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        HashMap targetResultMap = Maps.newHashMap();
        result.forEach((personIdStr, map) -> {
            if (null == map) {
                return;
            }
            Long personId = Long.parseLong(personIdStr);
            Object target = map.get(targetName);
            if (null == target) {
                return;
            }
            List targetMapList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(target), ArrayList.class);
            targetResultMap.put(personId, targetMapList);
        });
        return targetResultMap;
    }

    default public Map<Long, List<Map<String, Object>>> getPerContactInfoMap(List<String> perIdList) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"003"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", perIdList);
        Map employeeInfo = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> perContact = this.getTargetResult(employeeInfo, "hrpi_percontact");
        return perContact;
    }

    default public Map<Long, Long> getPerSysIdMap(Set<Long> personIdSet) {
        if (personIdSet != null) {
            HashMap<Long, Long> perSysMap = new HashMap<Long, Long>(personIdSet.size());
            ArrayList<Long> pIds = new ArrayList<Long>(personIdSet);
            HashMap<String, ArrayList<Long>> idMaps = new HashMap<String, ArrayList<Long>>(16);
            idMaps.put("person", pIds);
            Map userMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
            Map userInfoMap = (Map)userMap.get("data");
            for (Long pId : pIds) {
                Map personInfoMap;
                if (userInfoMap == null || (personInfoMap = (Map)userInfoMap.get(pId)) == null) continue;
                Long userId = (Long)personInfoMap.get("user");
                perSysMap.put(pId, userId);
            }
            return perSysMap;
        }
        return null;
    }

    default public Map<String, Object> constructSceneFieldValueMap(DynamicObject task, DynamicObject cont, String evalName, String cperCode, String cpUrl, String emailTheme) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("replaceVar", "1");
        customParams.put("emailtheme", emailTheme);
        customParams.put("evaltaskname", task.getString("name"));
        customParams.put("evaltaskcontname", cont.getString("contentname"));
        customParams.put("startdate", Objects.isNull(task.getDate("startdate")) ? "" : HRDateTimeUtils.format((Date)task.getDate("startdate"), (String)"yyyy-MM-dd"));
        customParams.put("planenddate", Objects.isNull(task.getDate("planenddate")) ? "" : HRDateTimeUtils.format((Date)task.getDate("planenddate"), (String)"yyyy-MM-dd"));
        customParams.put("evalname", evalName);
        customParams.put("cpercode", cperCode);
        customParams.put("cpurl", cpUrl);
        return customParams;
    }
}

