/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.bes.business.domain.entityservice.evalsubtask.track.TrackEvalObjPerEntityService;
import kd.hrmp.bes.business.domain.evaltask.EvalTaskDomainServiceImpl;

public class EvalTaskResultDomainServiceImpl {
    private static final EvalTaskDomainServiceImpl evalTaskDomainService = new EvalTaskDomainServiceImpl();
    private static final TrackEvalObjPerEntityService TRACK_EVAL_OBJ_PER_ENTITY_SERVICE = new TrackEvalObjPerEntityService();

    public Map<Long, List<Map<String, Object>>> getEvalTaskResult(Long taskId) {
        DynamicObject taskObj = evalTaskDomainService.queryById(taskId);
        Map<Long, String> contentIdAndType = this.getContentIdAndIndicatorEvalTypeMap(taskObj);
        Map<Long, Long> contendIdAndIndicatorId = this.getContendIdAndIndicatorId(taskObj);
        Map<Long, List<DynamicObject>> contendIdAndResultObjs = this.getContendIdAndResultObjs(taskId);
        HashMap<Long, List<Map<String, Object>>> contentIdAndResultList = new HashMap<Long, List<Map<String, Object>>>(contendIdAndResultObjs.size());
        for (Map.Entry<Long, List<DynamicObject>> contentIdAndResult : contendIdAndResultObjs.entrySet()) {
            Long contentId = contentIdAndResult.getKey();
            List<DynamicObject> resultList = contentIdAndResult.getValue();
            List<Map<String, Object>> resultMapList = this.getResultMapList(resultList, contentId, contentIdAndType, contendIdAndIndicatorId);
            contentIdAndResultList.put(contentId, resultMapList);
        }
        return contentIdAndResultList;
    }

    private List<Map<String, Object>> getResultMapList(List<DynamicObject> resultList, Long contentId, Map<Long, String> contentIdAndType, Map<Long, Long> contendIdAndIndicatorId) {
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>(resultList.size());
        for (DynamicObject result : resultList) {
            HashMap<String, Object> identifyAndValue = new HashMap<String, Object>(16);
            identifyAndValue.put("pername", result.get("pername"));
            identifyAndValue.put("pernumber", result.getString("pernumber"));
            identifyAndValue.put("telephone", result.getString("telephone"));
            identifyAndValue.put("percompany", result.get("percompany"));
            identifyAndValue.put("peradminorg", result.get("peradminorg"));
            identifyAndValue.put("totalevalnum", result.getInt("totalevalnum"));
            identifyAndValue.put("waiverevalnum", result.getInt("waiverevalnum"));
            identifyAndValue.put("completeevalnum", result.getInt("completeevalnum"));
            identifyAndValue.put("totalscore", result.getBigDecimal("totalscore"));
            identifyAndValue.put("indicatorevaltype", contentIdAndType.get(contentId));
            if (HRStringUtils.equals((String)"10", (String)contentIdAndType.get(contentId))) {
                List<Map<String, Object>> totalEvalMap = this.getTotalEvalMap(result, contendIdAndIndicatorId.get(contentId));
                identifyAndValue.put("totaleval", totalEvalMap);
            }
            resultMapList.add(identifyAndValue);
        }
        return resultMapList;
    }

    private List<Map<String, Object>> getTotalEvalMap(DynamicObject result, Long totalIndicatorId) {
        DynamicObjectCollection noScoreEntries = result.getDynamicObjectCollection("noscoreentry");
        List totalIndicatorObjs = noScoreEntries.stream().filter(indicator -> (long)totalIndicatorId.compareTo(indicator.getLong("indicator")) == 0L).collect(Collectors.toList());
        ArrayList<Map<String, Object>> totalIndicatorList = new ArrayList<Map<String, Object>>(totalIndicatorObjs.size());
        for (DynamicObject totalIndicatorObj : totalIndicatorObjs) {
            HashMap<String, Object> optAndValue = new HashMap<String, Object>(4);
            optAndValue.put("optname", totalIndicatorObj.get("optname"));
            optAndValue.put("optsindicaseq", totalIndicatorObj.getInt("optsindicaseq"));
            optAndValue.put("optvotes", totalIndicatorObj.getBigDecimal("optvotes"));
            optAndValue.put("optratio", totalIndicatorObj.getBigDecimal("optratio"));
            totalIndicatorList.add(optAndValue);
        }
        return totalIndicatorList;
    }

    private Map<Long, List<DynamicObject>> getContendIdAndResultObjs(Long taskId) {
        DynamicObject[] contentIdAndResult = TRACK_EVAL_OBJ_PER_ENTITY_SERVICE.queryByTaskId(taskId);
        return Arrays.stream(contentIdAndResult).collect(Collectors.groupingBy(dy -> dy.getLong("taskcontentid")));
    }

    private Map<Long, String> getContentIdAndIndicatorEvalTypeMap(DynamicObject taskObj) {
        DynamicObjectCollection contentEntries = taskObj.getDynamicObjectCollection("contententryentity");
        return contentEntries.stream().collect(Collectors.toMap(contentEntry -> contentEntry.getLong("id"), contentEntry -> contentEntry.getString("indicatorevaltype"), (Vone, Vtwo) -> Vone));
    }

    private Map<Long, Long> getContendIdAndIndicatorId(DynamicObject evalTaskObj) {
        DynamicObjectCollection evalContentCollection = evalTaskObj.getDynamicObjectCollection("contententryentity");
        HashMap<Long, Long> contentIdAndIndicatorId = new HashMap<Long, Long>(evalContentCollection.size());
        for (DynamicObject contentObj : evalContentCollection) {
            DynamicObjectCollection indicatorSubEntry = contentObj.getDynamicObjectCollection("indicatorsubentry");
            Optional<Long> indicatorIds = indicatorSubEntry.stream().filter(indicator -> {
                if ("2".equals(indicator.getString("areacode")) && "A".equals(indicator.getString("indicatortype")) && "2".equals(indicator.getString("indicatorclassify"))) {
                    indicator.getString("indicatortype");
                    return true;
                }
                return false;
            }).map(dy -> dy.getLong("id")).findFirst();
            if (!indicatorIds.isPresent()) continue;
            Long indicatorId = indicatorIds.get();
            contentIdAndIndicatorId.put(contentObj.getLong("id"), indicatorId);
        }
        return contentIdAndIndicatorId;
    }
}

