/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.setanonevaluator;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;

public class SetAnonEvaluatorHelper {
    private static final String SYMBOLS = "0123456789";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static Log LOG = LogFactory.getLog(SetAnonEvaluatorHelper.class);

    public static List<String> getAccountList(String accountLetter, int accountNumDigit, int number) {
        ArrayList<String> accountList = new ArrayList<String>(number);
        for (int index = 0; index < number; ++index) {
            String account = SetAnonEvaluatorHelper.getUniqueAccount(accountList, accountNumDigit, accountLetter);
            accountList.add(account);
        }
        return accountList;
    }

    private static String getUniqueAccount(List<String> list, int length, String letter) {
        String account = SetAnonEvaluatorHelper.getNumDigit(length, letter);
        if (list.contains(account)) {
            account = SetAnonEvaluatorHelper.getUniqueAccount(list, length, letter);
        }
        return account;
    }

    private static String getNumDigit(int length, String letter) {
        char[] numDigit = new char[length];
        for (int index = 0; index < length; ++index) {
            numDigit[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }
        if (HRStringUtils.isEmpty((String)letter)) {
            return new String(numDigit);
        }
        return letter + new String(numDigit);
    }

    public static List<String> getPassWordList(String pwdLetter, String symbol, int pwdNumDigit, int number) {
        ArrayList<String> pwdList = new ArrayList<String>(number);
        for (int index = 0; index < number; ++index) {
            String account = SetAnonEvaluatorHelper.getUniquePwd(pwdList, pwdNumDigit, pwdLetter, symbol);
            pwdList.add(account);
        }
        return pwdList;
    }

    private static String getUniquePwd(List<String> list, int length, String letter, String symbol) {
        String passWord = SetAnonEvaluatorHelper.getNumDigit(length, letter, symbol);
        if (list.contains(passWord)) {
            passWord = SetAnonEvaluatorHelper.getUniquePwd(list, length, letter, symbol);
        }
        return passWord;
    }

    private static String getNumDigit(int length, String letter, String symbol) {
        char[] numDigit = new char[length];
        for (int index = 0; index < length; ++index) {
            numDigit[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }
        String word = new String(numDigit);
        if (HRStringUtils.isNotEmpty((String)symbol)) {
            word = symbol + word;
        }
        if (HRStringUtils.isNotEmpty((String)letter)) {
            word = letter + word;
        }
        return word;
    }

    public static boolean isMatchLetter(String letter) {
        if (HRStringUtils.isEmpty((String)letter)) {
            return true;
        }
        if (letter.length() > 4) {
            return false;
        }
        return letter.matches("[a-zA-Z]+");
    }

    public static boolean isSpecialSymbol(String symbol) {
        if (HRStringUtils.isEmpty((String)symbol)) {
            return true;
        }
        if (symbol.length() != 1) {
            return false;
        }
        String symbolField = "~!@#$%^&*-+=?";
        return symbolField.contains(symbol);
    }
}

