/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.bes.business.domain.setindicator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.bes.business.domain.setindicator.ISetIndicatorGroupSeqService;

public class SetIndicatorGroupSeqServiceImpl
implements ISetIndicatorGroupSeqService {
    private static Log LOG = LogFactory.getLog(SetIndicatorGroupSeqServiceImpl.class);

    @Override
    public void setEvalTempIndicatorGroupSeq(IFormView view) {
        if (view == null) {
            return;
        }
        try {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("indicatorentryentity");
            if (entryEntity != null && entryEntity.size() > 0) {
                this.setIndicatorGroupSeq(entryEntity);
                view.updateView("indicatorentryentity");
            }
        }
        catch (Exception exception) {
            LOG.error("setEvalTempIndicatorGroupSeq error: ", (Throwable)exception);
        }
    }

    @Override
    public void setEvalTaskIndicatorGroupSeq(IFormView view) {
        if (view == null) {
            return;
        }
        try {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("contententryentity");
            if (entryEntity != null && entryEntity.size() > 0) {
                for (DynamicObject entry : entryEntity) {
                    DynamicObjectCollection indicatorSubEntry = entry.getDynamicObjectCollection("indicatorsubentry");
                    if (indicatorSubEntry == null || indicatorSubEntry.size() <= 0) continue;
                    this.setIndicatorGroupSeq(indicatorSubEntry);
                }
                view.updateView("contententryentity");
                view.updateView("indicatorsubentry");
            }
        }
        catch (Exception exception) {
            LOG.error("setEvalTaskIndicatorGroupSeq error: ", (Throwable)exception);
        }
    }

    private void setIndicatorGroupSeq(DynamicObjectCollection indicatorEntry) {
        block7: {
            block6: {
                if (indicatorEntry == null || indicatorEntry.size() == 0) {
                    return;
                }
                List collect = indicatorEntry.stream().map(dy -> dy.getLong("group")).distinct().collect(Collectors.toList());
                if (collect.size() != 1) break block6;
                for (int index = 0; index < indicatorEntry.size(); ++index) {
                    DynamicObject indicator = (DynamicObject)indicatorEntry.get(index);
                    indicator.set("indicgroupseq", (Object)(index + 1));
                }
                break block7;
            }
            HashMap indicatorGroup = new HashMap(16);
            for (DynamicObject indicator : indicatorEntry) {
                long group = indicator.getLong("group");
                List indicatorList = (List)indicatorGroup.get(group);
                if (indicatorList == null) {
                    ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
                    list.add(indicator);
                    indicatorGroup.put(group, list);
                    continue;
                }
                indicatorList.add(indicator);
            }
            if (indicatorGroup.size() <= 0) break block7;
            for (List value : indicatorGroup.values()) {
                for (int index = 0; index < value.size(); ++index) {
                    DynamicObject indicator = (DynamicObject)value.get(index);
                    indicator.set("indicgroupseq", (Object)(index + 1));
                }
            }
        }
    }
}

