/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.meta.StructClassHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRObjectUtils;

public class StructProjectPermUitl {
    private static Log LOGGER = LogFactory.getLog(StructProjectPermUitl.class);
    private static final String HR_ORG_VIEW_TYPE = "21";
    private static final String HOMS_APP = "homs";
    public static final String CGNAME_PERID = "3YYZN3RX1J03";
    public static final String RESULT = "result";

    public static Map<String, Object> hasStructProjectPerm(Long structProjectId) {
        DynamicObject otClassify;
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(RESULT, false);
        DynamicObject customStructProject = CustomStructProjectRepository.getRepository().queryOne("otclassify", structProjectId);
        if (!HRObjectUtils.isEmpty((Object)customStructProject) && (otClassify = customStructProject.getDynamicObject("otclassify")) != null) {
            String prefix = StructClassHelper.getPrefixNumberByStructTypeId(otClassify.getLong("id"));
            Boolean hasDataPerm = null;
            String orgMetaData = "haos_cusadminorgteam_" + prefix;
            boolean org = StructProjectPermUitl.checkViewPermission(orgMetaData);
            if (org && !(hasDataPerm = Boolean.valueOf(StructProjectPermUitl.checkDataPerm(orgMetaData, structProjectId))).booleanValue()) {
                return result;
            }
            String roleMeta = "haos_customorole_" + prefix;
            boolean role = StructProjectPermUitl.checkViewPermission(roleMeta);
            if (org && hasDataPerm == null && !(hasDataPerm = Boolean.valueOf(StructProjectPermUitl.checkDataPerm(roleMeta, structProjectId))).booleanValue()) {
                return result;
            }
            String personMeta = "haos_cusempposorgrel_" + prefix;
            boolean person = StructProjectPermUitl.checkViewPermission(personMeta);
            if (person && hasDataPerm == null && !(hasDataPerm = Boolean.valueOf(StructProjectPermUitl.checkDataPerm(personMeta, structProjectId))).booleanValue()) {
                return result;
            }
            boolean flag = org || role || person;
            result.put("maintainorg", org);
            result.put("maintainrole", role);
            result.put("maintainperson", person);
            result.put(RESULT, flag);
        }
        return result;
    }

    private static boolean checkDataPerm(String metaData, Long structProjectId) {
        HasPermOrgResult dataResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)HR_ORG_VIEW_TYPE, (String)HOMS_APP, (String)metaData, (String)"47150e89000000ac", (boolean)true);
        LOGGER.info("dataResult:{}", (Object)dataResult);
        if (dataResult == null) {
            return false;
        }
        if (dataResult.hasAllOrgPerm()) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)dataResult.getHasPermOrgs())) {
            return false;
        }
        DynamicObjectCollection projectDys = QueryServiceHelper.query((String)"haos_customstructproject", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)structProjectId)});
        if (projectDys == null || projectDys.size() == 0) {
            LOGGER.info("projectDys is null,id:{}", (Object)structProjectId);
            return false;
        }
        return dataResult.getHasPermOrgs().contains(((DynamicObject)projectDys.get(0)).getLong("org"));
    }

    public static boolean checkViewPermission(String metaNumber) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)HOMS_APP, (String)metaNumber, (String)"47150e89000000ac");
    }

    public static boolean checkSturctTypeCngName() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)HOMS_APP, (String)"haos_otherstructtype", (String)CGNAME_PERID);
    }

    public static HasPermOrgResult getAllPermOrgs(String metaData) {
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)HR_ORG_VIEW_TYPE, (String)HOMS_APP, (String)metaData, (String)"47150e89000000ac", (boolean)true);
    }

    public static Set<Long> getCustomRoleEmpAuthorizedAdminOrgsF7(String metaData) {
        QFilter qFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRuleForBdProp", (Object[])new Object[]{RequestContext.get().getCurrUserId(), HOMS_APP, metaData, "depemp.adminorg", "47150e89000000ac", null});
        if (qFilter != null && qFilter.getValue() instanceof Set) {
            return (Set)qFilter.getValue();
        }
        return new HashSet<Long>(0);
    }

    public static AuthorizedOrgTeamResult getPermOrgResult(String permEntityNumber) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = HOMS_APP;
        String propKey = "boid";
        return (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, permEntityNumber, "47150e89000000ac", propKey});
    }
}

