/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.adminorg;

import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.service.adminorg.IAdminOrgService;
import kd.hr.haos.business.domain.service.impl.adminorg.AdminOrgServiceImpl;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.fourlayermodel.FourLayerModelService;
import kd.hr.haos.business.service.adminorg.sortcode.AdminOrgSortCodeService;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgChgStructService;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class AdminOrgApplicationImpl
implements IAdminOrgService {
    private static final Log logger = LogFactory.getLog(AdminOrgApplicationImpl.class);
    private static AdminOrgApplicationImpl INSTANCE = new AdminOrgApplicationImpl();

    public static AdminOrgApplicationImpl getInstance() {
        return INSTANCE;
    }

    @Override
    @Deprecated
    public HisResponse<BatchVersionChangeRespData> batchAddNew(DynamicObject[] adminOrgObjs) {
        return null;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchChange(DynamicObject[] adminOrgObjs) {
        long startTimeMill = System.currentTimeMillis();
        HisResponse<BatchVersionChangeRespData> basicInfoChangeResponse = AdminOrgServiceImpl.getInstance().batchChange(adminOrgObjs);
        logger.info(String.format(Locale.ROOT, "AdminOrgServiceImpl.batchChange() call cost  %s milliseconds", System.currentTimeMillis() - startTimeMill));
        List<HisVersionParamBo> listHisVersionParamBo = FourLayerModelService.getInstance().buildChangeHisVersionParam(adminOrgObjs);
        List<DynamicObject> newSortList = AdminOrgChgStructService.getInstance().getChgSortByOrgId(adminOrgObjs);
        if (!ObjectUtils.isEmpty(newSortList)) {
            listHisVersionParamBo.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newSortList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false));
        }
        HisVersionParamListBo hisVersionParamListBo = AdminOrgHisServiceHelper.constructBatchSaveHisVersionParamBO(listHisVersionParamBo, ((BatchVersionChangeRespData)basicInfoChangeResponse.getData()).getEventId());
        long secondTimeMill = System.currentTimeMillis();
        HisResponse response = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchChange() another time call his interface cost %s milliseconds", System.currentTimeMillis() - secondTimeMill));
        if (ObjectUtils.isEmpty((Object)response.getData())) {
            return basicInfoChangeResponse;
        }
        ((BatchVersionChangeRespData)response.getData()).getVersionChangeRespDataList().addAll(((BatchVersionChangeRespData)basicInfoChangeResponse.getData()).getVersionChangeRespDataList());
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchChange() call total cost  %s milliseconds", System.currentTimeMillis() - startTimeMill));
        return response;
    }

    public HisResponse<VersionChangeRespData> batchSaveTemp(DynamicObject[] adminOrgObjs) {
        long startTimeStamp = System.currentTimeMillis();
        HisResponse<VersionChangeRespData> adminOrgHisVersionChgResp = AdminOrgServiceImpl.getInstance().batchSaveTemp(adminOrgObjs);
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchSaveTemp() save org info cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        List<HisVersionParamBo> listHisVersionParamBo = FourLayerModelService.getInstance().buildAddNewHisVersionParam(adminOrgObjs);
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchSaveTemp() construct group company department info cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        for (HisVersionParamBo hisVersionParamBo : listHisVersionParamBo) {
            DynamicObject[] dynamicObjectArray = hisVersionParamBo.getHisDyns();
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject hisDyn = dynamicObjectArray[i];
                hisDyn.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            }
            hisVersionParamBo.setEffImmediately(Boolean.FALSE.booleanValue());
            HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        }
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchSaveTemp() save group company department info cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        HisVersionParamBo sortCodeHisVersionParamBo = AdminOrgSortCodeService.getInstance().buildBatchSaveTempHisParam(adminOrgObjs);
        for (DynamicObject hisDyn : sortCodeHisVersionParamBo.getHisDyns()) {
            hisDyn.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        }
        sortCodeHisVersionParamBo.setEffImmediately(Boolean.FALSE.booleanValue());
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchSaveTemp() construct sortcode info cost %s milliseconds", System.currentTimeMillis() - startTimeStamp));
        HisModelController.getInstance().hisVersionChange(sortCodeHisVersionParamBo);
        logger.info(String.format(Locale.ROOT, "AdminOrgApplicationImpl.batchSaveTemp() total cost  %s milliseconds, and the size of org is: %s", System.currentTimeMillis() - startTimeStamp, adminOrgObjs.length));
        return adminOrgHisVersionChgResp;
    }

    @Override
    public void batchEnableOrDisable(DynamicObject[] adminOrgObjs, String enable) {
    }

    @Override
    public void batchCheck(DynamicObject[] adminOrgObjs) {
    }
}

