/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.adminorg;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.adminorg.IAdminOrgApplication;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;

public class AdminOrgNewApplicationImpl
implements IAdminOrgApplication {
    private static final Log logger = LogFactory.getLog(AdminOrgNewApplicationImpl.class);
    private AdminOrgStructRepository adminOrgStructRepository = AdminOrgStructRepository.getInstance();
    private AdOrgRepository adOrgRepository = AdOrgRepository.getInstance();

    @Override
    public Map<String, Map<String, Object>> queryAssignLevelOrgInfoById(List<Long> orgIds, List<String> orgNumbers, Integer level, Date date) {
        return this.queryAssignLevelOrgInfoByIdAndStrProId(orgIds, orgNumbers, level, date, 1010L);
    }

    @Override
    public Map<String, Map<String, Object>> queryAssignLevelOrgInfoByIdAndStrProId(List<Long> orgIds, List<String> orgNumbers, Integer level, Date date, Long structProjectId) {
        DynamicObject[] structHisInfoArr;
        String propKey;
        logger.info("queryAssignLevelOrgInfoByIdAndStrProId level:{}, date:{}, structProjectId{}, orgIds:{}, orgNumbers:{}", new Object[]{level, date, structProjectId, JSON.toJSONString(orgIds), JSON.toJSONString(orgNumbers)});
        if (CollectionUtils.isEmpty(orgIds) && CollectionUtils.isEmpty(orgNumbers)) {
            throw new KDBizException("orgIds and orgNumbers can not be empty at the same time!");
        }
        if (structProjectId == null || structProjectId == 0L) {
            throw new KDBizException("structProjectId can not be empty!");
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            propKey = "adminorg.id";
            structHisInfoArr = this.adminOrgStructRepository.queryOriginalHisStructByOrgIdAndLevel("adminorg.id, structlongnumber", orgIds, level, date, structProjectId);
        } else {
            propKey = "adminorg.number";
            structHisInfoArr = this.adminOrgStructRepository.queryOriginalHisStructByOrgNumberAndLevel("adminorg.number, structlongnumber", orgNumbers, level, date, structProjectId);
        }
        Map<Object, String> structLongNumberMap = Arrays.stream(structHisInfoArr).collect(Collectors.toMap(structHisInfo -> structHisInfo.get(propKey), structHisInfo -> structHisInfo.getString("structlongnumber")));
        HashMap structNumberMap = Maps.newHashMapWithExpectedSize((int)structLongNumberMap.size());
        for (Map.Entry<Object, String> entry : structLongNumberMap.entrySet()) {
            String[] structNumberArr = entry.getValue().split("!");
            if (structNumberArr.length < level) continue;
            structNumberMap.put(entry.getKey(), structNumberArr[level - 1]);
        }
        String selectField = "id, name, number, boid, enable, structnumber,isvirtualorg";
        DynamicObject[] adminOrgInfoArr = this.adOrgRepository.queryOriginalHisByStructNumber(selectField, structNumberMap.values(), date);
        Map<String, DynamicObject> adminOrgDynMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getString("structnumber"), adminOrgInfo -> adminOrgInfo));
        HashMap result = Maps.newHashMapWithExpectedSize((int)adminOrgInfoArr.length);
        for (Map.Entry structNumberEntry : structNumberMap.entrySet()) {
            String structNumber = (String)structNumberEntry.getValue();
            DynamicObject adminOrgInfo2 = adminOrgDynMap.get(structNumber);
            if (adminOrgInfo2 == null) continue;
            HashMap adminOrgInfoResultMap = Maps.newHashMapWithExpectedSize((int)16);
            adminOrgInfoResultMap.put("id", adminOrgInfo2.getLong("id"));
            adminOrgInfoResultMap.put("name", adminOrgInfo2.getString("name"));
            adminOrgInfoResultMap.put("number", adminOrgInfo2.getString("number"));
            adminOrgInfoResultMap.put("boid", adminOrgInfo2.getLong("boid"));
            adminOrgInfoResultMap.put("enable", adminOrgInfo2.getString("enable"));
            adminOrgInfoResultMap.put("isvirtualorg", adminOrgInfo2.getString("isvirtualorg"));
            adminOrgInfoResultMap.put("structproject", structProjectId);
            result.put(structNumberEntry.getKey().toString(), adminOrgInfoResultMap);
        }
        logger.info("queryAssignLevelOrgInfoByIdAndStrProId result size:{}", (Object)result.size());
        return result;
    }

    @Override
    public List<Long> queryAdminBoIdByIds(List<Long> idList) {
        DynamicObject[] adminOrgInfoArr = this.adOrgRepository.queryAdminBoIdByIds(idList);
        return Arrays.stream(adminOrgInfoArr).map(dyn -> dyn.getLong("boid")).distinct().collect(Collectors.toList());
    }
}

