/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.projectgroup;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.application.projectgroup.IProjectTeamApplication;
import kd.hr.haos.business.domain.service.impl.proteamgroup.ProjectTeamServiceImpl;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class ProjectTeamApplicationImpl
implements IProjectTeamApplication {
    private static final Log logger = LogFactory.getLog(ProjectTeamApplicationImpl.class);

    public static ProjectTeamApplicationImpl getInstance() {
        return ProjectTeamApplicationInstance.INSTANCE;
    }

    @Override
    public Map<Long, Map<String, Map<String, Object>>> getProjectTeamVersionInfoById(List<Long> proTeamVerIdList) {
        if (ObjectUtils.isEmpty(proTeamVerIdList)) {
            throw new KDBizException("proTeamVerIdList params is empty!");
        }
        if (proTeamVerIdList.size() > 50) {
            throw new KDBizException("The number of parameters cannot exceed 50.");
        }
        ProjectTeamServiceImpl projectTeamService = ProjectTeamServiceImpl.getInstance();
        DynamicObject[] projectTeamInfoArr = projectTeamService.getProjectTeamInfoByIdList(proTeamVerIdList);
        Map<String, String> fieldMap = this.getFieldMap();
        ArrayList<Long> sourceVidList = new ArrayList<Long>(8);
        if (projectTeamInfoArr == null) {
            return new HashMap<Long, Map<String, Map<String, Object>>>();
        }
        HashSet boIdSet = new HashSet(16);
        for (DynamicObject dyn : projectTeamInfoArr) {
            long boId = dyn.getLong("boid");
            if (!boIdSet.contains(boId)) continue;
            throw new KDBizException("Cannot have more than one version of boid id.");
        }
        HashMap<Long, Long> vidVsRootProTeamBoIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Map<String, Map<String, Object>>> dataMap = new HashMap<Long, Map<String, Map<String, Object>>>(16);
        this.assemblyProTeamBaseInfo(projectTeamInfoArr, fieldMap, dataMap, "after", sourceVidList, vidVsRootProTeamBoIdMap);
        DynamicObject[] beforeProTeamDynArr = projectTeamService.getProjectTeamInfoByIdList(sourceVidList);
        this.assemblyProTeamBaseInfo(beforeProTeamDynArr, fieldMap, dataMap, "before", null, vidVsRootProTeamBoIdMap);
        this.handleForRootProTeamInfo(vidVsRootProTeamBoIdMap, dataMap, projectTeamInfoArr, "after");
        this.handleForRootProTeamInfo(vidVsRootProTeamBoIdMap, dataMap, beforeProTeamDynArr, "before");
        logger.info("ProjectTeamApplicationImpl.getProjectTeamVersionInfoById,dataList={}", (Object)SerializationUtils.toJsonString(dataMap));
        return dataMap;
    }

    private void handleForRootProTeamInfo(Map<Long, Long> vidVsRootProTeamBoIdMap, Map<Long, Map<String, Map<String, Object>>> dataMap, DynamicObject[] projectTeamInfoArr, String versionKey) {
        if (ObjectUtils.isEmpty((Object[])projectTeamInfoArr)) {
            return;
        }
        HashSet<Long> rootProTeamBoIdSet = new HashSet<Long>(16);
        if (!ObjectUtils.isEmpty((Object[])projectTeamInfoArr)) {
            for (DynamicObject pjTeamDyn : projectTeamInfoArr) {
                long pjTeamBoId;
                Long rootProTeamBoId = pjTeamDyn.getLong("rootprojectteam.id");
                long rootPjTeamBoId = pjTeamDyn.getLong("rootprojectteam.id");
                if (rootPjTeamBoId == (pjTeamBoId = pjTeamDyn.getLong("boid"))) {
                    Map<String, Map<String, Object>> hisVersionMap = dataMap.get(pjTeamBoId);
                    Map<String, Object> verHisDataMap = hisVersionMap.get(versionKey);
                    this.setProjectInfo(verHisDataMap, pjTeamDyn);
                    continue;
                }
                rootProTeamBoIdSet.add(rootProTeamBoId);
            }
        }
        ProjectTeamServiceImpl projectTeamService = ProjectTeamServiceImpl.getInstance();
        if (!ObjectUtils.isEmpty(rootProTeamBoIdSet)) {
            DynamicObject[] hisRootProTeamArr = projectTeamService.getHisRootProjectTeamInfoByBoIdSet(rootProTeamBoIdSet);
            for (Map.Entry<Long, Map<String, Map<String, Object>>> entryMap : dataMap.entrySet()) {
                Map<String, Map<String, Object>> hisVersionMap = entryMap.getValue();
                Map<String, Object> verHisDataMap = hisVersionMap.get(versionKey);
                this.handleRootProTeamData(vidVsRootProTeamBoIdMap, hisRootProTeamArr, verHisDataMap);
            }
        }
    }

    private void handleRootProTeamData(Map<Long, Long> vidVsRootProTeamBoIdMap, DynamicObject[] hisRootProTeamArr, Map<String, Object> hisDataMap) {
        if (ObjectUtils.isEmpty((Object[])hisRootProTeamArr)) {
            return;
        }
        Long vid = (Long)hisDataMap.get("id");
        Date bSed = (Date)hisDataMap.get("bsed");
        Long rootProTeamBoId = vidVsRootProTeamBoIdMap.get(vid);
        for (DynamicObject hisRootProTeamDyn : hisRootProTeamArr) {
            long hisProTeamBoId = hisRootProTeamDyn.getLong("boid");
            if (rootProTeamBoId != hisProTeamBoId) continue;
            Date rootProTeamEffDate = hisRootProTeamDyn.getDate("bsed");
            Date rootProTeamBSLED = hisRootProTeamDyn.getDate("bsled");
            if (bSed.getTime() < rootProTeamEffDate.getTime() || bSed.getTime() > rootProTeamBSLED.getTime()) continue;
            this.setProjectInfo(hisDataMap, hisRootProTeamDyn);
            break;
        }
    }

    private void setProjectInfo(Map<String, Object> hisDataMap, DynamicObject hisRootProTeamDyn) {
        hisDataMap.put("projectName", hisRootProTeamDyn.get("projectname"));
        hisDataMap.put("projectIdentify", hisRootProTeamDyn.getString("projectidentify"));
    }

    private void assemblyProTeamBaseInfo(DynamicObject[] projectTeamInfoArr, Map<String, String> fieldMap, Map<Long, Map<String, Map<String, Object>>> dataMap, String versionKey, List<Long> sourceVidList, Map<Long, Long> vidVsRootProTeamBoIdMap) {
        if (ObjectUtils.isEmpty((Object[])projectTeamInfoArr)) {
            return;
        }
        String orgNumberPrefix = OrgTeamSynService.getNumberByPrefixId(1010L) + "_";
        String proNumberPrefix = OrgTeamSynService.getNumberByPrefixId(1020L) + "_";
        for (DynamicObject proTeamDyn : projectTeamInfoArr) {
            Map<String, Map<String, Object>> versionDataMap = dataMap.get(proTeamDyn.getLong("boid"));
            if (versionDataMap == null) {
                versionDataMap = new HashMap<String, Map<String, Object>>(16);
            }
            versionDataMap.putIfAbsent("after", new HashMap(16));
            versionDataMap.putIfAbsent("before", new HashMap(16));
            Map<String, Object> dataInfoMap = versionDataMap.get(versionKey);
            if (dataInfoMap != null) {
                vidVsRootProTeamBoIdMap.put(proTeamDyn.getLong("id"), proTeamDyn.getLong("rootprojectteam.id"));
                HRDynamicObjectUtils.assemblyDynToMap((DynamicObject)proTeamDyn, dataInfoMap, fieldMap);
                String parentProjectTeamNumber = (String)dataInfoMap.get("parentProjectTeamNumber");
                if (!StringUtils.isEmpty((CharSequence)parentProjectTeamNumber) && (parentProjectTeamNumber.contains(orgNumberPrefix) || parentProjectTeamNumber.contains(proNumberPrefix))) {
                    parentProjectTeamNumber = parentProjectTeamNumber.substring(4);
                    dataInfoMap.put("parentProjectTeamNumber", parentProjectTeamNumber);
                }
                dataMap.put(proTeamDyn.getLong("boid"), versionDataMap);
            }
            if (sourceVidList == null) continue;
            sourceVidList.add(proTeamDyn.getLong("sourcevid"));
        }
    }

    private Map<String, String> getFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        fieldMap.put("id", "id");
        fieldMap.put("name", "name");
        fieldMap.put("number", "number");
        fieldMap.put("belongadminorg.number", "belongAdminOrgNumber");
        fieldMap.put("belongadminorg.id", "belongAdminOrgBoId");
        fieldMap.put("bsed", "bsed");
        return fieldMap;
    }

    private static class ProjectTeamApplicationInstance {
        private static ProjectTeamApplicationImpl INSTANCE = new ProjectTeamApplicationImpl();

        private ProjectTeamApplicationInstance() {
        }
    }
}

