/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigContext;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigQueryService;

public class StructConfigBaseDataTypeStrategy
extends StructProjectConfigQueryService {
    public StructConfigBaseDataTypeStrategy(StructProjectConfigContext structProjectConfigContext, String entityType) {
        super(structProjectConfigContext, entityType);
    }

    @Override
    protected boolean buildStructConfig() {
        Set propKeySetDiff = (Set)this.params.get("propKeySetDiff");
        List baseDataTypes = (List)this.params.get("baseDataType");
        List propKeys = (List)this.params.get("propkey");
        if (CollectionUtils.isEmpty((Collection)propKeySetDiff)) {
            if (!CollectionUtils.isEmpty((Collection)baseDataTypes) && CollectionUtils.isEmpty((Collection)propKeys)) {
                baseDataTypes.forEach(baseDataType -> this.buildStructConfigResultMap("", (String)baseDataType, this.getStructProjectByBaseDataType((String)baseDataType)));
            }
            return true;
        }
        for (String propKey : propKeySetDiff) {
            String baseDataType2 = this.getPropKeyOrBaseDataType(propKey, propKeys, baseDataTypes);
            this.buildStructConfigResultMap(propKey, baseDataType2, this.getStructProjectByBaseDataType(baseDataType2));
        }
        return false;
    }

    protected List<DynamicObject> getStructProjectByBaseDataType(String baseDataType) {
        ArrayList structProjectList = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, List<String>> structEntityMapper = this.structProjectConfigContext.getStructEntityMapper();
        if (structEntityMapper.get("adminorg").contains(baseDataType)) {
            structProjectList.addAll(this.getStructProjectMapByEntityType(1010L));
        } else if (structEntityMapper.get("projteam").contains(baseDataType)) {
            structProjectList.addAll(this.getStructProjectMapByEntityType(1020L));
        } else if (structEntityMapper.get("orgteam").contains(baseDataType)) {
            structProjectList.addAll(this.getStructProjectMapByEntityType(1010L));
            structProjectList.addAll(this.getStructProjectMapByEntityType(1020L));
        }
        return structProjectList;
    }

    protected void buildStructConfigResultMap(String propKey, String baseDataType, List<DynamicObject> structProjectList) {
        HashMap structInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        structInfoMap.put("entitytype", this.entityType);
        structInfoMap.put("allowmodify", false);
        structInfoMap.put("propkey", propKey);
        structInfoMap.put("baseDataType", baseDataType);
        List<Map<String, Object>> structProjectInfoList = this.buildStructProjectInfo(structProjectList);
        if (!CollectionUtils.isEmpty(structProjectInfoList)) {
            structInfoMap.put("structproject", structProjectInfoList);
            this.structProjectConfigContext.getStructConfigResult().add(structInfoMap);
        }
    }
}

