/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigContext;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigQueryService;

public class StructConfigDefaultStrategy
extends StructProjectConfigQueryService {
    private DynamicObject structConfigInfo;

    public StructConfigDefaultStrategy(StructProjectConfigContext structProjectConfigContext, String entityType) {
        super(structProjectConfigContext, entityType);
    }

    public void setStructConfigInfo(DynamicObject structConfigInfo) {
        this.structConfigInfo = structConfigInfo;
    }

    @Override
    public boolean buildStructConfig() {
        List propKeys = (List)this.params.get("propkey");
        if (CollectionUtils.isEmpty((Collection)propKeys)) {
            return true;
        }
        HashSet<String> propKeySetDiff = new HashSet<String>(propKeys);
        if (this.structConfigInfo == null || CollectionUtils.isEmpty((Collection)this.structConfigInfo.getDynamicObjectCollection("entryentity"))) {
            this.params.put("propKeySetDiff", propKeySetDiff);
            return true;
        }
        List baseDataTypes = (List)this.params.get("baseDataType");
        DynamicObjectCollection entryEntities = this.structConfigInfo.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> propKeyEntryMap = entryEntities.stream().collect(Collectors.toMap(entry -> entry.getString("propkey"), entry -> entry, (entry1, entry2) -> entry1));
        HashSet propKeySetIn = new HashSet(propKeys);
        propKeySetIn.retainAll(propKeyEntryMap.keySet());
        propKeySetDiff.removeIf(propKeyEntryMap.keySet()::contains);
        for (String propKey : propKeySetIn) {
            DynamicObject structConfigEntryInfo = propKeyEntryMap.get(propKey);
            HashMap structInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            structInfoMap.put("entitytype", this.entityType);
            structInfoMap.put("allowmodify", structConfigEntryInfo.get("isallowmodify"));
            structInfoMap.put("propkey", propKey);
            structInfoMap.put("baseDataType", this.getPropKeyOrBaseDataType(propKey, propKeys, baseDataTypes));
            structInfoMap.put("teamtype", structConfigEntryInfo.get("teamtype.id"));
            DynamicObjectCollection otClassifyList = structConfigEntryInfo.getDynamicObjectCollection("otclassify");
            Set otClassifies = otClassifyList.stream().map(otClassify -> otClassify.getLong("fbasedataid.id")).collect(Collectors.toSet());
            structInfoMap.put("otclassify", otClassifies);
            DynamicObjectCollection subEntryEntity = structConfigEntryInfo.getDynamicObjectCollection("subentryentity");
            List<Object> structProjectInfoList = Lists.newArrayListWithCapacity((int)16);
            if (CollectionUtils.isEmpty((Collection)subEntryEntity)) {
                if (CollectionUtils.isEmpty(otClassifies)) {
                    propKeySetDiff.add(propKey);
                } else {
                    for (Long otClassifyId : otClassifies) {
                        List<DynamicObject> structProjectList = this.getStructProjectMapByEntityType(otClassifyId);
                        List<Map<String, Object>> structProjectInfoListMap = super.buildStructProjectInfo(structProjectList);
                        if (CollectionUtils.isEmpty(structProjectInfoListMap)) continue;
                        structProjectInfoList.addAll(structProjectInfoListMap);
                    }
                }
            } else {
                structProjectInfoList = this.buildStructProjectInfo(this.structProjectConfigContext, (List<DynamicObject>)subEntryEntity);
            }
            if (CollectionUtils.isEmpty((Collection)structProjectInfoList)) continue;
            structInfoMap.put("structproject", structProjectInfoList);
            this.structProjectConfigContext.getStructConfigResult().add(structInfoMap);
        }
        this.params.put("propKeySetDiff", propKeySetDiff);
        return !CollectionUtils.isEmpty(propKeySetDiff);
    }

    protected List<Map<String, Object>> buildStructProjectInfo(StructProjectConfigContext structProjectConfigContext, List<DynamicObject> structProjectList) {
        if (CollectionUtils.isEmpty(structProjectList)) {
            return null;
        }
        ArrayList structProjectInfoList = Lists.newArrayListWithCapacity((int)structProjectList.size());
        for (DynamicObject structProjectInfo : structProjectList) {
            HashMap structProjectInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            structProjectInfoMap.put("id", structProjectInfo.get("structproject.id"));
            structProjectInfoMap.put("name", structProjectInfo.getString("structproject.name"));
            structProjectInfoMap.put("number", structProjectInfo.getString("structproject.number"));
            structProjectInfoMap.put("enable", structProjectInfo.getString("structproject.enable"));
            structProjectInfoMap.put("issyspreset", structProjectInfo.get("subentryissyspreset"));
            structProjectInfoMap.put("istoallareas", structProjectInfo.get("structproject.istoallareas"));
            long otClassifyId = structProjectInfo.getLong("structproject.otclassify.id");
            structProjectInfoMap.put("otclassify", otClassifyId);
            structProjectInfoMap.put("structprojissyspreset", structProjectInfo.get("structproject.issyspreset"));
            super.getTeamTypeInfo(structProjectConfigContext, otClassifyId, structProjectInfoMap);
            structProjectInfoList.add(structProjectInfoMap);
        }
        return structProjectInfoList;
    }
}

