/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.application.impl.structproject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.application.impl.structproject.StructProjectConfigContext;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;

public abstract class StructProjectConfigQueryService
implements StructProjectConstants {
    protected static final Log logger = LogFactory.getLog(StructProjectConfigQueryService.class);
    protected StructProjectConfigContext structProjectConfigContext;
    protected String entityType;
    protected StructProjectConfigQueryService nextConfigQueryService;
    protected Map<String, Object> params;
    private Map<String, List<DynamicObject>> structProjectCache = Maps.newHashMapWithExpectedSize((int)16);

    public StructProjectConfigQueryService(StructProjectConfigContext structProjectConfigContext, String entityType) {
        this.structProjectConfigContext = structProjectConfigContext;
        this.entityType = entityType;
        this.params = structProjectConfigContext.getEntityTypeParamMap().get(entityType);
    }

    public void setNextConfigQueryService(StructProjectConfigQueryService nextConfigQueryService) {
        this.nextConfigQueryService = nextConfigQueryService;
    }

    protected void invokeStructConfigChain() {
        boolean isContinue = this.buildStructConfig();
        if (this.nextConfigQueryService != null && isContinue) {
            this.nextConfigQueryService.invokeStructConfigChain();
        }
    }

    protected abstract boolean buildStructConfig();

    protected List<Map<String, Object>> buildStructProjectInfo(List<DynamicObject> structProjectList) {
        if (CollectionUtils.isEmpty(structProjectList)) {
            return null;
        }
        ArrayList structProjectInfoList = Lists.newArrayListWithCapacity((int)structProjectList.size());
        for (DynamicObject structProjectInfo : structProjectList) {
            HashMap structProjectInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            structProjectInfoMap.put("id", structProjectInfo.get("id"));
            structProjectInfoMap.put("name", structProjectInfo.getString("name"));
            structProjectInfoMap.put("number", structProjectInfo.getString("number"));
            structProjectInfoMap.put("enable", structProjectInfo.getString("enable"));
            long otClassifyId = structProjectInfo.getLong("otclassify.id");
            structProjectInfoMap.put("otclassify", otClassifyId);
            structProjectInfoMap.put("structprojissyspreset", structProjectInfo.get("issyspreset"));
            structProjectInfoMap.put("istoallareas", structProjectInfo.get("istoallareas"));
            this.getTeamTypeInfo(this.structProjectConfigContext, otClassifyId, structProjectInfoMap);
            structProjectInfoList.add(structProjectInfoMap);
        }
        return structProjectInfoList;
    }

    protected List<DynamicObject> getStructProjectMapByEntityType(Long otClassify) {
        if (otClassify == null) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        boolean needToAllAreas = (Boolean)this.params.getOrDefault("needToAllAreasStructProject", false);
        String cacheKey = otClassify + "-" + needToAllAreas;
        List<Object> structProjectInfos = this.structProjectCache.getOrDefault(cacheKey, new ArrayList());
        if (CollectionUtils.isEmpty((Collection)structProjectInfos)) {
            Map<Long, List<DynamicObject>> otClassifyStructProjectMap = this.structProjectConfigContext.getOtClassifyStructProjectMap();
            List<DynamicObject> structProjectInfoFromDB = otClassifyStructProjectMap.get(otClassify);
            if (CollectionUtils.isEmpty(structProjectInfoFromDB)) {
                return Lists.newArrayListWithExpectedSize((int)16);
            }
            structProjectInfos = !needToAllAreas && !"haos_structproject".equals(this.entityType) && !"haos_structure".equals(this.entityType) && !"haos_structorgdetail".equals(this.entityType) ? structProjectInfoFromDB.stream().filter(structProjectInfo -> structProjectInfo.getBoolean("istoallareas")).collect(Collectors.toList()) : structProjectInfoFromDB;
            this.structProjectCache.put(cacheKey, structProjectInfos);
        }
        return structProjectInfos;
    }

    protected void getTeamTypeInfo(StructProjectConfigContext structProjectConfigContext, long otClassifyId, Map<String, Object> structProjectInfoMap) {
        DynamicObject otClassifyDyn;
        Map<Long, DynamicObject> otClassifyInfoMap = structProjectConfigContext.getOtClassifyInfoMap();
        if (!CollectionUtils.isEmpty(otClassifyInfoMap) && (otClassifyDyn = otClassifyInfoMap.get(otClassifyId)) != null) {
            structProjectInfoMap.put("teamtype", otClassifyDyn.get("teamtype.id"));
            structProjectInfoMap.put("iscustom", otClassifyDyn.get("teamtype.iscustom"));
        }
    }

    protected String getPropKeyOrBaseDataType(String param, List<String> fromParams, List<String> targetParams) {
        if (CollectionUtils.isEmpty(fromParams) || CollectionUtils.isEmpty(targetParams) || fromParams.size() != targetParams.size()) {
            return "";
        }
        int i = fromParams.indexOf(param);
        if (i >= 0) {
            return targetParams.get(i);
        }
        return "";
    }
}

