/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.IRepository;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HAOSBaseRepository
implements IRepository {
    protected HRBaseServiceHelper serviceHelper;

    public HAOSBaseRepository(String entityName) {
        this.serviceHelper = new HRBaseServiceHelper(entityName);
    }

    public void save(DynamicObject[] dynamicObjects) {
        this.serviceHelper.save(dynamicObjects);
    }

    public void saveOne(DynamicObject dynamicObject) {
        this.serviceHelper.saveOne(dynamicObject);
    }

    public HRBaseServiceHelper getServiceHelper() {
        return this.serviceHelper;
    }

    public DynamicObject genEmptyDy(List<String> fieldList) {
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)this.serviceHelper.getEntityName(), fieldList);
        return new DynamicObject(subDataEntityType);
    }

    public DynamicObject genEmptyDy() {
        return this.serviceHelper.generateEmptyDynamicObject();
    }

    public DynamicObject queryOriginalOneByPk(String selectFields, Object pk) {
        return this.serviceHelper.queryOriginalOne(selectFields, pk);
    }

    public DynamicObject[] queryOriginalByPks(String selectFields, Collection<Long> pks) {
        QFilter idFilter = new QFilter("id", "in", pks);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObjectCollection queryOriginalColByPks(String selectFields, Collection<Long> pks) {
        QFilter idFilter = new QFilter("id", "in", pks);
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject queryByPk(String fields, Object pk) {
        QFilter idFilter = new QFilter("id", "=", pk);
        return this.serviceHelper.queryOne(fields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryByPks(String fields, Collection<Long> pks) {
        QFilter idFilter = new QFilter("id", "in", pks);
        return this.serviceHelper.query(fields, new QFilter[]{idFilter});
    }

    public DynamicObject[] loadByIds(Collection<Long> idSet) {
        QFilter idFilter = new QFilter("id", "in", idSet);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public Object[] update(DynamicObject[] dynamicObjects) {
        return this.serviceHelper.update(dynamicObjects);
    }

    public void deleteByIds(Object[] ids) {
        this.serviceHelper.delete(ids);
    }

    public QFilter currentVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
    }

    public QFilter hisVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
    }

    public QFilter initFinishedFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public QFilter enabledFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public QFilter disabledFilter() {
        return new QFilter("enable", "=", (Object)"0");
    }

    public QFilter effDataStatusFilter() {
        return new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
    }

    public QFilter invalidedDataStatusFilter() {
        return new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.INVALIDED.getStatus());
    }

    public QFilter dataStatusFilter() {
        return new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()});
    }

    public QFilter bsedFilter(Date bsed) {
        Date date = HRDateTimeUtils.truncateDate((Date)bsed);
        return new QFilter("bsed", "<=", (Object)date);
    }

    public QFilter blsedFilter(Date blsed) {
        Date date = HRDateTimeUtils.truncateDate((Date)blsed);
        return new QFilter("bsled", ">=", (Object)date);
    }
}

