/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository;

import java.util.Date;
import java.util.List;
import java.util.function.Function;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class QFilterHelper {
    public static QFilter createInitFinishedFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    public static QFilter createEnabledFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static QFilter createEnablingFilter() {
        return new QFilter("enable", "=", (Object)"10");
    }

    public static QFilter create1NotEquals1Filter() {
        return new QFilter("1", "!=", (Object)1);
    }

    public static QFilter create1Equals1Filter() {
        return new QFilter("1", "=", (Object)1);
    }

    public static QFilter createHisCurrentDataFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')).and("datastatus", "=", (Object)Character.valueOf('1'));
    }

    public static QFilter createValidHisCurrentDataFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')).and("datastatus", "in", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
    }

    public static QFilter createEffectingDataFilter() {
        return new QFilter("datastatus", "in", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
    }

    public static QFilter createCurrentVersionDataFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
    }

    public static QFilter createValidHisVersionFilter(Date bsed) {
        return QFilterHelper.createValidHisVersionFilter().and(new QFilter("bsled", ">=", (Object)bsed));
    }

    public static QFilter createValidHisVersionFilterByOnePoint(Date bsed) {
        Date date = HRDateTimeUtils.truncateDate((Date)bsed);
        return QFilterHelper.createValidHisVersionFilter().and(new QFilter("bsed", "<=", (Object)date)).and(new QFilter("bsled", ">=", (Object)date));
    }

    public static QFilter createValidHisVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()}));
    }

    public static QFilter createEffectingHisVersionFilter() {
        return new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()));
    }

    public static QFilter[] convert2Array(List<QFilter> qFilterList, QFilter ... qFilters2) {
        return QFilterHelper.convert2Array(QFilterHelper.convert2Array(qFilterList), qFilters2);
    }

    public static QFilter[] convert2Array(List<QFilter> qFilterList) {
        if (qFilterList == null) {
            return null;
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    public static QFilter[] convert2Array(QFilter[] qFilters1, QFilter[] qFilters2) {
        if (qFilters2 == null && qFilters1 == null) {
            return null;
        }
        if (qFilters1 == null) {
            return qFilters2;
        }
        if (qFilters2 == null) {
            return qFilters1;
        }
        QFilter[] resultQFilters = new QFilter[qFilters1.length + qFilters2.length];
        System.arraycopy(qFilters1, 0, resultQFilters, 0, qFilters1.length);
        System.arraycopy(qFilters2, 0, resultQFilters, qFilters1.length, qFilters2.length);
        return resultQFilters;
    }

    public static QFilter createConvertedFieldFilter(QFilter qFilter, Function<String, String> setFieldFunction) {
        QFilter result = new QFilter(setFieldFunction.apply(qFilter.getProperty()), qFilter.getCP(), qFilter.getOriginValue());
        List nests = qFilter.getNests(true);
        nests.forEach(qFilterNest -> {
            QFilter targetFilter = qFilterNest.getFilter();
            QFilter newQFilter = new QFilter((String)setFieldFunction.apply(targetFilter.getProperty()), targetFilter.getCP(), targetFilter.getOriginValue());
            if (qFilterNest.isAnd()) {
                result.and(newQFilter);
            } else {
                result.or(newQFilter);
            }
        });
        return result;
    }

    public static QFilter createOverlapsFilter(Date startDate, Date endDate) {
        return new QFilter("bsed", "<=", (Object)endDate).and("bsled", ">=", (Object)startDate);
    }
}

