/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.adorg;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;

public class OrgBusinessFileRepository
extends HAOSBaseRepository {
    private OrgBusinessFileRepository() {
        super("haos_orgbusinessfile");
    }

    public static OrgBusinessFileRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] queryDysByOrg(String selectFields, Set<Long> orgIdSet) {
        QFilter qFilter = new QFilter("adminorg", "in", orgIdSet);
        qFilter.and(QFilterHelper.createInitFinishedFilter());
        qFilter.and("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        return this.serviceHelper.query(selectFields, qFilter.toArray());
    }

    public DynamicObject[] loadColByOrg(Set<Long> orgIdSet, Date startDate) {
        QFilter qFilter = new QFilter("adminorg", "in", orgIdSet);
        qFilter.and("bsled", ">=", (Object)startDate);
        qFilter.and(QFilterHelper.createInitFinishedFilter());
        qFilter.and(QFilterHelper.createValidHisVersionFilter());
        return this.serviceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public void deleteVirtualByOrgSet(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("adminorg", "in", orgSet);
        qFilter.and("adminorg.isvirtualorg", "=", (Object)Boolean.TRUE);
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    private static class Instance {
        private static OrgBusinessFileRepository INSTANCE = new OrgBusinessFileRepository();

        private Instance() {
        }
    }
}

