/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.customstruct;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;

public class CustomOrgTeamEmpRepository
extends HRBaseServiceHelper {
    private static final CustomOrgTeamEmpRepository REPOSITORY = new CustomOrgTeamEmpRepository("haos_cusempposorgrel");

    public CustomOrgTeamEmpRepository(String entityName) {
        super(entityName);
    }

    public static CustomOrgTeamEmpRepository getRepository() {
        return REPOSITORY;
    }

    public Map<Long, Integer> countByOrgTeamIds(List<Long> orgTeamIds) {
        QFilter filter = new QFilter("orgteam", "in", orgTeamIds);
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        QFilter[] filters = new QFilter[]{filter};
        Object[] orgTeamPersons = REPOSITORY.query("depemp,orgteam.id,outperson,datasource", filters);
        if (HRArrayUtils.isEmpty((Object[])orgTeamPersons)) {
            return Collections.emptyMap();
        }
        Map orgTeamRoleMap = Arrays.stream(orgTeamPersons).collect(Collectors.groupingBy(orgTeamRole -> orgTeamRole.getLong("orgteam.id"), Collectors.toList()));
        return orgTeamRoleMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List employees = (List)entry.getValue();
            int count = 0;
            HashSet<Long> employeeIds = new HashSet<Long>(employees.size());
            HashSet<Long> outperIds = new HashSet<Long>(employees.size());
            for (DynamicObject employee : employees) {
                if (employee.getBoolean("datasource")) {
                    long employeeId = employee.getLong("depemp.employee.id");
                    if (!employeeIds.contains(employeeId)) {
                        ++count;
                    }
                    if (employeeId == 0L) continue;
                    employeeIds.add(employeeId);
                    continue;
                }
                long outPerId = employee.getLong("outperson.id");
                if (!outperIds.add(outPerId)) continue;
                ++count;
            }
            return count;
        }));
    }
}

