/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.customstruct;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CustomOrgTeamRepository
extends HRBaseServiceHelper {
    private static final CustomOrgTeamRepository REPOSITORY = new CustomOrgTeamRepository("haos_cusadminorgteam");

    public CustomOrgTeamRepository(String entityName) {
        super(entityName);
    }

    public static CustomOrgTeamRepository getRepository() {
        return REPOSITORY;
    }

    public Map<Long, List<DynamicObject>> queryByParentIds(List<Long> parentIds, List<Long> ignoreIds, String selectProperties, boolean isOnlyQueryEnable) {
        Object[] childOrgTeams;
        QFilter filter = new QFilter("parent", "in", parentIds);
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        if (isOnlyQueryEnable) {
            filter.and(new QFilter("enable", "=", (Object)"1"));
        }
        if (!CollectionUtils.isEmpty(ignoreIds)) {
            filter.and(new QFilter("id", "not in", ignoreIds));
        }
        QFilter[] filters = new QFilter[]{filter};
        Object[] objectArray = childOrgTeams = HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(String.join((CharSequence)",", selectProperties, "parent.id"), filters);
        if (HRArrayUtils.isEmpty((Object[])childOrgTeams)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(childOrgTeams).collect(Collectors.groupingBy(orgTeam -> orgTeam.getLong("parent.id")));
    }

    public Map<Long, DynamicObject> queryByIds(List<Long> ids, String selectProperties) {
        Object[] orgTeams;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        Object[] objectArray = orgTeams = HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(selectProperties, filters);
        if (HRArrayUtils.isEmpty((Object[])orgTeams)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(orgTeams).collect(Collectors.toMap(orgTeam -> orgTeam.getLong("id"), orgTeam -> orgTeam, (v1, v2) -> v1));
    }

    public Map<Long, List<DynamicObject>> queryEffectingRepeatNameChildOrgTeams(List<Long> parentIds, List<Long> ignoreBoIds, List<String> names, Date earliestEffectDate, Date latestEffectDate) {
        QFilter filter = QFilterHelper.createEffectingDataFilter();
        filter.and(new QFilter("parent", "in", parentIds));
        filter.and(new QFilter("boid", "not in", ignoreBoIds));
        filter.and(new QFilter("name", "in", names));
        filter.and(new QFilter("bsed", "<=", (Object)latestEffectDate).and(new QFilter("bsled", ">=", (Object)earliestEffectDate)));
        Object[] orgTeams = REPOSITORY.query(String.join((CharSequence)",", "parent.id", "bsed", "bsled"), filter.toArray());
        if (HRArrayUtils.isEmpty((Object[])orgTeams)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(orgTeams).collect(Collectors.groupingBy(dy -> dy.getLong("parent.id")));
    }

    public Set<String> existRepeatNumbers(List<String> realNumbers, List<Long> ignoreBoIds) {
        QFilter[] filters;
        Object[] dys;
        QFilter filter = new QFilter("number", "in", realNumbers);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (!CollectionUtils.isEmpty(ignoreBoIds)) {
            filter.and(new QFilter("boid", "not in", ignoreBoIds));
        }
        if (HRArrayUtils.isEmpty((Object[])(dys = REPOSITORY.query("number", filters = filter.toArray())))) {
            return Collections.emptySet();
        }
        return Arrays.stream(dys).map(dy -> dy.getString("number")).collect(Collectors.toSet());
    }

    public DynamicObject[] queryCurByRightLikeStructLongNumber(List<String> structLongNumbers, String selectProperties) {
        if (CollectionUtils.isEmpty(structLongNumbers)) {
            return new DynamicObject[0];
        }
        QFilter filter = QFilterHelper.createHisCurrentDataFilter();
        QFilter structLongNumberFilter = this.getRightLikeFilter("structlongnumber", structLongNumbers.get(0));
        if (structLongNumbers.size() > 1) {
            for (int i = 1; i < structLongNumbers.size(); ++i) {
                structLongNumberFilter.or(this.getRightLikeFilter("structlongnumber", structLongNumbers.get(i)));
            }
        }
        filter.and(structLongNumberFilter);
        filter.and(new QFilter("structlongnumber", "not in", structLongNumbers));
        QFilter[] filters = filter.toArray();
        return HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(selectProperties, filters);
    }

    private QFilter getRightLikeFilter(String key, String value) {
        return new QFilter(key, "like", (Object)(value + "%"));
    }

    public DynamicObject[] queryRecentHisVersion(Set<Long> boIds) {
        if (boIds == null || boIds.isEmpty()) {
            return null;
        }
        QFilter boidFilter = new QFilter("boid", "in", boIds);
        QFilter idFilter = new QFilter("id", "not in", boIds);
        QFilter StatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        return REPOSITORY.loadDynamicObjectArray(new QFilter[]{boidFilter, idFilter, StatusFilter});
    }

    public void updateLatestOrgTeamHisId(long[] cusOrgTeamStructBoIds) {
        QFilter filter = new QFilter("id", "in", (Object)cusOrgTeamStructBoIds);
        DynamicObject[] customOrgTeamStructArray = REPOSITORY.query(String.join((CharSequence)",", "orgteamhisid", "orgteam.id"), filter.toArray());
        if (customOrgTeamStructArray.length == 0) {
            return;
        }
        Arrays.stream(customOrgTeamStructArray).forEach(dy -> dy.set("orgteamhisid", (Object)dy.getLong("orgteam.id")));
        REPOSITORY.save(customOrgTeamStructArray);
    }
}

