/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.customstruct;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CustomOrgTeamStructRepository
extends HRBaseServiceHelper {
    private static final CustomOrgTeamStructRepository REPOSITORY = new CustomOrgTeamStructRepository("haos_customotstruct");

    public CustomOrgTeamStructRepository(String entityName) {
        super(entityName);
    }

    public static CustomOrgTeamStructRepository getRepository() {
        return REPOSITORY;
    }

    public DynamicObject[] queryCurDyByOrgTeamBoIds(List<Long> orgTeamBoIds, String selectProperties) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return new DynamicObject[0];
        }
        QFilter hisCurrentDataFilter = QFilterHelper.createHisCurrentDataFilter();
        QFilter orgTeamBoIdFilter = new QFilter("orgteam", "in", orgTeamBoIds);
        QFilter[] filters = new QFilter[]{hisCurrentDataFilter, orgTeamBoIdFilter};
        return HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(selectProperties, filters);
    }

    public QFilter getOrgTeamTreeFilterByProjectStructId(Long structProjectId) {
        QFilter filter = QFilterHelper.createHisCurrentDataFilter();
        DynamicObject[] customOrgTeamStructArray = REPOSITORY.query("orgteam.id", new QFilter[]{new QFilter("structproject", "=", (Object)structProjectId)});
        if (customOrgTeamStructArray.length > 0) {
            Set orgTeamIds = Arrays.stream(customOrgTeamStructArray).map(customOrgTeamStruct -> customOrgTeamStruct.getLong("orgteam.id")).collect(Collectors.toSet());
            filter.and(new QFilter("id", "in", orgTeamIds));
        }
        return filter;
    }

    public boolean isRoot(long orgTeamId) {
        QFilter filter = QFilterHelper.createHisCurrentDataFilter();
        filter.and(new QFilter("orgteam", "=", (Object)orgTeamId));
        filter.and(new QFilter("isroot", "=", (Object)"1"));
        return REPOSITORY.isExists(filter.toArray());
    }

    public Set<Long> filterRootOrgTeamIds(List<Long> orgTeamIds) {
        if (CollectionUtils.isEmpty(orgTeamIds)) {
            return Collections.emptySet();
        }
        QFilter filter = QFilterHelper.createHisCurrentDataFilter();
        filter.and(new QFilter("orgteam", "in", orgTeamIds));
        filter.and(new QFilter("isroot", "=", (Object)"1"));
        DynamicObject[] rootOrgTeams = REPOSITORY.query("orgteam.id", filter.toArray());
        if (rootOrgTeams.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(rootOrgTeams).map(dy -> dy.getLong("orgteam.id")).collect(Collectors.toSet());
    }

    public DynamicObjectCollection queryValidColByStructProject(String selectFields, Long structProjectId, QFilter permQFilter, QFilter otherQFilter, String orderBys) {
        QFilter filter = new QFilter("structproject", "=", (Object)structProjectId);
        filter.and(QFilterHelper.createInitFinishedFilter());
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        if (otherQFilter == null) {
            filter.and("enable", "in", Arrays.asList("10", "1"));
        } else {
            filter.and(otherQFilter);
        }
        QFilter[] qFilters = permQFilter == null ? filter.toArray() : new QFilter[]{filter, permQFilter};
        return HRStringUtils.isEmpty((String)selectFields) ? REPOSITORY.queryOriginalCollection(selectFields, qFilters) : REPOSITORY.queryOriginalCollection(selectFields, qFilters, orderBys);
    }

    public DynamicObjectCollection queryColByOrgAndStructProject(String selectProperties, Set<Long> orgIds, Long structProjectId) {
        QFilter filter = new QFilter("orgteam", "in", orgIds);
        filter.and("structproject", "=", (Object)structProjectId);
        return REPOSITORY.queryOriginalCollection(selectProperties, new QFilter[]{filter, QFilterHelper.createInitFinishedFilter(), QFilterHelper.createValidHisCurrentDataFilter()});
    }

    public Map<Long, DynamicObject> queryByOrgTeamIds(String selectProperties, List<Long> orgTeamIds) {
        DynamicObject[] orgTeamStructArrays;
        QFilter filter = new QFilter("orgteam", "in", orgTeamIds);
        QFilter[] filters = new QFilter[]{filter, new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'))};
        DynamicObject[] dynamicObjectArray = orgTeamStructArrays = HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(selectProperties, filters);
        if (orgTeamStructArrays.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(orgTeamStructArrays).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), dy -> dy, (v1, v2) -> v1));
    }

    public DynamicObject getRootOrgTeamStruct(String selectProperties, long structProjectId) {
        QFilter filter = QFilterHelper.createHisCurrentDataFilter();
        filter.and(new QFilter("structproject", "=", (Object)structProjectId));
        filter.and(new QFilter("isroot", "=", (Object)"1"));
        QFilter[] filters = filter.toArray();
        return HRStringUtils.isEmpty((String)selectProperties) ? REPOSITORY.loadDynamicObject(filters) : REPOSITORY.queryOne(selectProperties, filters);
    }
}

