/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.custroleemp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.discard.HisDiscardService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;

public class CustRoleEmpRepository {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("haos_cusempposorgrel");
    private static final CustRoleEmpRepository REPOSITORY = new CustRoleEmpRepository();

    private CustRoleEmpRepository() {
    }

    public static CustRoleEmpRepository getInstance() {
        return REPOSITORY;
    }

    public DynamicObject getEmpDescById(String entityNum, Long employId) {
        if (employId == null || employId == 0L) {
            return null;
        }
        return CommonRepository.queryDynamicObjectByPk(entityNum, "", employId);
    }

    public void discardBoData(DynamicObject[] dataEntities, String entityNum) {
        HisDiscardApiBo hisDiscardApiBo = new HisDiscardApiBo();
        hisDiscardApiBo.setEntityNumber(entityNum);
        Set boIdSet = Arrays.stream(dataEntities).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        hisDiscardApiBo.setBoIdSet(boIdSet);
        HisDiscardService.getInstance().discardBoData(hisDiscardApiBo);
    }

    public void saveOrEditHisData(DynamicObject[] hisDys, String entityNum) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber(entityNum);
        hisVersionParamBo.setAtomicTrans(true);
        hisVersionParamBo.setHisDyns(hisDys);
        HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
    }

    public DynamicObject setCollDy(DynamicObject dy, DynamicObject entityDy) {
        dy.set("orgteam", entityDy.get("enorgteam"));
        dy.set("customorole", entityDy.get("encustomorole"));
        dy.set("ischarge", entityDy.get("enischarge"));
        dy.set("startdate", entityDy.get("enstartdate"));
        Date endDate = entityDy.getDate("ensysenddate");
        if (endDate != null) {
            dy.set("sysenddate", (Object)endDate);
        } else {
            dy.set("sysenddate", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
        }
        dy.set("description", entityDy.get("endescription"));
        dy.set("index", entityDy.get("enindex"));
        dy.set("bsed", (Object)new Date());
        return dy;
    }

    public DynamicObject setCustRelDyName(DynamicObject sourceDy, DynamicObject targetDy) {
        targetDy.set("name", sourceDy.get("name"));
        return targetDy;
    }

    public DynamicObject setCustRelDy(DynamicObject sourceDy, DynamicObject targetDy) {
        targetDy.set("depemp", sourceDy.get("depemp"));
        targetDy.set("number", sourceDy.get("number"));
        targetDy.set("name", sourceDy.get("name"));
        targetDy.set("person", sourceDy.get("person"));
        targetDy.set("outperson", sourceDy.get("outperson"));
        targetDy.set("datasource", sourceDy.get("datasource"));
        targetDy.set("businessstatus", sourceDy.get("businessstatus"));
        targetDy.set("person", sourceDy.get("person"));
        targetDy.set("bsed", (Object)new Date());
        targetDy.set("initstatus", (Object)"2");
        targetDy.set("initdatasource", (Object)"0");
        return targetDy;
    }

    public DynamicObject setCustRoleDy(DynamicObject sourceDy, DynamicObject targetDy) {
        targetDy.set("number", sourceDy.get("number"));
        targetDy.set("name", sourceDy.get("name"));
        targetDy.set("orgteam", sourceDy.get("orgteam"));
        targetDy.set("index", sourceDy.get("index"));
        targetDy.set("bsed", (Object)new Date());
        targetDy.set("status", (Object)"C");
        targetDy.set("enable", (Object)"1");
        targetDy.set("sourcetpl", sourceDy.get("sourcetpl"));
        return targetDy;
    }

    public List<DynamicObject> getCustRoleTargetData(DynamicObject[] entities) {
        if (entities == null || entities.length == 0) {
            return new ArrayList<DynamicObject>(1);
        }
        ArrayList<DynamicObject> hisAddData = new ArrayList<DynamicObject>(entities.length);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_customorole");
        long[] ids = ORM.create().genLongIds("haos_customorole", entities.length);
        for (int i = 0; i < entities.length; ++i) {
            DynamicObject sourceDy = entities[i];
            DynamicObject targetDy = helper.generateEmptyDynamicObject();
            targetDy.set("id", (Object)ids[i]);
            targetDy.set("masterid", (Object)ids[i]);
            this.setCustRoleDy(sourceDy, targetDy);
            hisAddData.add(targetDy);
        }
        return hisAddData;
    }

    public void viewEntryRow(DynamicObject[] dys, IFormView view, Map<String, String> fieldKey) {
        if (dys == null || dys.length == 0) {
            return;
        }
        List roleList = Arrays.stream(dys).sorted((o1, o2) -> {
            int o1Index = o1.getInt("index");
            int o2Index = o2.getInt("index");
            if (o1Index == 0) {
                return 1;
            }
            if (o2Index == 0) {
                return -1;
            }
            return o1Index > o2Index ? -1 : 1;
        }).collect(Collectors.toList());
        int[] rows = view.getModel().batchCreateNewEntryRow("entryentity", roleList.size());
        for (int i = 0; i < roleList.size(); ++i) {
            DynamicObject entryDy = (DynamicObject)roleList.get(i);
            for (Map.Entry<String, String> entry : fieldKey.entrySet()) {
                view.getModel().setValue(entry.getKey(), entryDy.get(entry.getValue()), rows[i]);
            }
        }
        view.getModel().endInit();
        view.updateView("entryentity");
    }

    public QFilter getFilterByStructProject(Long structprojectId, String key) {
        QFilter filter = new QFilter("structproject.id", "=", (Object)structprojectId).and(QFilterHelper.createValidHisCurrentDataFilter());
        DynamicObject[] orgTeams = CommonRepository.queryDynamicObjects("haos_customotstruct", "orgteam.id", filter);
        if (orgTeams != null && orgTeams.length > 0) {
            Set orgTeamId = Arrays.stream(orgTeams).map(team -> team.getLong("orgteam.id")).collect(Collectors.toSet());
            return new QFilter(key, "in", orgTeamId);
        }
        return null;
    }
}

