/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.orgteam;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.IRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;

public class OTQueryRepository
extends HAOSBaseRepository
implements IRepository {
    private OTQueryRepository() {
        super("haos_orgteamquery");
    }

    public static OTQueryRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObjectCollection queryHisColByBoId(String selectFields, Set<Long> set) {
        QFilter boFilter = new QFilter("boid", "in", set);
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{boFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] loadByBoId(Set<Long> set) {
        QFilter filter = new QFilter("boid", "in", set);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObject[] queryOriginalCurrentVersionById(String selectFields, Set<Long> boIdSet) {
        QFilter boIdFilter = new QFilter("boid", "in", boIdSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{boIdFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] queryByBoIdAndDataStatus(String fields, Set<Long> boIdSet, List<String> dataStatusList) {
        QFilter qFilter = new QFilter("boid", "in", boIdSet);
        qFilter.and("datastatus", "in", dataStatusList);
        return this.serviceHelper.query(fields, qFilter.toArray());
    }

    public DynamicObject[] loadAllDataByBo(Set<Long> boSet) {
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", boSet)});
    }

    public DynamicObject[] queryOriginalArrById(String selectFields, Set<Long> idSet) {
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] queryOrgById(Set<Long> idSet) {
        return this.serviceHelper.query("id, boid, org.id", new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] queryOrgById(String selectFields, Set<Long> idSet) {
        return this.serviceHelper.query(selectFields, new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] queryAllDataByBo(String selectFields, Set<Long> boSet) {
        return this.serviceHelper.query(selectFields, new QFilter[]{new QFilter("boid", "in", boSet)});
    }

    public DynamicObject[] queryCurrentByParent(String selectFields, Set<Long> idSet) {
        QFilter parentFilter = new QFilter("parent", "in", idSet);
        return this.serviceHelper.query(selectFields, new QFilter[]{parentFilter, QFilterHelper.createValidHisCurrentDataFilter()});
    }

    public DynamicObject[] query4Cascade(Set<Long> boSet, Date date) {
        QFilter boFilter = new QFilter("boid", "in", boSet);
        QFilter hisFilter = QFilterHelper.createValidHisVersionFilter(date);
        return this.serviceHelper.queryOriginalArray("id, boid, org.id, bsed, bsled", new QFilter[]{boFilter, hisFilter});
    }

    public DynamicObject[] loadAllByBoId(Collection boIds) {
        QFilter boFilter = new QFilter("boid", "in", (Object)boIds);
        QFilter hisCurrentDataFilter = QFilterHelper.createHisCurrentDataFilter();
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, hisCurrentDataFilter});
    }

    public DynamicObject[] loadAllHisByBoId(Collection boIds) {
        QFilter boFilter = new QFilter("boid", "in", (Object)boIds);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{boFilter, QFilterHelper.createValidHisVersionFilter()});
    }

    public DynamicObjectCollection queryColByNumber(String fields, Set<String> numberSet, Set<Long> boIdSet) {
        QFilter qFilter = new QFilter("number", "in", numberSet);
        if (!CollectionUtils.isEmpty(boIdSet)) {
            qFilter.and("boid", "not in", boIdSet);
        }
        return this.serviceHelper.queryOriginalCollection(fields, new QFilter[]{qFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryColByStructNumber(String fields, Set<String> structNumberSet) {
        QFilter qFilter = new QFilter("structnumber", "in", structNumberSet);
        return this.serviceHelper.queryOriginalCollection(fields, new QFilter[]{qFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryColByParent(String fields, Set<Long> parentSet) {
        QFilter qFilter = new QFilter("parent", "in", parentSet);
        return this.serviceHelper.queryOriginalCollection(fields, new QFilter[]{qFilter, QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryColByBoIdAndDate(Set<Long> boIdSet, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("boid", "in", boIdSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter());
        qFilter.and(QFilterHelper.createInitFinishedFilter());
        qFilter.and(QFilterHelper.createOverlapsFilter(startDate, endDate));
        return this.serviceHelper.queryOriginalCollection("id,boid,otclassify,structnumber,bsed,bsled", qFilter.toArray());
    }

    @Override
    public DynamicObject[] queryPerformanceUpdateFields(Collection<Long> adminOrgIds) {
        QFilter boidFilter = new QFilter("boid", "in", adminOrgIds);
        return this.serviceHelper.query("boid, level, structlongnumber, sortcode", new QFilter[]{boidFilter, QFilterHelper.createEffectingDataFilter()});
    }

    public void deleteVirtualByOrgSet(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("boid", "in", orgSet);
        qFilter.and("isvirtualorg", "=", (Object)Boolean.TRUE);
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    private static class Instance {
        private static OTQueryRepository INSTANCE = new OTQueryRepository();

        private Instance() {
        }
    }
}

