/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.prjorg;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.util.FilterCommonUtils;

public class PRJOrgRepository
extends HAOSBaseRepository {
    private PRJOrgRepository() {
        super("haos_projteambaseinfo");
    }

    public static PRJOrgRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] query4Cascade(Set<Long> boSet, Date date) {
        QFilter boFilter = new QFilter("boid", "in", boSet);
        QFilter hisFilter = QFilterHelper.createValidHisVersionFilter(date);
        return this.serviceHelper.queryOriginalArray("id, boid, parentorg.id, org.id, belongadminorg.id, rootprojectteam.id, bsed, bsled", new QFilter[]{boFilter, hisFilter});
    }

    public DynamicObject[] queryOriginalByBoAndEffectData(String selectFields, Set<Long> boSet, Date effectDate) {
        QFilter boFilter = new QFilter("boid", "in", boSet);
        QFilter effectFilter = QFilterHelper.createValidHisVersionFilter(effectDate);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{boFilter, effectFilter});
    }

    public DynamicObject[] queryOriginalArray(String fields, QFilter[] qFilters) {
        return this.serviceHelper.queryOriginalArray(fields, qFilters);
    }

    public DynamicObject[] queryOriginalByStructNumbers(String selectFields, Set<String> structNumberSet) {
        QFilter structNumberFilter = new QFilter("structnumber", "in", structNumberSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{structNumberFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] queryRootProjectTeamWithSameAdOrg(String selectFields, Set<Long> adminOrgBoSet, Date bsed) {
        QFilter belongAdOrgFilter = new QFilter("belongadminorg", "in", adminOrgBoSet);
        QFilter rootProjectTeamFilter = new QFilter("parentorg.otclassify.id", "=", (Object)1010L);
        QFilter validHisVersionFilter = QFilterHelper.createValidHisVersionFilter(bsed);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(selectFields, new QFilter[]{belongAdOrgFilter, rootProjectTeamFilter, validHisVersionFilter, enableFilter});
    }

    public DynamicObject[] queryRootProjectTeamWithSameAdOrg(String selectFields, long adminOrgBo, Date bsed) {
        QFilter belongAdOrgFilter = new QFilter("belongadminorg", "=", (Object)adminOrgBo);
        QFilter rootProjectTeamFilter = new QFilter("parentorg.otclassify.id", "=", (Object)1010L);
        QFilter validHisVersionFilter = QFilterHelper.createValidHisVersionFilter(bsed);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(selectFields, new QFilter[]{belongAdOrgFilter, rootProjectTeamFilter, validHisVersionFilter, enableFilter});
    }

    public DynamicObject[] queryProjectTeamWithSameAdOrg(String selectFields, long adminOrgBo, Date bsed) {
        QFilter belongAdOrgFilter = new QFilter("belongadminorg", "=", (Object)adminOrgBo);
        QFilter validHisVersionFilter = QFilterHelper.createValidHisVersionFilter(bsed);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(selectFields, new QFilter[]{belongAdOrgFilter, validHisVersionFilter, enableFilter});
    }

    public DynamicObject[] queryProjectTeamWithSameAdOrg(String selectFields, Set<Long> adminOrgBo, Date bsed) {
        QFilter belongAdOrgFilter = new QFilter("belongadminorg", "in", adminOrgBo);
        QFilter validHisVersionFilter = QFilterHelper.createValidHisVersionFilter(bsed);
        return this.serviceHelper.query(selectFields, new QFilter[]{belongAdOrgFilter, validHisVersionFilter});
    }

    public DynamicObject[] loadRootProjectTeamWithSameAdOrg(Set<Long> adminOrgBoSet) {
        QFilter parentAdOrgFilter = new QFilter("parentorg", "in", adminOrgBoSet);
        QFilter validHisVersionFilter = QFilterHelper.createValidHisVersionFilter();
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{parentAdOrgFilter, validHisVersionFilter});
    }

    public DynamicObject[] getProTeamInfo(String selectFields, List<Long> proTeamIdList, Boolean isCurVersion, List<String> dataStatusList, String initStatus) {
        if (ObjectUtils.isEmpty(proTeamIdList)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("id", "in", proTeamIdList);
        FilterCommonUtils.andCommonFilterByParam(isCurVersion, dataStatusList, initStatus, filter);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id,bo,org,name,number,parentorg,rootprojectteam,bsed,bsled,datastatus,iscurrentversion,sourcevid";
        }
        QFilter[] filters = new QFilter[]{filter};
        return this.serviceHelper.query(selectFields, filters);
    }

    public DynamicObject[] getProTeamInfoByBoIdSet(String selectFields, Set<Long> proTeamBoIdSet, Boolean isCurVersion, List<String> dataStatusList, String initStatus, String orderByStr) {
        if (ObjectUtils.isEmpty(proTeamBoIdSet)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("boid", "in", proTeamBoIdSet);
        FilterCommonUtils.andCommonFilterByParam(isCurVersion, dataStatusList, initStatus, filter);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id,bo,org,name,number,parentorg,rootprojectteam,bsed,bsled,datastatus,iscurrentversion,sourcevid";
        }
        QFilter[] filters = new QFilter[]{filter};
        return this.serviceHelper.query(selectFields, filters, orderByStr);
    }

    public DynamicObject[] queryOriginalArrayCurrentDataByNumber(String selectFields, Set<String> numberSet) {
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{numberFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] queryEffectingHisData(String selectFields, Set<Long> boSet) {
        QFilter boFilter = new QFilter("boid", "in", boSet);
        return this.serviceHelper.query(selectFields, new QFilter[]{boFilter, QFilterHelper.createEffectingHisVersionFilter()});
    }

    public DynamicObject[] queryOriginalByNumberAndCurrentVersion(String selectFields, Set<String> numberSet) {
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{numberFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    private static class Instance {
        private static PRJOrgRepository INSTANCE = new PRJOrgRepository();

        private Instance() {
        }
    }
}

