/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.staff.occupy.bean.QueryStaffDetailParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DutyOrgDetailRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_dutyorgdetail");

    public static DutyOrgDetailRepository getInstance() {
        return StaffDutyOrgDetailInstance.INSTANCE;
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters) {
        return this.serviceHelper.queryOriginalArray(selectFields, filters);
    }

    public DynamicObject[] loadDutyOrgDetailByFilter(QFilter filter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, dataStatusFilter, filter});
    }

    public DynamicObject[] loadByFilter(QFilter[] filters) {
        return this.serviceHelper.loadDynamicObjectArray(filters);
    }

    public DynamicObject[] queryOriginalByStaffAndOrg(String selectFields, long staffId, Set<Long> orgBoSet) {
        QFilter idFilter = new QFilter("staff", "=", (Object)staffId);
        QFilter orgFilter = new QFilter("dutyorg.boid", "in", orgBoSet);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter, orgFilter});
    }

    public DynamicObject[] queryOriginalByStaff(String selectFields, long staffId) {
        QFilter idFilter = new QFilter("staff", "=", (Object)staffId);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryIncludeSubStaffByOrgId(List<Long> orgIdList, Date queryDate) {
        QFilter orgFilter = new QFilter("dutyorg", "in", orgIdList);
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam(queryDate);
        QFilter yearFilter = new QFilter("staff.year", ">=", (Object)queryStaffDetailParam.getMinDate());
        yearFilter.and("staff.year", "<=", (Object)queryStaffDetailParam.getMaxDate());
        return this.serviceHelper.queryOriginalArray("dutyorg, staff.org, staffcount, controlstrategy, elasticcontrol, elasticcount", new QFilter[]{orgFilter, enableFilter, dataStatusFilter, yearFilter});
    }

    private static class StaffDutyOrgDetailInstance {
        private static DutyOrgDetailRepository INSTANCE = new DutyOrgDetailRepository();

        private StaffDutyOrgDetailInstance() {
        }
    }
}

