/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class MuldimDetailRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_muldimendetail");

    public static MuldimDetailRepository getInstance() {
        return MuldimDetailInstance.INSTANCE;
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters) {
        return this.serviceHelper.queryOriginalArray(selectFields, filters);
    }

    public DynamicObject[] queryMuldimDetailData(List<Long> orgIds, List<Long> dimensionIds, String dimensionStr) {
        QFilter orgIdFilter = new QFilter("useorg.boid", "in", orgIds);
        QFilter mulIdFilter = new QFilter(dimensionStr, "in", dimensionIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        return this.serviceHelper.query("id,staff,useorg,vid,bo," + dimensionStr, new QFilter[]{orgIdFilter, mulIdFilter, statusFilter});
    }

    public DynamicObject[] queryMuldimDetail(List<Long> useOrgIdList) {
        QFilter orgFilter = new QFilter("useorg.id", "in", useOrgIdList);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgFilter, statusFilter});
    }

    public DynamicObject[] loadDimensionDetailByFilter(QFilter filter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, dataStatusFilter, filter});
    }

    public void save(DynamicObject[] dynArr) {
        this.serviceHelper.save(dynArr);
    }

    private static class MuldimDetailInstance {
        private static MuldimDetailRepository INSTANCE = new MuldimDetailRepository();

        private MuldimDetailInstance() {
        }
    }
}

