/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgPersonStaffInfoRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgpersonstaffinfo");
    private HRBaseServiceHelper bosOrgServiceHelper = new HRBaseServiceHelper("bos_org");

    public void delete(List<Long> delIdList) {
        this.serviceHelper.delete(delIdList.toArray());
    }

    public static OrgPersonStaffInfoRepository getInstance() {
        return PersonStaffInfoInstance.INSTANCE;
    }

    public DynamicObject[] queryPersonStaffInfoByPersonIds(List<Long> personIds) {
        QFilter personFilter = new QFilter("person", "in", personIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
    }

    public DynamicObject[] queryPersonStaffInfoCandidateIds(List<Long> candidateIds) {
        QFilter personFilter = new QFilter("candidate", "in", candidateIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter, statusFilter});
    }

    public DynamicObject[] queryPersonStaffInfoByDepEmpIds(List<Long> depEmpIds) {
        QFilter personFilter = new QFilter("orgperson", "in", depEmpIds);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{personFilter});
    }

    public List<Long> queryExistDepempIdList(List<Long> depempIdList) {
        QFilter qFilter = new QFilter("orgperson", "in", depempIdList);
        DynamicObject[] dys = this.serviceHelper.query("orgperson", new QFilter[]{qFilter});
        return Stream.of(dys).map(it -> it.getLong("orgperson_id")).collect(Collectors.toList());
    }

    public void save(DynamicObject[] dys) {
        this.serviceHelper.save(dys);
    }

    public DynamicObject[] queryEffectDataByDepempId(List<Long> depempIdList) {
        QFilter qFilter = new QFilter("orgperson", "in", depempIdList);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter, statusFilter});
    }

    public DynamicObject getEmptyDynWithId(String entityName, Long id) {
        DynamicObject dyn = this.serviceHelper.generateEmptyDynamicObject(entityName);
        dyn.set("id", (Object)id);
        return dyn;
    }

    public Map<Long, String> getOrgNumberById(List<Long> orgIdList) {
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        DynamicObject[] dyns = this.bosOrgServiceHelper.queryOriginalArray("id, number", new QFilter[]{idFilter});
        return Arrays.stream(dyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("number")));
    }

    public DynamicObject[] queryPersonStaffInfoById(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject[] queryByOrgIdListAndDate(List<Long> orgIdList, Date startDate) {
        QFilter useOrgIdFilter = new QFilter("orgteam", "in", orgIdList);
        QFilter dateFilter = new QFilter("leffdt", ">=", (Object)startDate);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgIdFilter, dateFilter});
    }

    public DynamicObject[] queryByPersonIdListAndDate(List<Long> personid, Date startDate) {
        QFilter useOrgIdFilter = new QFilter("person", "in", personid);
        QFilter dateFilter = new QFilter("leffdt", ">=", (Object)startDate);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgIdFilter, dateFilter});
    }

    private static class PersonStaffInfoInstance {
        private static OrgPersonStaffInfoRepository INSTANCE = new OrgPersonStaffInfoRepository();

        private PersonStaffInfoInstance() {
        }
    }
}

