/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgUseStaffDetailRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgusestaffdetail");

    public static OrgUseStaffDetailRepository getInstance() {
        return OrgUseStaffDetailInstance.INSTANCE;
    }

    public DynamicObject[] queryOrgUseStaffByUseOrgDetailIds(List<Long> useorgdetailEntryIds) {
        QFilter useOrgDetailFilter = new QFilter("useorgdetail", "in", useorgdetailEntryIds);
        QFilter statusFilter = new QFilter("status", "in", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgDetailFilter, statusFilter});
    }

    public DynamicObject[] queryOrgUseStaffByUidList(List<Long> uidList) {
        QFilter useOrgDetailFilter = new QFilter("id", "in", uidList);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgDetailFilter});
    }

    public void save(DynamicObject[] dys) {
        this.serviceHelper.save(dys);
    }

    public void delete(List<Long> pkList) {
        this.serviceHelper.delete(pkList.toArray());
    }

    public DynamicObject[] queryEffStaffByStaffPersonId(List<Long> personStaffInfoIds) {
        QFilter useOrgDetailFilter = new QFilter("personstaffinfo", "in", personStaffInfoIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"1");
        QFilter staffTypeFilter = new QFilter("stafftype", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgDetailFilter, statusFilter, staffTypeFilter});
    }

    public DynamicObject[] queryOrgUseStaffByDepEmpId(List<Long> depEmpIds) {
        QFilter depEmpIdsFilter = new QFilter("orgperson", "in", depEmpIds);
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"1", "2"});
        QFilter stafftypeFilter = new QFilter("stafftype", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{depEmpIdsFilter, statusFilter, stafftypeFilter});
    }

    public int countOrgUseStaffByDepEmpId(List<Long> depEmpIds) {
        QFilter depEmpIdsFilter = new QFilter("orgperson", "in", depEmpIds);
        QFilter stafftypeFilter = new QFilter("stafftype", "=", (Object)"1");
        return this.serviceHelper.count("haos_orgusestaffdetail", new QFilter[]{depEmpIdsFilter, stafftypeFilter});
    }

    public DynamicObject[] queryAllOrgUseStaffByPersonStaffInfoIds(List<Long> depEmpIds, String[] stafftype) {
        QFilter depEmpIdFilter = new QFilter("orgperson", "in", depEmpIds);
        QFilter stafftypeFilter = new QFilter("stafftype", "in", (Object)stafftype);
        return this.serviceHelper.query("id,orgperson,stafftype,effdt,leffdt,status,modifier,modifytime", new QFilter[]{depEmpIdFilter, stafftypeFilter}, "effdt desc,id desc");
    }

    public List<Long> queryExistDepEmpIdList(List<Long> depEmpIdList) {
        DynamicObject[] dys = this.serviceHelper.query("orgperson", new QFilter("orgperson", "in", depEmpIdList).and(OrgStaffConstants.EFF_INV_STATUS_QFILTER).toArray());
        return Stream.of(dys).map(it -> it.getLong("orgperson_id")).collect(Collectors.toList());
    }

    public DynamicObject[] queryOccupyUseStaffInfoByBOId(String selectField, Date queryDate, Set<Long> boIdSet) {
        QFilter filter = new QFilter("bo", "in", boIdSet);
        filter.and("status", "in", (Object)new String[]{"1", "2"});
        if (queryDate != null) {
            filter.and("effdt", "<=", (Object)queryDate);
            filter.and("leffdt", ">=", (Object)queryDate);
        }
        filter.and("stafftype", "in", (Object)new String[]{"1", "2", "4"});
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffStaffInfoByDepId(List<Long> depEmpIds) {
        QFilter depEmpIdFilter = new QFilter("orgperson", "in", depEmpIds);
        depEmpIdFilter.and("status", "=", (Object)"1");
        depEmpIdFilter.and("stafftype", "in", (Object)new String[]{"1", "2"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{depEmpIdFilter});
    }

    public DynamicObject[] queryUseStaffInfoByDepempIdInStaffType(List<Long> depempIdList, List<String> staffType) {
        QFilter useOrgIdFilter = new QFilter("orgperson", "in", depempIdList);
        if (staffType != null) {
            useOrgIdFilter.and(new QFilter("stafftype", "in", staffType));
        }
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgIdFilter});
    }

    private static class OrgUseStaffDetailInstance {
        private static OrgUseStaffDetailRepository INSTANCE = new OrgUseStaffDetailRepository();

        private OrgUseStaffDetailInstance() {
        }
    }
}

