/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import org.apache.commons.collections.CollectionUtils;

public class StaffProjectRepository
extends HAOSBaseRepository {
    public StaffProjectRepository() {
        super("haos_staffproject");
    }

    public static StaffProjectRepository getInstance() {
        return StaffProjectInstance.INSTANCE;
    }

    public List<String> getSpecialRuleList(Long staffProjectId) {
        DynamicObject[] dys = this.serviceHelper.query("entryentity.rule", new QFilter("id", "=", (Object)staffProjectId).toArray());
        if (Objects.isNull(dys)) {
            return Lists.newArrayList();
        }
        return Stream.of(dys).map(it -> it.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(it -> it.getString("rule")).collect(Collectors.toList());
    }

    public Map<Long, List<String>> getSpecialRuleListByIdList(List<Long> staffProjectIdList) {
        DynamicObject[] dys;
        HashMap map = Maps.newHashMap();
        for (DynamicObject dy : dys = this.serviceHelper.query("entryentity.rule", new QFilter("id", "in", staffProjectIdList).toArray())) {
            DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isNotEmpty((Collection)entry)) continue;
            map.put(dy.getLong("id"), entry.stream().map(it -> it.getString("rule")).collect(Collectors.toList()));
        }
        return map;
    }

    private static class StaffProjectInstance {
        private static StaffProjectRepository INSTANCE = new StaffProjectRepository();

        private StaffProjectInstance() {
        }
    }
}

