/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StaffRepository {
    private static Log LOG = LogFactory.getLog(StaffRepository.class);
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_staff");

    public static StaffRepository getInstance() {
        return StaffInstance.INSTANCE;
    }

    public DynamicObject[] loadDynamicObject(QFilter filter) {
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject loadDynamicObject(Long staffId) {
        QFilter idQFilter = new QFilter("id", "=", (Object)staffId);
        DynamicObject staffDyn = this.serviceHelper.loadDynamicObject(idQFilter);
        return staffDyn;
    }

    public List<Long> queryStaffIdList(Long orgId) {
        QFilter ruleQFilter = new QFilter("org", "=", (Object)orgId);
        QFilter enableQFilter = new QFilter("enable", "in", (Object)new String[]{"0", "1"});
        DynamicObject[] staffs = this.serviceHelper.query("id", new QFilter[]{ruleQFilter, enableQFilter});
        return Stream.of(staffs).map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject queryStaff(Long id) {
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        return this.serviceHelper.queryOne("id,org,staffproject,enable,status", new QFilter[]{idQFilter});
    }

    public DynamicObject[] queryStaffByIdList(List<Long> idList) {
        QFilter idQFilter = new QFilter("id", "in", idList);
        return this.serviceHelper.query("id,org,staffproject,enable,status,year", new QFilter[]{idQFilter});
    }

    public DynamicObject queryStaffById(String selectFields, long id) {
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        return this.serviceHelper.queryOriginalOne(selectFields, new QFilter[]{idQFilter});
    }

    public DynamicObject[] queryEnableDyns() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query("id, name, year", new QFilter[]{enableFilter});
    }

    public boolean isExistDynById(Long id) {
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        return this.serviceHelper.isExists(new QFilter[]{idQFilter});
    }

    public boolean isExistEnableOrDisableDynById(Long id) {
        QFilter idQFilter = new QFilter("id", "=", (Object)id);
        QFilter enableOrDisableFilter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        return this.serviceHelper.isExists(new QFilter[]{idQFilter, enableOrDisableFilter});
    }

    public DynamicObject[] queryEnableAndNotInIdDyns(List<Long> staffIdList) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter nameFilter = new QFilter("id", "not in", staffIdList);
        return this.serviceHelper.query("id, name", new QFilter[]{enableFilter, nameFilter});
    }

    public DynamicObject[] queryEnabingAndEnableStaffDyn() {
        QFilter enableQFilter = new QFilter("enable", "in", (Object)new String[]{"10", "1"});
        DynamicObject[] staffDyns = this.serviceHelper.query("id, org, year, staffcycle, staffproject", new QFilter[]{enableQFilter});
        return staffDyns;
    }

    public DynamicObject[] queryByStaffId(String selectFields, List<Long> staffIdList) {
        QFilter staffIdQFilter = new QFilter("id", "in", staffIdList);
        return this.serviceHelper.query(selectFields, new QFilter[]{staffIdQFilter});
    }

    public DynamicObject[] queryEnabledStaffByStaffId(String selectFields, List<Long> staffIdList) {
        QFilter staffIdQFilter = new QFilter("id", "in", staffIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(selectFields, new QFilter[]{staffIdQFilter, enableFilter});
    }

    public void deleteDynByStaffId(List<Long> staffIdList) {
        this.serviceHelper.delete(staffIdList.toArray());
    }

    public DynamicObject[] queryEnabledStaffIds() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.queryOriginalArray("id", new QFilter[]{enableFilter});
    }

    private static class StaffInstance {
        private static StaffRepository INSTANCE = new StaffRepository();

        private StaffInstance() {
        }
    }
}

