/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.staff;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.staff.occupy.bean.QueryStaffDetailParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

public class UseOrgDetailRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_useorgdetail");

    public static UseOrgDetailRepository getInstance() {
        return StaffUseOrgDetailInstance.INSTANCE;
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters) {
        return this.serviceHelper.queryOriginalArray(selectFields, filters);
    }

    public DynamicObject[] queryUseOrgDetailSimpleData(List<Long> orgIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_useorgdetail");
        QFilter orgFilter = new QFilter("useorg.boid", "in", orgIds);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        return serviceHelper.query("id,staff,useorg,vid,bo", new QFilter[]{orgFilter, statusFilter});
    }

    public List<Long> queryUseOrgIdList(List<Long> idList) {
        QFilter staffIdQFilter = new QFilter("staff.id", "in", idList);
        DynamicObject[] useOrgs = this.serviceHelper.query("useorgbo.id", new QFilter[]{staffIdQFilter});
        return Stream.of(useOrgs).map(it -> it.getLong("useorgbo")).distinct().collect(Collectors.toList());
    }

    public DynamicObject[] queryUseOrgDetail(List<Long> useOrgBoIdList) {
        QFilter useorgboFilter = new QFilter("useorgbo", "in", useOrgBoIdList);
        QFilter statusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        DynamicObject[] useOrgs = this.serviceHelper.query("id, useorg.id, useorgbo, bo", new QFilter[]{useorgboFilter, statusFilter});
        if (Objects.isNull(useOrgs)) {
            return new DynamicObject[0];
        }
        return useOrgs;
    }

    public DynamicObject[] queryUseOrgByStaffId(List<Long> staffIdList) {
        DynamicObject[] useOrgDynArr = this.serviceHelper.query("id, useorg.id, useorgbo, bo, staff, vid", new QFilter("staff", "in", staffIdList).toArray());
        if (Objects.isNull(useOrgDynArr)) {
            return new DynamicObject[0];
        }
        return useOrgDynArr;
    }

    public DynamicObject[] queryOriginalUseOrgStaff(List<Long> useOrgBoIdList, Date queryDate) {
        QFilter useOrgBoIdFilter = new QFilter("useorgbo", "in", useOrgBoIdList);
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QueryStaffDetailParam queryStaffDetailParam = new QueryStaffDetailParam(queryDate);
        QFilter yearFilter = new QFilter("staff.year", ">=", (Object)queryStaffDetailParam.getMinDate());
        yearFilter.and("staff.year", "<=", (Object)queryStaffDetailParam.getMaxDate());
        DynamicObject[] useOrgDynArr = this.serviceHelper.queryOriginalArray("id, staff.org, staff.staffcycle, dutyorg, useorg, controlstrategy, elasticcontrol, elasticcount, useorgbo, yearstaff, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12", new QFilter[]{useOrgBoIdFilter, enableFilter, dataStatusFilter, yearFilter});
        if (Objects.isNull(useOrgDynArr)) {
            return new DynamicObject[0];
        }
        return useOrgDynArr;
    }

    public DynamicObject[] queryUseOrgDetailById(Long id) {
        QFilter staffIdQFilter = new QFilter("staff.id", "=", (Object)id);
        QFilter statusQFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        return this.serviceHelper.query("id,staff,bo,useorg,useorgbo", new QFilter[]{staffIdQFilter, statusQFilter});
    }

    public DynamicObject[] queryUseOrgDetailByStaffId(String selectFields, long id) {
        QFilter staffIdQFilter = new QFilter("staff.id", "=", (Object)id);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(selectFields, new QFilter[]{staffIdQFilter, enableQFilter});
    }

    public DynamicObject[] queryUseOrgDynArrByIdList(List<Long> staffIdList) {
        QFilter staffIdFilter = new QFilter("staff", "in", staffIdList);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()});
        return this.serviceHelper.query("id, pid, staff, useorg", new QFilter[]{staffIdFilter, dataStatusFilter});
    }

    public DynamicObject[] loadUseOrgDetailByFilter(QFilter filter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{enableFilter, dataStatusFilter, filter});
    }

    public DynamicObject[] queryUseOrgDetailByFilter(String selectField, QFilter filter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()});
        return this.serviceHelper.query(selectField, new QFilter[]{enableFilter, filter});
    }

    public DynamicObject[] queryUseOrgDetailByDutyOrgId(String selectField, List<Long> dutyOrgIds, long staffId) {
        QFilter filter = new QFilter("dutyorg.boid", "in", dutyOrgIds);
        filter.and("staff", "=", (Object)staffId);
        filter.and("enable", "=", (Object)"1");
        filter.and("datastatus", "in", (Object)new String[]{EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()});
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public void save(DynamicObject[] dynArr) {
        this.serviceHelper.save(dynArr);
    }

    private static class StaffUseOrgDetailInstance {
        private static UseOrgDetailRepository INSTANCE = new UseOrgDetailRepository();

        private StaffUseOrgDetailInstance() {
        }
    }
}

