/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.orgmsg;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgAddMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgChangeMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgDisableMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgMergeOrSplitMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgParentChangeMsgService;
import kd.hr.haos.business.util.AdminStructLongNumberUtils;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;

public class CommonOrgMsgService {
    public static void handleBatchOrgMsg(DynamicObject[] entry, Map<Long, List<Long>> sceneSubMap, String operateKey) {
        if (entry == null || entry.length == 0) {
            return;
        }
        ArrayList<DynamicObject> orgAddEntryList = new ArrayList<DynamicObject>(entry.length);
        ArrayList<DynamicObject> orgParentChangeEntryList = new ArrayList<DynamicObject>(entry.length);
        ArrayList<DynamicObject> orgChangeEntryList = new ArrayList<DynamicObject>(entry.length);
        ArrayList<DynamicObject> orgDisableEntryList = new ArrayList<DynamicObject>(entry.length);
        HashMap<Long, DynamicObject> allAddBoIdMap = new HashMap<Long, DynamicObject>(entry.length);
        ArrayList<DynamicObject> orgMergeEntryList = new ArrayList<DynamicObject>(entry.length);
        ArrayList<DynamicObject> orgSplitEntryList = new ArrayList<DynamicObject>(entry.length);
        HashMap<Long, DynamicObject> allBoIdMap = new HashMap<Long, DynamicObject>(entry.length);
        HashMap<Long, List<Long>> adminOrgBoIdToIdMap = new HashMap<Long, List<Long>>(entry.length);
        HashMap<Long, Long> idToAdminOrgBoIdMap = new HashMap<Long, Long>(entry.length);
        HashMap<Long, DynamicObject> inMergeSplitMap = new HashMap<Long, DynamicObject>(entry.length);
        for (DynamicObject org : entry) {
            Long changeType = org.getLong("changetype.id");
            if (!ChangeTransactionConstants.CHANGE_TYPE_MERGE.equals(changeType) && !ChangeTransactionConstants.CHANGE_TYPE_SPLIT.equals(changeType)) {
                allBoIdMap.put(org.getLong("adminorg.boid"), org);
            } else {
                inMergeSplitMap.put(org.getLong("adminorg.boid"), org);
            }
            idToAdminOrgBoIdMap.put(org.getLong("id"), org.getLong("adminorg.boid"));
            List ids = adminOrgBoIdToIdMap.computeIfAbsent(org.getLong("adminorg.boid"), k -> new ArrayList());
            ids.add(org.getLong("id"));
        }
        CommonOrgMsgService.initSubScene(entry, sceneSubMap, adminOrgBoIdToIdMap, idToAdminOrgBoIdMap);
        for (DynamicObject org : entry) {
            Long changetype = org.getLong("changetype.id");
            if (ChangeTransactionConstants.ADD.equals(changetype)) {
                if (!inMergeSplitMap.containsKey(org.getLong("adminorg.boid"))) {
                    orgAddEntryList.add(org);
                }
                allAddBoIdMap.put(org.getLong("adminorg.boid"), org);
                continue;
            }
            if (ChangeTransactionConstants.PARENT.equals(changetype) && !inMergeSplitMap.containsKey(org.getLong("adminorg.boid"))) {
                orgParentChangeEntryList.add(org);
                continue;
            }
            if (ChangeTransactionConstants.INFO.equals(changetype) && !inMergeSplitMap.containsKey(org.getLong("adminorg.boid"))) {
                orgChangeEntryList.add(org);
                continue;
            }
            if (ChangeTransactionConstants.DISABLE.equals(changetype) && !inMergeSplitMap.containsKey(org.getLong("adminorg.boid"))) {
                orgDisableEntryList.add(org);
                continue;
            }
            if (ChangeTransactionConstants.CHANGE_TYPE_MERGE.equals(changetype)) {
                orgMergeEntryList.add(org);
                continue;
            }
            if (!ChangeTransactionConstants.CHANGE_TYPE_SPLIT.equals(changetype)) continue;
            orgSplitEntryList.add(org);
        }
        ReentrantLock lock = new ReentrantLock();
        String groupNumber = UUID.randomUUID().toString().replace("-", "");
        OrgAddMsgService orgAddMsgService = new OrgAddMsgService(allAddBoIdMap, lock, groupNumber);
        orgAddMsgService.handleChangeMsg(orgAddEntryList, sceneSubMap, operateKey);
        OrgParentChangeMsgService orgParentChangeMsgService = new OrgParentChangeMsgService(lock, groupNumber);
        orgParentChangeMsgService.handleChangeMsg(orgParentChangeEntryList, sceneSubMap, operateKey);
        OrgChangeMsgService orgChangeMsgService = new OrgChangeMsgService(lock, groupNumber);
        orgChangeMsgService.handleChangeMsg(orgChangeEntryList, sceneSubMap, operateKey);
        OrgDisableMsgService orgDisableMsgService = new OrgDisableMsgService(lock, groupNumber);
        AdminStructLongNumberUtils.sortBatchEntityByAdminStructLongNumber(orgDisableEntryList, true);
        orgDisableMsgService.handleChangeMsg(orgDisableEntryList, sceneSubMap, operateKey);
        OrgMergeOrSplitMsgService orgMergeMsgService = new OrgMergeOrSplitMsgService(allBoIdMap, allAddBoIdMap, true);
        orgMergeMsgService.handleChangeMsg(orgMergeEntryList, sceneSubMap, operateKey);
        OrgMergeOrSplitMsgService orgSplitMsgService = new OrgMergeOrSplitMsgService(allBoIdMap, allAddBoIdMap, false);
        orgSplitMsgService.handleChangeMsg(orgSplitEntryList, sceneSubMap, operateKey);
    }

    private static void initSubScene(DynamicObject[] entry, Map<Long, List<Long>> sceneSubMap, Map<Long, List<Long>> adminOrgBoIdToIdMap, Map<Long, Long> idToAdminOrgBoIdMap) {
        for (DynamicObject org : entry) {
            Long id;
            List<Long> longs;
            if (sceneSubMap == null || !sceneSubMap.containsKey(org.getLong("id")) || (longs = adminOrgBoIdToIdMap.get(id = idToAdminOrgBoIdMap.get(org.getLong("id")))) == null || longs.size() == 0) continue;
            for (Long entryId : longs) {
                if (entryId.equals(org.getLong("id"))) continue;
                sceneSubMap.put(entryId, sceneSubMap.get(org.getLong("id")));
            }
        }
    }

    public static void setMsgCommonProperty(DynamicObject msg, DynamicObject org, String operateKey) {
        msg.set("changescene", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changescene"));
        msg.set("changetype", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changetype"));
        msg.set("changeoperate", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changetype"));
        msg.set("changereason", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changereason"));
        msg.set("changedesc", (Object)org.getString("changedescription"));
        msg.set("effetdate", (Object)org.getDate("bsed"));
        msg.set("changeuser", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"creator"));
        if ("C".equals(operateKey)) {
            msg.set("adminorg", (Object)org.getLong("afterbaseinfoid"));
        } else {
            msg.set("adminorg", (Object)org.getLong("adminorg.id"));
        }
        msg.set("adminorgbo", (Object)org.getLong("adminorg.boid"));
    }

    public static Map<String, Object> setParams(DynamicObject msg, DynamicObject org, List<Long> sceneSub, boolean isEffect) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put("aftervid", org.getString("afterbaseinfoid"));
        params.put("boid", org.getString("adminorg.boid"));
        params.put("number", org.getString("number"));
        params.put("name", org.getString("name"));
        params.put("bsed", org.getDate("bsed"));
        params.put("changescene", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changescene"));
        params.put("changetype", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changetype"));
        params.put("changeoperate", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changetype"));
        params.put("changereason", HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)org, (String)"changereason"));
        params.put("billid", org.getString("billid"));
        params.put("entryid", org.getString("id"));
        params.put("tobedisableflag", org.getBoolean("tobedisableflag"));
        params.put("scenesub", sceneSub);
        if (isEffect) {
            params.put("eventid", org.getString("billid"));
        }
        params.put("beforeOrgId", org.getString("adminorg.org.id"));
        params.put("afterOrgId", org.getString("org.id"));
        msg.set("msgparams", (Object)SerializationUtils.serializeToBase64((Object)params));
        return params;
    }

    private static String getBuOrgId(DynamicObject org) {
        String orgId = null;
        String name = org.getDataEntityType().getName();
        orgId = "homs_batchorgentity".equals(name) ? org.getString("org.id") : org.getString("adminorg.org.id");
        return orgId;
    }
}

