/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.orgteam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamSortRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.business.domain.service.orgteam.ICustomOrgTeamService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CustomOrgTeamServiceImpl
implements ICustomOrgTeamService {
    private static Log LOGGER = LogFactory.getLog(CustomOrgTeamServiceImpl.class);
    private static final Date DATE_2999 = HisEffDateCommonService.getInstance().getDate2999(null);

    @Override
    public void add(List<DynamicObject> orgTeams) {
        if (CollectionUtils.isEmpty(orgTeams)) {
            return;
        }
        int size = orgTeams.size();
        LOGGER.info("add start size:{}", (Object)size);
        try {
            CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
            CustomOrgTeamSortRepository customOrgTeamSortRepository = CustomOrgTeamSortRepository.getRepository();
            CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
            CustomStructProjectRepository customStructProjectRepository = CustomStructProjectRepository.getRepository();
            long[] orgTeamBoIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
            long[] orgTeamHisIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
            long[] cusOrgTeamStructBoIds = ORM.create().genLongIds("haos_customotstruct", size);
            long[] cusOrgTeamSortBoIds = ORM.create().genLongIds("haos_customotsort", size);
            String[] structNumbers = ORM.create().genStringIds("haos_cusadminorgteam", size);
            long[] secondOrgTeamHisIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
            List<Long> structProjectIds = orgTeams.stream().map(orgTeam -> orgTeam.getLong("structproject.id")).collect(Collectors.toList());
            Map<Long, DynamicObject> structProjectMap = customStructProjectRepository.queryByStructProjectIds(structProjectIds, "otclassify");
            List<Long> otClassifyIds = structProjectMap.values().stream().map(dy -> dy.getLong("otclassify.id")).collect(Collectors.toList());
            Map<Long, String> prefixNumberMap = NumberPrefixRepository.getRepository().getNumberPrefixByIds(otClassifyIds);
            ArrayList<DynamicObject> secondOrgTeamList = new ArrayList<DynamicObject>(size);
            ArrayList<DynamicObject> secondCusOrgTeamStructList = new ArrayList<DynamicObject>(size);
            ArrayList<DynamicObject> secondCusOrgTeamSortList = new ArrayList<DynamicObject>(size);
            ArrayList<DynamicObject> cusOrgTeamStructList = new ArrayList<DynamicObject>(size);
            ArrayList<DynamicObject> cusOrgTeamSortList = new ArrayList<DynamicObject>(size);
            HashMap<Long, String> structLongNumberMap = new HashMap<Long, String>(size);
            HashMap<Long, String> sortCodeMap = new HashMap<Long, String>(size);
            List<Long> parentOrgTeamIds = orgTeams.stream().map(orgTeam -> orgTeam.getLong("parent.id")).collect(Collectors.toList());
            Map<Long, DynamicObject> parentOrgTeamMap = customOrgTeamRepository.queryByIds(parentOrgTeamIds, String.join((CharSequence)",", "structlongnumber", "sortcode"));
            if (!parentOrgTeamMap.isEmpty()) {
                parentOrgTeamMap.forEach((parentOrgTeamId, parentOrgTeam) -> {
                    structLongNumberMap.put((Long)parentOrgTeamId, parentOrgTeam.getString("structlongnumber"));
                    sortCodeMap.put((Long)parentOrgTeamId, parentOrgTeam.getString("sortcode"));
                });
            }
            for (int i = 0; i < size; ++i) {
                DynamicObject orgTeam2 = orgTeams.get(i);
                long orgTeamBoId = orgTeam2.getLong("id");
                if (orgTeamBoId == 0L) {
                    orgTeamBoId = orgTeamBoIds[i];
                }
                long cusOrgTeamStructBoId = cusOrgTeamStructBoIds[i];
                long cusOrgTeamSortBoId = cusOrgTeamSortBoIds[i];
                Date effStartDate = HRDateTimeUtils.truncateDate((Date)orgTeam2.getDate("bsed"));
                this.initCommonFieldValue(orgTeam2, orgTeamBoId, effStartDate);
                Long structProjectId = orgTeam2.getLong("structproject.id");
                DynamicObject structProject = structProjectMap.get(structProjectId);
                DynamicObject otClassify = structProject.getDynamicObject("otclassify");
                DynamicObject teamType = otClassify.getDynamicObject("teamtype");
                DynamicObject orgType = otClassify.getDynamicObject("orgtype");
                orgTeam2.set("otclassify", (Object)otClassify);
                orgTeam2.set("teamtype", (Object)teamType);
                orgTeam2.set("orgtype", (Object)orgType);
                String numberPrefix = prefixNumberMap.get(otClassify.getLong("id"));
                String showNumber = orgTeam2.getString("number");
                orgTeam2.set("number", (Object)CustomStructHelper.showNumberToRealNumber(showNumber, numberPrefix));
                DynamicObject parentOrgTeam2 = orgTeam2.getDynamicObject("parent");
                String sortCode = this.getSortCode(orgTeam2, sortCodeMap);
                String structNumber = structNumbers[i];
                orgTeam2.set("structnumber", (Object)structNumber);
                String structLongNumber = structNumber;
                boolean effStartDateDayBeforeParent = false;
                if (!HRObjectUtils.isEmpty((Object)parentOrgTeam2)) {
                    Date parentEffStartDate = parentOrgTeam2.getDate("bsed");
                    effStartDateDayBeforeParent = HRDateTimeUtils.dayBefore((Date)effStartDate, (Date)parentEffStartDate);
                    if (effStartDateDayBeforeParent) {
                        orgTeam2.set("parent", null);
                        sortCode = CustomStructHelper.generateSortCode(orgTeam2);
                    } else {
                        structLongNumber = this.getStructLongNumber(orgTeam2, structLongNumberMap);
                    }
                }
                orgTeam2.set("sortcode", (Object)sortCode);
                orgTeam2.set("structlongnumber", (Object)structLongNumber);
                orgTeam2.set("level", (Object)CustomStructHelper.calculateLevel(structLongNumber));
                structLongNumberMap.put(orgTeamBoId, structLongNumber);
                sortCodeMap.put(orgTeamBoId, sortCode);
                DynamicObject cusOrgTeamStruct = customOrgTeamStructRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)orgTeam2, (DynamicObject)cusOrgTeamStruct);
                cusOrgTeamStruct.set("id", (Object)cusOrgTeamStructBoId);
                cusOrgTeamStruct.set("orgteam", (Object)orgTeamBoId);
                cusOrgTeamStruct.set("parentorgteam", (Object)orgTeam2.getDynamicObject("parent"));
                long orgTeamHisId = orgTeamHisIds[i];
                cusOrgTeamStruct.set("orgteamhisid", (Object)orgTeamHisId);
                cusOrgTeamStructList.add(cusOrgTeamStruct);
                DynamicObject customOrgTeamSort = customOrgTeamSortRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)orgTeam2, (DynamicObject)customOrgTeamSort);
                customOrgTeamSort.set("id", (Object)cusOrgTeamSortBoId);
                customOrgTeamSort.set("orgteam", (Object)orgTeamBoId);
                cusOrgTeamSortList.add(customOrgTeamSort);
                if (!effStartDateDayBeforeParent) continue;
                Date parentEffStartDate = parentOrgTeam2.getDate("bsed");
                DynamicObject secondOrgTeam = customOrgTeamRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)orgTeam2, (DynamicObject)secondOrgTeam);
                long secondOrgTeamHisId = secondOrgTeamHisIds[i];
                secondOrgTeam.set("parent", (Object)parentOrgTeam2);
                secondOrgTeam.set("bsed", (Object)parentEffStartDate);
                String secondSortCode = this.getSortCode(secondOrgTeam, sortCodeMap);
                secondOrgTeam.set("sortcode", (Object)secondSortCode);
                String secondStructLongNumber = this.getStructLongNumber(secondOrgTeam, structLongNumberMap);
                secondOrgTeam.set("structlongnumber", (Object)secondStructLongNumber);
                secondOrgTeam.set("level", (Object)CustomStructHelper.calculateLevel(secondStructLongNumber));
                secondOrgTeam.set("id", (Object)secondOrgTeamHisId);
                secondOrgTeam.set("boid", (Object)orgTeamBoId);
                secondOrgTeamList.add(secondOrgTeam);
                structLongNumberMap.put(orgTeamBoId, secondStructLongNumber);
                sortCodeMap.put(orgTeamBoId, secondSortCode);
                DynamicObject secondCusOrgTeamStruct = customOrgTeamStructRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)secondOrgTeam, (DynamicObject)secondCusOrgTeamStruct);
                secondCusOrgTeamStruct.set("id", null);
                secondCusOrgTeamStruct.set("boid", (Object)cusOrgTeamStructBoId);
                secondCusOrgTeamStruct.set("parentorgteam", (Object)parentOrgTeam2);
                secondCusOrgTeamStruct.set("orgteamhisid", (Object)secondOrgTeamHisId);
                secondCusOrgTeamStruct.set("orgteam_id", (Object)orgTeamBoId);
                secondCusOrgTeamStructList.add(secondCusOrgTeamStruct);
                DynamicObject secondCustomOrgTeamSort = customOrgTeamSortRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)secondOrgTeam, (DynamicObject)secondCustomOrgTeamSort);
                secondCustomOrgTeamSort.set("id", null);
                secondCustomOrgTeamSort.set("boid", (Object)cusOrgTeamSortBoId);
                secondCustomOrgTeamSort.set("orgteam_id", (Object)orgTeamBoId);
                secondCusOrgTeamSortList.add(secondCustomOrgTeamSort);
            }
            HisResponse<BatchVersionChangeRespData> response = this.saveOrgTeam(orgTeams, cusOrgTeamStructList, cusOrgTeamSortList, orgTeamHisIds);
            this.updateStructCurOrgTeamHisId(response);
            if (!CollectionUtils.isEmpty(secondOrgTeamList)) {
                HisResponse<BatchVersionChangeRespData> secondVersionResponse = this.saveOrgTeam(secondOrgTeamList, secondCusOrgTeamStructList, secondCusOrgTeamSortList, null);
                this.updateStructCurOrgTeamHisId(secondVersionResponse);
            }
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25", (String)"CustomOrgTeamServiceImpl_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
            LOGGER.error(message, (Throwable)e);
            throw new KDBizException(message);
        }
        LOGGER.info("add end size:{}", (Object)size);
    }

    private String getStructLongNumber(DynamicObject orgTeam, Map<Long, String> structLongNumberMap) {
        DynamicObject parentOrgTeam = orgTeam.getDynamicObject("parent");
        String structNumber = orgTeam.getString("structnumber");
        if (HRObjectUtils.isEmpty((Object)parentOrgTeam)) {
            return structNumber;
        }
        Long parentOrgTeamId = parentOrgTeam.getLong("id");
        String parentStructLongNumber = structLongNumberMap.get(parentOrgTeamId);
        if (HRStringUtils.isEmpty((String)parentStructLongNumber)) {
            return structNumber;
        }
        return String.join((CharSequence)"!", parentStructLongNumber, structNumber);
    }

    private String getSortCode(DynamicObject orgTeam, Map<Long, String> secondSortCodeMap) {
        DynamicObject parentOrgTeam = orgTeam.getDynamicObject("parent");
        int index = orgTeam.getInt("index");
        String sortCode = "0000" + index;
        if (HRObjectUtils.isEmpty((Object)parentOrgTeam)) {
            return sortCode;
        }
        Long parentOrgTeamId = parentOrgTeam.getLong("id");
        String parentSortCode = secondSortCodeMap.get(parentOrgTeamId);
        if (HRStringUtils.isEmpty((String)parentSortCode)) {
            return sortCode;
        }
        return String.join((CharSequence)"!", parentSortCode, sortCode);
    }

    private void updateStructCurOrgTeamHisId(HisResponse<BatchVersionChangeRespData> response) {
        BatchVersionChangeRespData data = (BatchVersionChangeRespData)response.getData();
        if (data != null) {
            List versionChangeRespDataList = data.getVersionChangeRespDataList();
            ArrayList curVersionOrgTeamStructDys = new ArrayList(versionChangeRespDataList.size());
            List<DynamicObject[]> newOrgTeamStructDys = versionChangeRespDataList.stream().filter(versionChange -> HRStringUtils.equals((String)versionChange.getEntityNumber(), (String)"haos_customotstruct")).map(VersionChangeRespData::getNewDynamicObjects).collect(Collectors.toList());
            newOrgTeamStructDys.forEach(arrays -> curVersionOrgTeamStructDys.addAll(Arrays.stream(arrays).filter(dy -> HRStringUtils.equals((String)dy.getString("iscurrentversion"), (String)"true")).collect(Collectors.toList())));
            curVersionOrgTeamStructDys.forEach(dy -> dy.set("orgteamhisid", (Object)dy.getLong("orgteam_id")));
            SaveServiceHelper.update((DynamicObject[])curVersionOrgTeamStructDys.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void change(List<DynamicObject> orgTeams) {
        if (CollectionUtils.isEmpty(orgTeams)) {
            return;
        }
        int size = orgTeams.size();
        LOGGER.info("change start size:{}", (Object)size);
        try {
            DynamicObject[] orgTeamSortArrays;
            DynamicObject[] orgTeamStructArrays;
            CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
            CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
            CustomOrgTeamSortRepository customOrgTeamSortRepository = CustomOrgTeamSortRepository.getRepository();
            ArrayList<HisVersionParamBo> hisVersionParamBos = new ArrayList<HisVersionParamBo>(size);
            List<Long> ids = orgTeams.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Map<Long, DynamicObject> oldOrgTeamMap = customOrgTeamRepository.queryByIds(ids, String.join((CharSequence)",", "otclassify.id", "sortcode", "structlongnumber"));
            ArrayList<DynamicObject> hisChangeOrgTeams = new ArrayList<DynamicObject>(size);
            ArrayList<DynamicObject> curVersionChangeOrgTeams = new ArrayList<DynamicObject>(size);
            HashMap<Long, DynamicObject> orgTeamMap = new HashMap<Long, DynamicObject>(size);
            ArrayList<String> changedLongNumbers = new ArrayList<String>(size);
            HashMap<String, String> structLongNumberMap = new HashMap<String, String>(size);
            HashMap<String, String> structLongNumberSortCodeMap = new HashMap<String, String>(size);
            HashMap<String, String> structLongNumberOldSortCodeMap = new HashMap<String, String>(size);
            HashMap<String, Date> structLongNumberBsedMap = new HashMap<String, Date>(size);
            List<Long> otClassifyIds = oldOrgTeamMap.values().stream().map(dy -> dy.getLong("otclassify.id")).collect(Collectors.toList());
            Map<Long, String> prefixNumberMap = NumberPrefixRepository.getRepository().getNumberPrefixByIds(otClassifyIds);
            long[] orgTeamHisIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
            HashMap<Long, Long> orgTeamHisIdMap = new HashMap<Long, Long>(size);
            for (int i = 0; i < orgTeams.size(); ++i) {
                DynamicObject orgTeam = orgTeams.get(i);
                long orgTeamId = orgTeam.getLong("id");
                DynamicObject oldOrgTeam = oldOrgTeamMap.get(orgTeamId);
                Long otClassifyId = oldOrgTeam.getLong("otclassify.id");
                String numberPrefix = prefixNumberMap.get(otClassifyId);
                String showNumber = orgTeam.getString("number");
                DynamicObject[] realNumber = CustomStructHelper.showNumberToRealNumber(showNumber, numberPrefix);
                orgTeam.set("number", (Object)realNumber);
                orgTeamMap.put(orgTeamId, orgTeam);
                long parentOrgTeamId = orgTeam.getLong("parent.id");
                if (orgTeamMap.containsKey(parentOrgTeamId)) {
                    orgTeam.set("parent", orgTeamMap.get(parentOrgTeamId));
                }
                String oldSortCode = oldOrgTeam.getString("sortcode");
                String sortCode = CustomStructHelper.generateSortCode(orgTeam);
                orgTeam.set("sortcode", (Object)sortCode);
                String oldStructLongNumber = oldOrgTeam.getString("structlongnumber");
                String structLongNumber = CustomStructHelper.generateStructLongNumber(orgTeam);
                if (!HRStringUtils.equals((String)structLongNumber, (String)oldStructLongNumber)) {
                    changedLongNumbers.add(oldStructLongNumber);
                    structLongNumberMap.put(oldStructLongNumber, structLongNumber);
                    structLongNumberSortCodeMap.put(oldStructLongNumber, sortCode);
                    structLongNumberOldSortCodeMap.put(oldStructLongNumber, oldSortCode);
                    orgTeam.set("structlongnumber", (Object)structLongNumber);
                    orgTeam.set("level", (Object)CustomStructHelper.calculateLevel(structLongNumber));
                } else if (!HRStringUtils.equals((String)sortCode, (String)oldSortCode)) {
                    changedLongNumbers.add(oldStructLongNumber);
                    structLongNumberMap.put(oldStructLongNumber, structLongNumber);
                    structLongNumberSortCodeMap.put(oldStructLongNumber, sortCode);
                    structLongNumberOldSortCodeMap.put(oldStructLongNumber, oldSortCode);
                }
                structLongNumberBsedMap.put(oldStructLongNumber, orgTeam.getDate("bsed"));
                DynamicObject customOrgTeam = customOrgTeamRepository.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)orgTeam, (DynamicObject)customOrgTeam);
                long orgTeamHisId = orgTeamHisIds[i];
                customOrgTeam.set("id", (Object)orgTeamHisId);
                orgTeamHisIdMap.put(orgTeamId, orgTeamHisId);
                hisChangeOrgTeams.add(customOrgTeam);
            }
            hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(hisChangeOrgTeams.toArray(new DynamicObject[0]), "haos_cusadminorgteam", false));
            DynamicObject[] relChildOrgTeams = CustomOrgTeamRepository.getRepository().queryCurByRightLikeStructLongNumber(changedLongNumbers, null);
            int length = relChildOrgTeams.length;
            ArrayList<Long> orgTeamIds = new ArrayList<Long>(ids.size() + length);
            orgTeamIds.addAll(ids);
            HashMap relChildOrgTeamBsedMap = new HashMap(length);
            if (length > 0) {
                Arrays.stream(relChildOrgTeams).forEach(childOrgTeam -> {
                    long childOrgTeamId = childOrgTeam.getLong("id");
                    if (orgTeamMap.containsKey(childOrgTeamId)) {
                        return;
                    }
                    String oldStructLongNumber = childOrgTeam.getString("structlongnumber");
                    String oldSortCode = childOrgTeam.getString("sortcode");
                    for (Map.Entry entry : structLongNumberMap.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!oldStructLongNumber.startsWith(key) || HRStringUtils.equals((String)oldStructLongNumber, (String)key)) continue;
                        Date bsed = (Date)structLongNumberBsedMap.get(key);
                        if (bsed != null) {
                            relChildOrgTeamBsedMap.put(childOrgTeam.getLong("id"), bsed);
                        }
                        String structLongNumber = oldStructLongNumber.replace(key, (CharSequence)entry.getValue());
                        childOrgTeam.set("structlongnumber", (Object)structLongNumber);
                        String sortCode = oldSortCode.replaceFirst((String)structLongNumberOldSortCodeMap.get(key), (String)structLongNumberSortCodeMap.get(key));
                        childOrgTeam.set("sortcode", (Object)sortCode);
                        childOrgTeam.set("level", (Object)CustomStructHelper.calculateLevel(structLongNumber));
                        curVersionChangeOrgTeams.add((DynamicObject)childOrgTeam);
                        orgTeamIds.add(childOrgTeamId);
                        orgTeamMap.put(childOrgTeamId, (DynamicObject)childOrgTeam);
                        break;
                    }
                });
            }
            Map<Long, Long> relChildOrgTeamHisIdMap = null;
            DynamicObject[] recentHisDys = this.queryRecentHisVersion(curVersionChangeOrgTeams);
            if (recentHisDys != null && recentHisDys.length > 0) {
                relChildOrgTeamHisIdMap = Arrays.stream(recentHisDys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
            }
            if ((orgTeamStructArrays = customOrgTeamStructRepository.queryCurDyByOrgTeamBoIds(orgTeamIds, null)).length > 0) {
                ArrayList<DynamicObject> customOrgTeamStructList = new ArrayList<DynamicObject>(orgTeamStructArrays.length);
                for (DynamicObject orgTeamStruct : orgTeamStructArrays) {
                    Long hisId;
                    long orgTeamId = orgTeamStruct.getLong("orgteam.id");
                    DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(orgTeamId);
                    orgTeamStruct.set("parentorgteam", (Object)orgTeam.getLong("parent.id"));
                    orgTeamStruct.set("structlongnumber", (Object)orgTeam.getString("structlongnumber"));
                    orgTeamStruct.set("level", orgTeam.get("level"));
                    Date bsed = (Date)relChildOrgTeamBsedMap.get(orgTeamId);
                    if (bsed != null) {
                        if (bsed.after(orgTeamStruct.getDate("bsed"))) {
                            orgTeamStruct.set("bsed", (Object)bsed);
                        }
                    } else {
                        orgTeamStruct.set("bsed", (Object)orgTeam.getDate("bsed"));
                    }
                    if (orgTeamHisIdMap.containsKey(orgTeamId)) {
                        orgTeamStruct.set("orgteamhisid", orgTeamHisIdMap.get(orgTeamId));
                    } else if (relChildOrgTeamHisIdMap != null && (hisId = relChildOrgTeamHisIdMap.get(orgTeamId)) != null) {
                        orgTeamStruct.set("orgteamhisid", (Object)hisId);
                    }
                    DynamicObject customOrgTeamStruct = customOrgTeamStructRepository.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)orgTeamStruct, (DynamicObject)customOrgTeamStruct);
                    customOrgTeamStructList.add(customOrgTeamStruct);
                }
                hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(customOrgTeamStructList.toArray(new DynamicObject[0]), "haos_customotstruct", false));
            }
            if ((orgTeamSortArrays = customOrgTeamSortRepository.queryCurDyByOrgTeamBoIds(orgTeamIds, null)).length > 0) {
                ArrayList customOrgTeamSortList = new ArrayList(orgTeamSortArrays.length);
                Arrays.stream(orgTeamSortArrays).forEach(orgTeamSort -> {
                    long orgTeamId = orgTeamSort.getLong("orgteam.id");
                    DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(orgTeamId);
                    orgTeamSort.set("index", (Object)orgTeam.getInt("index"));
                    orgTeamSort.set("sortcode", (Object)orgTeam.getString("sortcode"));
                    Date bsed = (Date)relChildOrgTeamBsedMap.get(orgTeamId);
                    if (bsed != null) {
                        if (bsed.after(orgTeamSort.getDate("bsed"))) {
                            orgTeamSort.set("bsed", (Object)bsed);
                        }
                    } else {
                        orgTeamSort.set("bsed", (Object)orgTeam.getDate("bsed"));
                    }
                    DynamicObject customOrgTeamSort = customOrgTeamSortRepository.generateEmptyDynamicObject();
                    HRDynamicObjectUtils.copy((DynamicObject)orgTeamSort, (DynamicObject)customOrgTeamSort);
                    customOrgTeamSortList.add(customOrgTeamSort);
                });
                hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(customOrgTeamSortList.toArray(new DynamicObject[0]), "haos_customotsort", false));
            }
            HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
            hisVersionParamListBo.setAtomicTrans(false);
            hisVersionParamListBo.setListHisVersionParamBo(hisVersionParamBos);
            HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
            this.addRecentHisVersion(curVersionChangeOrgTeams, recentHisDys);
            customOrgTeamRepository.update(curVersionChangeOrgTeams.toArray(new DynamicObject[0]));
            Arrays.stream(orgTeamStructArrays).forEach(dy -> dy.set("orgteamhisid", (Object)dy.getLong("orgteam.id")));
            SaveServiceHelper.update((DynamicObject[])orgTeamStructArrays);
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u53d8\u66f4\u7ec4\u7ec7\u5931\u8d25", (String)"CustomOrgTeamServiceImpl_1", (String)"hrmp-haos-business", (Object[])new Object[0]);
            LOGGER.error(message, (Throwable)e);
            throw new KDBizException(message);
        }
        LOGGER.info("change end size:{}", (Object)size);
    }

    private DynamicObject[] queryRecentHisVersion(List<DynamicObject> curVersionChangeOrgTeams) {
        if (curVersionChangeOrgTeams.isEmpty()) {
            return null;
        }
        Set<Long> boIds = curVersionChangeOrgTeams.stream().map(val -> val.getLong("boid")).collect(Collectors.toSet());
        return CustomOrgTeamRepository.getRepository().queryRecentHisVersion(boIds);
    }

    private void addRecentHisVersion(List<DynamicObject> curVersionChangeOrgTeams, DynamicObject[] recentHisDys) {
        if (curVersionChangeOrgTeams.isEmpty() || recentHisDys == null) {
            return;
        }
        Map<Long, DynamicObject> map = curVersionChangeOrgTeams.stream().collect(Collectors.toMap(val -> val.getLong("boid"), val -> val));
        if (recentHisDys != null && recentHisDys.length > 0) {
            for (DynamicObject dynamicObject : recentHisDys) {
                DynamicObject currentVersionDy = map.get(dynamicObject.getLong("boid"));
                if (currentVersionDy == null) continue;
                dynamicObject.set("structlongnumber", currentVersionDy.get("structlongnumber"));
                dynamicObject.set("sortcode", currentVersionDy.get("sortcode"));
                dynamicObject.set("level", currentVersionDy.get("level"));
                curVersionChangeOrgTeams.add(dynamicObject);
            }
        }
    }

    @Override
    public void enable(List<Long> orgTeamBoIds) {
        LOGGER.info("enable orgTeamBoIds:{}", orgTeamBoIds);
        this.disableOrEnable(orgTeamBoIds, false, true);
    }

    @Override
    public void disable(List<Long> orgTeamBoIds) {
        LOGGER.info("disable orgTeamBoIds:{}", orgTeamBoIds);
        this.disableOrEnable(orgTeamBoIds, true, true);
    }

    @Override
    public void delete(List<Long> orgTeamBoIds) {
        this.delete(orgTeamBoIds, true);
    }

    @Override
    public void delete(List<Long> orgTeamBoIds, boolean deleteOrgTeam) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return;
        }
        if (deleteOrgTeam) {
            CustomStructHelper.deleteByBoIds(orgTeamBoIds, "haos_adminorgteam");
        }
        CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
        DynamicObject[] customOrgTeamStructDys = customOrgTeamStructRepository.queryCurDyByOrgTeamBoIds(orgTeamBoIds, "boid");
        List<Long> customOrgTeamStructBoIds = Arrays.stream(customOrgTeamStructDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CustomStructHelper.deleteByBoIds(customOrgTeamStructBoIds, customOrgTeamStructRepository.getEntityName());
        CustomOrgTeamSortRepository customOrgTeamSortRepository = CustomOrgTeamSortRepository.getRepository();
        DynamicObject[] customOrgTeamSortDys = customOrgTeamSortRepository.queryCurDyByOrgTeamBoIds(orgTeamBoIds, "boid");
        List<Long> customOrgTeamBoIds = Arrays.stream(customOrgTeamSortDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CustomStructHelper.deleteByBoIds(customOrgTeamBoIds, customOrgTeamSortRepository.getEntityName());
    }

    @Override
    public void disableOrEnable(List<Long> orgTeamBoIds, boolean disable, boolean disableOrEnableOrgTeam) {
        if (CollectionUtils.isEmpty(orgTeamBoIds)) {
            return;
        }
        if (disableOrEnableOrgTeam) {
            CustomStructHelper.disableOrEnableByBoIds(orgTeamBoIds, "haos_adminorgteam", disable);
        }
        CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
        DynamicObject[] customOrgTeamStructDys = customOrgTeamStructRepository.queryCurDyByOrgTeamBoIds(orgTeamBoIds, "boid");
        List<Long> customOrgTeamStructBoIds = Arrays.stream(customOrgTeamStructDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CustomStructHelper.disableOrEnableByBoIds(customOrgTeamStructBoIds, customOrgTeamStructRepository.getEntityName(), disable);
        QFilter StatusFilter = new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
        DynamicObject[] orgTeamStructArrays = customOrgTeamStructRepository.loadDynamicObjectArray(new QFilter[]{new QFilter("orgteam.id", "in", orgTeamBoIds), StatusFilter});
        DynamicObject[] orgDys = CustomOrgTeamRepository.getRepository().loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", orgTeamBoIds), StatusFilter});
        if (orgTeamStructArrays != null && orgTeamStructArrays.length > 0 && orgDys != null && orgDys.length > 0) {
            Map<Long, List<DynamicObject>> boidMap = Arrays.stream(orgDys).collect(Collectors.groupingBy(val -> val.getLong("boid")));
            block0: for (DynamicObject structDy : orgTeamStructArrays) {
                long orgTeamId = structDy.getLong("orgteam.id");
                List<DynamicObject> list = boidMap.get(orgTeamId);
                if (list == null) continue;
                boolean isCurVersion = structDy.getBoolean("iscurrentversion");
                for (DynamicObject orgTeam : list) {
                    if (Boolean.TRUE.equals(isCurVersion) && orgTeam.getBoolean("iscurrentversion")) {
                        structDy.set("orgteamhisid", orgTeam.get("id"));
                        continue block0;
                    }
                    if (!HRStringUtils.equals((String)orgTeam.getString("hisversion"), (String)structDy.getString("hisversion"))) continue;
                    structDy.set("orgteamhisid", orgTeam.get("id"));
                    continue block0;
                }
            }
            SaveServiceHelper.update((DynamicObject[])orgTeamStructArrays);
        }
        CustomOrgTeamSortRepository customOrgTeamSortRepository = CustomOrgTeamSortRepository.getRepository();
        DynamicObject[] customOrgTeamSortDys = customOrgTeamSortRepository.queryCurDyByOrgTeamBoIds(orgTeamBoIds, "boid");
        List<Long> customOrgTeamBoIds = Arrays.stream(customOrgTeamSortDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        CustomStructHelper.disableOrEnableByBoIds(customOrgTeamBoIds, customOrgTeamSortRepository.getEntityName(), disable);
    }

    private void initCommonFieldValue(DynamicObject dy, long id, Date effStartDate) {
        dy.set("id", (Object)id);
        dy.set("initstatus", (Object)"2");
        dy.set("initbatch", (Object)0L);
        dy.set("initdatasource", (Object)"0");
        dy.set("enable", (Object)"1");
        dy.set("status", (Object)"C");
        dy.set("bsed", (Object)effStartDate);
        dy.set("bsled", (Object)DATE_2999);
    }

    private HisResponse<BatchVersionChangeRespData> saveOrgTeam(List<DynamicObject> orgTeamList, List<DynamicObject> cusOrgTeamStructList, List<DynamicObject> cusOrgTeamSortList, long[] orgTeamFirstVersionIds) {
        ArrayList<HisVersionParamBo> hisVersionParamBos = new ArrayList<HisVersionParamBo>(orgTeamList.size());
        HisVersionParamBo hisOrgTeamHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamList.toArray(new DynamicObject[0]), "haos_cusadminorgteam", false);
        hisOrgTeamHisVersionParam.setFirstVersionIds(orgTeamFirstVersionIds);
        hisVersionParamBos.add(hisOrgTeamHisVersionParam);
        hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(cusOrgTeamStructList.toArray(new DynamicObject[0]), "haos_customotstruct", false));
        hisVersionParamBos.add(AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(cusOrgTeamSortList.toArray(new DynamicObject[0]), "haos_customotsort", false));
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setListHisVersionParamBo(hisVersionParamBos);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }
}

