/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.proteamgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.domain.service.impl.proteamgroup.mode.ProjectTeamBuBo;
import kd.hr.haos.business.domain.service.projectgroup.IProjectTeamService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.util.BatchSynOtUtils;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.model.prj.ProjectTeamOrgChangeModel;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class ProjectTeamServiceImpl
implements IProjectTeamService {
    public static ProjectTeamServiceImpl getInstance() {
        return ProjectTeamServiceInstance.INSTANCE;
    }

    @Override
    public DynamicObject[] getProjectTeamInfoByIdList(List<Long> proTeamIdList) {
        if (ObjectUtils.isEmpty(proTeamIdList)) {
            return null;
        }
        PRJOrgRepository proTeamRepository = PRJOrgRepository.getInstance();
        String selectProTeamFields = "id,boid,name,number,bsed,bsled,rootprojectteam,projectname,projectidentify,simplename,parentorg,belongadminorg,establishmentdate,country,city,workplace,index,description,sourcevid";
        return proTeamRepository.getProTeamInfo(selectProTeamFields, proTeamIdList, null, null, "2");
    }

    @Override
    public DynamicObject[] getHisRootProjectTeamInfoByBoIdSet(Set<Long> proTeamBoIdSet) {
        if (ObjectUtils.isEmpty(proTeamBoIdSet)) {
            return new DynamicObject[0];
        }
        PRJOrgRepository proTeamRepository = PRJOrgRepository.getInstance();
        String selectProTeamFields = "id,boid,bsed,bsled,name,number,projectname,rootprojectteam,projectidentify,sourcevid";
        return proTeamRepository.getProTeamInfoByBoIdSet(selectProTeamFields, proTeamBoIdSet, false, null, "2", " id desc");
    }

    @Override
    public void changeByAdminOrgChangeOrg(List<ProjectTeamOrgChangeModel> projectTeamOrgChangeModelList) {
        Set<Long> adminOrgSet = projectTeamOrgChangeModelList.stream().map(ProjectTeamOrgChangeModel::getAdminOrgBo).collect(Collectors.toSet());
        List<Date> effectDateList = projectTeamOrgChangeModelList.stream().map(ProjectTeamOrgChangeModel::getEffectDate).collect(Collectors.toList());
        DynamicObject[] projectTeamDys = PRJOrgRepository.getInstance().queryProjectTeamWithSameAdOrg("id, boid, belongadminorg.id, org.id, bsed, bsled", adminOrgSet, LocalDateRangeUtils.getMinDate(effectDateList));
        List projectTeamBuBoList = Arrays.stream(projectTeamDys).map(this::toProjectTeamBuBo).collect(Collectors.toList());
        Map<Long, List<ProjectTeamBuBo>> adOrgVsPjtBuBo = projectTeamBuBoList.stream().collect(Collectors.groupingBy(ProjectTeamBuBo::getBelongAdminOrgId));
        List toSaveProjectBoList = projectTeamOrgChangeModelList.stream().map(this.followParent(adOrgVsPjtBuBo)).flatMap(Collection::stream).collect(Collectors.toList());
        if (toSaveProjectBoList.size() == 0) {
            return;
        }
        Set<Long> pjtIdList = toSaveProjectBoList.stream().map(ProjectTeamBuBo::getVid).collect(Collectors.toSet());
        DynamicObject[] pjtHiss = PRJOrgRepository.getInstance().loadByIds(pjtIdList);
        Map<Long, DynamicObject> vidVsPjtHis = Arrays.stream(pjtHiss).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        IdCreator idCreator = new IdCreator();
        DynamicObjectType orgDyType = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
        List<DynamicObject> toSavePjtDyList = toSaveProjectBoList.stream().map(projectTeamBuBo -> {
            DynamicObject pjtHis = (DynamicObject)vidVsPjtHis.get(projectTeamBuBo.getVid());
            DynamicObject newPjt = new DynamicObject(pjtHis.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)pjtHis, (DynamicObject)newPjt);
            DynamicObject org = new DynamicObject(orgDyType);
            org.set("id", (Object)projectTeamBuBo.getBuId());
            newPjt.set("org", (Object)org);
            LocalDateRangeUtils.setEffectRange(newPjt, projectTeamBuBo.getEffectRange());
            newPjt.set("id", (Object)idCreator.getId());
            return newPjt;
        }).collect(Collectors.toList());
        HisVersionParamListBo hisParamList = new HisVersionParamListBo();
        ArrayList<HisVersionParamBo> hisParamBo = new ArrayList<HisVersionParamBo>();
        hisParamList.setListHisVersionParamBo(hisParamBo);
        HisVersionParamBo pjtHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(toSavePjtDyList.toArray(new DynamicObject[0]), "haos_projteambaseinfo", false);
        hisParamBo.add(pjtHisVersionParam);
        HisResponse hisResponse = HisModelController.getInstance().batchHisVersionChange(hisParamList);
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setNewList(Collections.emptyList());
        batchSynModel.setSaveList(BatchSynOtUtils.createOt4Save(toSavePjtDyList, OrgTeamSynService.getNumberByPrefixId(1020L)));
        batchSynModel.setStrucrProjectId(1020L);
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        orgTeamBatchSynService.syn();
        List prjTeamList = Arrays.stream(((VersionChangeRespData)((BatchVersionChangeRespData)hisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects()).filter(prjTeam -> prjTeam.getLong("id") != prjTeam.getLong("boid")).collect(Collectors.toList());
        HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"changeProjectRoleOrg", (Object[])new Object[]{prjTeamList});
    }

    private Function<ProjectTeamOrgChangeModel, List<ProjectTeamBuBo>> followParent(Map<Long, List<ProjectTeamBuBo>> adOrgVsPjtBuBo) {
        return projectTeamOrgChangeModel -> {
            long adminOrgBo = projectTeamOrgChangeModel.getAdminOrgBo();
            List projectTeamBuBoList2 = adOrgVsPjtBuBo.getOrDefault(adminOrgBo, Collections.emptyList());
            return projectTeamBuBoList2.stream().filter(projectTeamBuBo -> projectTeamBuBo.getEffectRange().overlaps(projectTeamOrgChangeModel.getEffectRange())).filter(projectTeamBuBo -> projectTeamBuBo.getBuId() != projectTeamOrgChangeModel.getBuId()).map(projectTeamBuBo -> {
                ProjectTeamBuBo copy = new ProjectTeamBuBo();
                ProjectTeamBuBo.copy(projectTeamBuBo, copy);
                copy.setBuId(projectTeamOrgChangeModel.getBuId());
                copy.setEffectRange(projectTeamOrgChangeModel.getEffectRange().intersection(copy.getEffectRange()));
                return copy;
            }).collect(Collectors.toList());
        };
    }

    private ProjectTeamBuBo toProjectTeamBuBo(DynamicObject pjtDy) {
        ProjectTeamBuBo projectTeamBuBo = new ProjectTeamBuBo();
        projectTeamBuBo.setBelongAdminOrgId(pjtDy.getLong("belongadminorg.id"));
        projectTeamBuBo.setBo(pjtDy.getLong("boid"));
        projectTeamBuBo.setEffectRange(LocalDateRangeUtils.getEffectRange(pjtDy));
        projectTeamBuBo.setVid(pjtDy.getLong("id"));
        projectTeamBuBo.setBuId(pjtDy.getLong("org.id"));
        return projectTeamBuBo;
    }

    private static class ProjectTeamServiceInstance {
        private static ProjectTeamServiceImpl INSTANCE = new ProjectTeamServiceImpl();

        private ProjectTeamServiceInstance() {
        }
    }
}

