/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.service.impl.staff.AbstractUseStaffService;
import kd.hr.haos.business.domain.service.staff.IMuldimUseStaffService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class MuldimUseStaffServiceImpl
extends AbstractUseStaffService
implements IMuldimUseStaffService,
OrgStaffConstants {
    protected HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_muldimusestaff");

    @Override
    public void save(List<DynamicObject> dynList) {
        this.setDefaultFiled(dynList);
        this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
    }

    @Override
    public void update(List<DynamicObject> dynList) {
        dynList.stream().forEach(dyn -> {
            dyn.set("modifytime", (Object)RequestContext.get().getCurrUserId());
            dyn.set("modifytime", (Object)new Date());
        });
        this.serviceHelper.update(dynList.toArray(new DynamicObject[0]));
    }

    @Override
    public void invalid(List<DynamicObject> dynList) {
        DynamicObject[] hisDynList;
        Date now = new Date();
        Date curDay = Date.from(ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).toInstant());
        List hisIds = dynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter useOrgDetailFilter = new QFilter("id", "in", hisIds);
        for (DynamicObject hisdyn : hisDynList = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{useOrgDetailFilter})) {
            if (HRDateTimeUtils.dayEquals((Date)curDay, (Date)hisdyn.getDate("bsed"))) {
                hisdyn.set("status", (Object)"-1");
                continue;
            }
            hisdyn.set("status", (Object)"2");
            Date bsled = HRDateTimeUtils.addDay((Date)now, (long)-1L);
            hisdyn.set("bsled", (Object)bsled);
        }
        this.setModifyField(now, Arrays.asList(hisDynList));
        this.serviceHelper.update(hisDynList);
    }

    @Override
    public void deleteByIds(List<Long> Ids) {
        QFilter idsFilter = new QFilter("id", "in", Ids);
        this.serviceHelper.deleteByFilter(new QFilter[]{idsFilter});
    }
}

