/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.service.staff.IOrgPersonStaffInfoService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OrgPersonStaffInfoServiceImpl
implements IOrgPersonStaffInfoService,
OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(OrgPersonStaffInfoServiceImpl.class);
    protected HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgpersonstaffinfo");

    @Override
    public void save(List<DynamicObject> personStaffInfoList) {
        this.setDefaultFiled(personStaffInfoList);
        this.serviceHelper.save(personStaffInfoList.toArray(new DynamicObject[0]));
    }

    @Override
    public void update(List<DynamicObject> personStaffInfoList) {
        personStaffInfoList.stream().forEach(dyn -> {
            dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dyn.set("modifytime", (Object)new Date());
        });
        this.serviceHelper.update(personStaffInfoList.toArray(new DynamicObject[0]));
    }

    @Override
    public void deleteByIds(List<Long> Ids) {
        QFilter idsFilter = new QFilter("id", "in", Ids);
        this.serviceHelper.deleteByFilter(new QFilter[]{idsFilter});
    }

    @Override
    public List<Long> queryEffectingDepempId(List<Long> depempIdList) {
        QFilter idsFilter = new QFilter("orgperson", "in", depempIdList);
        DynamicObject[] dynamicObjects = this.serviceHelper.query("id, orgperson.id", new QFilter[]{idsFilter});
        return Arrays.stream(dynamicObjects).map(dyn -> dyn.getLong("orgperson.id")).collect(Collectors.toList());
    }

    private void setDefaultFiled(List<DynamicObject> baseDataList) {
        for (DynamicObject baseData : baseDataList) {
            baseData.set("modifier", baseData.get("creator"));
            baseData.set("modifytime", baseData.get("createtime"));
        }
    }
}

